/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.units;

import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Converter;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class UnitAABox
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public final double minx;
    public final double miny;
    public final double minz;
    public final double maxx;
    public final double maxy;
    public final double maxz;
    public final Unit unit;

    public UnitAABox() {
        this(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308, SI.METER);
    }

    public UnitAABox(UnitAABox unitAABox) {
        this(unitAABox.minx, unitAABox.miny, unitAABox.minz, unitAABox.maxx, unitAABox.maxy, unitAABox.maxz, unitAABox.unit);
    }

    public UnitAABox(Point3d point3d, Point3d point3d2, Unit unit) {
        this(point3d.x, point3d.y, point3d.z, point3d2.x, point3d2.y, point3d2.z, unit);
    }

    public UnitAABox(double d, double d2, double d3, double d4, double d5, double d6, Unit unit) {
        this.minx = d;
        this.miny = d2;
        this.minz = d3;
        this.maxx = d4;
        this.maxy = d5;
        this.maxz = d6;
        this.unit = unit;
    }

    public UnitAABox(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2) {
        this(unitPoint3D.getPoint3dValue(unitPoint3D.getUnit()), unitPoint3D2.getPoint3dValue(unitPoint3D.getUnit()), unitPoint3D.getUnit());
    }

    public UnitAABox(AABox aABox, Unit unit) {
        this(aABox.getMin(), aABox.getMax(), unit);
    }

    public boolean isValid() {
        return this.minx <= this.maxx && this.miny <= this.maxy && this.minz <= this.maxz;
    }

    public UnitAABox add(UnitAABox unitAABox) {
        double d = UnitDouble.convert(unitAABox.minx, unitAABox.unit, this.unit);
        double d2 = UnitDouble.convert(unitAABox.miny, unitAABox.unit, this.unit);
        double d3 = UnitDouble.convert(unitAABox.minz, unitAABox.unit, this.unit);
        double d4 = UnitDouble.convert(unitAABox.maxx, unitAABox.unit, this.unit);
        double d5 = UnitDouble.convert(unitAABox.maxy, unitAABox.unit, this.unit);
        double d6 = UnitDouble.convert(unitAABox.maxz, unitAABox.unit, this.unit);
        return new UnitAABox(Math.min(this.minx, d), Math.min(this.miny, d2), Math.min(this.minz, d3), Math.max(this.maxx, d4), Math.max(this.maxy, d5), Math.max(this.maxz, d6), this.unit);
    }

    public UnitPoint3D getCenter() {
        return new UnitPoint3D((this.minx + this.maxx) * 0.5, (this.miny + this.maxy) * 0.5, (this.minz + this.maxz) * 0.5, this.unit);
    }

    public Point3d getMin(Unit unit) {
        Converter converter = this.unit.getConverterTo(unit);
        return new Point3d(converter.convert(this.minx), converter.convert(this.miny), converter.convert(this.minz));
    }

    public Point3d getMax(Unit unit) {
        Converter converter = this.unit.getConverterTo(unit);
        return new Point3d(converter.convert(this.maxx), converter.convert(this.maxy), converter.convert(this.maxz));
    }

    public UnitPoint3D getMin() {
        return new UnitPoint3D(this.minx, this.miny, this.minz, this.unit);
    }

    public UnitPoint3D getMax() {
        return new UnitPoint3D(this.maxx, this.maxy, this.maxz, this.unit);
    }

    public AABox getValue(Unit unit) {
        Converter converter = this.unit.getConverterTo(unit);
        return new AABox(converter.convert(this.minx), converter.convert(this.miny), converter.convert(this.minz), converter.convert(this.maxx), converter.convert(this.maxy), converter.convert(this.maxz));
    }

    public Object clone() {
        try {
            UnitAABox unitAABox = (UnitAABox)super.clone();
            return unitAABox;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof UnitAABox)) {
            return false;
        }
        UnitAABox unitAABox = (UnitAABox)object;
        return this.getMin().equals(unitAABox.getMin()) && this.getMax().equals(unitAABox.getMax());
    }

    public int hashCode() {
        return 947183593 + this.getMin().hashCode() + this.getMax().hashCode();
    }

    public UnitAABox transform(Matrix4d matrix4d) {
        UnitPoint3D unitPoint3D = GeomUtil.xform(matrix4d, this.getMin());
        UnitPoint3D unitPoint3D2 = GeomUtil.xform(matrix4d, this.getMax());
        UnitPoint3D[] unitPoint3DArray = GeomUtil.rectify(unitPoint3D, unitPoint3D2);
        return new UnitAABox(unitPoint3DArray[0], unitPoint3DArray[1]);
    }
}

