/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.tools;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Reader;

public class MathML_WordToJava {
    public static void main(String[] stringArray) {
        String string = MathML_WordToJava.readClipboard();
        System.out.println(string);
        string = MathML_WordToJava.process(string);
        System.out.println(string);
        MathML_WordToJava.writeToClipboard(string);
    }

    private static String readClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            Transferable transferable = clipboard.getContents(null);
            if (transferable == null) {
                System.err.println("ERROR: No data on the clipboard.");
                return "";
            }
            Reader reader = DataFlavor.getTextPlainUnicodeFlavor().getReaderForText(transferable);
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[1024];
            int n = -1;
            while ((n = reader.read(cArray)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    private static void writeToClipboard(final String string) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        DataFlavor.getTextPlainUnicodeFlavor();
        Transferable transferable = new Transferable(){

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                return string;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return dataFlavor.match(DataFlavor.stringFlavor);
            }
        };
        clipboard.setContents(transferable, null);
    }

    private static String process(String string) {
        string = string.replaceAll("\\:mml", "");
        string = string.replaceAll("mml\\:", "");
        string = string.replaceAll("\"", "\\\\\"");
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u00ff') {
                String string2 = String.format("\\u%04X", c);
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

