/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking;

import java.util.Arrays;
import java.util.HashSet;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IBoxCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IPickable;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.LineConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class PolarSnap
implements IPickable {
    public final Point3d origin;
    public final Vector3d reference;
    public final Vector3d axis;
    public final double angle;
    public final double[] additionalAngles;
    private final Vector3d[] d_dirs;

    public PolarSnap(Point3d point3d, Vector3d vector3d, Vector3d vector3d2, double d, double ... dArray) {
        this.origin = point3d;
        this.reference = vector3d2;
        this.axis = vector3d;
        this.angle = d;
        this.additionalAngles = dArray;
        HashSet<Double> hashSet = new HashSet<Double>();
        for (double d2 : dArray) {
            hashSet.add(d2);
        }
        double d3 = 0.0;
        while (theUtil.lt(d3, Math.PI * 2, 1.0E-9)) {
            hashSet.add(d3);
            d3 += d;
        }
        double[] dArray2 = theUtil.toDoubleArray(hashSet);
        Arrays.sort(dArray2);
        Matrix4d matrix4d = new Matrix4d();
        AxisAngle4d axisAngle4d = new AxisAngle4d();
        this.d_dirs = new Vector3d[dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            axisAngle4d.set(vector3d, dArray2[i]);
            matrix4d.set(axisAngle4d);
            this.d_dirs[i] = Util3D.xform(matrix4d, vector3d2);
        }
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        for (Vector3d vector3d2 : this.d_dirs) {
            double[] dArray;
            LineConstraint lineConstraint = new LineConstraint(this.origin, vector3d2);
            if (!iIsectFilter.acceptPickObject(lineConstraint) || !iIsectFilter.acceptGeomType(lineConstraint, GeomType.EDGE) || (dArray = Inter3D.lineLineProximityT(point3d, vector3d, this.origin, vector3d2, 1.0E-9)) == null || !theUtil.ge0(dArray[1], 1.0E-9)) continue;
            Point3d point3d3 = Util3D.linePoint(this.origin, vector3d2, dArray[1]);
            iIsectCollector.addInfinite(lineConstraint, point3d3, GeomType.EDGE, new LineSeg(this.origin, Util3D.add(this.origin, (Tuple3d)vector3d2)));
        }
    }

    @Override
    public void pickBox(IBoxCollector iBoxCollector, IIsectFilter iIsectFilter, ConvexHull convexHull) {
    }

    @Override
    public void getAll(IBoxCollector iBoxCollector, IIsectFilter iIsectFilter) {
    }
}

