/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Box3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSeg3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSegRTreeTest;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.View;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.DefaultFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IBoxCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IPickConfig;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IPickRoot;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IPickable;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IsectInfo;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.RayPointProx;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredCollection;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.TaskProgress;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class GeomPicker {
    private final IPickRoot d_geometry;
    private final View d_view;
    private boolean d_occlusionFilterEnabled;
    public static final IIsectFilter ACCEPT_ALL = new DefaultFilter(){

        @Override
        public boolean acceptGeomType(Object object, GeomType geomType) {
            return geomType != GeomType.VOLUME;
        }
    };

    public GeomPicker(IPickRoot iPickRoot, View view) {
        this.d_geometry = iPickRoot;
        this.d_view = view;
        this.d_occlusionFilterEnabled = true;
    }

    public void setOcclusionFilteringEnabled(boolean bl) {
        this.d_occlusionFilterEnabled = bl;
    }

    public boolean isOcclusionFilteringEnabled() {
        return this.d_occlusionFilterEnabled;
    }

    public IPickRoot getGeomSource() {
        return this.d_geometry;
    }

    @Deprecated
    public IsectInfo pickClosest(Mode mode, Point2d point2d, double d) {
        return this.pickClosest(mode, point2d, d, ACCEPT_ALL);
    }

    @Deprecated
    public IsectInfo pickClosest(Mode mode, Point2d point2d, double d, IIsectFilter iIsectFilter) {
        try {
            Collection<IsectInfo> collection = this.pick(new TaskProgress(), mode, point2d, d, iIsectFilter);
            Iterator<IsectInfo> iterator = collection.iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            return iterator.next();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Collection<IsectInfo> pick(TaskProgress taskProgress, Mode mode, Point2d point2d, double d) {
        return this.pick(taskProgress, mode, point2d, d, ACCEPT_ALL);
    }

    public Collection<IsectInfo> pick(TaskProgress taskProgress, Mode mode, Point2d point2d, double d, IIsectFilter iIsectFilter) {
        iIsectFilter = new VisibilityFilter(iIsectFilter, this.d_geometry);
        LineSeg3D lineSeg3D = this.getPickRay(point2d);
        ArrayList<IsectInfo> arrayList = new ArrayList<IsectInfo>();
        for (IPickConfig iPickConfig : this.d_geometry.getPickConfigs()) {
            IRayProxDetector iRayProxDetector;
            ITest<AABox> iTest;
            Object object;
            LineSeg3D lineSeg3D2 = GeomPicker.trim(lineSeg3D, iPickConfig.getClippingRegion());
            if (lineSeg3D2 == null) continue;
            if (d > 0.0) {
                object = this.d_view.toFrustum(point2d, d);
                ConvexHull convexHull = GeomPicker.intersect((Box3d)object, iPickConfig.getClippingRegion());
                iTest = new CHTest(convexHull);
                iRayProxDetector = new RayTolProxDetector(this.d_view, point2d, d, lineSeg3D2, convexHull);
            } else {
                iTest = new LineSegRTreeTest(lineSeg3D2.p1, lineSeg3D2.p2);
                iRayProxDetector = new RayProxDetector(lineSeg3D2);
            }
            object = new RaySearchResult(taskProgress, mode, iIsectFilter, lineSeg3D2, iTest, this.d_geometry, iRayProxDetector);
            this.d_geometry.find(iPickConfig, iTest, (IResult<IPickable>)object);
            arrayList.addAll(((RaySearchResult)object).getIsects());
        }
        IsectSorter isectSorter = new IsectSorter(mode, this.d_geometry);
        Collections.sort(arrayList, isectSorter);
        AbstractCollection abstractCollection = !this.d_occlusionFilterEnabled ? arrayList : new FilteredCollection<IsectInfo>(arrayList, IsectInfo.class, new OcclusionFilter(taskProgress), true);
        if (abstractCollection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return abstractCollection;
    }

    private static LineSeg3D trim(LineSeg3D lineSeg3D, ConvexHull convexHull) {
        if (convexHull.acceptsAll()) {
            return lineSeg3D;
        }
        if (convexHull.acceptsNone()) {
            return null;
        }
        LineSeg lineSeg = new LineSeg(lineSeg3D.p1, lineSeg3D.p2);
        Vector3d vector3d = lineSeg3D.getDir();
        int n = 0;
        double[] dArray = new double[]{Double.NaN, Double.NaN};
        if (convexHull.contains(lineSeg3D.p1, 1.0E-9)) {
            dArray[n++] = 0.0;
        }
        if (convexHull.contains(lineSeg3D.p2, 1.0E-9)) {
            dArray[n++] = 1.0;
        }
        if (n < 2) {
            for (Plane3d plane3d : convexHull.getPlanes()) {
                double d = Inter3D.linePlaneIntersectionT(lineSeg3D.p1, vector3d, plane3d, 1.0E-9);
                if (Double.isNaN(d) || !theUtil.ge0(d, 1.0E-9) || !theUtil.le(d, 1.0, 1.0E-9) || !convexHull.contains(lineSeg.evaluate(d), 1.0E-9)) continue;
                dArray[n++] = d;
                if (n == 2) break;
            }
        }
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            System.err.println("0x223459f: Could not trim pick ray to clip region.");
            return lineSeg3D;
        }
        Arrays.sort(dArray);
        return new LineSeg3D(lineSeg.evaluate(dArray[0]), lineSeg.evaluate(dArray[1]));
    }

    private static ConvexHull intersect(Box3d box3d, ConvexHull convexHull) {
        return box3d.toConvexHull().intersect(convexHull, true);
    }

    public Collection<Object> pickBox(Point2d point2d, Point2d point2d2) {
        return this.pickBox(point2d, point2d2, ACCEPT_ALL);
    }

    public Collection<Object> pickBox(Point2d point2d, Point2d point2d2, IIsectFilter iIsectFilter) {
        iIsectFilter = new VisibilityFilter(iIsectFilter, this.d_geometry);
        Box3d box3d = this.d_view.toFrustum(point2d, point2d2);
        IPickConfig[] iPickConfigArray = this.d_geometry.getPickConfigs();
        ArrayList<Object> arrayList = iPickConfigArray.length == 1 ? new ArrayList() : new IdentityHashSet();
        for (IPickConfig iPickConfig : iPickConfigArray) {
            ConvexHull convexHull = GeomPicker.intersect(box3d, iPickConfig.getClippingRegion());
            BoxSearchResult boxSearchResult = new BoxSearchResult(iIsectFilter, convexHull, this.d_geometry);
            this.d_geometry.find(iPickConfig, new CHTest(convexHull), boxSearchResult);
            arrayList.addAll(boxSearchResult.d_objs);
        }
        return arrayList;
    }

    private LineSeg3D getPickRay(Point2d point2d) {
        Point3d point3d = this.d_view.screenToWorld(new Point3d(point2d.x, point2d.y, 0.0));
        Point3d point3d2 = this.d_view.screenToWorld(new Point3d(point2d.x, point2d.y, 1.0));
        return new LineSeg3D(point3d, point3d2);
    }

    public double findOccluderDistSq(Point3d point3d) {
        IsectInfo isectInfo = this.findOccluder(new TaskProgress(), point3d);
        if (isectInfo == null) {
            return Double.NaN;
        }
        return isectInfo.isectPoint.distanceSquared(point3d);
    }

    public IsectInfo findOccluder(TaskProgress taskProgress, Point3d point3d) {
        return this.findOccluder(taskProgress, point3d, false);
    }

    public IsectInfo findOccluder(TaskProgress taskProgress, Point3d point3d, boolean bl) {
        this.d_view.updateLayout();
        Matrix4d matrix4d = this.d_view.getCamera().getMatrix(6);
        Matrix4d matrix4d2 = this.d_view.getCamera().getMatrix(7);
        return this.findOccluder(taskProgress, point3d, bl, matrix4d, matrix4d2);
    }

    protected IsectInfo findOccluder(TaskProgress taskProgress, Point3d point3d, boolean bl, Matrix4d matrix4d, Matrix4d matrix4d2) {
        OccludedPointIsectFilter occludedPointIsectFilter = new OccludedPointIsectFilter(this.d_geometry, point3d, bl);
        VisibilityFilter visibilityFilter = new VisibilityFilter(occludedPointIsectFilter, this.d_geometry);
        Point3d point3d2 = Util3D.xform(matrix4d, point3d, true);
        point3d2.z = 0.0;
        Point3d point3d3 = Util3D.xform(matrix4d2, point3d2, true);
        LineSeg3D lineSeg3D = new LineSeg3D(point3d3, point3d);
        try {
            IPickConfig[] iPickConfigArray = this.d_geometry.getPickConfigs();
            for (int i = 0; i < iPickConfigArray.length; ++i) {
                LineSeg3D lineSeg3D2 = GeomPicker.trim(lineSeg3D, iPickConfigArray[i].getClippingRegion());
                if (lineSeg3D2 == null) continue;
                LineSegRTreeTest lineSegRTreeTest = new LineSegRTreeTest(lineSeg3D2.getP1(), lineSeg3D2.getP2());
                RayProxDetector rayProxDetector = new RayProxDetector(lineSeg3D2);
                RaySearchResult raySearchResult = new RaySearchResult(taskProgress, Mode.SNAP, visibilityFilter, lineSeg3D2, this.d_geometry, rayProxDetector);
                this.d_geometry.find(iPickConfigArray[i], lineSegRTreeTest, raySearchResult);
            }
        }
        catch (HaltException haltException) {
            // empty catch block
        }
        return occludedPointIsectFilter.occluder;
    }

    protected double findOccluderDistSq(final TaskProgress taskProgress, final Point3d point3d, IFace iFace, Matrix4d matrix4d, Matrix4d matrix4d2) {
        Point3d point3d2 = Util3D.xform(matrix4d, point3d, true);
        point3d2.z = 0.0;
        Point3d point3d3 = Util3D.xform(matrix4d2, point3d2, true);
        LineSeg3D lineSeg3D = new LineSeg3D(point3d3, point3d);
        LineSegRTreeTest lineSegRTreeTest = new LineSegRTreeTest(lineSeg3D.getP1(), lineSeg3D.getP2());
        final Point3d[] point3dArray = new Point3d[]{null};
        IIsectCollector iIsectCollector = new IIsectCollector(){

            @Override
            public void add(Object object, Point3d point3d2, GeomType geomType, IPrimitive iPrimitive) {
                if (point3d2.distance(point3d) > 1.0E-6) {
                    point3dArray[0] = point3d;
                    throw new HaltException();
                }
            }

            @Override
            public void addInfinite(Object object, Point3d point3d2, GeomType geomType, IPrimitive iPrimitive) {
                this.add(object, point3d2, geomType, iPrimitive);
            }

            @Override
            public TaskProgress getProgress() {
                return taskProgress;
            }
        };
        try {
            iFace.pickPoints(iIsectCollector, new DefaultFilter(GeomType.FACE), null, lineSeg3D.p1, lineSeg3D.p2, lineSeg3D.getDirN(), lineSegRTreeTest);
        }
        catch (HaltException haltException) {
            // empty catch block
        }
        return point3dArray[0] == null ? Double.NaN : point3dArray[0].distanceSquared(point3d);
    }

    private static class IsectSorter<T>
    implements Comparator<IsectInfo> {
        private static final int[] s_snapTypePriorities = new int[6];
        private static final int[] s_selTypePriorities;
        private final IPickRoot d_geometry;
        private final int[] d_searchPriorities;

        public IsectSorter(Mode mode, IPickRoot iPickRoot) {
            this.d_searchPriorities = mode == Mode.SNAP ? s_snapTypePriorities : s_selTypePriorities;
            this.d_geometry = iPickRoot;
        }

        @Override
        public int compare(IsectInfo isectInfo, IsectInfo isectInfo2) {
            int n;
            int n2 = this.d_searchPriorities[isectInfo.searchType.ordinal()];
            if (n2 == (n = this.d_searchPriorities[isectInfo2.searchType.ordinal()])) {
                int n3 = isectInfo.prox.compareTo(isectInfo2.prox);
                if (n3 == 0) {
                    return isectInfo.obj == isectInfo2.obj ? 0 : this.d_geometry.compare(isectInfo.obj, isectInfo2.obj);
                }
                return n3;
            }
            return n2 - n;
        }

        static {
            IsectSorter.s_snapTypePriorities[GeomType.VERTEX.ordinal()] = 0;
            IsectSorter.s_snapTypePriorities[GeomType.FACE_VERTEX.ordinal()] = 0;
            IsectSorter.s_snapTypePriorities[GeomType.EDGE.ordinal()] = 1;
            IsectSorter.s_snapTypePriorities[GeomType.FACE_EDGE.ordinal()] = 1;
            IsectSorter.s_snapTypePriorities[GeomType.FACE.ordinal()] = 2;
            IsectSorter.s_snapTypePriorities[GeomType.VOLUME.ordinal()] = 3;
            s_selTypePriorities = new int[6];
            IsectSorter.s_selTypePriorities[GeomType.VERTEX.ordinal()] = 0;
            IsectSorter.s_selTypePriorities[GeomType.EDGE.ordinal()] = 1;
            IsectSorter.s_selTypePriorities[GeomType.FACE.ordinal()] = 2;
            IsectSorter.s_selTypePriorities[GeomType.FACE_EDGE.ordinal()] = 3;
            IsectSorter.s_selTypePriorities[GeomType.FACE_VERTEX.ordinal()] = 3;
            IsectSorter.s_selTypePriorities[GeomType.VOLUME.ordinal()] = 4;
        }
    }

    private static class RayTolProxDetector
    implements IRayProxDetector {
        private final LineSeg3D d_ray;
        private final ConvexHull d_infTolFrustum;
        private final ConvexHull d_tolFrustum;
        private final Point2d d_rayOriginSc;
        private final double d_tolScrSq;
        private final Matrix4d d_wsXform;

        public RayTolProxDetector(View view, Point2d point2d, double d, LineSeg3D lineSeg3D, ConvexHull convexHull) {
            this.d_ray = lineSeg3D;
            this.d_infTolFrustum = view.toInfiniteFrustum(point2d, d);
            this.d_tolFrustum = convexHull;
            this.d_rayOriginSc = point2d;
            this.d_tolScrSq = d * d;
            view.updateLayout();
            this.d_wsXform = view.getCamera().getMatrix(6);
        }

        @Override
        public RayPointProx getProximity(Point3d point3d, boolean bl) {
            RayPointProx rayPointProx = this.testTolerance(point3d);
            if (rayPointProx == null) {
                return null;
            }
            if (bl && this.d_infTolFrustum.contains(point3d, 1.0E-6) || !bl && this.d_tolFrustum.contains(point3d, 1.0E-6)) {
                return rayPointProx;
            }
            return null;
        }

        private RayPointProx testTolerance(Point3d point3d) {
            Point3d point3d2 = Util3D.xform(this.d_wsXform, point3d, true);
            double d = point3d2.x - this.d_rayOriginSc.x;
            double d2 = point3d2.y - this.d_rayOriginSc.y;
            double d3 = d * d + d2 * d2;
            if (d3 > this.d_tolScrSq) {
                return null;
            }
            return new RayPointProx(this.d_ray.p1.distance(point3d), d3);
        }
    }

    private static class RayProxDetector
    implements IRayProxDetector {
        private final LineSeg3D d_ray;
        private final Vector3d d_rayDir;
        private final double d_rayLen;

        public RayProxDetector(LineSeg3D lineSeg3D) {
            this.d_ray = lineSeg3D;
            this.d_rayDir = lineSeg3D.getDir();
            this.d_rayLen = lineSeg3D.length();
        }

        @Override
        public RayPointProx getProximity(Point3d point3d, boolean bl) {
            double d = Inter3D.nearestTOnLine(this.d_ray.p1, this.d_rayDir, point3d);
            if (theUtil.lt0(d, 1.0E-9) || theUtil.gt(d, 1.0, 1.0E-9) || Util3D.linePoint(this.d_ray.p1, this.d_rayDir, d).distance(point3d) > 1.0E-9) {
                return null;
            }
            double d2 = d * this.d_rayLen;
            return new RayPointProx(d2, 0.0);
        }

        private static boolean pointWithinSeg(Point3d point3d, Point3d point3d2, Vector3d vector3d, double d) {
            double d2 = Util3D.dot(vector3d, point3d);
            return theUtil.ge0(d2, d) && theUtil.le(d2, 1.0, d);
        }
    }

    public static class IsectCollector
    implements IIsectCollector {
        private final TaskProgress d_progress;
        private final IPickRoot d_pickRoot;
        private final IIsectFilter d_searchFilter;
        private final List<IsectInfo> d_points;
        private final IRayProxDetector d_proxDet;

        public IsectCollector(TaskProgress taskProgress, IPickRoot iPickRoot, IIsectFilter iIsectFilter, IRayProxDetector iRayProxDetector) {
            this.d_pickRoot = iPickRoot;
            this.d_searchFilter = iIsectFilter;
            this.d_progress = taskProgress;
            this.d_proxDet = iRayProxDetector;
            this.d_points = new ArrayList<IsectInfo>();
        }

        @Override
        public TaskProgress getProgress() {
            return this.d_progress;
        }

        public List<IsectInfo> getIsects() {
            return this.d_points;
        }

        @Deprecated
        public final void add(Object object, Point3d point3d, GeomType geomType) {
        }

        @Override
        public void addInfinite(Object object, Point3d point3d, GeomType geomType, IPrimitive iPrimitive) {
            this.add(object, point3d, geomType, iPrimitive, true);
        }

        @Override
        public void add(Object object, Point3d point3d, GeomType geomType, IPrimitive iPrimitive) {
            this.add(object, point3d, geomType, iPrimitive, false);
        }

        public void add(Object object, Point3d point3d, GeomType geomType, IPrimitive iPrimitive, boolean bl) {
            this.d_progress.check();
            RayPointProx rayPointProx = this.d_proxDet.getProximity(point3d, bl);
            if (rayPointProx != null) {
                IsectInfo isectInfo;
                if ((geomType == GeomType.FACE_EDGE || geomType == GeomType.FACE_VERTEX) && this.d_pickRoot.isWireframe(object)) {
                    geomType = geomType == GeomType.FACE_EDGE ? GeomType.EDGE : GeomType.VERTEX;
                }
                if (this.d_searchFilter.acceptIntersection(isectInfo = new IsectInfo(geomType, object, point3d, iPrimitive, rayPointProx))) {
                    this.d_points.add(isectInfo);
                }
            }
        }
    }

    public static class BoxCollector
    implements IBoxCollector {
        private final BoxSearchResult d_result;

        public BoxCollector(BoxSearchResult boxSearchResult) {
            this.d_result = boxSearchResult;
        }

        @Override
        public void add(Object object) {
            this.add(object, null);
        }

        public void add(Object object, GeomType geomType) {
            this.d_result.d_objs.add(object);
        }
    }

    private static class RaySearchResult
    implements IResult<IPickable> {
        private final TaskProgress d_progress;
        private final ITest<AABox> d_tester;
        private final LineSeg3D d_ray;
        private final Vector3d d_rayDirN;
        private final IsectCollector d_isectCollector;

        public RaySearchResult(TaskProgress taskProgress, Mode mode, IIsectFilter iIsectFilter, LineSeg3D lineSeg3D, IPickRoot iPickRoot, IRayProxDetector iRayProxDetector) {
            this(taskProgress, mode, iIsectFilter, lineSeg3D, new LineSegRTreeTest(lineSeg3D.p1, lineSeg3D.p2), iPickRoot, iRayProxDetector);
        }

        public RaySearchResult(TaskProgress taskProgress, Mode mode, IIsectFilter iIsectFilter, LineSeg3D lineSeg3D, ITest<AABox> iTest, IPickRoot iPickRoot, IRayProxDetector iRayProxDetector) {
            this.d_progress = taskProgress;
            this.d_tester = iTest;
            this.d_ray = lineSeg3D;
            this.d_rayDirN = this.d_ray.getDirN();
            this.d_isectCollector = new IsectCollector(taskProgress, iPickRoot, iIsectFilter, iRayProxDetector);
        }

        public IsectCollector getResult() {
            return this.d_isectCollector;
        }

        public List<IsectInfo> getIsects() {
            return this.d_isectCollector.getIsects();
        }

        @Override
        public void mark(IPickable iPickable, Containment containment) {
            this.d_progress.check();
            iPickable.pickPoints(this.d_isectCollector, this.d_isectCollector.d_searchFilter, this.d_ray.p1, this.d_ray.p2, this.d_rayDirN, this.d_tester);
        }
    }

    private static interface IRayProxDetector {
        public RayPointProx getProximity(Point3d var1, boolean var2);
    }

    private static class BoxSearchResult
    implements IResult<IPickable> {
        public final List<Object> d_objs;
        private final ConvexHull d_tester;
        private final IIsectFilter d_searchFilter;
        private final IPickRoot d_display;
        private final BoxCollector d_result;

        public BoxSearchResult(IIsectFilter iIsectFilter, ConvexHull convexHull, IPickRoot iPickRoot) {
            this.d_tester = convexHull;
            this.d_objs = new ArrayList<Object>();
            this.d_searchFilter = iIsectFilter;
            this.d_display = iPickRoot;
            this.d_result = new BoxCollector(this);
        }

        @Override
        public void mark(IPickable iPickable, Containment containment) {
            switch (containment) {
                case INSIDE: {
                    iPickable.getAll(this.d_result, this.d_searchFilter);
                    break;
                }
                default: {
                    iPickable.pickBox(this.d_result, this.d_searchFilter, this.d_tester);
                }
            }
        }
    }

    private static class OccludedPointIsectFilter
    extends DefaultFilter {
        private final IPickRoot d_pickRoot;
        private final Point3d d_searchPoint;
        private final boolean d_findClosest;
        public IsectInfo occluder = null;

        public OccludedPointIsectFilter(IPickRoot iPickRoot, Point3d point3d, boolean bl) {
            super(GeomType.FACE);
            this.d_pickRoot = iPickRoot;
            this.d_searchPoint = point3d;
            this.d_findClosest = bl;
        }

        @Override
        public boolean acceptPickObject(Object object) {
            return this.d_pickRoot.isOcclusionSource(object);
        }

        @Override
        public boolean acceptIntersection(IsectInfo isectInfo) {
            double d = isectInfo.isectPoint.distance(this.d_searchPoint);
            if (d > 1.0E-6) {
                if (this.occluder == null || d > this.occluder.isectPoint.distance(this.d_searchPoint)) {
                    this.occluder = isectInfo;
                }
                if (!this.d_findClosest) {
                    throw new HaltException();
                }
            }
            return false;
        }
    }

    private static class HaltException
    extends RuntimeException {
        private static final long serialVersionUID = -820726468639723761L;

        private HaltException() {
        }
    }

    private class OcclusionFilter
    implements IObjectFilter<IsectInfo> {
        private final TaskProgress d_progress;
        private IsectInfo d_firstFaceIsect = null;
        private Map<Point3d, Boolean> d_occludedCache = new HashMap<Point3d, Boolean>();
        private List<IsectInfo> d_foundOccluders = new ArrayList<IsectInfo>();
        private final Matrix4d d_wsXform;
        private final Matrix4d d_swXform;

        public OcclusionFilter(TaskProgress taskProgress) {
            this.d_progress = taskProgress;
            GeomPicker.this.d_view.updateLayout();
            this.d_wsXform = GeomPicker.this.d_view.getCamera().getMatrix(6);
            this.d_swXform = GeomPicker.this.d_view.getCamera().getMatrix(7);
        }

        @Override
        public boolean shouldFilter(IsectInfo isectInfo) {
            if (!this.d_progress.isRunning()) {
                return true;
            }
            if (!GeomPicker.this.d_geometry.isOcclusionTarget(isectInfo.obj)) {
                return false;
            }
            Boolean bl = this.d_occludedCache.get(isectInfo.isectPoint);
            if (bl == null) {
                try {
                    for (IsectInfo isectInfo2 : this.d_foundOccluders) {
                        double d = GeomPicker.this.findOccluderDistSq(this.d_progress, isectInfo.isectPoint, (IFace)isectInfo2.prim, this.d_wsXform, this.d_swXform);
                        if (Double.isNaN(d)) continue;
                        bl = true;
                        break;
                    }
                    if (bl == null) {
                        IsectInfo isectInfo3 = GeomPicker.this.findOccluder(this.d_progress, isectInfo.isectPoint, false, this.d_wsXform, this.d_swXform);
                        if (isectInfo3 != null) {
                            this.d_foundOccluders.add(isectInfo3);
                        }
                        bl = isectInfo3 != null;
                    }
                    this.d_occludedCache.put(isectInfo.isectPoint, bl);
                }
                catch (HaltException haltException) {
                    bl = true;
                }
            }
            return bl;
        }
    }

    private static class VisibilityFilter
    implements IIsectFilter {
        private final IPickRoot d_display;
        private final IIsectFilter d_baseFilter;

        public VisibilityFilter(IIsectFilter iIsectFilter, IPickRoot iPickRoot) {
            this.d_display = iPickRoot;
            this.d_baseFilter = iIsectFilter;
        }

        @Override
        public boolean acceptIntersection(IsectInfo isectInfo) {
            return this.d_baseFilter.acceptIntersection(isectInfo);
        }

        @Override
        public boolean acceptGeomType(Object object, GeomType geomType) {
            if (geomType == GeomType.FACE && this.d_display.isWireframe(object)) {
                return false;
            }
            return this.d_baseFilter.acceptGeomType(object, geomType);
        }

        @Override
        public boolean acceptPickObjType(Class clazz) {
            return this.d_baseFilter.acceptPickObjType(clazz);
        }

        @Override
        public boolean acceptPickObject(Object object) {
            return this.d_baseFilter.acceptPickObject(object) && this.d_display.isVisible(object);
        }
    }

    private static class CHTest
    implements ITest<AABox> {
        public final ConvexHull ch;
        public final double tol;

        public CHTest(ConvexHull convexHull) {
            this(convexHull, 1.0E-9);
        }

        public CHTest(ConvexHull convexHull, double d) {
            this.ch = convexHull;
            this.tol = d;
        }

        @Override
        public Containment test(AABox aABox) {
            return this.ch.test(aABox, this.tol);
        }
    }

    public static enum Mode {
        SNAP,
        PICK;

    }
}

