/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools;

import java.awt.AWTException;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiUtil;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.Camera;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.AToolFunction;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.CursorTool;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.ISelector;

public class RoamFunc<T extends CursorTool>
extends AToolFunction<T> {
    public static final Cursor CURSOR = guiUtil.createTeciCursor("Freelook", "blank16.gif", 15, 16);
    public static final Icon ICON = guiUtil.loadTeciIcon("running_man.gif");
    private final ISelector<T> d_selectionTool;
    private Robot d_robot;
    private Point d_lastMouseLocation;
    private boolean d_roamMode = false;
    private AABox d_modelBounds;
    private double d_rotX = 0.0;
    private double d_rotZ = 0.0;

    public RoamFunc(ISelector<T> iSelector) {
        this.d_selectionTool = iSelector;
        try {
            this.d_robot = new Robot();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    public void setModelBounds(AABox aABox) {
        this.d_modelBounds = aABox;
    }

    protected double getMovementSpeed(T t) {
        AABox aABox = this.d_modelBounds;
        return aABox == null ? 0.05 : 0.001 * aABox.getMin().distance(aABox.getMax());
    }

    @Override
    public boolean isAltMenuAccessEnabled() {
        return false;
    }

    @Override
    public boolean isDrawable(T t) {
        return false;
    }

    @Override
    public boolean enableZoomAboutPoint(T t) {
        return false;
    }

    @Override
    public Cursor getCursor(T t) {
        return Cursor.getPredefinedCursor(0);
    }

    @Override
    public void keyReleased(T t, KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 27: {
                ((CursorTool)t).restoreSystemCursor();
                this.d_roamMode = false;
                ((CursorTool)t).repaintSurface();
            }
        }
    }

    @Override
    public void mousePressed(T t, MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(T t, MouseEvent mouseEvent) {
        this.respondToMouse(t, mouseEvent);
    }

    @Override
    public void mouseMoved(T t, MouseEvent mouseEvent) {
        if (!this.d_roamMode) {
            return;
        }
        ((CursorTool)t).getAttachedComponent().setCursor(CURSOR);
        this.respondToMouse(t, mouseEvent);
    }

    @Override
    public void mouseReleased(T t, MouseEvent mouseEvent) {
        if (!((CursorTool)t).dragAboveTolerance(0)) {
            if (mouseEvent.getButton() == 2) {
                if (this.d_roamMode) {
                    ((CursorTool)t).restoreSystemCursor();
                } else {
                    ((CursorTool)t).getAttachedComponent().setCursor(CURSOR);
                }
                boolean bl = this.d_roamMode = !this.d_roamMode;
            }
            if (!this.d_roamMode) {
                this.d_selectionTool.select(t, mouseEvent);
            }
        }
        this.d_lastMouseLocation = null;
    }

    public void respondToMouse(T t, MouseEvent mouseEvent) {
        double d;
        double d2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.d_robot == null) {
            this.d_roamMode = false;
        }
        this.calculateRotation(t);
        if (this.d_lastMouseLocation == null) {
            this.d_lastMouseLocation = mouseEvent.getPoint();
        }
        int n7 = mouseEvent.getX() - this.d_lastMouseLocation.x;
        int n8 = mouseEvent.getY() - this.d_lastMouseLocation.y;
        int n9 = 0;
        if (this.d_roamMode) {
            Point point = ((CursorTool)t).getAttachedComponent().getLocationOnScreen();
            this.d_robot.mouseMove(point.x + this.d_lastMouseLocation.x, point.y + this.d_lastMouseLocation.y);
            n6 = 128;
            n5 = 1024;
            n4 = n6;
            n3 = n5;
            n2 = 512;
            n = 4096;
        } else {
            n5 = n6 = 1152;
            n3 = n4 = n6;
            n = n2 = 1536;
        }
        boolean bl = (mouseEvent.getModifiersEx() & n2) == n2 || (mouseEvent.getModifiersEx() & n) == n;
        boolean bl2 = (mouseEvent.getModifiersEx() & n6) == n6 || (mouseEvent.getModifiersEx() & n5) == n5;
        boolean bl3 = (mouseEvent.getModifiersEx() & n4) == n4 || (mouseEvent.getModifiersEx() & n3) == n3;
        boolean bl4 = bl || bl2 || bl3;
        boolean bl5 = !bl4 && (mouseEvent.getModifiersEx() & n9) == n9;
        Camera camera = ((CursorTool)t).getView().getCamera();
        if (bl4) {
            d2 = this.getMovementSpeed(t);
            d = (double)n7 * d2;
            double d3 = (double)n8 * -d2;
            if (bl) {
                camera.translateWorld(new Vector3d(0.0, 0.0, d3), true);
            }
            if (bl2) {
                Vector3d vector3d = camera.getRightVector();
                Vector3d vector3d2 = new Vector3d();
                vector3d2.cross(new Vector3d(0.0, 0.0, 1.0), vector3d);
                vector3d2.normalize();
                vector3d2.scale(d3);
                camera.translateWorld(vector3d2, true);
            }
            if (bl3) {
                camera.translateEye(d, 0.0, 0.0, true);
            }
        }
        if (bl5) {
            this.d_rotX -= (double)n8 * 0.175;
            this.d_rotZ -= (double)n7 * 0.175;
            d2 = this.d_rotX / 360.0;
            if (d2 > 1.0) {
                this.d_rotX = (d2 - Math.floor(d2)) * 360.0;
            } else if (d2 < -1.0) {
                this.d_rotX = (d2 - Math.ceil(d2)) * 360.0;
            }
            d = this.d_rotZ / 360.0;
            if (d > 1.0) {
                this.d_rotZ = (d - Math.floor(d)) * 360.0;
            } else if (d < -1.0) {
                this.d_rotZ = (d - Math.ceil(d)) * 360.0;
            }
            if (this.d_rotX > 89.0) {
                this.d_rotX = 89.0;
            } else if (this.d_rotX < -89.0) {
                this.d_rotX = -89.0;
            }
            camera.resetRotation();
            camera.rotate(this.d_rotX, 1.0, 0.0, 0.0);
            camera.rotate(this.d_rotZ, 0.0, 0.0, 1.0);
        }
        ((CursorTool)t).repaintSurface();
        if (!this.d_roamMode) {
            this.d_lastMouseLocation = mouseEvent.getPoint();
        }
    }

    private void calculateRotation(T t) {
        Camera camera = ((CursorTool)t).getView().getCamera();
        Point3d point3d = new Point3d(camera.getPosition());
        Point3d point3d2 = new Point3d(camera.getReference());
        Vector3d vector3d = new Vector3d();
        vector3d.sub(point3d2, point3d);
        Vector3d vector3d2 = new Vector3d(0.0, 1.0, 0.0);
        Vector3d vector3d3 = new Vector3d(vector3d.x, vector3d.y, 0.0);
        double d = vector3d2.angle(vector3d3);
        Vector3d vector3d4 = new Vector3d();
        vector3d4.cross(vector3d2, vector3d3);
        if (vector3d4.z < 0.0) {
            d = -d;
        }
        if (new Double(d).isNaN()) {
            d = 0.0;
        }
        AxisAngle4d axisAngle4d = new AxisAngle4d(0.0, 0.0, 1.0, -d);
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.set(axisAngle4d);
        matrix3d.transform(vector3d);
        Vector3d vector3d5 = new Vector3d(0.0, vector3d.y, vector3d.z);
        double d2 = vector3d2.angle(vector3d5);
        Vector3d vector3d6 = new Vector3d();
        vector3d6.cross(vector3d2, vector3d5);
        if (vector3d6.x < 0.0) {
            d2 = -d2;
        }
        if (new Double(d2).isNaN()) {
            d2 = 0.0;
        }
        this.d_rotZ = d * 180.0 / Math.PI;
        this.d_rotX = d2 * 180.0 / Math.PI;
    }
}

