/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import javax.vecmath.Matrix4d;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IConcreteRenderSurface;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.RenderBuffer;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.SceneLayout;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.VirtualRenderSurface;

public class nb3dUtil {
    public static void write(INativeStream iNativeStream, Matrix4d matrix4d) {
        iNativeStream.writeDoubles(matrix4d.m00, matrix4d.m01, matrix4d.m02, matrix4d.m03, matrix4d.m10, matrix4d.m11, matrix4d.m12, matrix4d.m13, matrix4d.m20, matrix4d.m21, matrix4d.m22, matrix4d.m23, matrix4d.m30, matrix4d.m31, matrix4d.m32, matrix4d.m33);
    }

    public static void writeFloats(INativeStream iNativeStream, Color color) {
        nb3dUtil.writeFloats(iNativeStream, color, new float[4]);
    }

    public static void writeFloats(INativeStream iNativeStream, Color color, float[] fArray) {
        color.getComponents(fArray);
        iNativeStream.writeFloats(fArray);
    }

    public static boolean takeScreenshot(String string, int n, int n2, Color color, IConcreteRenderSurface iConcreteRenderSurface, List<? extends SceneLayout> list, List<Rectangle> list2) throws IOException {
        int n3;
        if (list.size() != list2.size()) {
            return false;
        }
        int n4 = string.lastIndexOf(46);
        if (n4 == -1) {
            return false;
        }
        String string2 = string.substring(n4 + 1);
        Rectangle rectangle = new Rectangle();
        for (n3 = 0; n3 < list.size(); ++n3) {
            Rectangle rectangle2 = list2.get(n3);
            rectangle.add(rectangle2);
        }
        n3 = n * 3;
        int n5 = n3 * n2;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n5).order(ByteOrder.nativeOrder());
        if (color != null) {
            for (int i = 0; i < n5; i += 3) {
                byteBuffer.put((byte)color.getRed());
                byteBuffer.put((byte)color.getGreen());
                byteBuffer.put((byte)color.getBlue());
            }
            byteBuffer.position(0);
        }
        RenderBuffer renderBuffer = new RenderBuffer(iConcreteRenderSurface);
        for (int i = 0; i < list.size(); ++i) {
            SceneLayout sceneLayout = list.get(i);
            Rectangle rectangle3 = list2.get(i);
            double d = rectangle3.getWidth() / rectangle.getWidth() * (double)n;
            double d2 = rectangle3.getHeight() / rectangle.getHeight() * (double)n2;
            double d3 = rectangle3.getMinX() / rectangle.getWidth() * (double)n;
            double d4 = (rectangle.getHeight() - rectangle3.getMaxY()) / rectangle.getHeight() * (double)n2;
            renderBuffer.setLayout(sceneLayout);
            renderBuffer.setSize((int)d, (int)d2);
            byteBuffer.position((int)d4 * n3 + (int)d3 * 3);
            renderBuffer.setBuffer(byteBuffer.slice(), n3);
            renderBuffer.render();
        }
        byteBuffer.position(0);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n6 = byteBuffer.get() & 0xFF;
                int n7 = byteBuffer.get() & 0xFF;
                int n8 = byteBuffer.get() & 0xFF;
                int n9 = 0xFF000000 | n6 << 16 | n7 << 8 | n8;
                bufferedImage.setRGB(j, n2 - i - 1, n9);
            }
        }
        ImageIO.write((RenderedImage)bufferedImage, string2, new File(string));
        return true;
    }

    public static IConcreteRenderSurface findRenderSurface(Collection<? extends IRenderSurface> collection) {
        for (IRenderSurface iRenderSurface : collection) {
            IConcreteRenderSurface iConcreteRenderSurface;
            if (iRenderSurface instanceof IConcreteRenderSurface) {
                return (IConcreteRenderSurface)iRenderSurface;
            }
            if (!(iRenderSurface instanceof VirtualRenderSurface) || (iConcreteRenderSurface = ((VirtualRenderSurface)iRenderSurface).getBackingSurface()) == null) continue;
            return iConcreteRenderSurface;
        }
        return null;
    }
}

