/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import javax.vecmath.Matrix4d;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.Native;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.Camera;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IRenderable;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.Object3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.Keyable;
import thunderheadeng.gui.Application;

public class TextRenderer
extends Object3D
implements IRenderable {
    private static final long serialVersionUID = -2508195566672183971L;
    public static final int MODE_2D = 0;
    public static final int MODE_3D = 1;
    public static final int RENDERTYPE_PIXMAP = 0;
    public static final int RENDERTYPE_TEXTURE = 1;
    public static final int RENDERTYPE_BITMAP = 2;
    private static final int method_setRenderSurface = 0;
    private static final String DEFAULT_FACE_NAME = "lib/kochi-gothic-subst.ttf";
    private String d_face = TextRenderer.getDefaultFont();
    private Color d_fontColor = Color.BLACK;
    private float d_fontSize = 12.0f;
    private Camera d_camera = null;
    private int[] d_padding = new int[]{0, 0, 0, 0};
    private Matrix4d d_xform = null;
    private boolean d_showLeader = false;
    private int d_mode = 0;
    private int d_renderType = 1;

    public static String getDefaultFont() {
        String string = Application.getApp().getInstallDir();
        File file = new File(string, DEFAULT_FACE_NAME);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        URL uRL = TextRenderer.class.getResource(DEFAULT_FACE_NAME);
        if (uRL == null) {
            return DEFAULT_FACE_NAME;
        }
        String string2 = uRL.getFile();
        File file2 = null;
        try {
            file2 = new File(URLDecoder.decode(string2, "UTF-8"));
            return file2.getPath();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return DEFAULT_FACE_NAME;
        }
    }

    public TextRenderer() {
        this.nativeConstructed(TextRenderer.class);
    }

    public void setGraphicsContext(IRenderSurface iRenderSurface) {
        Native.manager.execMethod(TextRenderer.class, this, 0, iRenderSurface);
    }

    public void setMode(int n) {
        if (n == this.d_mode) {
            return;
        }
        this.d_mode = n;
        this.markNativeDirty();
    }

    public int getMode(int n) {
        return this.d_mode;
    }

    public void setRenderType(int n) {
        if (n == this.d_renderType) {
            return;
        }
        this.d_renderType = n;
        this.markNativeDirty();
    }

    public int getRenderType() {
        return this.d_renderType;
    }

    public void setTransform(Matrix4d matrix4d) {
        this.d_xform = matrix4d;
        this.markNativeDirty();
    }

    public void setLeaderEnabled(boolean bl) {
        if (this.d_showLeader == bl) {
            return;
        }
        this.d_showLeader = bl;
        this.markNativeDirty();
    }

    public boolean isLeaderEnabled() {
        return this.d_showLeader;
    }

    @Override
    public void writeNativeData(INativeStream iNativeStream) {
        iNativeStream.writeString(this.d_face);
        iNativeStream.writeFloats(this.d_fontColor.getComponents(null));
        iNativeStream.writeFloat(this.d_fontSize);
        iNativeStream.writeInt(this.d_renderType);
        iNativeStream.writeInt(this.d_mode);
        iNativeStream.writeInts(this.d_padding);
        iNativeStream.write((Keyable)this.d_camera);
        iNativeStream.writeBoolean(this.d_xform != null);
        if (this.d_xform != null) {
            iNativeStream.writeDoubles(this.d_xform.m00, this.d_xform.m01, this.d_xform.m02, this.d_xform.m03, this.d_xform.m10, this.d_xform.m11, this.d_xform.m12, this.d_xform.m13, this.d_xform.m20, this.d_xform.m21, this.d_xform.m22, this.d_xform.m23, this.d_xform.m30, this.d_xform.m31, this.d_xform.m32, this.d_xform.m33);
        }
        iNativeStream.writeBoolean(this.d_showLeader);
    }

    @Override
    public Class resolveNativeClass() {
        return TextRenderer.class;
    }

    public void setFace(String string) {
        this.d_face = string;
        this.markNativeDirty();
    }

    public void setFontColor(Color color) {
        this.d_fontColor = color;
        this.markNativeDirty();
    }

    public void setFontSize(float f) {
        this.d_fontSize = f;
        this.markNativeDirty();
    }

    public void setCamera(Camera camera) {
        this.d_camera = camera;
        this.markNativeDirty();
    }

    public void setPadding(int[] nArray) {
        assert (nArray.length == 4);
        this.d_padding = nArray;
        this.markNativeDirty();
    }
}

