/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.util.Arrays;
import java.util.HashSet;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.Native;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.ConcreteRenderSurface;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IRenderSurface;

public class RenderWindow
extends ConcreteRenderSurface {
    private static final long serialVersionUID = 3143271052495260201L;
    public static final int CAP_FAST_DEPTH_READS = 1;
    public static final int CAP_FAST_COLOR_READS = 2;
    public static final int CAP_FAST_VERTEX_BUFFERS = 4;
    public static final int CAP_FAST_SHADERS = 8;
    public static final int ALL_CAPS = 15;
    private static final int method_getPrimaryDisplayAdapterInfo = 0;
    private IRenderSurface d_sharingSurface = null;

    public RenderWindow() {
        this(null);
    }

    @Override
    public Class resolveNativeClass() {
        return RenderWindow.class;
    }

    public RenderWindow(IRenderSurface iRenderSurface) {
        this.d_sharingSurface = iRenderSurface;
    }

    public IRenderSurface getSharingSurface() {
        return this.d_sharingSurface;
    }

    public void setSharingSurface(IRenderSurface iRenderSurface) {
        this.d_sharingSurface = iRenderSurface;
    }

    public static DeviceInfo getPrimaryDisplayAdapterInfo() {
        Native.manager.lockWriteBuffer();
        Native.manager.execStaticMethod(RenderWindow.class, 0, new Object[0]);
        Native.manager.flush();
        DeviceInfo deviceInfo = new DeviceInfo(Native.manager.readString(), Native.manager.readString(), Native.manager.readString(), Native.manager.readString());
        Native.manager.unlockWriteBuffer();
        return deviceInfo;
    }

    public static int testCapabilities(int n) {
        int n2 = 0;
        DeviceInfo deviceInfo = RenderWindow.getPrimaryDisplayAdapterInfo();
        String string = deviceInfo.desc.toLowerCase();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(string.split("\\W")));
        if (hashSet.contains("nvidia")) {
            n2 = n;
        } else if (hashSet.contains("ati")) {
            n2 = n & 0xFFFFFFFE;
        }
        return n2;
    }

    public static class DeviceInfo {
        public final String name;
        public final String desc;
        public final String id;
        public final String key;

        public DeviceInfo(String string, String string2, String string3, String string4) {
            this.name = string;
            this.desc = string2;
            this.id = string3;
            this.key = string4;
        }
    }
}

