/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.awt.Canvas;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.concurrent.Callable;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.Native;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.ARenderCounter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IConcreteRenderSurface;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.RenderWindow;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.SceneLayout;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.Viewport;

public class RenderComponent
extends Canvas
implements IConcreteRenderSurface {
    private static final long serialVersionUID = -869616839982922850L;
    private boolean d_nativeSurfaceCreated = false;
    private boolean d_canRender = false;
    private boolean d_resourcesValid = false;
    private final RenderWindow d_helperSurface;
    private final Painter d_painter;
    private final ARenderCounter d_renderCounter = new ARenderCounter(){

        @Override
        protected void forceRender(Viewport viewport) {
            RenderComponent.this.forceRender(viewport);
        }

        @Override
        protected Viewport getFullVP() {
            return new Viewport(0, 0, RenderComponent.this.getWidth(), RenderComponent.this.getHeight());
        }
    };

    private native void lock(int var1);

    private native void unlock(int var1);

    private native boolean initResources(int var1, int var2);

    private native void freeResources(int var1);

    private void lock() {
        Native.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                RenderComponent.this.lock(RenderComponent.this.getKey());
            }
        });
    }

    private void unlock() {
        Native.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                RenderComponent.this.unlock(RenderComponent.this.getKey());
            }
        });
    }

    private void freeResources() {
        Native.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                RenderComponent.this.freeResources(RenderComponent.this.getKey());
            }
        });
    }

    private boolean initResources(final IRenderSurface iRenderSurface) {
        return Native.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                int n = iRenderSurface == null ? 0 : iRenderSurface.getKey();
                return RenderComponent.this.initResources(RenderComponent.this.getKey(), n);
            }
        });
    }

    public RenderComponent() {
        this((IRenderSurface)null);
    }

    public RenderComponent(IRenderSurface iRenderSurface) {
        this.d_helperSurface = new RenderWindow(iRenderSurface);
        this.d_painter = new Painter();
        this.setMinimumSize(new Dimension(0, 0));
    }

    public boolean isInitialized() {
        return this.d_nativeSurfaceCreated;
    }

    public void setSharingSurface(IRenderSurface iRenderSurface) {
        assert (!this.d_nativeSurfaceCreated);
        this.d_helperSurface.setSharingSurface(iRenderSurface);
    }

    @Override
    public Cursor getCursor() {
        Cursor cursor;
        Container container = this.getParent();
        if (container != null && (cursor = container.getCursor()).equals(Cursor.getPredefinedCursor(3))) {
            return cursor;
        }
        return super.getCursor();
    }

    public boolean initResources() {
        if (!this.d_nativeSurfaceCreated) {
            RenderComponent renderComponent;
            IRenderSurface iRenderSurface = this.d_helperSurface.getSharingSurface();
            if (iRenderSurface instanceof RenderComponent && !(renderComponent = (RenderComponent)iRenderSurface).isInitialized()) {
                renderComponent.setSharingSurface(this);
                iRenderSurface = null;
            }
            this.d_resourcesValid = this.initResources(iRenderSurface);
            this.d_nativeSurfaceCreated = true;
        }
        return this.d_resourcesValid;
    }

    @Override
    public float getZValue(int n, int n2) {
        return this.d_helperSurface.getZValue(n, n2);
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.d_helperSurface.setSize(n, n2);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.d_helperSurface.setSize(n3, n4);
    }

    @Override
    public void setLayout(SceneLayout sceneLayout) {
        this.d_helperSurface.setLayout(sceneLayout);
    }

    @Override
    public SceneLayout getLayout() {
        return this.d_helperSurface.getLayout();
    }

    @Override
    public void updateLayout() {
        this.d_helperSurface.updateLayout();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.d_canRender = true;
        this.setVisible(false);
        this.setVisible(true);
    }

    @Override
    public void removeNotify() {
        this.d_canRender = false;
        Native.manager.flush();
        this.freeResources();
        this.d_nativeSurfaceCreated = false;
        this.d_resourcesValid = false;
        super.removeNotify();
    }

    public void redraw() {
        this.render();
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        this.render(new Viewport(0, 0, this.getWidth(), this.getHeight()));
    }

    protected synchronized void forceRender(Viewport viewport) {
        this.d_painter.d_clippingVP = viewport;
        if (EventQueue.isDispatchThread()) {
            this.d_painter.run();
        } else {
            try {
                EventQueue.invokeLater(this.d_painter);
            }
            catch (Exception exception) {
                System.err.println("Render thread interrupted.");
            }
        }
    }

    @Override
    public Integer getKey() {
        return this.d_helperSurface.getKey();
    }

    private final Viewport rectToVp(Rectangle rectangle) {
        if (rectangle == null) {
            return new Viewport(0, 0, this.getWidth(), this.getHeight());
        }
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = rectangle.x;
        int n4 = this.getHeight() - (rectangle.y + rectangle.height) - 1;
        return new Viewport(n3, n4, n, n2);
    }

    @Override
    public void pauseRender() {
        this.d_renderCounter.pauseRender();
    }

    @Override
    public void render() {
        this.d_renderCounter.render();
    }

    @Override
    public void render(Viewport viewport) {
        this.d_renderCounter.render(viewport);
    }

    @Override
    public void resumeRender() {
        this.d_renderCounter.resumeRender();
    }

    @Override
    public void resumeRender(boolean bl) {
        this.d_renderCounter.resumeRender(bl);
    }

    private class Painter
    implements Runnable {
        private volatile Viewport d_clippingVP;

        private Painter() {
        }

        @Override
        public void run() {
            if (!RenderComponent.this.d_canRender) {
                return;
            }
            RenderComponent.this.d_canRender = false;
            Native.manager.flush();
            RenderComponent.this.initResources();
            RenderComponent.this.d_helperSurface.getFPSTimer().start();
            RenderComponent.this.lock();
            RenderComponent.this.d_helperSurface.render(this.d_clippingVP);
            RenderComponent.this.unlock();
            RenderComponent.this.d_helperSurface.getFPSTimer().stop();
            RenderComponent.this.d_canRender = true;
        }
    }
}

