/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.Camera;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.CameraRecord;

public class OrthoCamera
extends Camera {
    private static final long serialVersionUID = -7514484926758313826L;
    private double d_height;

    private OrthoCamera() {
    }

    public OrthoCamera(Point3d point3d, Point3d point3d2, Vector3d vector3d, double d, double d2, double d3) {
        super(point3d, point3d2, vector3d, d, d2);
        this.d_height = d3;
        this.nativeConstructed(OrthoCamera.class);
    }

    @Override
    public void writeNativeData(INativeStream iNativeStream) {
        super.writeNativeData(iNativeStream);
        iNativeStream.writeDouble(this.d_height);
    }

    @Override
    public Class resolveNativeClass() {
        return OrthoCamera.class;
    }

    @Override
    public Camera createCopyCam() {
        OrthoCamera orthoCamera = new OrthoCamera();
        orthoCamera.setCopyCam(this);
        return orthoCamera;
    }

    public void setWorldHeight(double d) {
        this.d_height = d;
        this.markDirty();
    }

    public double getWorldHeight() {
        return this.d_height;
    }

    @Override
    protected Point3d constrainPointToView(Point3d point3d, Point3d point3d2) {
        Point3d point3d3 = this.getPosition();
        Vector3d vector3d = this.getViewVector();
        vector3d.normalize();
        Vector3d vector3d2 = new Vector3d();
        vector3d2.sub(point3d, point3d3);
        double d = vector3d.dot(vector3d2);
        Vector3d vector3d3 = new Vector3d();
        vector3d3.sub(point3d2, point3d3);
        double d2 = vector3d.dot(vector3d3);
        double d3 = d - d2;
        Point3d point3d4 = new Point3d(vector3d);
        point3d4.scale(d3);
        point3d4.add(point3d2);
        return point3d4;
    }

    @Override
    protected double calcScreenZValue(double d) {
        double d2 = 1.0 / (this.getFarClip() - this.getNearClip());
        double d3 = -2.0 * d2;
        double d4 = -(this.getFarClip() - this.getNearClip()) * d2;
        double d5 = d3 * d + d4;
        return d5 * 0.5 + 0.5;
    }

    @Override
    public double getSubjectSize() {
        return this.d_height;
    }

    @Override
    public void reset(Vector3d vector3d, Vector3d vector3d2, AABox aABox, int n, int n2) {
        super.reset(vector3d, vector3d2, aABox, n, n2);
        Point3d point3d = aABox.getMin();
        Point3d point3d2 = aABox.getMax();
        Point3d[] point3dArray = new Point3d[]{new Point3d(point3d.x, point3d.y, point3d.z), new Point3d(point3d.x, point3d.y, point3d2.z), new Point3d(point3d.x, point3d2.y, point3d.z), new Point3d(point3d.x, point3d2.y, point3d2.z), new Point3d(point3d2.x, point3d.y, point3d.z), new Point3d(point3d2.x, point3d.y, point3d2.z), new Point3d(point3d2.x, point3d2.y, point3d.z), new Point3d(point3d2.x, point3d2.y, point3d2.z)};
        Matrix3d matrix3d = this.getLocalTransformLHR();
        Point3d point3d3 = new Point3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Point3d point3d4 = new Point3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (int i = 0; i < 8; ++i) {
            matrix3d.transform(point3dArray[i]);
            if (point3dArray[i].x < point3d3.x) {
                point3d3.x = point3dArray[i].x;
            }
            if (point3dArray[i].x > point3d4.x) {
                point3d4.x = point3dArray[i].x;
            }
            if (point3dArray[i].y < point3d3.y) {
                point3d3.y = point3dArray[i].y;
            }
            if (point3dArray[i].y > point3d4.y) {
                point3d4.y = point3dArray[i].y;
            }
            if (-point3dArray[i].z < point3d3.z) {
                point3d3.z = -point3dArray[i].z;
            }
            if (!(-point3dArray[i].z > point3d4.z)) continue;
            point3d4.z = -point3dArray[i].z;
        }
        Vector3d vector3d3 = new Vector3d();
        vector3d3.sub(point3d4, point3d3);
        double d = vector3d3.y / vector3d3.x;
        double d2 = (double)n2 / (double)n;
        double d3 = d >= d2 ? vector3d3.y : vector3d3.x * d2;
        d3 *= 1.1;
        Point3d point3d5 = new Point3d();
        point3d5.add(point3d, point3d2);
        point3d5.scale(0.5);
        Vector3d vector3d4 = this.getViewVector();
        vector3d4.normalize();
        double d4 = Math.max(vector3d3.z * 0.5 + 10.0, Math.sqrt(vector3d3.x * vector3d3.x + vector3d3.y * vector3d3.y));
        Point3d point3d6 = new Point3d();
        point3d6.scale(d4, vector3d4);
        point3d6.sub(point3d5, point3d6);
        this.setWorldHeight(d3);
        this.setPosition(point3d6);
        this.setReference(point3d5);
        this.fitClipping(aABox);
    }

    @Override
    public Vector3d getViewVector(Point3d point3d) {
        return this.getViewVector();
    }

    @Override
    public CameraRecord capture() {
        return new CameraRecord(this.getPosition(), this.getReference(), this.getUpVector(), this.getZoom(), this.getZoomLoc(), this.getNearClip(), this.getFarClip(), this.getWorldHeight());
    }

    @Override
    public void apply(CameraRecord cameraRecord) {
        this.pauseUpdates();
        super.apply(cameraRecord);
        this.setWorldHeight(cameraRecord.extra);
        this.resumeUpdates();
    }
}

