/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.vecmath.Matrix4d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.Native;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IDisplayable;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IRenderable;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.ISceneObject;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.Scene;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.SceneRenderOptions;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredCollection;
import pyrosim.legacy_2012_1.thunderheadeng.util.Keyable;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class ModelScene
extends Scene {
    private static final long serialVersionUID = 1481471511062920032L;
    private static final int MAX_ARR_SIZE = 10000;
    private SceneRenderOptions d_drawProps = new SceneRenderOptions();
    private Matrix4d d_xform = null;
    private static final int method_addRenderableObjects = 0;
    private static final int method_removeRenderableObjects = 1;
    private static final int method_addSceneObjects = 2;
    private static final int method_removeSceneObjects = 3;
    private static final int method_removeAllObjects = 4;
    private static final int method_forceImmediate = 5;
    private static final int method_addCullBox = 6;
    private static final int method_removeCullBox = 7;
    private static final int method_removeAllCullBoxes = 8;

    public ModelScene() {
        this.markNativeDirty();
        this.nativeConstructed(ModelScene.class);
    }

    public void setTransform(Matrix4d matrix4d) {
        if (theUtil.equal(this.d_xform, matrix4d)) {
            return;
        }
        this.d_xform = matrix4d;
        this.markNativeDirty();
    }

    public Matrix4d getTransform() {
        return this.d_xform;
    }

    @Override
    public Class resolveNativeClass() {
        return ModelScene.class;
    }

    public void setDrawProps(SceneRenderOptions sceneRenderOptions) {
        assert (sceneRenderOptions != null);
        this.d_drawProps = sceneRenderOptions;
        this.markNativeDirty();
    }

    public SceneRenderOptions getDrawProps() {
        return this.d_drawProps;
    }

    @Override
    public void writeNativeData(INativeStream iNativeStream) {
        super.writeNativeData(iNativeStream);
        iNativeStream.write((Keyable)this.d_drawProps);
        iNativeStream.writeBoolean(this.d_xform != null);
        if (this.d_xform != null) {
            Matrix4d matrix4d = new Matrix4d(this.d_xform);
            matrix4d.invert();
            ModelScene.write(iNativeStream, this.d_xform);
            ModelScene.write(iNativeStream, matrix4d);
        }
    }

    private static void write(INativeStream iNativeStream, Matrix4d matrix4d) {
        iNativeStream.writeDoubles(matrix4d.m00, matrix4d.m01, matrix4d.m02, matrix4d.m03, matrix4d.m10, matrix4d.m11, matrix4d.m12, matrix4d.m13, matrix4d.m20, matrix4d.m21, matrix4d.m22, matrix4d.m23, matrix4d.m30, matrix4d.m31, matrix4d.m32, matrix4d.m33);
    }

    public void forceImmediate(boolean bl) {
        Native.manager.execMethod(ModelScene.class, this, 5, bl);
        Native.manager.flush();
    }

    public void addObjects(IDisplayable ... iDisplayableArray) {
        this.addObjects(Arrays.asList(iDisplayableArray));
    }

    public void addObjects(Collection<? extends IDisplayable> collection) {
        this.addRenderableObjects(new FilteredCollection<IRenderable>(collection, IRenderable.class));
        this.addSceneObjects(new FilteredCollection<ISceneObject>(collection, ISceneObject.class));
    }

    public void removeObjects(IDisplayable ... iDisplayableArray) {
        this.removeObjects(Arrays.asList(iDisplayableArray));
    }

    public void removeObjects(Collection<? extends IDisplayable> collection) {
        this.removeRenderableObjects(new FilteredCollection<IRenderable>(collection, IRenderable.class));
        this.removeSceneObjects(new FilteredCollection<ISceneObject>(collection, ISceneObject.class));
    }

    public void addRenderableObjects(IRenderable ... iRenderableArray) {
        this.addRenderableObjects(Arrays.asList(iRenderableArray));
    }

    public void addRenderableObjects(Collection<? extends IRenderable> collection) {
        this.execArrayMethod(0, collection);
    }

    public void removeRenderableObjects(IRenderable ... iRenderableArray) {
        this.removeRenderableObjects(Arrays.asList(iRenderableArray));
    }

    public void removeRenderableObjects(Collection<? extends IRenderable> collection) {
        this.execArrayMethod(1, collection);
    }

    public void addSceneObjects(ISceneObject ... iSceneObjectArray) {
        this.addSceneObjects(Arrays.asList(iSceneObjectArray));
    }

    public void addSceneObjects(Collection<? extends ISceneObject> collection) {
        this.execArrayMethod(2, collection);
    }

    public void removeSceneObjects(ISceneObject ... iSceneObjectArray) {
        this.removeSceneObjects(Arrays.asList(iSceneObjectArray));
    }

    public void removeSceneObjects(Collection<? extends ISceneObject> collection) {
        this.execArrayMethod(3, collection);
    }

    public void removeAllObjects() {
        Native.manager.execMethod(ModelScene.class, this, 4, new Object[0]);
    }

    private final void execArrayMethod(int n, Collection<? extends Keyable> collection) {
        int n2 = collection.size() / 10000;
        if (collection.size() % 10000 != 0) {
            ++n2;
        }
        Iterator<? extends Keyable> iterator = collection.iterator();
        int n3 = collection.size();
        Object[] objectArray = new Object[Math.min(10000, n3)];
        for (int i = 0; i < n2; ++i) {
            int n4 = Math.min(n3, 10000);
            if (i == n2 - 1 && i > 0) {
                objectArray = new Object[n4];
            }
            for (int j = 0; j < n4; ++j) {
                objectArray[j] = iterator.next();
            }
            n3 -= n4;
            Native.manager.execMethod(ModelScene.class, this, n, n4, objectArray);
        }
    }

    private final Object[] getKeyableArray(Collection<?> collection) {
        FilteredCollection<Keyable> filteredCollection = new FilteredCollection<Keyable>(collection, Keyable.class);
        Object[] objectArray = filteredCollection.toArray((Keyable[])new Keyable[filteredCollection.size()]);
        return objectArray;
    }

    private static Object[] extractCHParams(ConvexHull convexHull) {
        Object[] objectArray = new Object[1 + convexHull.getPlanes().length * 4];
        objectArray[0] = convexHull.getPlanes().length;
        for (int i = 0; i < convexHull.getPlanes().length; ++i) {
            Plane3d plane3d = convexHull.getPlanes()[i];
            int n = (i << 2) + 1;
            objectArray[n + 0] = plane3d.x;
            objectArray[n + 1] = plane3d.y;
            objectArray[n + 2] = plane3d.z;
            objectArray[n + 3] = plane3d.w;
        }
        return objectArray;
    }

    public void addCullBox(ConvexHull convexHull) {
        Object[] objectArray = ModelScene.extractCHParams(convexHull);
        Native.manager.execMethod(ModelScene.class, this, 6, objectArray);
    }

    public void removeCullBox(ConvexHull convexHull) {
        Object[] objectArray = ModelScene.extractCHParams(convexHull);
        Native.manager.execMethod(ModelScene.class, this, 7, objectArray);
    }

    public void removeAllCullBoxes() {
        Native.manager.execMethod(ModelScene.class, this, 8, new Object[0]);
    }
}

