/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.ANativelyMirrored;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.NativeImage;
import pyrosim.legacy_2012_1.thunderheadeng.util.Keyable;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class Material
extends ANativelyMirrored {
    private static final long serialVersionUID = -5509726297599843462L;
    private Color d_diffuseColor;
    private Color d_specularColor;
    private NativeImage d_diffuseTex;
    private NativeImage d_specularTex;
    private NativeImage d_normalTex;

    public Material() {
        this.d_diffuseColor = this.d_specularColor = Color.BLACK;
        this.d_normalTex = null;
        this.d_specularTex = null;
        this.d_diffuseTex = null;
        this.nativeConstructed(Material.class);
    }

    @Override
    public Class resolveNativeClass() {
        return Material.class;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Material)) {
            return false;
        }
        Material material = (Material)object;
        return this.d_diffuseColor.equals(material.d_diffuseColor) && this.d_specularColor.equals(material.d_specularColor) && this.d_diffuseTex == material.d_diffuseTex && this.d_specularTex == material.d_specularTex && this.d_normalTex == material.d_normalTex;
    }

    public int hashCode() {
        return 54497274 + this.d_diffuseColor.hashCode() + this.d_specularColor.hashCode() + System.identityHashCode(this.d_diffuseTex) + System.identityHashCode(this.d_specularTex) + System.identityHashCode(this.d_normalTex);
    }

    public void setDiffuse(Color color, NativeImage nativeImage) {
        this.d_diffuseColor = color;
        this.d_diffuseTex = nativeImage;
        this.markNativeDirty();
    }

    public Pair<Color, NativeImage> getDiffuse() {
        return new Pair<Color, NativeImage>(this.d_diffuseColor, this.d_diffuseTex);
    }

    public void setSpecular(Color color, NativeImage nativeImage) {
        this.d_specularColor = color;
        this.d_specularTex = nativeImage;
        this.markNativeDirty();
    }

    public Pair<Color, NativeImage> getSpecular() {
        return new Pair<Color, NativeImage>(this.d_specularColor, this.d_specularTex);
    }

    public void setNormal(NativeImage nativeImage) {
        this.d_normalTex = nativeImage;
        this.markNativeDirty();
    }

    public NativeImage getNormal() {
        return this.d_normalTex;
    }

    @Override
    public void writeNativeData(INativeStream iNativeStream) {
        Material.write(iNativeStream, this.d_diffuseColor);
        iNativeStream.write((Keyable)this.d_diffuseTex);
        Material.write(iNativeStream, this.d_specularColor);
        iNativeStream.write((Keyable)this.d_specularTex);
        iNativeStream.write((Keyable)this.d_normalTex);
    }

    private static void write(INativeStream iNativeStream, Color color) {
        iNativeStream.writeBytes((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)color.getAlpha());
    }
}

