/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyLine;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Quad;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Triangle;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.Native;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IGeomSource;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IMaterial;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.ITexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IDisplayable;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.ISceneObject;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.Material;
import pyrosim.legacy_2012_1.thunderheadeng.util.Keyable;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class GeomDisplay
extends ISceneObject {
    private static final long serialVersionUID = 6764469365996011489L;
    private static final int method_setSelected = 0;
    private boolean d_selected = false;
    private INativeDisplayProps d_dispProps;
    private IGeomSource d_source;

    public GeomDisplay(INativeDisplayProps iNativeDisplayProps, IGeomSource iGeomSource) {
        this.d_dispProps = iNativeDisplayProps;
        this.d_source = iGeomSource;
        this.nativeConstructed(GeomDisplay.class);
    }

    @Override
    public Class resolveNativeClass() {
        return GeomDisplay.class;
    }

    public IDisplayable[] getDisplayObjs() {
        return new IDisplayable[]{this};
    }

    public INativeDisplayProps getDisplayProps() {
        return this.d_dispProps;
    }

    public void setSelected(boolean bl) {
        if (this.d_selected == bl) {
            return;
        }
        this.d_selected = bl;
        Native.manager.execMethod(GeomDisplay.class, this, 0, bl);
    }

    public boolean isSelected() {
        return this.d_selected;
    }

    public IGeomSource getSource() {
        return this.d_source;
    }

    public void setSource(IGeomSource iGeomSource) {
        this.d_source = iGeomSource;
        this.update();
    }

    public void update() {
        this.markNativeDirty();
    }

    @Override
    public void writeNativeData(INativeStream iNativeStream) {
        super.writeNativeData(iNativeStream);
        iNativeStream.writeInts(0, 0, 0, 0);
        DisplayGeom displayGeom = this.d_source.getDisplayGeom(this.d_dispProps);
        IGeom iGeom = displayGeom.geom;
        IPropsSrc iPropsSrc = displayGeom.props;
        this.writeGeom(iNativeStream, iGeom, iPropsSrc, 0, displayGeom.texuv);
        iNativeStream.writeInt(GeomType.GT_END.ordinal());
    }

    private int writeGeom(INativeStream iNativeStream, IGeom iGeom, IPropsSrc iPropsSrc, int n, ITexCoordGenerator iTexCoordGenerator) {
        if (iGeom instanceof Point) {
            this.writePoint(iNativeStream, (Point)iGeom, iPropsSrc.get(n++));
        } else if (iGeom instanceof LineSeg) {
            this.writeLineSeg(iNativeStream, (LineSeg)iGeom, iPropsSrc.get(n++));
        } else if (iGeom instanceof PolyLine) {
            this.writeLineStrip(iNativeStream, (PolyLine)iGeom, iPropsSrc.get(n++));
        } else if (iGeom instanceof Triangle) {
            this.writeTriangle(iNativeStream, (Triangle)iGeom, iPropsSrc.get(n), n, iTexCoordGenerator);
            ++n;
        } else if (iGeom instanceof Quad) {
            this.writeQuad(iNativeStream, (Quad)iGeom, iPropsSrc.get(n), n, iTexCoordGenerator);
            ++n;
        } else if (iGeom instanceof IPolygon) {
            this.writePoly(iNativeStream, (IPolygon)iGeom, iPropsSrc.get(n), n, iTexCoordGenerator);
            ++n;
        } else if (iGeom instanceof Mesh) {
            n = this.writeMesh(iNativeStream, (Mesh)iGeom, iPropsSrc, n, iTexCoordGenerator, null);
        } else if (iGeom instanceof ICurve) {
            Mesh mesh = ((ICurve)iGeom).getSegments(this.d_dispProps.getCurveError());
            n = this.writeMesh(iNativeStream, mesh, iPropsSrc, n, iTexCoordGenerator, (ICurve)iGeom);
        } else if (iGeom instanceof IFace) {
            Mesh mesh = ((IFace)iGeom).triangulate(this.d_dispProps.getFaceError());
            n = this.writeMesh(iNativeStream, mesh, iPropsSrc, n, iTexCoordGenerator, (IFace)iGeom);
        } else if (iGeom.canExplode()) {
            Collection<IGeom> collection = iGeom.explode(new ArrayList<IGeom>());
            for (IGeom iGeom2 : collection) {
                n = this.writeGeom(iNativeStream, iGeom2, iPropsSrc, n, iTexCoordGenerator);
            }
        } else {
            assert (iGeom.getNumPrims(7) == 0);
            n += iGeom.getNumPrims(7);
        }
        return n;
    }

    private static List<Point2d> generateTexUV(IPolygon iPolygon, IPrimProps iPrimProps, int n, ITexCoordGenerator iTexCoordGenerator) {
        if (GeomDisplay.needsTexUV(iPrimProps)) {
            ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
            iTexCoordGenerator.generate(n, iPolygon, iPrimProps, arrayList);
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    private static void write(INativeStream iNativeStream, List<Point2d> list) {
        iNativeStream.writeInt(list.size());
        for (Point2d point2d : list) {
            iNativeStream.writeFloat((float)point2d.x);
            iNativeStream.writeFloat((float)point2d.y);
        }
    }

    private void writePoint(INativeStream iNativeStream, Point point, IPrimProps iPrimProps) {
        this.beginGeom(iNativeStream, point, GeomType.GT_POINT.ordinal(), iPrimProps);
        this.write(iNativeStream, point.loc);
    }

    private void writeLineSeg(INativeStream iNativeStream, LineSeg lineSeg, IPrimProps iPrimProps) {
        this.beginGeom(iNativeStream, lineSeg, GeomType.GT_LINESEG.ordinal(), iPrimProps);
        this.write(iNativeStream, lineSeg.p1, lineSeg.p2);
    }

    private void writeLineStrip(INativeStream iNativeStream, PolyLine polyLine, IPrimProps iPrimProps) {
        this.beginGeom(iNativeStream, polyLine, GeomType.GT_LINE_STRIP.ordinal(), iPrimProps);
        this.writeArray(iNativeStream, polyLine.verts);
    }

    private void writeTriangle(INativeStream iNativeStream, Triangle triangle, IPrimProps iPrimProps, int n, ITexCoordGenerator iTexCoordGenerator) {
        this.beginGeom(iNativeStream, triangle, GeomType.GT_TRIANGLE.ordinal(), iPrimProps);
        GeomDisplay.write(iNativeStream, GeomDisplay.generateTexUV(triangle, iPrimProps, n, iTexCoordGenerator));
        this.write(iNativeStream, triangle.p1, triangle.p2, triangle.p3);
    }

    private void writeQuad(INativeStream iNativeStream, Quad quad, IPrimProps iPrimProps, int n, ITexCoordGenerator iTexCoordGenerator) {
        this.beginGeom(iNativeStream, quad, GeomType.GT_QUAD.ordinal(), iPrimProps);
        GeomDisplay.write(iNativeStream, GeomDisplay.generateTexUV(quad, iPrimProps, n, iTexCoordGenerator));
        this.write(iNativeStream, quad.p1, quad.p2, quad.p3, quad.p4);
    }

    private void writePoly(INativeStream iNativeStream, IPolygon iPolygon, IPrimProps iPrimProps, int n, ITexCoordGenerator iTexCoordGenerator) {
        this.beginGeom(iNativeStream, iPolygon, GeomType.GT_POLYGON.ordinal(), iPrimProps);
        GeomDisplay.write(iNativeStream, GeomDisplay.generateTexUV(iPolygon, iPrimProps, n, iTexCoordGenerator));
        iNativeStream.writeInt(iPolygon.getNumLoops());
        for (int i = 0; i < iPolygon.getNumLoops(); ++i) {
            iNativeStream.writeInt(iPolygon.getNumPoints(i));
            for (int j = 0; j < iPolygon.getNumPoints(i); ++j) {
                Point3d point3d = iPolygon.getPoint(i, j);
                this.write(iNativeStream, point3d);
            }
        }
    }

    private int writeMesh(INativeStream iNativeStream, Mesh mesh, IPropsSrc iPropsSrc, int n, ITexCoordGenerator iTexCoordGenerator, IPrimitive iPrimitive) {
        Object object;
        List<Point2d> list;
        int n2;
        iNativeStream.writeInt(GeomType.GT_MESH.ordinal());
        boolean bl = mesh.testFlag(2);
        iNativeStream.writeBoolean(bl);
        switch (mesh.primtype) {
            case 0: {
                iNativeStream.writeInt(GeomType.GT_POINT.ordinal());
                break;
            }
            case 1: {
                iNativeStream.writeInt(GeomType.GT_LINESEG.ordinal());
                break;
            }
            case 2: {
                iNativeStream.writeInt(GeomType.GT_TRIANGLE.ordinal());
                break;
            }
            case 3: {
                iNativeStream.writeInt(GeomType.GT_QUAD.ordinal());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        boolean bl2 = mesh.primtype == 3 || mesh.primtype == 2;
        boolean bl3 = false;
        int n3 = mesh.getNumPrims(7);
        int n4 = n2 = iPrimitive != null ? 1 : n3;
        if (iPropsSrc.isUniform(n, n2)) {
            iNativeStream.writeInt(1);
            list = iPropsSrc.get(n);
            this.writeMeta(iNativeStream, mesh, (IPrimProps)((Object)list));
            bl3 = bl2 && GeomDisplay.needsTexUV((IPrimProps)((Object)list));
        } else {
            list = new LinkedIdentityHashMap();
            object = new int[n2];
            for (int i = 0; i < n2; ++i) {
                IPrimProps iPrimProps = iPropsSrc.get(n + i);
                bl3 = bl3 || bl2 && GeomDisplay.needsTexUV(iPrimProps);
                Integer n5 = (Integer)list.get(iPrimProps);
                if (n5 == null) {
                    n5 = list.size();
                    list.put(iPrimProps, n5);
                }
                object[i] = n5;
            }
            iNativeStream.writeInt(list.size());
            if (list.size() == 1) {
                this.writeMeta(iNativeStream, mesh, (IPrimProps)list.keySet().iterator().next());
            } else if (!list.isEmpty()) {
                for (IPrimProps iPrimProps : list.keySet()) {
                    this.writeMeta(iNativeStream, mesh, iPrimProps);
                }
                this.writeArray(iNativeStream, (int)object);
            }
        }
        list = Collections.EMPTY_LIST;
        if (bl3) {
            if (iPrimitive != null) {
                list = new ArrayList<Point2d>();
                iTexCoordGenerator.generate(n, (IFace)iPrimitive, iPropsSrc.get(n), mesh, list);
            } else {
                object = GeomDisplay.generateTexUV(iTexCoordGenerator, mesh, iPropsSrc, n, n3);
                mesh = (Mesh)object.v1;
                list = (List)object.v2;
            }
        }
        this.writeArray(iNativeStream, mesh.vertices);
        GeomDisplay.write(iNativeStream, list);
        this.writeArray(iNativeStream, mesh.indices);
        return n + n2;
    }

    private static boolean needsTexUV(IPrimProps iPrimProps) {
        IMaterial iMaterial = iPrimProps.getMaterial();
        return iMaterial != null && (iMaterial.getDiffuse().v2 != null || iMaterial.getNormal() != null || iMaterial.getSpecular().v2 != null);
    }

    private static Pair<Mesh, List<Point2d>> generateTexUV(ITexCoordGenerator iTexCoordGenerator, Mesh mesh, IPropsSrc iPropsSrc, int n, int n2) {
        Point2d point2d = new Point2d(0.0, 0.0);
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>(mesh.vertices.length);
        for (int i = 0; i < mesh.vertices.length; ++i) {
            arrayList.add(null);
        }
        ArrayList<Point3d> arrayList2 = new ArrayList<Point3d>(Arrays.asList(mesh.vertices));
        int[] nArray = new int[mesh.indices.length];
        int n3 = mesh.primtype == 3 ? 4 : 3;
        ArrayList<Point2d> arrayList3 = new ArrayList<Point2d>(n3);
        int n4 = 0;
        int n5 = 0;
        while (n4 < mesh.indices.length) {
            IPrimProps iPrimProps = iPropsSrc.get(n + n5);
            if (!GeomDisplay.needsTexUV(iPrimProps)) {
                for (int i = 0; i < n3; ++i) {
                    nArray[n4 + i] = mesh.indices[n4 + i];
                }
            } else {
                AFace aFace = mesh.primtype == 2 ? new Triangle(mesh.vertices[mesh.indices[n4 + 0]], mesh.vertices[mesh.indices[n4 + 1]], mesh.vertices[mesh.indices[n4 + 2]]) : new Quad(mesh.vertices[mesh.indices[n4 + 0]], mesh.vertices[mesh.indices[n4 + 1]], mesh.vertices[mesh.indices[n4 + 2]], mesh.vertices[mesh.indices[n4 + 3]]);
                arrayList3.clear();
                iTexCoordGenerator.generate(n + n5, (IPolygon)((Object)aFace), iPrimProps, (List<Point2d>)arrayList3);
                assert (arrayList3.size() == n3);
                for (int i = 0; i < n3; ++i) {
                    int n6;
                    int n7 = n6 = mesh.indices[n4 + i];
                    Point2d point2d2 = (Point2d)arrayList.get(n6);
                    Point2d point2d3 = (Point2d)arrayList3.get(i);
                    if (point2d2 == null) {
                        arrayList.set(n6, point2d3);
                    } else if (!point2d2.equals(point2d3)) {
                        n7 = arrayList2.size();
                        arrayList2.add(mesh.vertices[n6]);
                        arrayList.add(point2d3);
                    }
                    nArray[n4 + i] = n7;
                }
            }
            n4 += n3;
            ++n5;
        }
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            if (arrayList.get(n4) != null) continue;
            arrayList.set(n4, point2d);
        }
        Point3d[] point3dArray = arrayList2.size() == mesh.vertices.length ? mesh.vertices : arrayList2.toArray(new Point3d[arrayList2.size()]);
        mesh = new Mesh(point3dArray, nArray, mesh.primtype, mesh.flags);
        return new Pair<Mesh, List<Point2d>>(mesh, arrayList);
    }

    private void beginGeom(INativeStream iNativeStream, IGeom iGeom, int n, IPrimProps iPrimProps) {
        iNativeStream.writeInt(n);
        this.writeMeta(iNativeStream, iGeom, iPrimProps);
    }

    private void writeMeta(INativeStream iNativeStream, IGeom iGeom, IPrimProps iPrimProps) {
        IMaterial iMaterial = iPrimProps.getMaterial();
        Material material = null;
        if (iMaterial != null) {
            material = this.d_dispProps.getNativeMat(iMaterial);
        }
        iNativeStream.write((Keyable)material);
        Color color = iPrimProps.getColor();
        assert (color != null || iMaterial != null) : "Either a material or a color must be specified.";
        iNativeStream.writeBoolean(color != null);
        if (color != null) {
            this.write(iNativeStream, color);
        }
        iNativeStream.writeFloat((float)iPrimProps.getEdgeWidth());
        iNativeStream.writeFloat((float)iPrimProps.getPointSize());
        iNativeStream.writeBoolean(iPrimProps.getCullFace());
    }

    private void write(INativeStream iNativeStream, Color color) {
        float[] fArray = new float[4];
        color.getComponents(fArray);
        iNativeStream.writeFloats(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    private void writeArray(INativeStream iNativeStream, Point3d ... point3dArray) {
        iNativeStream.writeInt(point3dArray.length);
        this.write(iNativeStream, point3dArray);
    }

    private void write(INativeStream iNativeStream, Point3d ... point3dArray) {
        for (Point3d point3d : point3dArray) {
            this.write(iNativeStream, point3d);
        }
    }

    private void writeArray(INativeStream iNativeStream, int ... nArray) {
        iNativeStream.writeInt(nArray.length);
        for (int n : nArray) {
            iNativeStream.writeInt(n);
        }
    }

    private void write(INativeStream iNativeStream, Point3d point3d) {
        iNativeStream.writeFloats((float)point3d.x, (float)point3d.y, (float)point3d.z);
    }

    private static enum GeomType {
        GT_END,
        GT_POINT,
        GT_LINE_STRIP,
        GT_LINESEG,
        GT_TRIANGLE,
        GT_QUAD,
        GT_POLYGON,
        GT_MESH;

    }
}

