/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import java.awt.geom.Point2D;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.Native;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IRenderable;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.Object3D;

public class GenericActor
extends Object3D
implements IRenderable {
    private static final long serialVersionUID = -3273507549051213667L;
    private static final int resetData = 0;
    private static final int finalizeData = 1;
    private static final int setSelectionKey = 2;
    private static final int setVisible = 3;
    private static final int setTexture = 4;
    private static final int setLineStipplePattern = 5;
    private static final int setPolygonStipplePattern = 6;
    private static final int addPoint = 7;
    private static final int addLine = 8;
    private static final int addQuad = 9;
    private static final int addTriangle = 10;
    private static final int addTexturedQuad = 11;
    private static final int setTransform = 12;
    private static final int setCullFrontFace = 13;
    private static final int setWireframe = 14;
    private static final int setLineWidth = 15;
    private static final int setOpacity = 16;
    private static final int setColor = 17;
    private static final int setPointSize = 18;
    private static final Color DEF_LINE_COLOR = new Color(0.0f, 1.0f, 0.0f, 1.0f);
    private static final Color DEF_POLY_COLOR = new Color(0.5f, 0.5f, 0.5f, 1.0f);
    private static final Color DEF_POINT_COLOR = new Color(1.0f, 0.0f, 0.0f, 1.0f);
    private Color d_lineColor = DEF_LINE_COLOR;
    private Color d_polyColor = DEF_POLY_COLOR;
    private Color d_pointColor = DEF_POINT_COLOR;
    private boolean d_visible = true;
    private int d_selectionKey;

    @Override
    public Class resolveNativeClass() {
        return GenericActor.class;
    }

    public void resetData() {
        Native.manager.execMethod(GenericActor.class, this, 0, new Object[0]);
    }

    public void finalizeData() {
        Native.manager.execMethod(GenericActor.class, this, 1, new Object[0]);
    }

    public Object getData() {
        return null;
    }

    public void setSelectionKey(int n) {
        this.d_selectionKey = n;
    }

    public int getSelectionKey() {
        return this.d_selectionKey;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl == this.d_visible) {
            return;
        }
        this.d_visible = bl;
        Native.manager.execMethod(GenericActor.class, this, 3, bl);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    public void setLineStipplePattern(int n, short s) {
        Native.manager.execMethod(GenericActor.class, this, 5, n, s);
    }

    public void setPolygonStipplePattern(byte[] byArray) {
        Native.manager.execMethod(GenericActor.class, this, 6, byArray.length, byArray);
    }

    private final float[] getComps(Color color) {
        float[] fArray = new float[4];
        color.getComponents(fArray);
        return fArray;
    }

    public void setFaceColor(Color color) {
        this.d_polyColor = color;
    }

    public void setEdgeColor(Color color) {
        this.d_lineColor = color;
    }

    public void setVertexColor(Color color) {
        this.d_pointColor = color;
    }

    public void setColor(Color color) {
        Native.manager.execMethod(GenericActor.class, this, 17, new Object[]{this.getComps(color)});
    }

    public void addPoint(Point3d point3d) {
        this.addPoint(point3d, this.d_pointColor);
    }

    public void addPoint(Point3d point3d, Color color) {
        Native.manager.execMethod(GenericActor.class, this, 7, this.getComps(color), point3d.x, point3d.y, point3d.z);
    }

    public void addLine(Point3d point3d, Point3d point3d2) {
        this.addLine(point3d, point3d2, this.d_lineColor);
    }

    public void addLine(Point3d point3d, Point3d point3d2, Color color) {
        Native.manager.execMethod(GenericActor.class, this, 8, this.getComps(color), point3d.x, point3d.y, point3d.z, point3d2.x, point3d2.y, point3d2.z);
    }

    public void addTriangle(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        this.addTriangle(point3d, point3d2, point3d3, this.d_polyColor);
    }

    public void addTriangle(Point3d point3d, Point3d point3d2, Point3d point3d3, Color color) {
        Vector3d vector3d = GenericActor.calcNormal(point3d, point3d2, point3d3);
        Native.manager.execMethod(GenericActor.class, this, 10, this.getComps(color), vector3d.x, vector3d.y, vector3d.z, point3d.x, point3d.y, point3d.z, point3d2.x, point3d2.y, point3d2.z, point3d3.x, point3d3.y, point3d3.z);
    }

    public void addQuad(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        this.addQuad(point3d, point3d2, point3d3, point3d4, this.d_polyColor);
    }

    public void addQuad(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Color color) {
        Vector3d vector3d = GenericActor.calcNormal(point3d, point3d2, point3d3);
        Native.manager.execMethod(GenericActor.class, this, 9, this.getComps(color), vector3d.x, vector3d.y, vector3d.z, point3d.x, point3d.y, point3d.z, point3d2.x, point3d2.y, point3d2.z, point3d3.x, point3d3.y, point3d3.z, point3d4.x, point3d4.y, point3d4.z);
    }

    public void addTexturedQuad(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
    }

    private static Vector3d calcNormal(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        Vector3d vector3d = new Vector3d();
        vector3d.sub(point3d2, point3d);
        Vector3d vector3d2 = new Vector3d();
        vector3d2.sub(point3d3, point3d);
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d, vector3d2);
        vector3d3.normalize();
        return vector3d3;
    }

    public void addTriangleStrip(Point3d[] point3dArray, Color color) {
    }

    public void setTransform(Matrix4d matrix4d) {
    }

    public void setCullFrontFace(boolean bl) {
        Native.manager.execMethod(GenericActor.class, this, 13, bl);
    }

    public void setWireframe(boolean bl) {
        Native.manager.execMethod(GenericActor.class, this, 14, bl);
    }

    public void setPointSize(double d) {
        Native.manager.execMethod(GenericActor.class, this, 18, d);
    }

    public void setLineWidth(double d) {
        Native.manager.execMethod(GenericActor.class, this, 15, d);
    }

    public void setOpacity(double d) {
        Native.manager.execMethod(GenericActor.class, this, 16, d);
    }
}

