/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.ANativelyMirrored;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.ILayer;

public class ClearableBackground
extends ANativelyMirrored
implements ILayer {
    private static final long serialVersionUID = -3149735012750956397L;
    private Color d_clearColor = Color.BLACK;
    private double d_clearDepth;
    private int d_clearStencil;
    private boolean d_clearColorEnabled = false;
    private boolean d_clearDepthEnabled = false;
    private boolean d_clearStencilEnabled = false;

    public ClearableBackground(boolean bl, boolean bl2) {
        this.setColorClearEnabled(bl);
        this.setClearColor(Color.WHITE);
        this.setDepthClearEnabled(bl2);
        this.setClearDepth(1.0);
    }

    @Override
    public void writeNativeData(INativeStream iNativeStream) {
        iNativeStream.writeBooleans(this.d_clearColorEnabled, this.d_clearDepthEnabled, this.d_clearStencilEnabled);
        float[] fArray = new float[4];
        this.d_clearColor.getComponents(fArray);
        iNativeStream.writeFloats(fArray);
        iNativeStream.writeDouble(this.d_clearDepth);
        iNativeStream.writeInt(this.d_clearStencil);
    }

    @Override
    public Class resolveNativeClass() {
        return ClearableBackground.class;
    }

    public void setColorClearEnabled(boolean bl) {
        this.d_clearColorEnabled = bl;
        this.markNativeDirty();
    }

    public void setDepthClearEnabled(boolean bl) {
        this.d_clearDepthEnabled = bl;
        this.markNativeDirty();
    }

    public void setStencilClearEnabled(boolean bl) {
        this.d_clearStencilEnabled = bl;
        this.markNativeDirty();
    }

    public void setClearColor(Color color) {
        this.d_clearColor = color;
        this.markNativeDirty();
    }

    public void setClearDepth(double d) {
        this.d_clearDepth = d;
        this.markNativeDirty();
    }

    public void setClearStencil(int n) {
        this.d_clearStencil = n;
        this.markNativeDirty();
    }

    public void setColor(Color color) {
        this.setClearColor(color);
    }
}

