/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.util.Observer;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.ANativelyMirrored;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.Native;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.CameraRecord;
import pyrosim.legacy_2012_1.thunderheadeng.util.ObservableMediator;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public abstract class Camera
extends ANativelyMirrored {
    private static final long serialVersionUID = 800908134791145585L;
    public static final int LOCALAXIS_FORWARD = 0;
    public static final int LOCALAXIS_RIGHT = 1;
    public static final int LOCALAXIS_UP = 2;
    private final ObservableMediator d_observable = new ObservableMediator();
    private Point3d d_pos;
    private Point3d d_ref;
    private Vector3d d_up;
    private Matrix4d d_customXform;
    private static final int method_worldToView = 0;
    private static final int method_viewToWorld = 1;
    private static final int method_worldToScreen = 2;
    private static final int method_screenToWorld = 3;
    private static final int method_viewToScreen = 4;
    private static final int method_screenToView = 5;
    private static final int method_worldToCamera = 6;
    private static final int method_screenToCamera = 7;
    private static final int method_reset = 8;
    private static final int method_getMatrix = 9;
    private static final int method_setCopyCam = 10;
    private static final int method_setClip = 11;
    private static final int method_getClip = 12;
    private static final int method_zoom = 13;
    private static final int method_zoomAboutPoint = 14;
    private static final int method_setZoom = 15;
    private static final int method_getZoom = 16;
    private static final int method_fitClipping = 17;
    public static final int MAT_TRANSFORM = 0;
    public static final int MAT_INV_TRANSFORM = 1;
    public static final int MAT_VIEW = 2;
    public static final int MAT_INV_VIEW = 3;
    public static final int MAT_PROJECTION = 4;
    public static final int MAT_INV_PROJECTION = 5;
    public static final int MAT_WORLD_TO_SCREEN = 6;
    public static final int MAT_SCREEN_TO_WORLD = 7;

    protected abstract double calcScreenZValue(double var1);

    protected abstract Point3d constrainPointToView(Point3d var1, Point3d var2);

    public abstract double getSubjectSize();

    public abstract Vector3d getViewVector(Point3d var1);

    protected Camera() {
    }

    public Camera(Point3d point3d, Point3d point3d2, Vector3d vector3d, double d, double d2) {
        this.d_pos = new Point3d(point3d);
        this.d_ref = new Point3d(point3d2);
        this.d_up = new Vector3d(vector3d);
        this.nativeConstructed(Camera.class);
        this.setClip(d, d2);
    }

    @Override
    public Class resolveNativeClass() {
        return Camera.class;
    }

    public void setCustomTransform(Matrix4d matrix4d) {
        this.d_customXform = matrix4d;
        this.markNativeDirty();
    }

    public Matrix4d getCustomTransform() {
        return this.d_customXform;
    }

    public Matrix4d getInverseCustomTransform() {
        if (this.d_customXform == null) {
            return null;
        }
        Matrix4d matrix4d = new Matrix4d(this.d_customXform);
        matrix4d.invert();
        return matrix4d;
    }

    protected AABox toView(AABox aABox) {
        if (this.d_customXform == null) {
            return aABox;
        }
        aABox = new AABox(aABox);
        aABox.transformEq(this.d_customXform);
        return aABox;
    }

    protected Vector3d toView(Vector3d vector3d) {
        Matrix4d matrix4d = this.getCustomTransform();
        return matrix4d != null ? Util3D.xform(matrix4d, vector3d) : vector3d;
    }

    protected Point3d toView(Point3d point3d) {
        Matrix4d matrix4d = this.getCustomTransform();
        return matrix4d != null ? Util3D.xform(matrix4d, point3d) : point3d;
    }

    @Override
    public void writeNativeData(INativeStream iNativeStream) {
        iNativeStream.writeDoubles(this.d_pos.x, this.d_pos.y, this.d_pos.z);
        iNativeStream.writeDoubles(this.d_ref.x, this.d_ref.y, this.d_ref.z);
        iNativeStream.writeDoubles(this.d_up.x, this.d_up.y, this.d_up.z);
        iNativeStream.writeBoolean(this.d_customXform != null);
        if (this.d_customXform != null) {
            Matrix4d matrix4d = new Matrix4d(this.d_customXform);
            matrix4d.invert();
            Camera.write(iNativeStream, this.d_customXform);
            Camera.write(iNativeStream, matrix4d);
        }
    }

    private static void write(INativeStream iNativeStream, Matrix4d matrix4d) {
        iNativeStream.writeDoubles(matrix4d.m00, matrix4d.m01, matrix4d.m02, matrix4d.m03, matrix4d.m10, matrix4d.m11, matrix4d.m12, matrix4d.m13, matrix4d.m20, matrix4d.m21, matrix4d.m22, matrix4d.m23, matrix4d.m30, matrix4d.m31, matrix4d.m32, matrix4d.m33);
    }

    public void setCopyCam(Camera camera) {
        Native.manager.execMethod(Camera.class, this, 10, camera);
    }

    public abstract Camera createCopyCam();

    public void addObserver(Observer observer) {
        this.d_observable.addObserver(observer);
    }

    public void removeObserver(Observer observer) {
        this.d_observable.deleteObserver(observer);
    }

    public void resetRotation() {
        Vector3d vector3d = new Vector3d(this.d_pos);
        this.d_up.set(0.0, 0.0, 1.0);
        this.d_ref.set(0.0, 1.0, 0.0);
        this.d_pos.set(0.0, 0.0, 0.0);
        this.d_ref.add(vector3d);
        this.d_pos.add(vector3d);
        this.markDirty();
    }

    public AABox ensureValidForReset(AABox aABox, double d) {
        return aABox.ensureValidSize(d, d);
    }

    public void reset(AABox aABox, int n, int n2) {
        this.reset(new Vector3d(0.0, 0.0, -1.0), new Vector3d(0.0, 1.0, 0.0), aABox, n, n2);
    }

    public void reset(Vector3d vector3d, Vector3d vector3d2, AABox aABox, int n, int n2) {
        this.setZoom(new Point2d(0.0, 0.0), 1.0);
    }

    public void orbit(double d, double d2, double d3, double d4) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        vector3d3.sub(this.d_pos, this.d_ref);
        vector3d2.set(this.d_up);
        vector3d.cross(vector3d2, vector3d3);
        vector3d.normalize();
        vector3d2.normalize();
        vector3d3.normalize();
        vector3d.scale(d2);
        vector3d2.scale(d3);
        vector3d3.scale(d4);
        Vector3d vector3d4 = new Vector3d(vector3d);
        vector3d4.add(vector3d2);
        vector3d4.add(vector3d3);
        double d5 = d * Math.PI / 180.0;
        AxisAngle4d axisAngle4d = new AxisAngle4d(vector3d4, d5);
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.set(axisAngle4d);
        Vector3d vector3d5 = new Vector3d();
        vector3d5.sub(this.d_pos, this.d_ref);
        matrix3d.transform(vector3d5);
        this.d_pos.add(this.d_ref, vector3d5);
        matrix3d.transform(this.d_up);
        this.markDirty();
    }

    public void orbit(double d, Vector3d vector3d) {
        this.orbit(d, vector3d.x, vector3d.y, vector3d.z);
    }

    public void rotate(double d, Vector3d vector3d) {
        double d2 = d * Math.PI / 180.0;
        AxisAngle4d axisAngle4d = new AxisAngle4d(vector3d, d2);
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.set(axisAngle4d);
        Vector3d vector3d2 = new Vector3d();
        vector3d2.sub(this.d_ref, this.d_pos);
        matrix3d.transform(vector3d2);
        this.d_ref.add(this.d_pos, vector3d2);
        matrix3d.transform(this.d_up);
        this.markDirty();
    }

    public void rotate(double d, double d2, double d3, double d4) {
        this.rotate(d, new Vector3d(d2, d3, d4));
    }

    public void translateWorld(Vector3d vector3d, boolean bl) {
        this.d_pos.add(vector3d);
        if (bl) {
            this.d_ref.add(vector3d);
        }
        this.markDirty();
    }

    public void translateWorld(double d, double d2, double d3, boolean bl) {
        this.translateWorld(new Vector3d(d, d2, d3), bl);
    }

    public void translateEye(Point3d point3d, Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        vector3d4.sub(this.d_pos, this.d_ref);
        vector3d3.set(this.d_up);
        vector3d2.cross(vector3d3, vector3d4);
        vector3d2.normalize();
        vector3d3.normalize();
        vector3d4.normalize();
        vector3d2.scale(vector3d.x);
        vector3d3.scale(vector3d.y);
        vector3d4.scale(vector3d.z);
        Vector3d vector3d5 = new Vector3d(0.0, 0.0, 0.0);
        vector3d5.add(vector3d2);
        vector3d5.add(vector3d3);
        vector3d5.add(vector3d4);
        point3d.add(vector3d5);
    }

    public void translateEye(Vector3d vector3d, boolean bl) {
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        vector3d4.sub(this.d_pos, this.d_ref);
        vector3d3.set(this.d_up);
        vector3d2.cross(vector3d3, vector3d4);
        vector3d2.normalize();
        vector3d3.normalize();
        vector3d4.normalize();
        vector3d2.scale(vector3d.x);
        vector3d3.scale(vector3d.y);
        vector3d4.scale(vector3d.z);
        Vector3d vector3d5 = new Vector3d(0.0, 0.0, 0.0);
        vector3d5.add(vector3d2);
        vector3d5.add(vector3d3);
        vector3d5.add(vector3d4);
        this.d_pos.add(vector3d5);
        if (bl) {
            this.d_ref.add(vector3d5);
        }
        this.markDirty();
    }

    public void translateEye(double d, double d2, double d3, boolean bl) {
        Vector3d vector3d = new Vector3d(d, d2, d3);
        this.translateEye(vector3d, bl);
    }

    public void zoomAboutPoint(double d, Point2d point2d) {
        Native.manager.execMethod(Camera.class, this, 14, d, point2d.x, point2d.y);
    }

    public void zoom(double d, Point2d point2d) {
        Native.manager.execMethod(Camera.class, this, 13, d, point2d.x, point2d.y);
    }

    public void setZoom(Point2d point2d, double d) {
        Native.manager.execMethod(Camera.class, this, 15, d, point2d.x, point2d.y);
    }

    protected Pair<Double, Point2d> getFullZoom() {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 16, new Object[0]);
        Native.manager.flush();
        double d = Native.manager.readDouble();
        Point2d point2d = new Point2d(Native.manager.readDouble(), Native.manager.readDouble());
        Native.manager.unlockWriteBuffer();
        return new Pair<Double, Point2d>(d, point2d);
    }

    public double getZoom() {
        return (Double)this.getFullZoom().v1;
    }

    public Point2d getZoomLoc() {
        return (Point2d)this.getFullZoom().v2;
    }

    public void setPosition(Point3d point3d) {
        this.d_pos.set(point3d);
        this.markDirty();
    }

    public void setPosition(double d, double d2, double d3) {
        this.d_pos.set(d, d2, d3);
        this.markDirty();
    }

    public Point3d getPosition() {
        return new Point3d(this.d_pos);
    }

    public void setReference(Point3d point3d) {
        this.d_ref.set(point3d);
        this.markDirty();
    }

    public void setReference(double d, double d2, double d3) {
        this.d_ref.set(d, d2, d3);
        this.markDirty();
    }

    public Point3d getReference() {
        return new Point3d(this.d_ref);
    }

    public void setUpVector(Vector3d vector3d) {
        this.d_up.set(vector3d);
        this.markDirty();
    }

    public void setUpVector(double d, double d2, double d3) {
        this.d_up.set(d, d2, d3);
        this.markDirty();
    }

    public Vector3d getUpVector() {
        return new Vector3d(this.d_up);
    }

    public void setClip(double d, double d2) {
        Native.manager.execMethod(Camera.class, this, 11, d, d2);
    }

    public double[] getClip() {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 12, new Object[0]);
        Native.manager.flush();
        double[] dArray = new double[]{Native.manager.readDouble(), Native.manager.readDouble()};
        Native.manager.unlockWriteBuffer();
        return dArray;
    }

    public double getNearClip() {
        return this.getClip()[0];
    }

    public double getFarClip() {
        return this.getClip()[1];
    }

    public void fitClipping(AABox aABox) {
        this.fitClipping(aABox, 0.005);
    }

    public void fitClipping(AABox aABox, double d) {
        Native.manager.execMethod(Camera.class, this, 17, aABox.getMinX(), aABox.getMinY(), aABox.getMinZ(), aABox.getMaxX(), aABox.getMaxY(), aABox.getMaxZ(), d);
    }

    public Vector3d getViewVector() {
        Vector3d vector3d = new Vector3d();
        vector3d.sub(this.d_ref, this.d_pos);
        return vector3d;
    }

    public Vector3d getRightVector() {
        Vector3d vector3d = this.getUpVector();
        Vector3d vector3d2 = this.getViewVector();
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d2, vector3d);
        return vector3d3;
    }

    public double getDistance() {
        return this.getViewVector().length();
    }

    public Plane3d getViewPlane() {
        Vector3d vector3d = this.getViewVector();
        vector3d.normalize();
        Point3d point3d = this.getPosition();
        double d = -point3d.x * vector3d.x - point3d.y * vector3d.y - point3d.z * vector3d.z;
        return new Plane3d(vector3d.x, vector3d.y, vector3d.z, d);
    }

    public Plane3d getRefPlane() {
        Vector3d vector3d = this.getViewVector();
        vector3d.normalize();
        Point3d point3d = this.getReference();
        return new Plane3d(vector3d, point3d);
    }

    public Vector3d vecToPointAlongLocalAxis(Point3d point3d, int n) {
        Vector3d vector3d = new Vector3d();
        switch (n) {
            case 0: {
                vector3d.normalize(this.getViewVector());
                break;
            }
            case 2: {
                vector3d.normalize(this.getUpVector());
                break;
            }
            case 1: {
                vector3d.normalize(this.getRightVector());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Vector3d vector3d2 = new Vector3d();
        vector3d2.sub(point3d, this.getPosition());
        double d = vector3d2.dot(vector3d);
        vector3d.scale(d);
        return vector3d;
    }

    public Matrix3d getLocalTransformLHR() {
        Vector3d vector3d = this.getUpVector();
        vector3d.normalize();
        Vector3d vector3d2 = this.getRightVector();
        vector3d2.normalize();
        Vector3d vector3d3 = this.getViewVector();
        vector3d3.normalize();
        return new Matrix3d(vector3d2.x, vector3d2.y, vector3d2.z, vector3d.x, vector3d.y, vector3d.z, vector3d3.x, vector3d3.y, vector3d3.z);
    }

    public Matrix3d getLocalTransformRHR() {
        Matrix3d matrix3d = this.getLocalTransformLHR();
        matrix3d.m20 = -matrix3d.m20;
        matrix3d.m21 = -matrix3d.m21;
        matrix3d.m22 = -matrix3d.m22;
        return matrix3d;
    }

    protected void markDirty() {
        this.markNativeDirty();
        this.d_observable.setChanged();
        this.d_observable.notifyObservers();
    }

    private static Point3d readP3d() {
        Native.manager.flush();
        double[] dArray = new double[3];
        Native.manager.readDoubles(dArray);
        return new Point3d(dArray);
    }

    private static Point4d readP4d() {
        Native.manager.flush();
        double[] dArray = new double[4];
        Native.manager.readDoubles(dArray);
        return new Point4d(dArray);
    }

    private static Matrix4d readMatrix4d() {
        Native.manager.flush();
        double[] dArray = new double[16];
        Native.manager.readDoubles(dArray);
        return new Matrix4d(dArray);
    }

    protected Point3d worldToLocal(Point3d point3d) {
        Matrix3d matrix3d = this.getLocalTransformRHR();
        Point3d point3d2 = new Point3d(point3d);
        matrix3d.transform(point3d2);
        return point3d2;
    }

    protected Point3d worldToView(Point3d point3d) {
        Point4d point4d = this.worldToView(new Point4d(point3d.x, point3d.y, point3d.z, 1.0));
        return theUtil.p4dTo3d(point4d);
    }

    protected Point4d worldToView(Point4d point4d) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 0, point4d.x, point4d.y, point4d.z, point4d.w);
        Point4d point4d2 = Camera.readP4d();
        Native.manager.unlockWriteBuffer();
        return point4d2;
    }

    protected Point3d viewToWorld(Point3d point3d) {
        Point4d point4d = this.viewToWorld(new Point4d(point3d.x, point3d.y, point3d.z, 1.0));
        return theUtil.p4dTo3d(point4d);
    }

    protected Point4d viewToWorld(Point4d point4d) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 1, point4d.x, point4d.y, point4d.z, point4d.w);
        Point4d point4d2 = Camera.readP4d();
        Native.manager.unlockWriteBuffer();
        return point4d2;
    }

    protected Point3d worldToScreen(Point3d point3d) {
        return this.worldToScreen(new Point4d(point3d.x, point3d.y, point3d.z, 1.0));
    }

    protected Point3d worldToScreen(Point4d point4d) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 2, point4d.x, point4d.y, point4d.z, point4d.w);
        Point3d point3d = Camera.readP3d();
        Native.manager.unlockWriteBuffer();
        return point3d;
    }

    protected Point3d screenToWorld(Point3d point3d) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 3, point3d.x, point3d.y, point3d.z);
        Point3d point3d2 = Camera.readP3d();
        Native.manager.unlockWriteBuffer();
        return point3d2;
    }

    protected double screenToWorld(double d, Point3d point3d) {
        Point3d point3d2 = this.worldToScreen(point3d);
        return this.screenToWorld(d, point3d2.z);
    }

    protected double screenToWorld(double d, double d2) {
        Point3d point3d = this.screenToWorld(new Point3d(d, 0.0, d2));
        Point3d point3d2 = this.screenToWorld(new Point3d(0.0, 0.0, d2));
        return point3d.distance(point3d2);
    }

    protected Point3d viewToScreen(Point4d point4d) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 4, point4d.x, point4d.y, point4d.z, point4d.w);
        Point3d point3d = Camera.readP3d();
        Native.manager.unlockWriteBuffer();
        return point3d;
    }

    protected Point3d viewToScreen(Point3d point3d) {
        return this.viewToScreen(new Point4d(point3d.x, point3d.y, point3d.z, 1.0));
    }

    protected Point3d screenToView(Point3d point3d) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 5, point3d.x, point3d.y, point3d.z);
        Point3d point3d2 = Camera.readP3d();
        Native.manager.unlockWriteBuffer();
        return point3d2;
    }

    protected double screenToView(double d) {
        Point3d point3d = this.screenToView(new Point3d(d, 0.0, 0.0));
        Point3d point3d2 = this.screenToView(new Point3d(0.0, 0.0, 0.0));
        return point3d.distance(point3d2);
    }

    protected Point3d worldToCamera(Point3d point3d) {
        Point4d point4d = this.worldToCamera(new Point4d(point3d.x, point3d.y, point3d.z, 1.0));
        return theUtil.p4dTo3d(point4d);
    }

    protected Point4d worldToCamera(Point4d point4d) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 6, point4d.x, point4d.y, point4d.z, point4d.w);
        Point4d point4d2 = Camera.readP4d();
        Native.manager.unlockWriteBuffer();
        return point4d2;
    }

    protected Point3d screenToCamera(Point3d point3d) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 7, point3d.x, point3d.y, point3d.z);
        Point3d point3d2 = Camera.readP3d();
        Native.manager.unlockWriteBuffer();
        return point3d2;
    }

    public Matrix4d getMatrix(int n) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 9, n);
        Matrix4d matrix4d = Camera.readMatrix4d();
        Native.manager.unlockWriteBuffer();
        return matrix4d;
    }

    public abstract CameraRecord capture();

    public void apply(CameraRecord cameraRecord) {
        this.pauseUpdates();
        this.setPosition(cameraRecord.loc);
        this.setReference(cameraRecord.ref);
        this.setUpVector(cameraRecord.up);
        this.setZoom(cameraRecord.zoomLoc, cameraRecord.zoom);
        this.setClip(cameraRecord.near, cameraRecord.far);
        this.resumeUpdates();
    }
}

