/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.Semaphore;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.ILegacy_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.APrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BGImageXform;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagHelper;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.LinkStatus;
import pyrosim.legacy_2012_1.thunderheadeng.gui.MultiLineLabel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Utils;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Validateable;
import pyrosim.legacy_2012_1.thunderheadeng.gui.WaitCursorMgr;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.ColorChangedEvent;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.ColorChangedListener;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.ColorMgr;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiAction;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiCheckBox;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDialog;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiIntField;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiLabel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiPanel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiStatusBar;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiStatusMessage;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiTextField;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiUnitDoubleField;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiValueField;
import pyrosim.legacy_2012_1.thunderheadeng.gui.tool.Tool;
import pyrosim.legacy_2012_1.thunderheadeng.gui.tool.ToolManager;
import pyrosim.legacy_2012_1.thunderheadeng.image.Image;
import pyrosim.legacy_2012_1.thunderheadeng.io.FilenameManager;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.IntermediateGraphicsXfer;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IGeomSource;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IMaterial;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.PropsBuilder;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.AxesScene;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.BasicRenderer;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.ClearableBackground;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.ILayer;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.Material;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.ModelScene;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.NativeImage;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.NativeImageMgr;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.OriginDisp;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.RasterObj;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.RenderComponent;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.SceneLayout;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.StringRenderer;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.TextRenderer;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.View;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.AToolFunction;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.CursorTool;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.DragFunc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.IToolController;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.ZoomBoxFunc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.ZoomFunc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomPicker;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.DoubleVR;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;
import pyrosim.legacy_2012_1.thunderheadeng.util.IntVR;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theObservable;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class BGImageDlg
extends guiDialog
implements Observer {
    private static final long serialVersionUID = 5452886056388152870L;
    private final IImageLoader d_loader;
    private final Unit d_displayUnit;
    private Mode d_mode;
    private final BGImageBuilder d_builder;
    private IntermediateGraphicsXfer d_igx;
    private guiPanel d_imgFilenamePanel;
    private JLabel d_imgFilenameTitle;
    private guiTextField d_filenameFld;
    private JButton d_filenameBtn;
    private guiPanel d_anchorPanel;
    private JLabel d_anchorTitle;
    private MultiLineLabel d_anchorDesc;
    private guiUnitDoubleField d_modelX;
    private guiUnitDoubleField d_modelY;
    private guiUnitDoubleField d_modelZ;
    private guiPanel d_scalePanel;
    private JLabel d_scaleTitle;
    private MultiLineLabel d_scaleDesc;
    private guiUnitDoubleField d_distAB;
    private guiCheckBox d_abAngleCB;
    private guiUnitDoubleField d_abAngle;
    private guiPanel d_imagePanel;
    private ImageEditor d_imageEditor;
    private JSlider d_opacitySlider;
    private guiIntField d_opacityField;
    private final IRenderSurface d_parent;
    private static final int STEP_IMAGE_SPECIFIED = 0;
    private static final int STEP_ANCHOR_IMAGE_SET = 1;
    private static final int STEP_ANCHOR_MODEL_SET = 2;
    private static final int STEP_SCALE_POINTA_SET = 3;
    private static final int STEP_SCALE_POINTB_SET = 4;
    private static final int STEP_SCALE_DISTAB_SET = 5;
    public static final String LastDlgWidthPref = "BGImageDlg.BGImageDlg.LastWidth";
    public static final String LastDlgHeightPref = "BGImageDlg.BGImageDlg.LastHeight";

    public BGImageDlg(Window window, IRenderSurface iRenderSurface, ColorMgr colorMgr, Map<Colors, String> map, IImageLoader iImageLoader, Unit unit, IntermediateGraphicsXfer intermediateGraphicsXfer) {
        super(window, Intl.intl("Configure Background Image"), 9);
        assert (map.size() == Colors.values().length);
        this.d_mode = Mode.CREATE;
        this.d_loader = iImageLoader;
        this.d_displayUnit = unit;
        intermediateGraphicsXfer.acquire();
        this.d_igx = intermediateGraphicsXfer;
        this.d_builder = new BGImageBuilder();
        this.d_builder.addWeakObserver(this);
        this.d_parent = iRenderSurface;
        this.d_imageEditor = new ImageEditor(iRenderSurface, colorMgr, map, this.d_displayUnit, this.d_builder);
        this.d_imageEditor.getRenderComp().setPreferredSize(new Dimension(600, 400));
        this.d_opacitySlider = new JSlider(0, 0, 100, 100);
        this.d_opacityField = new guiIntField(100, IntVR.between(0, 100, true, true));
        this.d_opacityField.setColumns(3);
        this.d_opacityField.setHorizontalAlignment(4);
        this.d_imgFilenamePanel = this.buildFileChooserPanel();
        guiPanel guiPanel2 = this.buildDialogPanel();
        this.d_imagePanel = this.buildImagePanel();
        guiPanel guiPanel3 = this.getDialogPane();
        guiPanel3.setLayout(new GridBagLayout());
        GridBagUtil.add(guiPanel3, this.d_imgFilenamePanel, 1, 1, 2, 1, 11, 11, 0, 11, 2, 1.0, 0.0, 18);
        GridBagUtil.add(guiPanel3, guiPanel2, 1, 2, 1, 1, 11, 11, 0, 0, 3, 0.0, 1.0, 18);
        GridBagUtil.add(guiPanel3, this.d_imagePanel, 2, 2, 1, 1, 11, 11, 0, 11, 1, 1.0, 1.0, 18);
        this.d_opacityField.getDocument().addDocumentListener(new DocumentListener(){

            private void update() {
                if (!BGImageDlg.this.d_opacityField.validateData(false, false)) {
                    return;
                }
                int n = (Integer)BGImageDlg.this.d_opacityField.getValue();
                BGImageDlg.this.d_opacitySlider.setValue(n);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }
        });
        this.d_opacitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = BGImageDlg.this.d_opacitySlider.getValue();
                BGImageDlg.this.d_opacityField.setValue(n);
                float f = (float)n / (float)BGImageDlg.this.d_opacitySlider.getMaximum();
                BGImageDlg.this.d_builder.setOpacity(f);
            }
        });
        this.setDisposeAfterModal(false);
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.setImage(null, null, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageInfo editImage(Window window, IRenderSurface iRenderSurface, ColorMgr colorMgr, Map<Colors, String> map, IImageLoader iImageLoader, Unit unit, IntermediateGraphicsXfer intermediateGraphicsXfer, ImageInfo imageInfo) {
        Serializable serializable;
        if (imageInfo == null) {
            WaitCursorMgr waitCursorMgr;
            serializable = iImageLoader.choose(window, null);
            if (serializable == null) {
                return null;
            }
            WaitCursorMgr waitCursorMgr2 = waitCursorMgr = window != null ? new WaitCursorMgr(window) : null;
            if (waitCursorMgr != null) {
                waitCursorMgr.beginWaitCursor();
            }
            try {
                Pair<Image, BGImageXform> pair = iImageLoader.load((File)serializable);
                if (pair == null) {
                    ImageInfo imageInfo2 = null;
                    return imageInfo2;
                }
                imageInfo = new ImageInfo((Image)pair.v1, (BGImageXform)pair.v2, 1.0f);
            }
            catch (IOException iOException) {
                BGImageDlg.showLoadError(window, iOException);
                ImageInfo imageInfo3 = null;
                return imageInfo3;
            }
            finally {
                if (waitCursorMgr != null) {
                    waitCursorMgr.endWaitCursor();
                }
            }
        }
        serializable = new BGImageDlg(window, iRenderSurface, colorMgr, map, iImageLoader, unit, intermediateGraphicsXfer);
        ((BGImageDlg)serializable).setImage(imageInfo.image, imageInfo.xform, imageInfo.opacity);
        if (((BGImageDlg)serializable).doModal() == 1) {
            return ((BGImageDlg)serializable).getImage();
        }
        return null;
    }

    private guiPanel buildFileChooserPanel() {
        guiPanel guiPanel2 = new guiPanel();
        GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2);
        this.d_imgFilenameTitle = new JLabel(Intl.intl("1. Choose image file:"));
        this.d_imgFilenameTitle.setFont(new Font("Sans Serif", 1, 11));
        this.d_filenameFld = new guiTextField();
        this.d_filenameFld.setEditable(false);
        ImageIcon imageIcon = guiUtil.loadTeciIcon("Open16.gif");
        this.d_filenameBtn = new JButton(imageIcon);
        this.d_filenameBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGImageDlg.this.loadImageFromChooser();
            }
        });
        this.d_filenameBtn.setPreferredSize(new Dimension(imageIcon.getIconWidth() + 6, imageIcon.getIconHeight() + 6));
        gridBagHelper.addRow(this.d_imgFilenameTitle, this.d_filenameFld, 1.0, this.d_filenameBtn);
        return guiPanel2;
    }

    private guiPanel buildDialogPanel() {
        guiPanel guiPanel2 = new guiPanel();
        guiPanel2.setLayout(new GridBagLayout());
        this.d_anchorPanel = new guiPanel(new GridBagLayout());
        int n = 1;
        this.d_anchorTitle = new JLabel(Intl.intl("2. Set Anchor Point:"));
        this.d_anchorTitle.setFont(new Font("Sans Serif", 1, 11));
        GridBagUtil.add(this.d_anchorPanel, this.d_anchorTitle, 1, n++, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 18);
        this.d_anchorDesc = new MultiLineLabel(String.format(Intl.intl("The Anchor Point is a reference point that determines where to place the image in the model.  To set it, make sure the button, \"%s,\" is selected below, and click on the image at the desired anchor location.  Then enter the coordinates for the corresponding point in the model."), this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAnchorTool()).getText()));
        GridBagUtil.add(this.d_anchorPanel, this.d_anchorDesc, 1, n++, 2, 1, 6, 11, 0, 0, 2, 1.0, 0.0, 18);
        GridBagUtil.add(this.d_anchorPanel, this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAnchorTool()), 1, n++, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
        this.d_modelX = new guiUnitDoubleField(0.0, this.d_displayUnit);
        this.d_modelY = new guiUnitDoubleField(0.0, this.d_displayUnit);
        this.d_modelZ = new guiUnitDoubleField(0.0, this.d_displayUnit);
        this.d_distAB = new guiUnitDoubleField(1.0, DoubleVR.above(0.0, false), this.d_displayUnit);
        this.d_abAngleCB = new guiCheckBox(Intl.intl("A->B angle:"));
        this.d_abAngle = new guiUnitDoubleField(0.0, NonSI.DEGREE_ANGLE);
        this.d_abAngle.aliasValue(null, "");
        new FldListener(new guiValueField[]{this.d_distAB}){

            @Override
            protected void updateToProps() {
                BGImageDlg.this.d_builder.setABDistModel((UnitDouble)BGImageDlg.this.d_distAB.getValue());
            }
        };
        new FldListener(new guiValueField[]{this.d_abAngle}){

            @Override
            protected void updateToProps() {
                if (BGImageDlg.this.d_abAngleCB.isSelected()) {
                    BGImageDlg.this.d_builder.setABAngle((UnitDouble)BGImageDlg.this.d_abAngle.getValue());
                }
            }
        };
        new FldListener(new guiValueField[]{this.d_modelX, this.d_modelY, this.d_modelZ}){

            @Override
            protected void updateToProps() {
                BGImageDlg.this.d_builder.setAnchorModel(new UnitPoint3D((UnitDouble)BGImageDlg.this.d_modelX.getValue(), (UnitDouble)BGImageDlg.this.d_modelY.getValue(), (UnitDouble)BGImageDlg.this.d_modelZ.getValue()));
            }
        };
        GridBagUtil.add(this.d_anchorPanel, new ComponentPair(new JLabel(Intl.intl("Model X:")), this.d_modelX, true), 1, n++, 1, 1, 6, 12, 0, 0, 0, 1.0, 0.0, 18);
        GridBagUtil.add(this.d_anchorPanel, new ComponentPair(new JLabel(Intl.intl("Model Y:")), this.d_modelY, true), 1, n++, 1, 1, 6, 12, 0, 0, 0, 1.0, 0.0, 18);
        GridBagUtil.add(this.d_anchorPanel, new ComponentPair(new JLabel(Intl.intl("Model Z:")), this.d_modelZ, true), 1, n++, 1, 1, 6, 12, 0, 0, 0, 1.0, 0.0, 18);
        this.d_scalePanel = new guiPanel(new GridBagLayout());
        n = 1;
        this.d_scaleTitle = new JLabel(Intl.intl("3. Set Scale:"));
        this.d_scaleTitle.setFont(new Font("Sans Serif", 1, 11));
        GridBagUtil.add(this.d_scalePanel, this.d_scaleTitle, 1, n++, 1, 1, 11, 0, 0, 0);
        this.d_scaleDesc = new MultiLineLabel(Intl.intl("The Scale determines how big the image will appear in the model.  To set the scale, find two points in the image that are a known distance apart, and use the buttons, \"Choose Point A\" and \"Choose Point B\" to set the two points.  Then specify their separation in model coordinates below."));
        GridBagUtil.add(this.d_scalePanel, this.d_scaleDesc, 1, n++, 2, 1, 6, 11, 0, 0, 2, 1.0, 0.0, 18);
        guiPanel guiPanel3 = new guiPanel(new GridBagLayout());
        GridBagUtil.add(guiPanel3, this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAPointTool()), 0, 0, 1, 1, 6, 0, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this.d_scalePanel, guiPanel3, 1, n++, 2, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 18);
        GridBagUtil.add(this.d_scalePanel, this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getBPointTool()), 1, n++, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this.d_scalePanel, new ComponentPair(new JLabel(Intl.intl("Dist. A to B:")), this.d_distAB, true), 1, n++, 1, 1, 6, 12, 0, 0, 0, 1.0, 0.0, 18);
        LinkStatus.link((AbstractButton)this.d_abAngleCB, this.d_abAngle);
        GridBagUtil.add(this.d_scalePanel, new ComponentPair(this.d_abAngleCB, this.d_abAngle, true), 1, n, 1, 1, 6, 12, 0, 0, 0, 1.0, 0.0, 18);
        this.d_abAngleCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!BGImageDlg.this.d_abAngleCB.isSelected()) {
                    BGImageDlg.this.updateABAngleFromProps();
                    BGImageDlg.this.d_builder.setABAngle(null);
                } else {
                    BGImageDlg.this.d_abAngle.requestFocus();
                }
            }
        });
        n = 1;
        GridBagUtil.add(guiPanel2, this.d_anchorPanel, 1, n++, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 18);
        GridBagUtil.add(guiPanel2, this.d_scalePanel, 1, n++, 1, 1, 0, 0, 0, 0, 0, 1.0, 0.0, 18);
        GridBagUtil.add(guiPanel2, Box.createVerticalGlue(), 1, 99, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 18);
        return guiPanel2;
    }

    private guiPanel buildImagePanel() {
        guiPanel guiPanel2 = new guiPanel(new BorderLayout());
        guiPanel guiPanel3 = new guiPanel();
        guiPanel3.setLayout(new BorderLayout());
        guiPanel3.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        guiPanel guiPanel4 = new guiPanel(new BorderLayout());
        guiPanel4.add((Component)this.d_imageEditor.getEditToolbar(), "North");
        guiPanel4.add(this.d_imageEditor.getRenderComp(), "Center");
        guiPanel guiPanel5 = new guiPanel(new BorderLayout());
        guiPanel5.add((Component)this.d_imageEditor.getStatusBar(), "South");
        guiPanel3.add((Component)guiPanel4, "Center");
        guiPanel3.add((Component)guiPanel5, "South");
        guiPanel guiPanel6 = new guiPanel(new GridBagLayout());
        GridBagUtil.add(guiPanel6, new guiLabel(Intl.intl("Image Brightness (Opacity)") + ": "), 0, 0, 1, 1, 6, 6, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel6, this.d_opacitySlider, 1, 0, 1, 1, 6, 0, 0, 6, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel6, this.d_opacityField, 2, 0, 1, 1, 6, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel6, new guiLabel("%"), 3, 0, 1, 1, 6, 0, 0, 6, 0, 0.0, 0.0, 17);
        guiPanel2.add((Component)guiPanel3, "Center");
        guiPanel2.add((Component)guiPanel6, "South");
        return guiPanel2;
    }

    @Override
    public void update(Observable observable, Object object) {
        ILegacy_2012_1 iLegacy_2012_1;
        Set set = (Set)object;
        if (set.contains(BGImageBuilder.IMAGE_CHANGED)) {
            this.d_filenameFld.setText(this.d_builder.getName());
        }
        if ((set.contains(BGImageBuilder.A_CHANGED) || set.contains(BGImageBuilder.B_CHANGED)) && this.d_builder.getABAngle() == null) {
            this.updateABAngleFromProps();
        }
        if (set.contains(BGImageBuilder.AB_ANGLE_CHANGED)) {
            iLegacy_2012_1 = this.d_builder.getABAngle();
            this.d_abAngleCB.setSelected(iLegacy_2012_1 != null);
            if (iLegacy_2012_1 != null) {
                this.d_abAngle.setValue(iLegacy_2012_1);
            } else {
                this.updateABAngleFromProps();
            }
        }
        if (set.contains(BGImageBuilder.ANCHOR_MODEL_CHANGED)) {
            iLegacy_2012_1 = this.d_builder.getAnchorModel();
            this.d_modelX.setValue(((UnitPoint3D)iLegacy_2012_1).xu());
            this.d_modelY.setValue(((UnitPoint3D)iLegacy_2012_1).yu());
            this.d_modelZ.setValue(((UnitPoint3D)iLegacy_2012_1).zu());
        }
        if (set.contains(BGImageBuilder.OPACITY_CHANGED)) {
            this.d_opacityField.setValue(Math.round(this.d_builder.getOpacity() * 100.0f));
        }
        if (set.contains(BGImageBuilder.ANCHOR_IMAGE_CHANGED) && this.d_builder.isAnchorImageCommitted()) {
            this.stepCompleted(1);
        } else if (set.contains(BGImageBuilder.B_CHANGED) && this.d_builder.isBCommitted()) {
            this.stepCompleted(4);
        } else if (set.contains(BGImageBuilder.A_CHANGED) && this.d_builder.isACommitted()) {
            this.stepCompleted(3);
        }
        if (set.contains(BGImageBuilder.AB_DIST_CHANGED)) {
            this.d_distAB.setValue(this.d_builder.getDistABModel());
        } else if (set.contains(BGImageBuilder.IMAGE_CHANGED) && this.d_builder.getImage() != null) {
            this.stepCompleted(0);
        }
    }

    private void updateABAngleFromProps() {
        Point2d point2d = this.d_builder.getAImage();
        Point2d point2d2 = this.d_builder.getBImage();
        if (point2d == null || point2d2 == null) {
            this.d_abAngle.setValue(null);
            return;
        }
        Vector2d vector2d = Util2D.vectorN(point2d, point2d2);
        Vector2d vector2d2 = new Vector2d(1.0, 0.0);
        double d = Util2D.angle(vector2d2, vector2d);
        this.d_abAngle.setValue(new UnitDouble(d, SI.RADIAN).convert(NonSI.DEGREE_ANGLE));
    }

    private void stepCompleted(int n) {
        if (this.d_mode == Mode.EDIT) {
            return;
        }
        switch (n) {
            case 0: {
                this.showPanel(this.d_anchorPanel, true);
                this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAnchorTool()).setEnabled(true);
                this.d_imageEditor.getToolManager().setCurrentTool(this.d_imageEditor.getAnchorTool());
                this.d_modelX.setEnabled(true);
                this.d_modelY.setEnabled(true);
                this.d_modelZ.setEnabled(true);
                this.d_modelX.requestFocus();
                break;
            }
            case 1: {
                this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAPointTool()).setEnabled(true);
                this.d_imageEditor.getToolManager().setCurrentTool(this.d_imageEditor.getAPointTool());
                break;
            }
            case 3: {
                this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getBPointTool()).setEnabled(true);
                this.d_imageEditor.getToolManager().setCurrentTool(this.d_imageEditor.getBPointTool());
                this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getBPointTool()).requestFocus();
                break;
            }
            case 4: {
                this.d_distAB.setEnabled(true);
                this.d_distAB.requestFocus();
                this.d_abAngleCB.setEnabled(true);
                this.d_abAngle.setEnabled(this.d_abAngleCB.isSelected());
                this.getButton(1).setEnabled(true);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private void showPanel(guiPanel guiPanel2, boolean bl) {
        if (guiPanel2 == this.d_imgFilenamePanel && bl) {
            this.d_imgFilenameTitle.setForeground(Color.BLUE);
            this.d_scaleTitle.setForeground(Color.BLACK);
            this.d_scaleDesc.setForeground(Color.BLACK);
            this.d_anchorTitle.setForeground(Color.BLACK);
            this.d_anchorDesc.setForeground(Color.BLACK);
        } else if (guiPanel2 == this.d_anchorPanel && bl) {
            this.d_imgFilenameTitle.setForeground(Color.BLACK);
            this.d_scaleTitle.setForeground(Color.BLACK);
            this.d_scaleDesc.setForeground(Color.BLACK);
            this.d_anchorTitle.setForeground(Color.BLUE);
            this.d_anchorDesc.setForeground(Color.BLUE);
        } else if (guiPanel2 == this.d_scalePanel && bl) {
            this.d_imgFilenameTitle.setForeground(Color.BLACK);
            this.d_scaleTitle.setForeground(Color.BLUE);
            this.d_scaleDesc.setForeground(Color.BLUE);
            this.d_anchorTitle.setForeground(Color.BLACK);
            this.d_anchorDesc.setForeground(Color.BLACK);
        }
    }

    public void setZLocation(UnitDouble unitDouble) {
        this.d_modelZ.setValue(unitDouble);
        this.d_builder.setAnchorModel(new UnitPoint3D(0.0, 0.0, unitDouble.getValueNoUnit(), unitDouble.getUnit()));
    }

    @Override
    public void dispose() {
        this.d_igx.release();
        this.d_imageEditor = null;
        super.dispose();
    }

    @Override
    public int doModal() {
        this.loadPreferredSize(LastDlgWidthPref, LastDlgHeightPref);
        int n = super.doModal();
        if (n != 1) {
            this.dispose();
        }
        this.savePreferredSize(LastDlgWidthPref, LastDlgHeightPref);
        return n;
    }

    @Override
    public void pack() {
        super.pack();
        this.d_imageEditor.resetCamera();
    }

    public void setImage(Image image, BGImageXform bGImageXform, float f) {
        Mode mode = this.d_mode = bGImageXform == null ? Mode.CREATE : Mode.EDIT;
        if (this.d_mode == Mode.CREATE) {
            this.d_modelX.setEnabled(false);
            this.d_modelY.setEnabled(false);
            this.d_modelZ.setEnabled(false);
            this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAnchorTool()).setEnabled(false);
            this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAPointTool()).setEnabled(false);
            this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getBPointTool()).setEnabled(false);
            this.d_distAB.setEnabled(false);
            this.d_abAngleCB.setEnabled(false);
            this.d_abAngle.setEnabled(false);
            this.showPanel(this.d_imgFilenamePanel, true);
            this.getButton(1).setEnabled(false);
        } else {
            this.d_modelX.setEnabled(true);
            this.d_modelY.setEnabled(true);
            this.d_modelZ.setEnabled(true);
            this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAnchorTool()).setEnabled(true);
            this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getAPointTool()).setEnabled(true);
            this.d_imageEditor.getToolManager().getToolbarButton(this.d_imageEditor.getBPointTool()).setEnabled(true);
            this.d_distAB.setEnabled(true);
            this.d_abAngleCB.setEnabled(true);
            this.d_abAngle.setEnabled(this.d_abAngleCB.isSelected());
            this.showPanel(this.d_imgFilenamePanel, true);
            this.getButton(1).setEnabled(true);
        }
        this.d_builder.pause();
        if (image != null) {
            this.d_builder.setImage(image);
        }
        if (bGImageXform != null) {
            this.d_builder.setTransform(bGImageXform);
        }
        this.d_builder.setOpacity(f);
        this.d_builder.resume();
    }

    public ImageInfo getImage() {
        if (this.d_builder.getImage() != null) {
            this.d_igx.unregisterGraphics(this.d_builder.getName());
        }
        this.d_imageEditor.registerGraphics(this.d_igx);
        return this.d_builder.save();
    }

    private void loadImageFromChooser() {
        File file = this.d_loader.choose(this, this.d_builder.getFile());
        if (file == null) {
            return;
        }
        try {
            this.loadImage(file);
        }
        catch (IOException iOException) {
            BGImageDlg.showLoadError(this, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImage(File file) throws IOException {
        this.beginWaitCursor();
        try {
            if (!file.exists()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            File file2 = this.d_builder.getFile();
            if (file2 != null && FilenameManager.equal(file2, file)) {
                return;
            }
            Pair<Image, BGImageXform> pair = this.d_loader.load(file);
            if (pair == null) {
                return;
            }
            this.d_builder.pause();
            this.d_builder.setImage((Image)pair.v1);
            if (pair.v2 != null) {
                this.d_builder.setTransform((BGImageXform)pair.v2);
            }
            this.d_builder.resume();
        }
        finally {
            this.endWaitCursor();
        }
    }

    private static void showLoadError(Component component, IOException iOException) {
        JOptionPane.showMessageDialog(component, String.format("%s: %s", iOException.getClass().getSimpleName(), iOException.getLocalizedMessage()), Intl.intl("Image Error"), 0);
    }

    private static BGImageXform generateTransform(Point2d point2d, UnitPoint3D unitPoint3D, Point2d point2d2, Point2d point2d3, UnitDouble unitDouble, UnitDouble unitDouble2) {
        BaseUnit baseUnit = SI.METER;
        Unit unit = SI.RADIAN;
        assert (point2d != null && unitPoint3D != null);
        Point3d point3d = unitPoint3D.getPoint3dValue(baseUnit);
        if (point2d2 == null || point2d3 == null || unitDouble == null) {
            return new BGImageXform(point2d, point3d, new Point2d(0.0, 0.0), new Point2d(1.0, 0.0), 1.0, 0.0);
        }
        double d = unitDouble.getValue(baseUnit);
        if (unitDouble2 == null) {
            return new BGImageXform(point2d, point3d, point2d2, point2d3, d, Util2D.angle(new Vector2d(1.0, 0.0), Util2D.vector(point2d2, point2d3)));
        }
        return new BGImageXform(point2d, point3d, point2d2, point2d3, d, unitDouble2.getValue(unit));
    }

    public static interface IImageLoader {
        public File choose(Component var1, File var2);

        public Pair<Image, BGImageXform> load(File var1) throws IOException;
    }

    public static class ImageInfo {
        public final Image image;
        public final BGImageXform xform;
        public final float opacity;

        public ImageInfo(Image image, BGImageXform bGImageXform, float f) {
            this.image = image;
            this.xform = bGImageXform;
            this.opacity = f;
        }
    }

    private static class BGImageBuilder
    extends theObservable {
        public static final Object IMAGE_CHANGED = "IMAGE_CHANGED";
        public static final Object A_CHANGED = "A_CHANGED";
        public static final Object B_CHANGED = "B_CHANGED";
        public static final Object AB_DIST_CHANGED = "AB_DIST_CHANGED";
        public static final Object AB_ANGLE_CHANGED = "AB_ANGLE_CHANGED";
        public static final Object ANCHOR_IMAGE_CHANGED = "ANCHOR_IMAGE_CHANGED";
        public static final Object ANCHOR_MODEL_CHANGED = "ANCHOR_MODEL_CHANGED";
        public static final Object OPACITY_CHANGED = "OPACITY_CHANGED";
        public Image d_image = null;
        public Point2d d_anchorImage = new Point2d(0.0, 0.0);
        public boolean d_anchorCommitted = false;
        public UnitPoint3D d_anchorModel = new UnitPoint3D(0.0, 0.0, 0.0, SI.METER);
        public Point2d d_aImage = null;
        public boolean d_aCommitted = false;
        public Point2d d_bImage = null;
        public boolean d_bCommitted = false;
        public UnitDouble d_distABModel = new UnitDouble(1.0, SI.METER);
        public UnitDouble d_abAngle = null;
        public float d_opacity = 1.0f;
        private Set<Object> d_changes = new HashSet<Object>();
        private Semaphore d_lock = new Semaphore(1);

        private BGImageBuilder() {
        }

        protected boolean lock() {
            return this.d_lock.tryAcquire();
        }

        protected void unlock() {
            this.d_lock.release();
        }

        protected void changed(Object ... objectArray) {
            for (Object object : objectArray) {
                this.d_changes.add(object);
            }
            this.setChanged();
            this.tryFireNotification();
        }

        @Override
        protected boolean tryFireNotification(Object object) {
            if (super.tryFireNotification(this.d_changes)) {
                this.d_changes.clear();
                return true;
            }
            return false;
        }

        public void setImage(Image image) {
            if (!this.lock()) {
                return;
            }
            this.d_image = image;
            this.changed(IMAGE_CHANGED);
            this.unlock();
        }

        public void setTransform(BGImageXform bGImageXform) {
            this.pause();
            this.setAnchorImage(bGImageXform.anchorImage, true);
            this.setAnchorModel(new UnitPoint3D(bGImageXform.anchorModel, (Unit)SI.METER));
            this.setAImage(bGImageXform.aImage, true);
            this.setBImage(bGImageXform.bImage, true);
            this.setABDistModel(new UnitDouble(bGImageXform.distABModel, SI.METER));
            double d = bGImageXform.abAngle;
            double d2 = Util2D.angle(new Vector2d(1.0, 0.0), Util2D.vector(bGImageXform.aImage, bGImageXform.bImage));
            UnitDouble unitDouble = theUtil.eq(d, d2, 1.0E-6) ? null : new UnitDouble(d, SI.RADIAN);
            this.setABAngle(unitDouble);
            this.resume();
        }

        public ImageInfo save() {
            if (this.d_image == null) {
                return null;
            }
            BGImageXform bGImageXform = BGImageDlg.generateTransform(this.d_anchorImage, this.d_anchorModel, this.d_aImage, this.d_bImage, this.d_distABModel, this.d_abAngle);
            return new ImageInfo(this.d_image, bGImageXform, this.d_opacity);
        }

        public Image getImage() {
            return this.d_image;
        }

        public String getName() {
            return this.d_image != null ? this.d_image.getFilename() : null;
        }

        public File getFile() {
            return this.d_image != null ? new File(this.d_image.getFilename()) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setProperty(String string, Object object, Object object2) {
            if (!this.lock()) {
                return;
            }
            try {
                Field field = BGImageBuilder.class.getField(string);
                field.set(this, object);
                this.changed(object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.unlock();
            }
        }

        public void setOpacity(float f) {
            this.setProperty("d_opacity", Float.valueOf(f), OPACITY_CHANGED);
        }

        public float getOpacity() {
            return this.d_opacity;
        }

        public void setAnchorModel(UnitPoint3D unitPoint3D) {
            this.setProperty("d_anchorModel", unitPoint3D, ANCHOR_MODEL_CHANGED);
        }

        public UnitPoint3D getAnchorModel() {
            return this.d_anchorModel;
        }

        public void setAnchorImage(Point2d point2d, boolean bl) {
            if (!this.lock()) {
                return;
            }
            this.d_anchorImage = point2d;
            this.d_anchorCommitted = bl;
            this.changed(ANCHOR_IMAGE_CHANGED);
            this.unlock();
        }

        public Point2d getAnchorImage() {
            return this.d_anchorImage;
        }

        public boolean isAnchorImageCommitted() {
            return this.d_anchorCommitted;
        }

        public void setABDistModel(UnitDouble unitDouble) {
            this.setProperty("d_distABModel", unitDouble, AB_DIST_CHANGED);
        }

        public UnitDouble getDistABModel() {
            return this.d_distABModel;
        }

        public void setABAngle(UnitDouble unitDouble) {
            this.setProperty("d_abAngle", unitDouble, AB_ANGLE_CHANGED);
        }

        public UnitDouble getABAngle() {
            return this.d_abAngle;
        }

        public void setAImage(Point2d point2d, boolean bl) {
            if (!this.lock()) {
                return;
            }
            this.d_aImage = point2d;
            this.d_aCommitted = bl;
            this.changed(A_CHANGED);
            this.unlock();
        }

        public Point2d getAImage() {
            return this.d_aImage;
        }

        public boolean isACommitted() {
            return this.d_aCommitted;
        }

        public void setBImage(Point2d point2d, boolean bl) {
            if (!this.lock()) {
                return;
            }
            this.d_bImage = point2d;
            this.d_bCommitted = bl;
            this.changed(B_CHANGED);
            this.unlock();
        }

        public Point2d getBImage() {
            return this.d_bImage;
        }

        public boolean isBCommitted() {
            return this.d_bCommitted;
        }
    }

    public static class ImageEditor
    implements ColorChangedListener,
    IToolController,
    Observer {
        public static final Color COMMITTED_COLOR = new Color(0.8f, 0.1f, 0.3f, 1.0f);
        public static final Color EDITING_COLOR = Color.BLUE;
        private final BGImageBuilder d_builder;
        private final Unit d_displayLenUnit;
        private final SceneLayout d_layout = new SceneLayout(new ILayer[0]);
        private final ClearableBackground d_background = new ClearableBackground(true, true);
        private final AxesScene d_axes = new AxesScene();
        private final ModelScene d_imageScene = new ModelScene();
        private final ModelScene d_toolScene = new ModelScene();
        private final RenderComponent d_renderComp;
        private final View d_mainView;
        private final BasicRenderer d_toolLayer = new BasicRenderer();
        private final OriginDisp d_origin = new OriginDisp();
        private final OrthoCamera d_camera;
        private final ColorMgr d_colors;
        private final Map<Colors, String> d_colorMap;
        private final ToolManager d_tools;
        private final AnchorTool d_anchorTool;
        private final APointTool d_aPointTool;
        private final BPointTool d_bPointTool;
        private final CursorTool d_dragTool;
        private final CursorTool d_zoomTool;
        private final CursorTool d_zoomBoxTool;
        private final StringRenderer d_anchorRenderer;
        private final StringRenderer d_aRenderer;
        private final StringRenderer d_bRenderer;
        private final StringRenderer d_distRenderer;
        private final StringRenderer d_toolTextRenderer;
        private final GeomDisplay d_toolDisplay;
        private final JToolBar d_editToolbar;
        private final guiStatusBar d_statusBar;
        private final guiStatusMessage d_statusMessage;
        private final ResetAction d_resetAction = new ResetAction();
        private RasterObj d_imageDisplay = new RasterObj();

        public ImageEditor(IRenderSurface iRenderSurface, ColorMgr colorMgr, Map<Colors, String> map, Unit unit, BGImageBuilder bGImageBuilder) {
            this.d_builder = bGImageBuilder;
            this.d_displayLenUnit = unit;
            this.d_builder.addWeakObserver(this);
            this.d_colors = colorMgr;
            this.d_colorMap = map;
            this.d_renderComp = new RenderComponent(iRenderSurface);
            this.d_mainView = new View(this.d_renderComp, this.d_imageScene);
            this.d_renderComp.setLayout(this.d_layout);
            this.d_imageScene.getDrawProps().setLightingEnabled(false);
            this.d_imageScene.getDrawProps().setDepthTestEnabled(false);
            this.d_imageScene.forceImmediate(true);
            this.d_toolScene.getDrawProps().setLightingEnabled(false);
            this.d_toolScene.getDrawProps().setDepthTestEnabled(false);
            this.d_toolScene.forceImmediate(true);
            this.d_camera = new OrthoCamera(new Point3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), 0.0, 2.0, 10.0);
            TextRenderer textRenderer = new TextRenderer();
            textRenderer.setFontSize(12.0f);
            textRenderer.setCamera(this.d_camera);
            textRenderer.setPadding(new int[]{4, 4, 4, 4});
            textRenderer.setFontColor(Color.WHITE);
            textRenderer.setRenderType(0);
            this.d_anchorRenderer = ImageEditor.newStringRenderer(textRenderer, "", COMMITTED_COLOR);
            this.d_aRenderer = ImageEditor.newStringRenderer(textRenderer, "A", COMMITTED_COLOR);
            this.d_bRenderer = ImageEditor.newStringRenderer(textRenderer, "B", COMMITTED_COLOR);
            this.d_distRenderer = ImageEditor.newStringRenderer(textRenderer, "", COMMITTED_COLOR);
            this.d_toolTextRenderer = ImageEditor.newStringRenderer(textRenderer, "", EDITING_COLOR);
            this.d_statusBar = new guiStatusBar();
            this.d_statusBar.setLabelBorder(guiStatusBar.BEVEL_BORDER);
            this.d_statusMessage = new guiStatusMessage();
            this.d_statusBar.setStatusMessage(this.d_statusMessage);
            this.d_tools = new ToolManager(this.d_renderComp);
            this.d_anchorTool = new AnchorTool();
            this.d_tools.addTool(this.d_anchorTool, Intl.intl("Choose Anchor Point"), "Set the Anchor Point", null);
            this.d_aPointTool = new APointTool();
            this.d_tools.addTool(this.d_aPointTool, Intl.intl("Choose Point A"), "Set Point A", null);
            this.d_bPointTool = new BPointTool();
            this.d_tools.addTool(this.d_bPointTool, Intl.intl("Choose Point B"), "Set Point B", null);
            DragFunc dragFunc = new DragFunc();
            this.d_dragTool = new CursorTool(this, dragFunc);
            this.d_tools.addTool(this.d_dragTool, "Drag", Intl.intl("Pan View"), guiUtil.loadTeciIcon("drag16.gif"));
            ZoomFunc zoomFunc = new ZoomFunc();
            this.d_zoomTool = new CursorTool(this, zoomFunc);
            this.d_tools.addTool(this.d_zoomTool, "Zoom", Intl.intl("Zoom"), guiUtil.loadTeciIcon("Zoom16.gif"));
            ZoomBoxFunc zoomBoxFunc = new ZoomBoxFunc();
            this.d_zoomBoxTool = new CursorTool(this, zoomBoxFunc);
            this.d_tools.addTool(this.d_zoomBoxTool, "Zoom Box", Intl.intl("Zoom Box"), guiUtil.loadTeciIcon("zoombox16.gif"));
            this.d_tools.addToolChangeListener(new ToolManager.ToolChangeListener(){

                @Override
                public void toolWillChanged(Tool tool, Tool tool2) {
                    this.updateCurrentTool();
                }
            });
            this.d_toolDisplay = new GeomDisplay(new INativeDisplayProps(){

                @Override
                public double getFaceError() {
                    return 0.0;
                }

                @Override
                public double getCurveError() {
                    return 0.0;
                }

                @Override
                public Material getNativeMat(IMaterial iMaterial) {
                    return null;
                }
            }, new ConstGeomSrc());
            this.d_tools.setCurrentTool(this.d_dragTool);
            this.d_imageScene.setCamera(this.d_camera);
            this.d_toolScene.setCamera(this.d_camera);
            this.d_axes.setBaseCamera(this.d_camera);
            this.d_imageScene.addObjects(this.d_imageDisplay);
            this.d_toolScene.addObjects(this.d_toolDisplay, this.d_anchorRenderer, this.d_aRenderer, this.d_bRenderer, this.d_distRenderer);
            this.d_layout.addLayer(this.d_background);
            this.d_layout.addLayer(new BasicRenderer(this.d_imageScene));
            this.d_layout.addLayer(new BasicRenderer(this.d_camera, this.d_origin, this.d_toolScene));
            this.d_layout.addLayer(this.d_axes);
            this.d_layout.addLayer(new BasicRenderer(this.d_camera, this.d_toolTextRenderer));
            this.d_layout.addLayer(this.d_toolLayer);
            this.updateCurrentTool();
            this.d_editToolbar = this.createEditToolbar();
            this.updateColors();
            this.updateOrigin();
            this.updateDisplays();
        }

        @Override
        public GeomPicker getSnapper() {
            return null;
        }

        @Override
        public ModelScene[] getToolScenes() {
            return new ModelScene[2];
        }

        private static StringRenderer newStringRenderer(TextRenderer textRenderer, String string, Color color) {
            StringRenderer stringRenderer = new StringRenderer();
            stringRenderer.setRenderer(textRenderer);
            stringRenderer.setString(string);
            stringRenderer.setColor(color);
            return stringRenderer;
        }

        @Override
        public ColorMgr getColors() {
            return this.d_colors;
        }

        @Override
        public Component getRenderComp() {
            return this.d_renderComp;
        }

        @Override
        public guiStatusMessage getStatusMessage() {
            return this.d_statusMessage;
        }

        private JToolBar createEditToolbar() {
            JToolBar jToolBar = new JToolBar();
            jToolBar.add(this.d_tools.getToolbarButton(this.d_dragTool));
            jToolBar.add(this.d_tools.getToolbarButton(this.d_zoomTool));
            jToolBar.add(this.d_tools.getToolbarButton(this.d_zoomBoxTool));
            jToolBar.add(this.d_resetAction);
            Utils.noToolBarFocus(jToolBar);
            jToolBar.setMinimumSize(new Dimension(0, 0));
            return jToolBar;
        }

        protected void finalize() throws Throwable {
            System.out.println("finalizing image editor");
            System.out.flush();
            super.finalize();
        }

        @Override
        public void colorChanged(ColorChangedEvent colorChangedEvent) {
            this.updateColors();
            this.d_renderComp.repaint();
        }

        public void updateColors() {
            Color color = this.d_colors.getColor(this.d_colorMap.get((Object)Colors.BACKGROUND));
            this.d_background.setColor(color);
            float[] fArray = color.getComponents(new float[4]);
            this.d_axes.setBackgroundColor(new Color(fArray[0], fArray[1], fArray[2], 0.9f));
            this.d_axes.setAxisColor(this.d_colors.getColor(this.d_colorMap.get((Object)Colors.AXIS)));
            this.d_axes.setBoxColor(this.d_colors.getColor(this.d_colorMap.get((Object)Colors.AXIS_BOX)));
            this.d_axes.setTextColor(this.d_colors.getColor(this.d_colorMap.get((Object)Colors.AXIS_TEXT)));
            this.d_origin.setColor(this.d_colors.getColor(this.d_colorMap.get((Object)Colors.ORIGIN)));
        }

        @Override
        public void update(Observable observable, Object object) {
            Set set = (Set)object;
            boolean bl = false;
            boolean bl2 = false;
            if (set.contains(BGImageBuilder.IMAGE_CHANGED)) {
                Image image = this.d_builder.getImage();
                NativeImage nativeImage = image == null ? null : NativeImageMgr.getImage(image);
                this.d_imageDisplay.setImage(nativeImage);
                this.resetCamera();
            }
            if (set.contains(BGImageBuilder.ANCHOR_MODEL_CHANGED)) {
                this.d_anchorTool.markNativeDirty();
                bl2 = true;
                bl = true;
            }
            if (set.contains(BGImageBuilder.ANCHOR_IMAGE_CHANGED)) {
                this.d_anchorTool.markNativeDirty();
                bl2 = true;
                bl = true;
            }
            if (set.contains(BGImageBuilder.A_CHANGED)) {
                this.d_aPointTool.markNativeDirty();
                bl2 = true;
                bl = true;
            }
            if (set.contains(BGImageBuilder.B_CHANGED)) {
                this.d_bPointTool.markNativeDirty();
                bl2 = true;
                bl = true;
            }
            if (set.contains(BGImageBuilder.AB_ANGLE_CHANGED)) {
                bl2 = true;
            }
            if (set.contains(BGImageBuilder.AB_DIST_CHANGED)) {
                bl2 = true;
                bl = true;
            }
            if (set.contains(BGImageBuilder.OPACITY_CHANGED)) {
                this.d_imageDisplay.setColor(new Color(1.0f, 1.0f, 1.0f, this.d_builder.getOpacity()));
            }
            if (bl) {
                this.updateDisplays();
            }
            if (bl2) {
                this.updateOrigin();
            }
            this.d_mainView.getSurface().repaint();
        }

        private void updateDisplays() {
            Object object;
            Serializable serializable;
            Color color = COMMITTED_COLOR;
            ArrayList<APrimitive> arrayList = new ArrayList<APrimitive>();
            PropsBuilder propsBuilder = new PropsBuilder();
            this.d_anchorRenderer.setVisible(this.d_builder.isAnchorImageCommitted());
            if (this.d_builder.isAnchorImageCommitted()) {
                serializable = this.d_builder.getAnchorImage();
                arrayList.add(new Point(new Point3d(serializable.x, serializable.y, 0.0)));
                propsBuilder.add(new IPrimProps.Vertex(color, 5.0));
                object = this.d_anchorTool.toString();
                this.d_anchorRenderer.setString((String)object);
                this.d_anchorRenderer.setLocation(new Point3d(serializable.x, serializable.y, 0.0), null);
            }
            this.d_aRenderer.setVisible(this.d_builder.isACommitted());
            if (this.d_builder.isACommitted()) {
                serializable = this.d_builder.getAImage();
                arrayList.add(new Point(new Point3d(serializable.x, serializable.y, 0.0)));
                propsBuilder.add(new IPrimProps.Vertex(color, 5.0));
                this.d_aRenderer.setLocation(new Point3d(serializable.x, serializable.y, 0.0), null);
            }
            this.d_bRenderer.setVisible(this.d_builder.isBCommitted());
            if (this.d_builder.isBCommitted()) {
                serializable = this.d_builder.getBImage();
                arrayList.add(new Point(new Point3d(serializable.x, serializable.y, 0.0)));
                propsBuilder.add(new IPrimProps.Vertex(color, 5.0));
                this.d_bRenderer.setLocation(new Point3d(serializable.x, serializable.y, 0.0), null);
            }
            this.d_distRenderer.setVisible(this.d_builder.getAImage() != null && this.d_builder.getBImage() != null);
            if (this.d_builder.getAImage() != null && this.d_builder.getBImage() != null) {
                serializable = this.d_builder.getAImage();
                object = this.d_builder.getBImage();
                LineSeg lineSeg = new LineSeg(new Point3d(serializable.x, serializable.y, 0.0), new Point3d(((Point2d)object).x, ((Point2d)object).y, 0.0));
                arrayList.add(lineSeg);
                propsBuilder.add(new IPrimProps.Edge(color, 3.0));
                this.d_distRenderer.setString(this.d_builder.getDistABModel().toString());
                this.d_distRenderer.setLocation(Util3D.getMidPoint(lineSeg.p1, lineSeg.p2), null);
            }
            serializable = new GeomGroup(arrayList);
            object = new DisplayGeom((IGeom)serializable, propsBuilder.finalizeProps());
            ((ConstGeomSrc)this.d_toolDisplay.getSource()).setGeom((DisplayGeom)object);
            this.d_toolDisplay.update();
        }

        private void updateOrigin() {
            Matrix4d matrix4d;
            if (this.d_builder.getAnchorImage() == null || this.d_builder.getAnchorModel() == null) {
                matrix4d = new Matrix4d();
                matrix4d.setIdentity();
            } else {
                BGImageXform bGImageXform = BGImageDlg.generateTransform(this.d_builder.getAnchorImage(), this.d_builder.getAnchorModel(), this.d_builder.getAImage(), this.d_builder.getBImage(), this.d_builder.getDistABModel(), this.d_builder.getABAngle());
                matrix4d = bGImageXform.toMatrix();
                matrix4d.invert();
            }
            this.d_origin.setTransform(matrix4d);
        }

        public void registerGraphics(IntermediateGraphicsXfer intermediateGraphicsXfer) {
            if (intermediateGraphicsXfer != null) {
                String string = this.d_builder.getName();
                intermediateGraphicsXfer.registerGraphics(string, this.d_imageDisplay);
            }
        }

        public ToolManager getToolManager() {
            return this.d_tools;
        }

        public guiStatusBar getStatusBar() {
            return this.d_statusBar;
        }

        public JToolBar getEditToolbar() {
            return this.d_editToolbar;
        }

        public AnchorTool getAnchorTool() {
            return this.d_anchorTool;
        }

        public APointTool getAPointTool() {
            return this.d_aPointTool;
        }

        public BPointTool getBPointTool() {
            return this.d_bPointTool;
        }

        public void resetCamera() {
            OrthoCamera orthoCamera = this.d_camera;
            AABox aABox = this.d_imageDisplay.getBoundingBox();
            aABox = orthoCamera.ensureValidForReset(aABox, 5.0);
            orthoCamera.reset(aABox, this.d_renderComp.getWidth(), this.d_renderComp.getHeight());
        }

        private void updateCurrentTool() {
            Tool tool = this.d_tools.getCurrentTool();
            if (tool instanceof CursorTool) {
                CursorTool cursorTool = (CursorTool)tool;
                cursorTool.setView(this.d_mainView);
                this.d_toolLayer.clear();
                this.d_toolLayer.add(cursorTool);
            }
        }

        @Override
        public Unit[] getLengthUnits() {
            return new Unit[]{Unit.ONE, Unit.ONE};
        }

        private class ResetAction
        extends guiAction {
            private static final long serialVersionUID = 1441942531684678815L;

            public ResetAction() {
                super(Intl.intl("Reset View"), guiUtil.loadTeciIcon("ZoomFit16.gif"));
                this.putValue("ShortDescription", Intl.intl("Reset View"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke('r'));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke('R'));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageEditor.this.resetCamera();
                ImageEditor.this.d_renderComp.repaint();
            }
        }

        public static interface EditPointSetListener {
            public static final int EDIT_POINT_ANCHOR = 0;
            public static final int EDIT_POINT_A = 1;
            public static final int EDIT_POINT_B = 2;

            public void editPointSet(int var1, Point2d var2);
        }

        private class BPointTool
        extends PointTool {
            public BPointTool() {
                super(2, "B");
            }

            @Override
            protected void setPoint(Point2d point2d, boolean bl) {
                if (!point2d.equals(ImageEditor.this.d_aPointTool.getPoint())) {
                    // empty if block
                }
                ImageEditor.this.d_builder.setBImage(point2d, bl);
            }

            @Override
            protected Point2d getPoint() {
                return ImageEditor.this.d_builder.getBImage();
            }

            @Override
            protected String getStatusMessage() {
                if (ImageEditor.this.d_builder.getAImage() != null && ImageEditor.this.d_builder.getBImage() != null && ImageEditor.this.d_builder.getAImage().equals(ImageEditor.this.d_builder.getBImage())) {
                    return Intl.intl("Setting A and B to the same location causes an undefined scale factor.");
                }
                return super.getStatusMessage();
            }
        }

        private class APointTool
        extends PointTool {
            public APointTool() {
                super(1, "A");
            }

            @Override
            protected void setPoint(Point2d point2d, boolean bl) {
                if (!point2d.equals(ImageEditor.this.d_bPointTool.getPoint())) {
                    ImageEditor.this.d_builder.setAImage(point2d, bl);
                }
            }

            @Override
            protected Point2d getPoint() {
                return ImageEditor.this.d_builder.getAImage();
            }

            @Override
            protected String getStatusMessage() {
                if (ImageEditor.this.d_builder.getAImage() != null && ImageEditor.this.d_builder.getBImage() != null && ImageEditor.this.d_builder.getAImage().equals(ImageEditor.this.d_builder.getBImage())) {
                    return Intl.intl("Setting A and B to the same location causes an undefined scale factor.");
                }
                return super.getStatusMessage();
            }
        }

        private class AnchorTool
        extends PointTool {
            public AnchorTool() {
                super(0, Intl.intl("Anchor"));
            }

            @Override
            protected void setPoint(Point2d point2d, boolean bl) {
                ImageEditor.this.d_builder.setAnchorImage(point2d, bl);
            }

            @Override
            protected Point2d getPoint() {
                return ImageEditor.this.d_builder.getAnchorImage();
            }

            @Override
            public String toString() {
                if (ImageEditor.this.d_builder.getAnchorModel() != null) {
                    UnitPoint3D unitPoint3D = ImageEditor.this.d_builder.getAnchorModel().convert(ImageEditor.this.d_displayLenUnit);
                    String string = String.format("(%s, %s, %s) %s", Global.format(unitPoint3D.x()), Global.format(unitPoint3D.y()), Global.format(unitPoint3D.z()), unitPoint3D.getUnit().toString());
                    return super.toString() + " " + string;
                }
                return super.toString();
            }
        }

        private abstract class PointTool
        extends CursorTool {
            private int d_editEvent;
            private String d_text;

            public PointTool(int n, String string) {
                super(ImageEditor.this, new ToolFunc());
                this.d_text = "";
                this.d_editEvent = n;
                this.d_text = string;
            }

            protected abstract Point2d getPoint();

            protected abstract void setPoint(Point2d var1, boolean var2);

            public String toString() {
                return this.d_text;
            }

            @Override
            protected String getStatusMessage() {
                return Intl.intl("Image Position") + ": (" + Global.format(this.getP1().referenceSnap.x) + "," + Global.format(this.getP1().referenceSnap.y) + ")";
            }

            protected void updateDisplay(Point3d point3d) {
                String string = this.toString();
                ImageEditor.this.d_toolTextRenderer.setString(string);
                ImageEditor.this.d_toolTextRenderer.setLocation(new Point3d(point3d.x, point3d.y, 0.0), null);
            }

            protected void updatePoint(Point3d point3d, boolean bl) {
                Point2d point2d = new Point2d(point3d.x, point3d.y);
                this.setPoint(point2d, bl);
                this.updateDisplay(point3d);
            }
        }

        private class ToolFunc
        extends AToolFunction<PointTool> {
            private ToolFunc() {
            }

            @Override
            public Cursor getCursor(PointTool pointTool) {
                return null;
            }

            @Override
            public void mouseEntered(PointTool pointTool, MouseEvent mouseEvent) {
                ImageEditor.this.d_toolTextRenderer.setVisible(true);
            }

            @Override
            public void mouseExited(PointTool pointTool, MouseEvent mouseEvent) {
                ImageEditor.this.d_toolTextRenderer.setVisible(false);
            }

            @Override
            public void mousePressed(PointTool pointTool, MouseEvent mouseEvent) {
                pointTool.updatePoint(pointTool.getP0().referenceSnap, false);
            }

            @Override
            public void mouseReleased(PointTool pointTool, MouseEvent mouseEvent) {
                pointTool.updatePoint(pointTool.getP1().referenceSnap, true);
            }

            @Override
            public void mouseDragged(PointTool pointTool, MouseEvent mouseEvent) {
                pointTool.updatePoint(pointTool.getP1().referenceSnap, false);
            }

            @Override
            public void mouseMoved(PointTool pointTool, MouseEvent mouseEvent) {
                pointTool.updateDisplay(pointTool.getP1().referenceSnap);
            }
        }

        private static class ConstGeomSrc
        implements IGeomSource {
            private boolean d_visible = true;
            private DisplayGeom d_geom = DisplayGeom.EMPTY;

            private ConstGeomSrc() {
            }

            @Override
            public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
                return this.d_geom;
            }

            public void setGeom(DisplayGeom displayGeom) {
                this.d_geom = displayGeom;
            }

            @Override
            public boolean isVisible() {
                return this.d_visible;
            }

            @Override
            public void setVisible(boolean bl) {
                this.d_visible = bl;
            }
        }
    }

    private class ComponentPair
    extends guiPanel {
        private static final long serialVersionUID = -1461631803827397214L;

        public ComponentPair(Component component, Component component2, boolean bl) {
            this.setLayout(new GridBagLayout());
            if (bl) {
                GridBagUtil.add(this, component, 1, 1, 1, 1, 0, 0, 0, 6, 3, 0.0, 1.0, 17);
                GridBagUtil.add(this, component2, 2, 1, 1, 1, 0, 0, 0, 0, 3, 0.0, 1.0, 13);
            } else {
                GridBagUtil.add(this, component, 1, 1, 1, 1, 0, 0, 0, 6, 3, 0.0, 1.0, 17);
                GridBagUtil.add(this, component2, 2, 1, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
            }
        }
    }

    private static abstract class FldListener
    implements KeyListener,
    FocusListener {
        private guiValueField[] d_fields;

        protected abstract void updateToProps();

        public FldListener(guiValueField ... guiValueFieldArray) {
            this.d_fields = guiValueFieldArray;
            this.addAsListener();
        }

        private void addAsListener() {
            for (guiValueField guiValueField2 : this.d_fields) {
                guiValueField2.addKeyListener(this);
                guiValueField2.addFocusListener(this);
            }
        }

        private void removeAsListener() {
            for (guiValueField guiValueField2 : this.d_fields) {
                guiValueField2.addKeyListener(this);
                guiValueField2.removeFocusListener(this);
            }
        }

        private void update(boolean bl) {
            for (guiValueField guiValueField2 : this.d_fields) {
                if (guiValueField2.validateData(bl, bl)) continue;
                return;
            }
            this.updateToProps();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                this.update(true);
                for (guiValueField guiValueField2 : this.d_fields) {
                    guiValueField2.setSelectionStart(0);
                    guiValueField2.setSelectionEnd(guiValueField2.getDocument().getLength());
                }
                keyEvent.consume();
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary() && focusEvent.getOppositeComponent() != null && focusEvent.getSource() instanceof Validateable && ((Validateable)focusEvent.getSource()).validateData(true, true)) {
                this.update(false);
            }
        }
    }

    public static enum Mode {
        CREATE,
        EDIT;

    }

    public static enum Colors {
        BACKGROUND,
        AXIS,
        AXIS_BOX,
        AXIS_TEXT,
        ORIGIN;

    }
}

