/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import javax.vecmath.Point2d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.EmptyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.FlattenedProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.ITexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;

public class DisplayGeom {
    public static final ITexCoordGenerator DEF_TEXCOORDGEN = new DefTexCoordGen();
    public static final DisplayGeom EMPTY = new DisplayGeom((IGeom)EmptyGeom.INSTANCE, new FlattenedProps(new IPrimProps[0]));
    public final IGeom geom;
    public final IPropsSrc props;
    public final ITexCoordGenerator texuv;

    public DisplayGeom(IGeom iGeom, ITexCoordGenerator iTexCoordGenerator, IPropsSrc iPropsSrc) {
        this.geom = iGeom;
        this.props = iPropsSrc;
        this.texuv = iTexCoordGenerator;
    }

    public DisplayGeom(IGeom iGeom, IPropsSrc iPropsSrc) {
        this(iGeom, DEF_TEXCOORDGEN, iPropsSrc);
    }

    public DisplayGeom(IGeom iGeom, IPrimProps iPrimProps) {
        this(iGeom, new UniformProps(iPrimProps));
    }

    public DisplayGeom(IGeom iGeom, ITexCoordGenerator iTexCoordGenerator, IPrimProps iPrimProps) {
        this(iGeom, iTexCoordGenerator, new UniformProps(iPrimProps));
    }

    public DisplayGeom(IGeom iGeom, IPrimProps ... iPrimPropsArray) {
        this(iGeom, new FlattenedProps(iPrimPropsArray));
    }

    public DisplayGeom(IGeom iGeom, ITexCoordGenerator iTexCoordGenerator, IPrimProps ... iPrimPropsArray) {
        this(iGeom, iTexCoordGenerator, new FlattenedProps(iPrimPropsArray));
    }

    private static class DefTexCoordGen
    implements ITexCoordGenerator,
    Serializable {
        static final long serialVersionUID = 1L;

        private DefTexCoordGen() {
        }

        @Override
        public IElemSource<Point2d> fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
            return Elements.NO_UV;
        }

        @Override
        public void generate(int n, IPolygon iPolygon, IPrimProps iPrimProps, List<Point2d> list) {
            Point2d point2d = new Point2d(0.0, 0.0);
            int n2 = iPolygon.getNumLoops();
            for (int i = 0; i < n2; ++i) {
                int n3 = iPolygon.getNumPoints(i);
                for (int j = 0; j < n3; ++j) {
                    list.add(point2d);
                }
            }
        }

        @Override
        public void generate(int n, IFace iFace, IPrimProps iPrimProps, Mesh mesh, List<Point2d> list) {
            Point2d point2d = new Point2d(0.0, 0.0);
            for (int i = 0; i < mesh.vertices.length; ++i) {
                list.add(point2d);
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return DEF_TEXCOORDGEN;
        }
    }
}

