/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.license3;

import com.reprisesoftware.rlm.RlmAvailableProduct;
import com.reprisesoftware.rlm.RlmException;
import com.reprisesoftware.rlm.RlmHandle;
import com.reprisesoftware.rlm.RlmLicense;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.util.TeciProps;

public class LicenseManager {
    private final String d_productName;
    private final String d_license;
    private final String d_lmVersion;
    private RlmHandle d_rlm = null;
    private RlmLicense d_product = null;
    private Map<String, RlmLicense> d_options = new HashMap<String, RlmLicense>();
    private String d_licLoc = ".";
    private String d_lastError = "";
    private Timer d_timer;
    private int d_strikes = 0;

    public LicenseManager(String string, String string2, String string3) {
        this.d_productName = string;
        this.d_lmVersion = string3;
        this.d_license = string2;
    }

    public synchronized boolean startLM(String string) {
        RlmAvailableProduct rlmAvailableProduct;
        if (string == null) {
            string = "";
        }
        try {
            System.out.println("*** Using " + string);
            this.d_rlm = new RlmHandle(string, ".", this.d_license);
        }
        catch (RlmException rlmException) {
            System.out.println("RLM Handle Exception...");
            System.out.println(rlmException.getMessage());
            this.d_lastError = rlmException.getMessage();
            return false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("RLM Handle Exception...");
            System.out.println(unsatisfiedLinkError.getMessage());
            this.d_lastError = unsatisfiedLinkError.getMessage();
            return false;
        }
        try {
            this.d_product = new RlmLicense(this.d_rlm, this.d_productName, this.d_lmVersion, 1);
        }
        catch (RlmException rlmException) {
            System.out.println("RLM License Exception...");
            System.out.println(rlmException.getMessage());
            this.d_lastError = rlmException.getMessage();
            return false;
        }
        try {
            rlmAvailableProduct = this.getProduct();
        }
        catch (NoAvailableProductsException noAvailableProductsException) {
            rlmAvailableProduct = null;
        }
        double d = Double.parseDouble(this.d_product.getVersion());
        double d2 = Double.parseDouble(this.d_lmVersion);
        if ((this.d_product.getHostID().equals("") && (this.d_product.getHostID().equalsIgnoreCase("ANY") || this.d_product.getShare() != 3 || rlmAvailableProduct != null && rlmAvailableProduct.getCount() == 0) || d - d2 > 5.0 || this.d_product.getIssuer().toLowerCase().contains("lz0")) && Application.getApp() != null) {
            TeciProps teciProps = Application.getApp().getPrefs();
            boolean bl = teciProps.getBoolean("runlog", false);
            if (!bl) {
                LicenseManager.reportAbuse(this.d_productName, this.d_lmVersion, "firstrun");
                teciProps.set("runlog", (Object)true);
            } else {
                LicenseManager.reportAbuse(this.d_productName, this.d_lmVersion, "run");
            }
        }
        if (this.d_product.getHostID().equals("")) {
            System.out.println("Starting timer");
            this.d_strikes = 0;
            this.d_timer = new Timer(true);
            this.d_timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    LicenseManager.this.checkServerStatus();
                }
            }, 60000L, 60000L);
        }
        return true;
    }

    private synchronized void checkServerStatus() {
        block9: {
            int n = -1;
            if (this.d_product != null) {
                try {
                    n = this.d_product.getAttrHealth();
                }
                catch (RlmException rlmException) {
                    System.out.println("RLM License Exception...");
                    System.out.println(rlmException.getMessage());
                }
            }
            if (n != 0 && n != -25) {
                System.out.println("License Server Down -- status: " + n);
                ++this.d_strikes;
                if (this.d_strikes >= 3) {
                    this.checkin();
                    try {
                        this.d_product = new RlmLicense(this.d_rlm, this.d_productName, this.d_lmVersion, 1);
                    }
                    catch (RlmException rlmException) {
                        System.out.println("RLM License Exception...");
                        System.out.println(rlmException.getMessage());
                        this.d_lastError = rlmException.getMessage();
                        JOptionPane.showMessageDialog(null, Intl.intl("Lost floating license -- closing program."), String.format(Intl.intl("%s (Unlicensed)"), this.d_productName), 0);
                        System.out.println("Licensing failure. Shutting down.");
                        if (Application.getApp() != null) {
                            Application.getApp().quit(false);
                            break block9;
                        }
                        System.exit(0);
                    }
                }
            } else {
                System.out.println("License Server OK");
                this.d_strikes = 0;
            }
        }
    }

    private static void reportAbuse(final String string, final String string2, final String string3) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String string4 = "http://www.pyrosim.legacy_2012_1.thunderheadeng.com/runlog.php?prod=" + string + "&vers=" + string2 + "&event=" + string3;
                    URL uRL = new URL(string4);
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.getResponseCode();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        thread.start();
    }

    public String getHostID() {
        return this.d_rlm.getHostID(1).trim();
    }

    public String getHostIDs() {
        if (this.d_rlm == null) {
            return Intl.intl("unavailable");
        }
        String[] stringArray = this.d_rlm.getAllHostIDs(3);
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string = string + " ";
            }
            string = string + stringArray[i].trim();
        }
        return "hostid=" + this.d_rlm.getHostID(1).trim() + "\n" + "ether=" + string + "\n" + this.d_rlm.getHostID(6).trim();
    }

    public String getEth0(String string) {
        String[] stringArray = this.d_rlm.getAllHostIDs(3);
        if (stringArray != null && 0 < stringArray.length) {
            return stringArray[0];
        }
        return string;
    }

    public String getLicenseLocation() {
        return this.d_product == null ? "" : this.d_product.getLFPath();
    }

    public boolean isAuthorized() {
        return this.d_product != null && this.d_product.goodOnce();
    }

    public boolean isRoaming() {
        return this.d_product != null && this.d_product.isRoaming();
    }

    public boolean inQueue() {
        if (this.d_product != null) {
            try {
                if (this.d_product.status() == -25) {
                    return true;
                }
            }
            catch (RlmException rlmException) {
                System.out.println("RLM License Exception...");
                System.out.println(rlmException.getMessage());
                return false;
            }
        }
        return false;
    }

    public int getDaysRemaining() {
        return this.d_product.daysToExpiration();
    }

    private RlmAvailableProduct getProduct() throws NoAvailableProductsException {
        Vector vector = this.d_rlm.getAvailableProducts(this.d_productName, this.d_lmVersion);
        if (vector == null) {
            throw new NoAvailableProductsException();
        }
        return (RlmAvailableProduct)vector.get(0);
    }

    public String getDescription() {
        String string = Intl.intl("unknown error");
        if (this.d_rlm == null || this.d_product == null) {
            return this.d_lastError;
        }
        if (this.isAuthorized() || this.inQueue()) {
            try {
                RlmAvailableProduct rlmAvailableProduct = this.getProduct();
                string = "";
                int n = rlmAvailableProduct.getCount();
                System.out.println("Host ID: " + this.d_product.getHostID());
                String string2 = this.d_product.getHostID().equals("") ? Intl.intl("Floating") : Intl.intl("Node-Locked");
                String string3 = "";
                string3 = this.d_product.isRoaming() ? Intl.intl("Roaming") : (n == 0 ? Intl.intl("Unlimited") : String.format(Intl.intl("%1$d of %2$d"), rlmAvailableProduct.getCurrentInUse(), n));
                string = string + String.format(Intl.intl("Usage: %1$s, %2$s\n"), string2, string3);
                int n2 = this.d_product.daysToExpiration();
                String string4 = n2 == 0 ? Intl.intl("Unlimited") : Integer.toString(n2);
                string = string + String.format(Intl.intl("Days Remaining: %s\n"), string4);
                string = string + this.getAdditionalDesc();
                System.out.println("ROAM: " + this.d_product.isRoaming());
            }
            catch (NoAvailableProductsException noAvailableProductsException) {
                string = Intl.intl("Unable to communicate with license server.");
            }
        }
        return string;
    }

    protected String getAdditionalDesc() {
        return "";
    }

    public String getLastError() {
        return this.d_lastError;
    }

    private synchronized void checkin() {
        if (this.d_product != null) {
            this.d_product.checkin();
            this.d_product = null;
        }
        Set<String> set = this.d_options.keySet();
        for (String string : set) {
            this.d_options.get(string).checkin();
            this.d_options.remove(string);
        }
    }

    public synchronized void closeLM() {
        if (this.d_timer != null) {
            this.d_timer.cancel();
        }
        this.checkin();
        if (this.d_rlm != null) {
            this.d_rlm.close();
            this.d_rlm = null;
        }
    }

    public boolean isOptionAvailable(String string) {
        if (this.d_rlm == null || !this.isAuthorized()) {
            return false;
        }
        if (this.d_options.get(string) == null) {
            try {
                this.d_options.put(string, new RlmLicense(this.d_rlm, string, this.d_lmVersion, 1));
                int n = this.d_options.get(string).status();
                if (n != 0) {
                    return false;
                }
            }
            catch (RlmException rlmException) {
                System.out.println("RLM License Exception...");
                System.out.println(rlmException.getMessage());
                return false;
            }
        }
        return this.d_options.get(string).goodOnce();
    }

    public class NoAvailableProductsException
    extends Exception {
        private static final long serialVersionUID = 1205309955521637375L;
    }
}

