/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.legacy.v1.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import pyrosim.legacy_2012_1.thunderheadeng.util.IHasher;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHasher;
import pyrosim.legacy_2012_1.thunderheadeng.util.JavaHasher;
import pyrosim.legacy_2012_1.thunderheadeng.util.PtrHasher;

public class ListSet<T>
extends AbstractSet<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IHasher<T> d_hasher = null;
    private final List<T> d_elements = null;

    private ListSet() {
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        if (this.size() != set.size()) {
            return false;
        }
        for (T t : this.d_elements) {
            boolean bl = false;
            for (Object e : set) {
                if (!this.d_hasher.equal(t, e)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (T t : this.d_elements) {
            n += this.d_hasher.hash(t);
        }
        return n;
    }

    @Override
    public boolean add(T t) {
        if (!this.contains(t)) {
            return this.d_elements.add(t);
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        for (int i = 0; i < this.d_elements.size(); ++i) {
            T t = this.d_elements.get(i);
            if (!this.d_hasher.equal(t, object)) continue;
            this.d_elements.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        for (T t : this.d_elements) {
            if (!this.d_hasher.equal(t, object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.d_elements.clear();
    }

    @Override
    public Object[] toArray() {
        return this.d_elements.toArray();
    }

    @Override
    public <T2> T2[] toArray(T2[] T2Array) {
        return this.d_elements.toArray(T2Array);
    }

    @Override
    public Iterator<T> iterator() {
        return this.d_elements.iterator();
    }

    @Override
    public int size() {
        return this.d_elements.size();
    }

    public pyrosim.legacy_2012_1.thunderheadeng.util.ListSet convert() {
        IHasher iHasher = this.d_hasher instanceof PtrHasher ? IdentityHasher.INSTANCE : JavaHasher.INSTANCE;
        return new pyrosim.legacy_2012_1.thunderheadeng.util.ListSet<T>(iHasher, this.d_elements);
    }
}

