/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer;

import java.io.IOException;
import java.io.ObjectInputStream;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeObject;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.Native;
import pyrosim.legacy_2012_1.thunderheadeng.util.KeyableObject;

public class NativeObjectHelper
extends KeyableObject {
    private static final long serialVersionUID = -2072751119891279627L;
    private boolean d_nativeDirty = false;
    private INativeObject d_baseObject;

    public NativeObjectHelper(INativeObject iNativeObject) {
        this.d_baseObject = iNativeObject;
    }

    public void nativeConstructed(Class clazz) {
        if (clazz.equals(this.d_baseObject.resolveNativeClass())) {
            this.markNativeDirty();
        }
    }

    public void createPeer() {
        Native.manager.createPeer(this.d_baseObject.resolveNativeClass(), this.getKey());
    }

    @Override
    protected void finalize() throws Throwable {
        Native.manager.deletePeer(this.d_baseObject);
        super.finalize();
    }

    protected INativeObject getBaseObject() {
        return this.d_baseObject;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.createPeer();
    }

    public Object clone(INativeObject iNativeObject) {
        NativeObjectHelper nativeObjectHelper = (NativeObjectHelper)super.clone();
        nativeObjectHelper.d_baseObject = iNativeObject;
        nativeObjectHelper.createPeer();
        nativeObjectHelper.markNativeDirty();
        return nativeObjectHelper;
    }

    public void markNativeDirty() {
        this.d_nativeDirty = true;
    }

    public void markNativeClean() {
        this.d_nativeDirty = false;
    }

    public final boolean isNativeDirty() {
        return this.d_nativeDirty;
    }
}

