/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.ABufferedNativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeObject;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativelyMirrored;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.JNIException;

public class NativeManager
extends ABufferedNativeStream {
    protected long d_peerObj;
    private static final byte COMMAND_CREATE_OBJECT = 0;
    private static final byte COMMAND_DELETE_OBJECT = 1;
    private static final byte COMMAND_UPDATE_OBJECT = 2;
    private static final byte COMMAND_EXEC_METHOD = 3;
    private static final byte COMMAND_EXEC_STATIC_METHOD = 4;
    private static final byte COMMAND_STATUS_COMPLETE = 0;
    private static final byte COMMAND_STATUS_INCOMPLETE = 1;
    private int d_numCommands = 0;
    private byte d_commandStatus = 1;
    private int d_lastCommandPosition = 0;
    private int d_firstCommandLengthB = 0;
    private int d_lastCommandLengthB = 0;
    private final Map<Class<?>, Integer> d_classKeyMap = new HashMap();
    private int d_classKeyIt = 0;
    private int d_numFlushes = 0;
    private final ExecutorService d_executor = Executors.newSingleThreadExecutor();

    private native void registerClassKey(String var1, int var2);

    private final native void dispatch(ByteBuffer var1, ByteBuffer var2, int var3, byte var4, int var5, int var6) throws JNIException;

    public NativeManager() {
        this(0x100000, 0x100000);
    }

    public NativeManager(int n, int n2) {
        super(n, n2);
    }

    public ExecutorService getDispatchExecutor() {
        return this.d_executor;
    }

    private int registerClass(Class<?> clazz) {
        int n = this.d_classKeyIt++;
        this.d_classKeyMap.put(clazz, n);
        this.registerClassKey(clazz.getCanonicalName(), n);
        return n;
    }

    private final void beginCommand(byte by) {
        this.lockWriteBuffer();
        this.writeByte(by);
        this.d_lastCommandPosition = this.getWritePosition() - 1;
        this.d_commandStatus = 1;
        ++this.d_numCommands;
    }

    private final void endCommand() {
        this.d_commandStatus = 0;
        if (this.d_numCommands == 1) {
            this.d_firstCommandLengthB = this.getWritePosition() - this.d_lastCommandPosition;
        }
        this.markStrongRefsFinished();
        this.unlockWriteBuffer();
    }

    private final void beginCustomCommand(byte by, Class clazz, int n) {
        Integer n2 = this.d_classKeyMap.get(clazz);
        if (n2 == null) {
            n2 = this.registerClass(clazz);
        }
        this.beginCommand(by);
        this.writeInt(n2);
        this.writeInt(n);
    }

    private final void beginStaticCustomCommand(byte by, Class clazz) {
        Integer n = this.d_classKeyMap.get(clazz);
        if (n == null) {
            n = this.registerClass(clazz);
        }
        this.beginCommand(by);
        this.writeInt(n);
    }

    private final void beginFullCommand(byte by, INativeObject iNativeObject) {
        this.beginCustomCommand(by, iNativeObject.resolveNativeClass(), iNativeObject.getKey());
    }

    private final void beginSimpleCommand(byte by, INativeObject iNativeObject) {
        this.beginCommand(by);
        this.writeInt(iNativeObject.getKey());
    }

    public final void markPeerDirty(INativelyMirrored iNativelyMirrored) {
        this.updatePeer(iNativelyMirrored);
    }

    public final void createPeer(INativeObject iNativeObject) {
        this.beginFullCommand((byte)0, iNativeObject);
        this.endCommand();
    }

    public final void createPeers(Collection<? extends INativeObject> collection) {
        for (INativeObject iNativeObject : collection) {
            this.createPeer(iNativeObject);
        }
    }

    public final void createPeer(Class clazz, int n) {
        this.beginCustomCommand((byte)0, clazz, n);
        this.endCommand();
    }

    private final void updatePeer(INativelyMirrored iNativelyMirrored) {
        this.beginSimpleCommand((byte)2, iNativelyMirrored);
        iNativelyMirrored.writeNativeData(this);
        this.endCommand();
        iNativelyMirrored.markNativeClean();
    }

    private final void updatePeers(Collection<? extends INativelyMirrored> collection) {
        for (INativelyMirrored iNativelyMirrored : collection) {
            this.updatePeer(iNativelyMirrored);
        }
    }

    public final void execMethod(Class clazz, INativeObject iNativeObject, int n, Object ... objectArray) {
        this.beginCustomCommand((byte)3, clazz, iNativeObject.getKey());
        this.writeInt(n);
        this.writeObjects(objectArray);
        this.endCommand();
    }

    public final void execStaticMethod(Class clazz, int n, Object ... objectArray) {
        this.beginStaticCustomCommand((byte)4, clazz);
        this.writeInt(n);
        this.writeObjects(objectArray);
        this.endCommand();
    }

    public final void deletePeer(INativeObject iNativeObject) {
        this.scheduleFlush(5000L);
        this.beginSimpleCommand((byte)1, iNativeObject);
        this.endCommand();
    }

    public final void deletePeers(Collection<? extends INativeObject> collection) {
        for (INativeObject iNativeObject : collection) {
            this.deletePeer(iNativeObject);
        }
    }

    @Override
    public final void flush() {
        super.flush();
    }

    @Override
    protected void dispatch(final ByteBuffer byteBuffer, final ByteBuffer byteBuffer2) {
        this.d_lastCommandLengthB = this.getWritePosition() - this.d_lastCommandPosition;
        if (this.d_numCommands == 1) {
            this.d_firstCommandLengthB = this.d_lastCommandLengthB;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                NativeManager.this.dispatch(byteBuffer, byteBuffer2, NativeManager.this.d_numCommands, NativeManager.this.d_commandStatus, NativeManager.this.d_firstCommandLengthB, NativeManager.this.d_lastCommandLengthB);
            }
        };
        try {
            this.d_executor.submit(runnable).get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.d_numCommands = this.d_commandStatus == 1 ? 1 : 0;
        this.d_lastCommandPosition = 0;
        ++this.d_numFlushes;
    }

    public void resetFlushCount() {
        this.lockWriteBuffer();
        this.d_numFlushes = 0;
        this.unlockWriteBuffer();
    }

    public int getFlushCount() {
        return this.d_numFlushes;
    }
}

