/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer;

import java.io.Flushable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.util.Keyable;
import pyrosim.legacy_2012_1.thunderheadeng.util.KeyableObject;

public abstract class ABufferedNativeStream
implements INativeStream,
Flushable {
    public static final int DEFAULT_CAPACITY = 0x100000;
    private ByteBuffer d_writeBuffer;
    private final ReentrantLock d_bufferLock = new ReentrantLock();
    private ByteBuffer d_readBuffer;
    private Timer d_flushTimer = null;
    private final CustomList<Keyable> d_strongReferences = new CustomList(262144);
    private int d_numStrongRefsFinished = 0;

    public ABufferedNativeStream() {
        this(0x100000, 0x100000);
    }

    public ABufferedNativeStream(int n, int n2) {
        this.d_writeBuffer = ByteBuffer.allocateDirect(n).order(ByteOrder.nativeOrder());
        this.d_readBuffer = ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder());
    }

    public boolean setWriteCapacity(int n) {
        this.lockWriteBuffer();
        if (this.getWritePosition() != 0) {
            this.unlockWriteBuffer();
            return false;
        }
        this.d_writeBuffer = ByteBuffer.allocateDirect(n).order(ByteOrder.nativeOrder());
        this.unlockWriteBuffer();
        return true;
    }

    public void lockWriteBuffer() {
        this.d_bufferLock.lock();
    }

    public void unlockWriteBuffer() {
        this.d_bufferLock.unlock();
    }

    public final int getWritePosition() {
        return this.d_writeBuffer.position();
    }

    @Override
    public final void write(Keyable keyable) {
        this.d_strongReferences.add(keyable);
        this.checkBuffer(4);
        this.d_writeBuffer.putInt(keyable != null ? keyable.getKey() : 0);
    }

    @Override
    public final void write(Keyable ... keyableArray) {
        for (Keyable keyable : keyableArray) {
            this.write(keyable);
        }
    }

    @Override
    public void write(Collection<? extends Keyable> collection) {
        for (Keyable keyable : collection) {
            this.write(keyable);
        }
    }

    @Override
    public final void writeBoolean(boolean bl) {
        this.checkBuffer(1);
        this.d_writeBuffer.put(bl ? (byte)1 : 0);
    }

    @Override
    public final void writeBooleans(boolean ... blArray) {
        for (boolean bl : blArray) {
            this.writeBoolean(bl);
        }
    }

    @Override
    public final void writeByte(byte by) {
        this.checkBuffer(1);
        this.d_writeBuffer.put(by);
    }

    @Override
    public final void writeBytes(byte ... byArray) {
        for (byte by : byArray) {
            this.writeByte(by);
        }
    }

    @Override
    public final void writeShort(short s) {
        this.checkBuffer(2);
        this.d_writeBuffer.putShort(s);
    }

    @Override
    public final void writeShorts(short ... sArray) {
        for (short s : sArray) {
            this.writeShort(s);
        }
    }

    @Override
    public final void writeLong(long l) {
        this.checkBuffer(8);
        this.d_writeBuffer.putLong(l);
    }

    @Override
    public final void writeLongs(long ... lArray) {
        for (long l : lArray) {
            this.writeLong(l);
        }
    }

    @Override
    public void writeChar(char c) {
        this.checkBuffer(2);
        this.d_writeBuffer.putChar(c);
    }

    @Override
    public void writeChars(char ... cArray) {
        for (char c : cArray) {
            this.writeChar(c);
        }
    }

    @Override
    public final void writeInt(int n) {
        this.checkBuffer(4);
        this.d_writeBuffer.putInt(n);
    }

    @Override
    public final void writeInts(int ... nArray) {
        for (int n : nArray) {
            this.writeInt(n);
        }
    }

    @Override
    public final void writeFloat(float f) {
        this.checkBuffer(4);
        this.d_writeBuffer.putFloat(f);
    }

    @Override
    public final void writeFloats(float ... fArray) {
        for (float f : fArray) {
            this.writeFloat(f);
        }
    }

    @Override
    public final void writeDouble(double d) {
        this.checkBuffer(8);
        this.d_writeBuffer.putDouble(d);
    }

    @Override
    public final void writeDoubles(double ... dArray) {
        for (double d : dArray) {
            this.writeDouble(d);
        }
    }

    @Override
    public void writeString(String string) {
        if (string == null) {
            this.writeInt(0);
            return;
        }
        this.writeInt(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            this.writeChar(c);
        }
    }

    @Override
    public void writeStrings(String ... stringArray) {
        for (String string : stringArray) {
            this.writeString(string);
        }
    }

    @Override
    public void writeObject(Object object) {
        if (object == null) {
            this.writeInt(0);
        } else if (object instanceof Byte) {
            this.writeByte((Byte)object);
        } else if (object instanceof byte[]) {
            this.writeBytes((byte[])object);
        } else if (object instanceof Short) {
            this.writeShort((Short)object);
        } else if (object instanceof short[]) {
            this.writeShorts((short[])object);
        } else if (object instanceof Long) {
            this.writeLong((Long)object);
        } else if (object instanceof long[]) {
            this.writeLongs((long[])object);
        } else if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof boolean[]) {
            this.writeBooleans((boolean[])object);
        } else if (object instanceof Character) {
            this.writeChar(((Character)object).charValue());
        } else if (object instanceof char[]) {
            this.writeChars((char[])object);
        } else if (object instanceof Integer) {
            this.writeInt((Integer)object);
        } else if (object instanceof int[]) {
            this.writeInts((int[])object);
        } else if (object instanceof Float) {
            this.writeFloat(((Float)object).floatValue());
        } else if (object instanceof float[]) {
            this.writeFloats((float[])object);
        } else if (object instanceof Double) {
            this.writeDouble((Double)object);
        } else if (object instanceof double[]) {
            this.writeDoubles((double[])object);
        } else if (object instanceof Keyable) {
            this.write((Keyable)object);
        } else if (object instanceof Keyable[]) {
            this.write((Keyable[])object);
        } else if (object instanceof String) {
            this.writeString((String)object);
        } else if (object instanceof String[]) {
            this.writeStrings((String[])object);
        } else if (object instanceof Object[]) {
            this.writeObjects((Object[])object);
        } else assert (false) : "ABufferedNativeStream.writeObject failed: didn't recognize object type, " + object.getClass();
    }

    @Override
    public void writeObjects(Object ... objectArray) {
        for (Object object : objectArray) {
            this.writeObject(object);
        }
    }

    @Override
    public Keyable read() {
        int n = this.d_readBuffer.getInt();
        return KeyableObject.KEY_GENERATOR.get(n);
    }

    @Override
    public void read(Keyable ... keyableArray) {
        for (int i = 0; i < keyableArray.length; ++i) {
            keyableArray[i] = this.read();
        }
    }

    @Override
    public void read(int n, Collection<Keyable> collection) {
        for (int i = 0; i < n; ++i) {
            collection.add(this.read());
        }
    }

    @Override
    public boolean readBoolean() {
        return this.d_readBuffer.get() != 0;
    }

    @Override
    public void readBooleans(boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.d_readBuffer.get() != 0;
        }
    }

    @Override
    public byte readByte() {
        return this.d_readBuffer.get();
    }

    @Override
    public void readBytes(byte[] byArray) {
        this.d_readBuffer.get(byArray, 0, byArray.length);
    }

    @Override
    public short readShort() {
        return this.d_readBuffer.getShort();
    }

    @Override
    public void readShorts(short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = this.d_readBuffer.getShort();
        }
    }

    @Override
    public long readLong() {
        return this.d_readBuffer.getLong();
    }

    @Override
    public void readLongs(long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = this.d_readBuffer.getLong();
        }
    }

    @Override
    public char readChar() {
        return this.d_readBuffer.getChar();
    }

    @Override
    public void readChars(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = this.d_readBuffer.getChar();
        }
    }

    @Override
    public int readInt() {
        return this.d_readBuffer.getInt();
    }

    @Override
    public void readInts(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.d_readBuffer.getInt();
        }
    }

    @Override
    public float readFloat() {
        return this.d_readBuffer.getFloat();
    }

    @Override
    public void readFloats(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.d_readBuffer.getFloat();
        }
    }

    @Override
    public double readDouble() {
        return this.d_readBuffer.getDouble();
    }

    @Override
    public void readDoubles(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.d_readBuffer.getDouble();
        }
    }

    public double[] readDoubles(int n) {
        double[] dArray = new double[n];
        this.readDoubles(dArray);
        return dArray;
    }

    @Override
    public String readString() {
        int n = this.readInt();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = this.readChar();
        }
        return new String(cArray);
    }

    @Override
    public void readStrings(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.readString();
        }
    }

    private final void checkBuffer(int n) {
        assert (n <= this.d_writeBuffer.capacity());
        if (n > this.d_writeBuffer.remaining()) {
            this.forceFlush();
        }
    }

    protected void markStrongRefsFinished() {
        this.d_numStrongRefsFinished = this.d_strongReferences.size();
    }

    private void clearFinishedStrongRefs() {
        int n = this.d_strongReferences.size() - this.d_numStrongRefsFinished;
        if (n == 0) {
            this.d_strongReferences.clear();
        } else {
            this.d_strongReferences.removeRange(0, this.d_numStrongRefsFinished);
        }
        this.d_numStrongRefsFinished = n;
    }

    @Override
    public void flush() {
        this.lockWriteBuffer();
        this.forceFlush();
        this.unlockWriteBuffer();
    }

    protected final void forceFlush() {
        this.cancelScheduledFlush();
        if (this.d_writeBuffer.position() == 0) {
            return;
        }
        this.dispatch(this.d_writeBuffer, this.d_readBuffer);
        this.clearFinishedStrongRefs();
        this.d_writeBuffer.position(0);
        this.d_readBuffer.position(0);
    }

    protected abstract void dispatch(ByteBuffer var1, ByteBuffer var2);

    public final synchronized void scheduleFlush(long l) {
        if (this.d_flushTimer == null) {
            this.d_flushTimer = new Timer();
            this.d_flushTimer.schedule((TimerTask)new FlushTask(), l);
        }
    }

    public final synchronized void cancelScheduledFlush() {
        if (this.d_flushTimer != null) {
            this.d_flushTimer.cancel();
            this.d_flushTimer = null;
        }
    }

    private static class CustomList<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = -5364222441192552349L;

        public CustomList(int n) {
            super(n);
        }

        @Override
        public void removeRange(int n, int n2) {
            super.removeRange(n, n2);
        }
    }

    private final class FlushTask
    extends TimerTask {
        private FlushTask() {
        }

        @Override
        public void run() {
            ABufferedNativeStream.this.d_flushTimer = null;
            ABufferedNativeStream.this.lockWriteBuffer();
            ABufferedNativeStream.this.forceFlush();
            ABufferedNativeStream.this.unlockWriteBuffer();
        }
    }
}

