/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.io;

import java.util.Enumeration;
import java.util.Properties;
import pyrosim.legacy_2012_1.thunderheadeng.util.Queue.UniqQImpl;

public class MRUFileList {
    private static final int DefaultMaxEntries = 4;
    public static final String DefaultPrefixString = "MRU.";
    private static final String FILE_NUM_STR = "FILE_";
    public static final String NUM_ENTRIES_STR = "MAX_ENTRIES";
    private String d_prefix = "MRU.";
    private int d_maxEntries = 4;
    UniqQImpl d_entries = new UniqQImpl(this.d_maxEntries);

    public void setMaxEntries(int n) {
        this.d_maxEntries = n;
        this.d_entries.setMaxSize(this.d_maxEntries);
    }

    public int getMaxEntries() {
        return this.d_maxEntries;
    }

    public void setEntryPrefix(String string) {
        this.d_prefix = string;
    }

    public String getEntryPrefix() {
        return this.d_prefix;
    }

    public void usedFile(String string) {
        this.d_entries.insertFirst(string);
    }

    public void removeFile(String string) {
        this.d_entries.removeElement(string);
    }

    public int getNumEntries() {
        return this.d_entries.size();
    }

    public String getFilename(int n) {
        if (n < 0 || n >= this.d_entries.size()) {
            return null;
        }
        Enumeration enumeration = this.d_entries.elements();
        for (int i = 0; i < n; ++i) {
            enumeration.nextElement();
        }
        return (String)enumeration.nextElement();
    }

    public String[] getFileList() {
        String[] stringArray = new String[this.d_entries.size()];
        Enumeration enumeration = this.d_entries.elements();
        for (int i = 0; enumeration.hasMoreElements() && i < this.d_maxEntries; ++i) {
            stringArray[i] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public void load(Properties properties) {
        String string = properties.getProperty(this.d_prefix + NUM_ENTRIES_STR);
        if (string != null) {
            try {
                this.setMaxEntries(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.loadEntries(properties);
    }

    public void store(Properties properties) {
        properties.setProperty(this.d_prefix + NUM_ENTRIES_STR, Integer.toString(this.getMaxEntries()));
        this.saveEntries(properties);
    }

    private void loadEntries(Properties properties) {
        String string;
        this.d_entries.clear();
        for (int i = 1; i <= this.d_maxEntries && (string = properties.getProperty(this.d_prefix + FILE_NUM_STR + i)) != null; ++i) {
            this.d_entries.insertLast(string);
        }
    }

    private void saveEntries(Properties properties) {
        String string;
        Enumeration enumeration = this.d_entries.elements();
        int n = 1;
        while (enumeration.hasMoreElements() && n <= this.d_maxEntries) {
            string = (String)enumeration.nextElement();
            properties.setProperty(this.d_prefix + FILE_NUM_STR + n++, string);
        }
        while ((string = properties.getProperty(this.d_prefix + FILE_NUM_STR + n)) != null) {
            properties.remove(this.d_prefix + FILE_NUM_STR + n);
            ++n;
        }
    }
}

