/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedRandomAccessFile
extends RandomAccessFile {
    private static final int DefaultBufferSize = 8192;
    private byte[] d_buf;
    private int d_bufEnd = 0;
    private int d_bufPos = 0;
    private long d_realPos = 0L;

    public BufferedRandomAccessFile(String string, String string2) throws FileNotFoundException {
        super(string, string2);
        this.init(8192);
    }

    public BufferedRandomAccessFile(File file, String string) throws FileNotFoundException {
        super(file, string);
        this.init(8192);
    }

    public BufferedRandomAccessFile(String string, String string2, int n) throws FileNotFoundException {
        super(string, string2);
        this.init(n);
    }

    public BufferedRandomAccessFile(File file, String string, int n) throws FileNotFoundException {
        super(file, string);
        this.init(n);
    }

    private void init(int n) {
        this.invalidate();
        this.d_buf = new byte[n];
    }

    @Override
    public final int read() throws IOException {
        if (this.d_bufPos >= this.d_bufEnd && this.fillBuffer() < 0) {
            return -1;
        }
        if (this.d_bufEnd == 0) {
            return -1;
        }
        return this.d_buf[this.d_bufPos++];
    }

    private int fillBuffer() throws IOException {
        int n = super.read(this.d_buf, 0, this.d_buf.length);
        if (n >= 0) {
            this.d_realPos += (long)n;
            this.d_bufEnd = n;
            this.d_bufPos = 0;
        }
        return n;
    }

    private void invalidate() {
        this.d_bufEnd = 0;
        this.d_bufPos = 0;
        try {
            this.d_realPos = super.getFilePointer();
        }
        catch (IOException iOException) {
            this.d_realPos = 0L;
        }
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.d_bufEnd - this.d_bufPos;
        if (n2 <= n3) {
            System.arraycopy(this.d_buf, this.d_bufPos, byArray, n, n2);
            this.d_bufPos += n2;
            return n2;
        }
        for (int i = 0; i < n2; ++i) {
            int n4 = this.read();
            if (n4 == -1) {
                return i;
            }
            byArray[n + i] = (byte)n4;
        }
        return n2;
    }

    @Override
    public long getFilePointer() throws IOException {
        long l = this.d_realPos;
        return l - (long)this.d_bufEnd + (long)this.d_bufPos;
    }

    @Override
    public void seek(long l) throws IOException {
        int n = (int)(this.d_realPos - l);
        if (n >= 0 && n <= this.d_bufEnd) {
            this.d_bufPos = this.d_bufEnd - n;
        } else {
            super.seek(l);
            this.invalidate();
        }
    }

    public final String getNextLine() throws IOException {
        String string = null;
        if (this.d_bufEnd - this.d_bufPos <= 0 && this.fillBuffer() < 0) {
            throw new IOException("error in filling buffer!");
        }
        int n = -1;
        for (int i = this.d_bufPos; i < this.d_bufEnd; ++i) {
            if (this.d_buf[i] != 10) continue;
            n = i;
            break;
        }
        if (n < 0) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer(256);
            while ((n2 = this.read()) != -1 && n2 != 10) {
                stringBuffer.append((char)n2);
            }
            if (n2 == -1 && stringBuffer.length() == 0) {
                return null;
            }
            return stringBuffer.toString();
        }
        string = n > 0 && this.d_buf[n - 1] == 13 ? new String(this.d_buf, this.d_bufPos, n - this.d_bufPos - 1) : new String(this.d_buf, this.d_bufPos, n - this.d_bufPos);
        this.d_bufPos = n + 1;
        return string;
    }
}

