/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;
import pyrosim.legacy_2012_1.ILegacy_2012_1;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.util.ImageInfo;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.FileSystem;
import thunderheadeng.io.streamsrc.ByteBufferStreamSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;

public class Image
implements Serializable,
ILegacy_2012_1 {
    static final long serialVersionUID = 1L;
    private static final Integer CURR_VERSION = 2;
    private Integer d_version = CURR_VERSION;
    private transient ByteBuffer d_buffer;
    private int d_width;
    private int d_height;
    private String d_filename;

    protected Image(String string, ByteBuffer byteBuffer, int n, int n2) {
        this.d_buffer = byteBuffer;
        this.d_width = n;
        this.d_height = n2;
        this.d_filename = string;
    }

    @Override
    public thunderheadeng.image.Image fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        IStreamSrc iStreamSrc;
        Object object;
        Object object2;
        Object object3 = null;
        if (this.d_filename != null && new File(this.d_filename).exists()) {
            object2 = FileSystem.INSTANCE;
            object = object2.getStreamSrc(this.d_filename, 3);
            object3 = thunderheadeng.image.Image.loadUnchecked(this.d_filename, (IStreamSrc)object);
        }
        if (this.isCached()) {
            object = this.getBuffer();
            iStreamSrc = new ByteBufferStreamSrc((ByteBuffer)object);
            object2 = thunderheadeng.image.Image.loadUnchecked(this.d_filename, iStreamSrc);
        } else {
            object2 = object3;
        }
        if (object3 != null && (object2 == object3 || object2.makeHashable().equals(object3))) {
            ImageManager.registerImage(this.d_filename, (thunderheadeng.image.Image)object2);
        }
        if (object2 == null) {
            object = this.d_filename == null ? "" : this.d_filename;
            iStreamSrc = FileSystem.INSTANCE.getStreamSrc((String)object, 3);
            object2 = thunderheadeng.image.Image.loadUnchecked((String)object, iStreamSrc);
        }
        return object2;
    }

    public boolean pseudoEquals(Image image) {
        if (this.getFileSize() != image.getFileSize()) {
            return false;
        }
        return this.getFileSize() == image.getFileSize() && this.getWidth() == image.getWidth() && this.getHeight() == image.getHeight();
    }

    public int pseudoHashCode() {
        return (int)this.getFileSize() + this.getWidth() + this.getHeight();
    }

    private long getFileSize() {
        if (this.isCached()) {
            return this.getBuffer().limit();
        }
        File file = new File(this.getFilename());
        return file.length();
    }

    public boolean isCached() {
        return this.d_buffer != null;
    }

    public boolean isValid() {
        return this.isCached() || new File(this.d_filename).exists();
    }

    public Image toCachedImage() {
        if (this.isCached()) {
            return this;
        }
        return Image.load(this.d_filename);
    }

    public BufferedImage toBufferedImage() {
        try {
            if (!this.isCached()) {
                return ImageIO.read(new File(this.d_filename));
            }
            return ImageIO.read(new ByteBufferInputStream(this.d_buffer));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean save(String string) {
        Object object;
        ByteBuffer byteBuffer = this.d_buffer;
        if (byteBuffer == null && (object = Image.load(this.d_filename)) != null) {
            byteBuffer = ((Image)object).d_buffer;
        }
        if (byteBuffer != null) {
            object = new byte[byteBuffer.limit()];
            byteBuffer.get((byte[])object, 0, byteBuffer.limit());
            byteBuffer.position(0);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                fileOutputStream.write((byte[])object);
                fileOutputStream.close();
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public String getFilename() {
        return this.d_filename;
    }

    public int getHeight() {
        return this.d_height;
    }

    public int getWidth() {
        return this.d_width;
    }

    public ByteBuffer getBuffer() {
        if (this.d_buffer == null) {
            return null;
        }
        return this.d_buffer.duplicate();
    }

    public static Image loadUncached(String string) {
        int[] nArray = Image.retrieveImageInfo(string, null);
        return new Image(string, null, nArray[0], nArray[1]);
    }

    public static Image load(String string) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        Image image = Image.loadFromStream(string, fileInputStream);
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return image;
    }

    public static Image load(String string, BufferedImage bufferedImage) {
        return Image.loadFromImage(string, bufferedImage);
    }

    public static Image load(String string, InputStream inputStream) {
        return Image.loadFromStream(string, inputStream);
    }

    public static Image load(String string, byte[] byArray) {
        return Image.loadFromBuffer(string, byArray, 0, byArray.length);
    }

    public static Image load(String string, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        return Image.loadFromLegacy(string, byArray, n, n2, n3, n4, n6, n5);
    }

    public static Image legacySetName(String string, Image image) {
        return new Image(string, image.d_buffer, image.d_width, image.d_height);
    }

    private static Image loadFromImage(String string, BufferedImage bufferedImage) {
        CustomByteArrayOutputStream customByteArrayOutputStream = new CustomByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "PNG", customByteArrayOutputStream);
        }
        catch (IOException iOException) {
            return null;
        }
        return Image.loadFromBuffer(string, customByteArrayOutputStream.getBuffer(), 0, customByteArrayOutputStream.size());
    }

    private static Image loadFromStream(String string, InputStream inputStream) {
        try {
            if (inputStream instanceof FileInputStream) {
                return Image.loadFromFile(string, (FileInputStream)inputStream);
            }
            return Image.loadFromUnknown(string, inputStream);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Image loadFromFile(String string, FileInputStream fileInputStream) throws IOException {
        long l = fileInputStream.getChannel().size();
        if (l > Integer.MAX_VALUE) {
            return null;
        }
        return Image.loadFromStream(string, fileInputStream, (int)l);
    }

    private static Image loadFromStream(String string, InputStream inputStream, int n) throws IOException {
        ByteBuffer byteBuffer = Image.allocate(n);
        if (byteBuffer == null) {
            return null;
        }
        byte[] byArray = new byte[8192];
        while (byteBuffer.hasRemaining()) {
            int n2 = Math.min(byteBuffer.remaining(), byArray.length);
            int n3 = inputStream.read(byArray, 0, n2);
            if (n3 == -1) {
                return null;
            }
            byteBuffer.put(byArray, 0, n3);
        }
        byteBuffer.position(0);
        int[] nArray = Image.retrieveImageInfo(string, byteBuffer);
        return new Image(string, byteBuffer, nArray[0], nArray[1]);
    }

    private static Image loadFromUnknown(String string, InputStream inputStream) throws IOException {
        try (CustomByteArrayOutputStream customByteArrayOutputStream = new CustomByteArrayOutputStream();){
            int n;
            byte[] byArray = new byte[8192];
            while (inputStream.available() > 0 && (n = inputStream.read(byArray)) != -1) {
                customByteArrayOutputStream.write(byArray, 0, n);
            }
            Image image = Image.loadFromBuffer(string, customByteArrayOutputStream.getBuffer(), 0, customByteArrayOutputStream.size());
            return image;
        }
    }

    private static Image loadFromLegacy(String string, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        assert (byArray.length >= n3 * n2);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        int n7 = 0;
        for (int i = 0; i < n2; ++i) {
            int n8 = n2 - i - 1;
            for (int j = 0; j < n; ++j) {
                int n9 = n7 + j * 3;
                int n10 = byArray[n9 + n4] & 0xFF;
                int n11 = byArray[n9 + n5] & 0xFF;
                int n12 = byArray[n9 + n6] & 0xFF;
                int n13 = 0xFF000000 | n10 << 16 | n11 << 8 | n12 << 0;
                bufferedImage.setRGB(j, n8, n13);
            }
            n7 += n3;
        }
        return Image.loadFromImage(string, bufferedImage);
    }

    private static Image loadFromBuffer(String string, byte[] byArray, int n, int n2) {
        ByteBuffer byteBuffer = Image.allocate(byArray.length);
        if (byteBuffer == null) {
            return null;
        }
        byteBuffer.put(byArray, n, n2);
        byteBuffer.position(0);
        int[] nArray = Image.retrieveImageInfo(string, byteBuffer);
        return new Image(string, byteBuffer, nArray[0], nArray[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] retrieveImageInfo(String string, ByteBuffer byteBuffer) {
        InputStream inputStream = null;
        if (byteBuffer != null) {
            inputStream = new ByteBufferInputStream(byteBuffer);
        } else if (string != null) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        if (inputStream == null) {
            return new int[]{0, 0};
        }
        try {
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setInput(inputStream);
            if (!imageInfo.check()) {
                int[] nArray = new int[]{0, 0};
                return nArray;
            }
            int[] nArray = new int[]{imageInfo.getWidth(), imageInfo.getHeight()};
            return nArray;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.d_buffer == null) {
            objectOutputStream.writeBoolean(false);
        } else {
            objectOutputStream.writeBoolean(true);
            if (this.d_buffer.hasArray()) {
                byte[] byArray = this.d_buffer.array();
                objectOutputStream.writeInt(byArray.length);
                objectOutputStream.write(byArray, 0, byArray.length);
            } else {
                objectOutputStream.writeInt(this.d_buffer.limit());
                byte[] byArray = new byte[8192];
                while (this.d_buffer.hasRemaining()) {
                    int n = Math.min(this.d_buffer.remaining(), byArray.length);
                    this.d_buffer.get(byArray, 0, n);
                    objectOutputStream.write(byArray, 0, n);
                }
                this.d_buffer.position(0);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        boolean bl = objectInputStream.readBoolean();
        if (!bl) {
            this.d_buffer = null;
        } else {
            Image image;
            int n = objectInputStream.readInt();
            if (this.d_version == null) {
                this.d_version = CURR_VERSION;
                byte[] byArray = new byte[n];
                objectInputStream.readFully(byArray);
                int n2 = 2;
                int n3 = 1;
                int n4 = 0;
                int n5 = this.d_width * 3;
                int n6 = n5 % 4 == 0 ? n5 : (n5 >> 2) + 1 << 2;
                image = Image.loadFromLegacy(this.d_filename, byArray, this.d_width, this.d_height, n6, n2, n3, n4);
            } else {
                image = Image.loadFromStream(this.d_filename, objectInputStream, n);
            }
            this.d_filename = image.d_filename;
            this.d_width = image.d_width;
            this.d_height = image.d_height;
            this.d_buffer = image.d_buffer;
        }
    }

    public static ByteBuffer allocate(int n) {
        if (n == 0) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    private static class ByteBufferInputStream
    extends InputStream {
        private final ByteBuffer d_buffer;

        public ByteBufferInputStream(ByteBuffer byteBuffer) {
            this.d_buffer = byteBuffer.duplicate();
        }

        @Override
        public synchronized void mark(int n) {
            this.d_buffer.mark();
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.d_buffer.reset();
        }

        @Override
        public int available() throws IOException {
            return this.d_buffer.remaining();
        }

        @Override
        public int read() throws IOException {
            if (this.d_buffer.remaining() == 0) {
                return -1;
            }
            return this.d_buffer.get();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            int n = this.d_buffer.remaining();
            if (n == 0) {
                return -1;
            }
            int n2 = Math.min(n, byArray.length);
            this.d_buffer.get(byArray, 0, n2);
            return n2;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.d_buffer.remaining();
            if (n3 == 0) {
                return -1;
            }
            int n4 = Math.min(n3, n2);
            this.d_buffer.get(byArray, n, n4);
            return n4;
        }

        @Override
        public long skip(long l) throws IOException {
            if (l < 0L) {
                return 0L;
            }
            int n = this.d_buffer.remaining();
            int n2 = Math.min(n, (int)Math.min(Integer.MAX_VALUE, l));
            this.d_buffer.position(this.d_buffer.position() + n2);
            return n2;
        }
    }

    private static class CustomByteArrayOutputStream
    extends ByteArrayOutputStream {
        private CustomByteArrayOutputStream() {
        }

        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

