/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.table;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import junit.framework.TestCase;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Command;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.ClipboardTableModel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.guiDefaultTableModel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.guiTable;

public class guiTableTest
extends TestCase {
    private guiTable d_table;
    private ClipboardOwner d_owner = new TestOwner();
    private ClipboardTableModel d_cbModel;
    private TableModel d_resizeModel;
    private String d_littleData;
    private String d_wideData;
    private String d_tallData;
    private String d_bigData;
    private String d_intData;
    private JFrame d_frame;

    public guiTableTest(String string) {
        super(string);
    }

    public void setUp() {
        this.d_resizeModel = new guiDefaultTableModel(6, 2);
        ((guiDefaultTableModel)this.d_resizeModel).setColumnClass(Integer.class);
        this.d_table = new guiTable(this.d_resizeModel, 15);
        this.d_table.setSortOrder(0);
        this.d_table.setValueAt(new Integer(2), 0, 0);
        this.d_table.setValueAt(new Integer(3), 1, 0);
        this.d_table.setValueAt(new Integer(4), 2, 0);
        this.d_table.setValueAt(new Integer(5), 3, 0);
        this.d_table.setValueAt(new Integer(1), 4, 0);
        this.d_table.setValueAt(new Integer(8), 5, 0);
        this.d_table.setValueAt(new Integer(10), 0, 1);
        this.d_table.setValueAt(new Integer(9), 1, 1);
        this.d_table.setValueAt(new Integer(8), 2, 1);
        this.d_table.setValueAt(new Integer(7), 3, 1);
        this.d_table.setValueAt(new Integer(6), 4, 1);
        this.d_table.setValueAt(new Integer(5), 5, 1);
        String string = "\t";
        String string2 = "\n";
        this.d_littleData = "Hi" + string + "There" + string2 + "Line" + string + "Two" + string2;
        this.d_wideData = "This" + string + "data" + string + "is" + string2 + "three" + string + "columns" + string + "wide." + string2;
        this.d_tallData = "There" + string + "are" + string2 + "three" + string + "lines" + string2 + "of" + string + "data." + string2;
        this.d_bigData = "Here" + string + "is" + string + "a" + string + "dataset" + string + "that" + string + "is" + string + "large" + string2 + "and" + string + "irregular." + string + "" + string + "There's" + string2 + "an" + string2 + "empty" + string2 + "cell" + string + "" + string + "<-empty" + string2 + "before" + string2 + "this" + string + "sentence." + string + "Make" + string + "sure" + string + "it's" + string2 + "empty." + string2;
        this.d_intData = "16" + string + "-4" + string + "7" + string2 + "3" + string2 + "2" + string + "22" + string + "222" + string2 + "50" + string2 + "-67" + string2 + "15" + string + "11" + string + "-1" + string + "248" + string + "9" + string2 + "43" + string + "29" + string + "10" + string2 + "430" + string + "290" + string + "100" + string2;
        this.d_frame = new JFrame();
        this.d_frame.getContentPane().add(new JScrollPane(this.d_table));
        this.d_frame.setSize(300, 200);
        this.d_frame.setVisible(true);
    }

    public void tearDown() {
        this.d_frame.dispose();
    }

    public void testSort() {
        Integer n = (Integer)this.d_table.getValueAt(0, 0);
        guiTableTest.assertEquals((int)2, (int)n);
        n = (Integer)this.d_table.getValueAt(5, 0);
        guiTableTest.assertEquals((int)8, (int)n);
        n = (Integer)this.d_table.getValueAt(0, 1);
        guiTableTest.assertEquals((int)10, (int)n);
        n = (Integer)this.d_table.getValueAt(5, 1);
        guiTableTest.assertEquals((int)5, (int)n);
        this.d_table.setSortOrder(1);
        n = (Integer)this.d_table.getValueAt(0, 0);
        guiTableTest.assertEquals((int)1, (int)n);
        n = (Integer)this.d_table.getValueAt(5, 0);
        guiTableTest.assertEquals((int)8, (int)n);
        n = (Integer)this.d_table.getValueAt(0, 1);
        guiTableTest.assertEquals((int)6, (int)n);
        n = (Integer)this.d_table.getValueAt(5, 1);
        guiTableTest.assertEquals((int)5, (int)n);
        this.d_table.setSortOrder(2);
        n = (Integer)this.d_table.getValueAt(0, 0);
        guiTableTest.assertEquals((int)8, (int)n);
        n = (Integer)this.d_table.getValueAt(5, 0);
        guiTableTest.assertEquals((int)1, (int)n);
        n = (Integer)this.d_table.getValueAt(0, 1);
        guiTableTest.assertEquals((int)5, (int)n);
        n = (Integer)this.d_table.getValueAt(5, 1);
        guiTableTest.assertEquals((int)6, (int)n);
        this.d_table.setSortOrder(1);
        this.d_table.setSortColumn(1);
        n = (Integer)this.d_table.getValueAt(0, 0);
        guiTableTest.assertEquals((int)8, (int)n);
        n = (Integer)this.d_table.getValueAt(5, 0);
        guiTableTest.assertEquals((int)2, (int)n);
        n = (Integer)this.d_table.getValueAt(0, 1);
        guiTableTest.assertEquals((int)5, (int)n);
        n = (Integer)this.d_table.getValueAt(5, 1);
        guiTableTest.assertEquals((int)10, (int)n);
    }

    public void testSelectedRow() {
        int n = this.d_table.getSelectedRow();
        guiTableTest.assertEquals((int)-1, (int)n);
        int[] nArray = this.d_table.getSelectedRows();
        guiTableTest.assertEquals((int)0, (int)nArray.length);
        int n2 = this.d_table.convertRowIndexToModel(2);
        guiTableTest.assertEquals((int)2, (int)n2);
        this.d_table.setRowSelectionInterval(2, 2);
        n = this.d_table.getSelectedRow();
        guiTableTest.assertEquals((int)2, (int)n);
        nArray = this.d_table.getSelectedRows();
        guiTableTest.assertEquals((int)1, (int)nArray.length);
        guiTableTest.assertEquals((int)2, (int)nArray[0]);
        this.d_table.setSortColumn(0);
        this.d_table.setSortOrder(1);
        n = this.d_table.getSelectedRow();
        n = this.d_table.convertRowIndexToModel(n);
        guiTableTest.assertEquals((int)2, (int)n);
        nArray = this.d_table.getSelectedRows();
        guiTableTest.assertEquals((int)1, (int)nArray.length);
        guiTableTest.assertEquals((int)2, (int)this.d_table.convertRowIndexToModel(nArray[0]));
    }

    public void testCut() {
    }

    public void testCopy() {
    }

    public void testPasteLittle() {
        this.putOnClipboard(this.d_littleData);
        this.d_table.setRowSelectionInterval(2, 2);
        this.d_table.paste();
        Integer n = (Integer)this.d_table.getValueAt(1, 0);
        guiTableTest.assertEquals((int)3, (int)n);
        n = (Integer)this.d_table.getValueAt(1, 1);
        guiTableTest.assertEquals((int)9, (int)n);
        guiTableTest.assertEquals((Object)"Hi", (Object)this.d_table.getValueAt(2, 0));
        guiTableTest.assertEquals((Object)"There", (Object)this.d_table.getValueAt(2, 1));
        guiTableTest.assertEquals((Object)"Line", (Object)this.d_table.getValueAt(3, 0));
        guiTableTest.assertEquals((Object)"Two", (Object)this.d_table.getValueAt(3, 1));
        n = (Integer)this.d_table.getValueAt(4, 0);
        guiTableTest.assertEquals((int)1, (int)n);
        n = (Integer)this.d_table.getValueAt(4, 1);
        guiTableTest.assertEquals((int)6, (int)n);
    }

    public void testPasteWide() {
        this.putOnClipboard(this.d_wideData);
        this.d_table.setRowSelectionInterval(2, 2);
        this.d_table.paste();
        guiTableTest.assertEquals((int)3, (int)this.d_table.getColumnCount());
        Integer n = (Integer)this.d_table.getValueAt(1, 0);
        guiTableTest.assertEquals((int)3, (int)n);
        n = (Integer)this.d_table.getValueAt(1, 1);
        guiTableTest.assertEquals((int)9, (int)n);
        guiTableTest.assertEquals((Object)"This", (Object)this.d_table.getValueAt(2, 0));
        guiTableTest.assertEquals((Object)"data", (Object)this.d_table.getValueAt(2, 1));
        guiTableTest.assertEquals((Object)"is", (Object)this.d_table.getValueAt(2, 2));
        guiTableTest.assertEquals((Object)"three", (Object)this.d_table.getValueAt(3, 0));
        guiTableTest.assertEquals((Object)"columns", (Object)this.d_table.getValueAt(3, 1));
        guiTableTest.assertEquals((Object)"wide.", (Object)this.d_table.getValueAt(3, 2));
        n = (Integer)this.d_table.getValueAt(4, 0);
        guiTableTest.assertEquals((int)1, (int)n);
        n = (Integer)this.d_table.getValueAt(4, 1);
        guiTableTest.assertEquals((int)6, (int)n);
        guiTableTest.assertEquals(null, (Object)this.d_table.getValueAt(4, 2));
    }

    public void testPasteTall() {
        this.putOnClipboard(this.d_tallData);
        this.d_table.setRowSelectionInterval(4, 4);
        this.d_table.paste();
        guiTableTest.assertEquals((int)7, (int)this.d_table.getModel().getRowCount());
        Integer n = (Integer)this.d_table.getValueAt(3, 0);
        guiTableTest.assertEquals((int)5, (int)n);
        n = (Integer)this.d_table.getValueAt(3, 1);
        guiTableTest.assertEquals((int)7, (int)n);
        guiTableTest.assertEquals((Object)"There", (Object)this.d_table.getValueAt(4, 0));
        guiTableTest.assertEquals((Object)"are", (Object)this.d_table.getValueAt(4, 1));
        guiTableTest.assertEquals((Object)"three", (Object)this.d_table.getValueAt(5, 0));
        guiTableTest.assertEquals((Object)"lines", (Object)this.d_table.getValueAt(5, 1));
        guiTableTest.assertEquals((Object)"of", (Object)this.d_table.getValueAt(6, 0));
        guiTableTest.assertEquals((Object)"data.", (Object)this.d_table.getValueAt(6, 1));
    }

    public void testPasteBig() {
        this.putOnClipboard(this.d_bigData);
        this.d_table.setRowSelectionInterval(0, 0);
        this.d_table.paste();
        guiTableTest.assertEquals((int)8, (int)this.d_table.getModel().getRowCount());
        guiTableTest.assertEquals((int)7, (int)this.d_table.getColumnCount());
        guiTableTest.assertEquals((Object)"Here", (Object)this.d_table.getValueAt(0, 0));
        guiTableTest.assertEquals((Object)"large", (Object)this.d_table.getValueAt(0, 6));
        guiTableTest.assertEquals((Object)"irregular.", (Object)this.d_table.getValueAt(1, 1));
        guiTableTest.assertEquals((Object)"empty", (Object)this.d_table.getValueAt(3, 0));
        guiTableTest.assertEquals((Object)"", (Object)this.d_table.getValueAt(4, 1));
        guiTableTest.assertEquals((Object)"empty.", (Object)this.d_table.getValueAt(7, 0));
    }

    public void testPasteSorted() {
        this.d_table.setSortOrder(1);
        ((guiDefaultTableModel)this.d_resizeModel).setColumnClass(String.class);
        this.putOnClipboard(this.d_intData);
        this.d_table.setRowSelectionInterval(0, 0);
        this.d_table.paste();
        guiTableTest.assertEquals((int)8, (int)this.d_table.getModel().getRowCount());
        guiTableTest.assertEquals((int)5, (int)this.d_table.getColumnCount());
        guiTableTest.assertEquals((Object)"16", (Object)this.d_table.getValueAt(0, 0));
        guiTableTest.assertEquals((Object)"3", (Object)this.d_table.getValueAt(1, 0));
        guiTableTest.assertEquals((Object)"22", (Object)this.d_table.getValueAt(2, 1));
        guiTableTest.assertEquals((Object)"-67", (Object)this.d_table.getValueAt(4, 0));
        guiTableTest.assertEquals((Object)"9", (Object)this.d_table.getValueAt(5, 4));
        guiTableTest.assertEquals((Object)"100", (Object)this.d_table.getValueAt(7, 2));
    }

    public void testInsertRows() {
        this.d_table.setRowSelectionInterval(3, 3);
        guiTable.InsertRowCmd insertRowCmd = this.d_table.getInsertRowCommand();
        insertRowCmd.execute();
        insertRowCmd.execute();
        guiTableTest.assertEquals((int)8, (int)this.d_table.getModel().getRowCount());
        guiTableTest.assertEquals((Object)new Integer(4), (Object)this.d_table.getValueAt(2, 0));
        guiTableTest.assertEquals(null, (Object)this.d_table.getValueAt(3, 0));
        guiTableTest.assertEquals(null, (Object)this.d_table.getValueAt(4, 0));
        guiTableTest.assertEquals((Object)new Integer(5), (Object)this.d_table.getValueAt(5, 0));
    }

    public void testInsertRowsSorted() {
        this.d_table.setSortOrder(1);
        guiTableTest.assertEquals((int)6, (int)this.d_table.getModel().getRowCount());
        guiTableTest.assertEquals((Object)new Integer(3), (Object)this.d_table.getValueAt(2, 0));
        guiTableTest.assertEquals((Object)new Integer(8), (Object)this.d_table.getValueAt(3, 1));
        this.d_table.setRowSelectionInterval(3, 3);
        guiTable.InsertRowCmd insertRowCmd = this.d_table.getInsertRowCommand();
        insertRowCmd.execute();
        insertRowCmd.execute();
        guiTableTest.assertEquals((int)6, (int)this.d_table.getModel().getRowCount());
        guiTableTest.assertEquals((Object)new Integer(3), (Object)this.d_table.getValueAt(2, 0));
        guiTableTest.assertEquals((Object)new Integer(8), (Object)this.d_table.getValueAt(3, 1));
    }

    public void testRemoveRows() {
        this.d_table.setRowSelectionInterval(3, 3);
        guiTable.RemoveRowCmd removeRowCmd = this.d_table.getRemoveRowCommand();
        removeRowCmd.execute();
        removeRowCmd.execute();
        guiTableTest.assertEquals((int)4, (int)this.d_table.getModel().getRowCount());
        guiTableTest.assertEquals((Object)new Integer(4), (Object)this.d_table.getValueAt(2, 0));
        guiTableTest.assertEquals((Object)new Integer(8), (Object)this.d_table.getValueAt(2, 1));
        guiTableTest.assertEquals((Object)new Integer(5), (Object)this.d_table.getValueAt(3, 1));
    }

    public void testRemoveRowsSorted() {
        this.d_table.setSortOrder(2);
        guiTableTest.assertEquals((int)6, (int)this.d_table.getModel().getRowCount());
        this.d_table.setRowSelectionInterval(2, 4);
        guiTable.RemoveRowCmd removeRowCmd = this.d_table.getRemoveRowCommand();
        removeRowCmd.execute();
        guiTableTest.assertEquals((int)3, (int)this.d_table.getModel().getRowCount());
        guiTableTest.assertEquals((Object)new Integer(5), (Object)this.d_table.getValueAt(1, 0));
        guiTableTest.assertEquals((Object)new Integer(7), (Object)this.d_table.getValueAt(1, 1));
        guiTableTest.assertEquals((Object)new Integer(1), (Object)this.d_table.getValueAt(2, 0));
    }

    public void testMoveRowsUp() {
        this.d_table.setRowSelectionInterval(3, 3);
        guiTable.MoveRowUpCmd moveRowUpCmd = this.d_table.getMoveRowUpCommand();
        ((Command)moveRowUpCmd).execute();
        ((Command)moveRowUpCmd).execute();
        guiTableTest.assertEquals((int)6, (int)this.d_table.getModel().getRowCount());
        guiTableTest.assertEquals((Object)new Integer(2), (Object)this.d_table.getValueAt(0, 0));
        guiTableTest.assertEquals((Object)new Integer(5), (Object)this.d_table.getValueAt(1, 0));
        guiTableTest.assertEquals((Object)new Integer(3), (Object)this.d_table.getValueAt(2, 0));
        guiTableTest.assertEquals((Object)new Integer(4), (Object)this.d_table.getValueAt(3, 0));
        guiTableTest.assertEquals((Object)new Integer(1), (Object)this.d_table.getValueAt(4, 0));
    }

    public void testMoveRowsUpSorted() {
        this.d_table.setSortOrder(1);
        guiTableTest.assertEquals((int)6, (int)this.d_table.getModel().getRowCount());
        guiTableTest.assertEquals((Object)new Integer(3), (Object)this.d_table.getValueAt(2, 0));
        guiTableTest.assertEquals((Object)new Integer(8), (Object)this.d_table.getValueAt(3, 1));
        this.d_table.setRowSelectionInterval(3, 4);
        guiTable.MoveRowUpCmd moveRowUpCmd = this.d_table.getMoveRowUpCommand();
        ((Command)moveRowUpCmd).execute();
        ((Command)moveRowUpCmd).execute();
        guiTableTest.assertEquals((int)6, (int)this.d_table.getModel().getRowCount());
        guiTableTest.assertEquals((Object)new Integer(3), (Object)this.d_table.getValueAt(2, 0));
        guiTableTest.assertEquals((Object)new Integer(8), (Object)this.d_table.getValueAt(3, 1));
    }

    public void testMoveRowsDown() {
        this.d_table.setRowSelectionInterval(1, 1);
        guiTable.MoveRowDownCmd moveRowDownCmd = this.d_table.getMoveRowDownCommand();
        ((Command)moveRowDownCmd).execute();
        ((Command)moveRowDownCmd).execute();
        guiTableTest.assertEquals((int)6, (int)this.d_table.getModel().getRowCount());
        guiTableTest.assertEquals((Object)new Integer(2), (Object)this.d_table.getValueAt(0, 0));
        guiTableTest.assertEquals((Object)new Integer(4), (Object)this.d_table.getValueAt(1, 0));
        guiTableTest.assertEquals((Object)new Integer(5), (Object)this.d_table.getValueAt(2, 0));
        guiTableTest.assertEquals((Object)new Integer(3), (Object)this.d_table.getValueAt(3, 0));
        guiTableTest.assertEquals((Object)new Integer(1), (Object)this.d_table.getValueAt(4, 0));
    }

    private void putOnClipboard(String string) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), this.d_owner);
    }

    class TestOwner
    implements ClipboardOwner {
        TestOwner() {
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }
}

