/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.AbstractCommand;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Command;
import pyrosim.legacy_2012_1.thunderheadeng.gui.CommandAction;
import pyrosim.legacy_2012_1.thunderheadeng.gui.ContextMenu;
import pyrosim.legacy_2012_1.thunderheadeng.gui.ContextMenuListener;
import pyrosim.legacy_2012_1.thunderheadeng.gui.ContextMenuModel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Modifiable;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Validateable;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDialog;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.ComboBoxTableCell;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.CustomHeader;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.DefaultTableClipboard;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.LimitedTableClipboard;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.ResizableTableModel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.SortMod;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.TableModelValidator;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.guiDefaultTableModel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.guiRowHeader;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.guiTableClipboard;
import pyrosim.legacy_2012_1.thunderheadeng.io.ObjectSelection;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;

public class guiTable
extends JTable
implements ContextMenuModel,
Modifiable,
Validateable {
    private static final long serialVersionUID = -9003580211472127340L;
    public static final CustomHeader HEADER_UP = new CustomHeader("graphics/SpinUp.gif");
    public static final CustomHeader HEADER_DOWN = new CustomHeader("graphics/SpinDown.gif");
    public static final String COMMIT_ADD_ROW_ACTION = "CommitAddRow";
    public static final String CUT_ACTION = "Cut";
    public static final String COPY_ACTION = "Copy";
    public static final String PASTE_ACTION = "Paste";
    public static final String DELETE_ACTION = "Delete";
    public static final KeyStroke PASTE_ACCEL = KeyStroke.getKeyStroke(86, 2);
    public static final KeyStroke COPY_ACCEL = KeyStroke.getKeyStroke(67, 2);
    public static final KeyStroke CUT_ACCEL = KeyStroke.getKeyStroke(88, 2);
    public static final KeyStroke DELETE_ACCEL = KeyStroke.getKeyStroke(127, 0);
    private static final int ROW_UP = -1;
    private static final int ROW_DOWN = 1;
    public static final int CAN_SORT_NONE = 1;
    public static final int CAN_SORT_ASCENDING = 2;
    public static final int CAN_SORT_DESCENDING = 4;
    public static final int CAN_SORT_ALL = 7;
    public static final int CAN_ADD_ROW = 8;
    public static final int SHOW_ROW_HEADERS = 16;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    public static final int NONE = 0;
    private static DataFlavor GUITABLE_DATA_FLAVOR = new DataFlavor(TableObjectSelection.class, "guiTable Object Selection");
    private RemoveRowCmd d_removeRowCmd;
    private InsertRowCmd d_insertRowCmd;
    private MoveRowUpCmd d_moveRowUpCmd;
    private MoveRowDownCmd d_moveRowDownCmd;
    private EnableSortCmd d_enableSortCmd;
    private CutCmd d_cutCmd;
    private CopyCmd d_copyCmd;
    private PasteCmd d_pasteCmd;
    private DeleteCmd d_deleteCmd;
    private TableModel d_baseModel;
    private SortMod d_sortMod = new SortMod();
    private HashMap<TableColumn, guiTableClipboard> d_clipboards;
    private guiTableClipboard d_defaultClipboard;
    private TableModelValidator d_validator;
    private boolean d_canAddRow;
    private boolean d_showRowHeaders;
    private JTable d_rowHeader;
    private boolean d_canResize;
    private Object[] d_tempRowValues;
    private boolean d_addRowModified;
    private int d_sortOptions;
    private int d_lastSortColumn;
    private boolean d_delaySort;
    private int d_rowLimit = Integer.MAX_VALUE;
    private boolean d_popup;
    private boolean d_nullValuesAllowed = true;
    private boolean d_isModified;
    private Set<Integer> d_uneditableCols = new HashSet<Integer>();
    public static final String COL_SEPARATOR = "\t";
    public static final String ROW_SEPARATOR = "\n";

    public guiTable() {
        this((TableModel)new guiDefaultTableModel(), 6);
    }

    public guiTable(TableModel tableModel, int n) {
        super(tableModel);
        this.getTableHeader().setReorderingAllowed(false);
        this.setColumnSelectionAllowed(true);
        boolean bl = this.d_canAddRow = (n & 8) > 0;
        if (this.d_canAddRow && !this.d_canResize) {
            throw new IllegalArgumentException("model must implement ResizableTableModel if canAddRow==true");
        }
        if (this.d_canAddRow) {
            this.getTableHeader().setReorderingAllowed(false);
        }
        this.d_rowHeader = new guiRowHeader(this);
        this.d_showRowHeaders = (n & 0x10) > 0;
        this.d_sortOptions = n & 7;
        if (this.d_sortOptions > 0) {
            this.getTableHeader().addMouseListener(new SortListener(this));
        }
        this.addMouseListener(new ContextMenuListener(this));
        this.d_clipboards = new HashMap();
        this.d_defaultClipboard = new DefaultTableClipboard();
        this.d_validator = null;
        this.allocateTempRowValues();
        this.d_popup = true;
        this.setDefaultEditor(Double.class, new guiDoubleEditor());
        this.setDefaultRenderer(Double.class, new guiDoubleRenderer());
        this.setDefaultRenderer(UnitDouble.class, new UnitDoubleRenderer());
        this.d_removeRowCmd = new RemoveRowCmd();
        this.d_insertRowCmd = new InsertRowCmd();
        this.d_moveRowUpCmd = new MoveRowUpCmd();
        this.d_moveRowDownCmd = new MoveRowDownCmd();
        this.d_enableSortCmd = new EnableSortCmd();
        this.d_cutCmd = new CutCmd();
        this.d_copyCmd = new CopyCmd();
        this.d_pasteCmd = new PasteCmd();
        this.d_deleteCmd = new DeleteCmd();
        this.setSortOrder(this.getNextAllowedSortOption(true));
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        inputMap.put((KeyStroke)this.getPasteCommand().getValue("AcceleratorKey"), PASTE_ACTION);
        actionMap.put(PASTE_ACTION, this.getPasteCommand());
        inputMap.put((KeyStroke)this.getCopyCommand().getValue("AcceleratorKey"), COPY_ACTION);
        actionMap.put(COPY_ACTION, this.getCopyCommand());
        inputMap.put((KeyStroke)this.getCutCommand().getValue("AcceleratorKey"), CUT_ACTION);
        actionMap.put(CUT_ACTION, this.getCutCommand());
        inputMap.put((KeyStroke)this.getDeleteCommand().getValue("AcceleratorKey"), DELETE_ACTION);
        actionMap.put(DELETE_ACTION, this.getDeleteCommand());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateColumnHeaders();
    }

    public void setNullValuesAllowed(boolean bl) {
        this.d_nullValuesAllowed = bl;
    }

    public boolean getNullValuesAllowed() {
        return this.d_nullValuesAllowed;
    }

    private void allocateTempRowValues() {
        this.d_tempRowValues = this.allocateRow();
        this.d_addRowModified = false;
    }

    private Object[] allocateRow() {
        int n = this.getColumnModel().getColumnCount();
        return new Object[n];
    }

    public int autoSizeColumns() {
        return this.autoSizeColumns(true, this.getPreferredScrollableViewportSize().height);
    }

    public int autoSizeColumns(int n) {
        return this.autoSizeColumns(true, n);
    }

    public int autoSizeColumns(boolean bl) {
        return this.autoSizeColumns(true, this.getPreferredScrollableViewportSize().height);
    }

    public int autoSizeColumns(boolean bl, int n) {
        JLabel jLabel = new JLabel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            Object object = tableColumn.getHeaderValue();
            int n2 = 0;
            if (tableCellRenderer != null) {
                Component component = tableCellRenderer.getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
                n2 = component.getPreferredSize().width;
            } else if (object instanceof String) {
                jLabel.setText((String)object);
                n2 = jLabel.getPreferredSize().width + 20;
            }
            if (bl) {
                for (int j = 0; j < this.getRowCount(); ++j) {
                    Component component;
                    Object object2;
                    Object object3 = this.getValueAt(j, i);
                    TableCellRenderer tableCellRenderer2 = this.getCellRenderer(j, i);
                    if (tableCellRenderer2 != null && (object2 = tableCellRenderer2.getTableCellRendererComponent(this, object3, false, false, j, i)) != null) {
                        n2 = Math.max(n2, ((Component)object2).getPreferredSize().width + 20);
                    }
                    if ((object2 = this.getCellEditor(j, i)) == null || (component = object2.getTableCellEditorComponent(this, object3, false, j, i)) == null) continue;
                    n2 = Math.max(n2, component.getPreferredSize().width + 20);
                }
            }
            tableColumn.setPreferredWidth(n2);
        }
        this.setPreferredScrollableViewportSize(new Dimension(this.getPreferredSize().width, n));
        return this.getPreferredSize().width;
    }

    public Object[] getRowData(int n) {
        if (this.isAddRow(n)) {
            return this.d_tempRowValues;
        }
        if (n < 0 || n >= this.getRowCount()) {
            return null;
        }
        Object[] objectArray = new Object[this.getColumnCount()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.getValueAt(n, i);
        }
        return objectArray;
    }

    public boolean isAddRow(int n) {
        int n2 = super.getRowCount();
        return this.d_canAddRow && n == n2 && ((ResizableTableModel)this.d_baseModel).getMaxRows() > n2 && n < this.d_rowLimit;
    }

    public void setRowLimit(int n) {
        this.d_rowLimit = n;
    }

    @Override
    public void setModel(TableModel tableModel) {
        if (this.d_sortMod == null) {
            this.d_sortMod = new SortMod();
        }
        this.d_baseModel = tableModel;
        this.d_canResize = this.d_baseModel instanceof ResizableTableModel;
        this.resort();
        super.setModel(this.d_baseModel);
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container container;
        super.configureEnclosingScrollPane();
        if (!this.d_showRowHeaders) {
            return;
        }
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setRowHeaderView(this.getRowHeader());
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.d_rowHeader != null) {
            this.d_rowHeader.setEnabled(bl);
        }
        if (this.getTableHeader() != null) {
            this.getTableHeader().setEnabled(bl);
        }
        super.setEnabled(bl);
    }

    @Override
    public Color getBackground() {
        if (this.isEnabled()) {
            return super.getBackground();
        }
        Container container = this.getParent();
        return container != null ? container.getBackground() : null;
    }

    @Override
    public void setRowHeight(int n, int n2) {
        super.setRowHeight(n, n2);
        if (this.d_rowHeader != null) {
            this.d_rowHeader.setRowHeight(n, n2);
        }
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.d_rowHeader != null) {
            this.d_rowHeader.setRowHeight(n);
        }
    }

    @Override
    public void setRowMargin(int n) {
        super.setRowMargin(n);
        if (this.d_rowHeader != null) {
            this.d_rowHeader.setRowMargin(n);
        }
    }

    @Override
    public JPopupMenu getContextMenu(MouseEvent mouseEvent) {
        if (!this.isEnabled() || !this.d_popup) {
            return null;
        }
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n >= 0 && n2 >= 0 && !this.isCellSelected(n, n2)) {
            this.setRowSelectionInterval(n, n);
            this.setColumnSelectionInterval(n2, n2);
        }
        ArrayList<Command> arrayList = new ArrayList<Command>();
        arrayList.add(this.d_cutCmd);
        arrayList.add(this.d_copyCmd);
        arrayList.add(this.d_pasteCmd);
        if (this.canAddRow()) {
            arrayList.add(this.d_insertRowCmd);
            arrayList.add(this.d_removeRowCmd);
            arrayList.add(this.d_moveRowUpCmd);
            arrayList.add(this.d_moveRowDownCmd);
        }
        return ContextMenu.menuFromCommands(arrayList.toArray(new Command[arrayList.size()]));
    }

    public void setAllowPopup(boolean bl) {
        this.d_popup = bl;
    }

    public boolean canAddRow() {
        return this.d_canAddRow;
    }

    public Component getRowHeader() {
        return this.d_rowHeader;
    }

    @Override
    public int getRowCount() {
        int n = super.getRowCount();
        if (this.isAddRow(n)) {
            ++n;
        }
        return n;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.isAddRow(n)) {
            return this.d_tempRowValues[n2];
        }
        return super.getValueAt(n, n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if ("".equals(object)) {
            object = null;
        }
        if (this.isAddRow(n)) {
            this.d_tempRowValues[n2] = object;
            this.d_addRowModified = object != null;
            this.repaint(this.getCellRect(n, n2, true));
        } else {
            super.setValueAt(object, n, n2);
        }
    }

    @Override
    public int convertColumnIndexToModel(int n) {
        if (n >= this.getColumnModel().getColumnCount() && this.d_canResize) {
            return n;
        }
        return super.convertColumnIndexToModel(n);
    }

    public RemoveRowCmd getRemoveRowCommand() {
        return this.d_removeRowCmd;
    }

    public InsertRowCmd getInsertRowCommand() {
        return this.d_insertRowCmd;
    }

    public MoveRowUpCmd getMoveRowUpCommand() {
        return this.d_moveRowUpCmd;
    }

    public MoveRowDownCmd getMoveRowDownCommand() {
        return this.d_moveRowDownCmd;
    }

    public EnableSortCmd getEnableSortCommand() {
        return this.d_enableSortCmd;
    }

    private Object[][] convertToObjArr2(int[][] nArray) {
        if (nArray == null || nArray.length == 0) {
            return new Integer[0][0];
        }
        if (nArray[0] == null) {
            Object[][] objectArray = new Integer[nArray.length][0];
            return objectArray;
        }
        Object[][] objectArray = new Integer[nArray.length][nArray[0].length];
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < objectArray[0].length; ++j) {
                objectArray[i][j] = new Integer(nArray[i][j]);
            }
        }
        return objectArray;
    }

    private Object[][] convertToObjArr2(double[][] dArray) {
        if (dArray == null || dArray.length == 0) {
            return new Double[0][0];
        }
        if (dArray[0] == null) {
            Object[][] objectArray = new Double[dArray.length][0];
            return objectArray;
        }
        Object[][] objectArray = new Double[dArray.length][dArray[0].length];
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < objectArray[0].length; ++j) {
                objectArray[i][j] = new Double(dArray[i][j]);
            }
        }
        return objectArray;
    }

    public static double[][] transpose(double[][] dArray) {
        if (dArray == null || dArray[0] == null) {
            return dArray;
        }
        double[][] dArray2 = new double[dArray[0].length][dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                dArray2[j][i] = dArray[i][j];
            }
        }
        return dArray2;
    }

    protected void lockSort() {
        this.d_delaySort = true;
    }

    protected void freeSort() {
        this.d_delaySort = false;
    }

    public void moveRows(int n) {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        int n2 = nArray.length - 1;
        Object[][] objectArrayArray = new Object[nArray.length][];
        Arrays.sort(nArray);
        if (n == -1 && nArray[0] == 0 || n == 1 && (nArray[n2] == this.getRowCount() - 1 || this.isAddRow(nArray[n2] + 1))) {
            return;
        }
        if (this.d_canResize) {
            int n3;
            ResizableTableModel resizableTableModel = (ResizableTableModel)this.d_baseModel;
            if (this.isAddRow(nArray[n2])) {
                --n2;
            }
            for (n3 = n2; n3 >= 0; --n3) {
                objectArrayArray[n3] = this.getRowData(nArray[n3]);
                resizableTableModel.removeRow(nArray[n3]);
            }
            for (n3 = 0; n3 <= n2; ++n3) {
                resizableTableModel.insertRow(nArray[n3] + n, objectArrayArray[n3]);
            }
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            int n4 = listSelectionModel.getSelectionMode();
            if (n4 == 0) {
                this.setRowSelectionInterval(nArray[0] + n, nArray[0] + n);
            } else if (n4 == 1) {
                this.setRowSelectionInterval(nArray[0] + n, nArray[n2] + n);
            } else if (n4 == 2) {
                for (int i = 0; i <= n2; ++i) {
                    listSelectionModel.addSelectionInterval(nArray[i] + n, nArray[i] + n);
                }
            }
        } else {
            throw new RuntimeException("It should be possible to move rows on a non-resizable guiTable, but that option is not currently implemented.");
        }
    }

    public guiTableClipboard getClipboard(int n) {
        assert (n >= 0 && n < this.getColumnCount());
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        guiTableClipboard guiTableClipboard2 = this.d_clipboards.get(tableColumn);
        if (guiTableClipboard2 == null) {
            return this.d_defaultClipboard;
        }
        return guiTableClipboard2;
    }

    public void setClipboard(Class clazz, guiTableClipboard guiTableClipboard2) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnClass(i).equals(clazz)) continue;
            this.setClipboard(i, guiTableClipboard2);
        }
    }

    public void setClipboard(int n, guiTableClipboard guiTableClipboard2) {
        assert (n >= 0 && n < this.getColumnCount());
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        this.d_clipboards.put(tableColumn, guiTableClipboard2);
    }

    public <T> void setColumnOptions(int n, T ... TArray) {
        this.setColumnOptions(n, (Collection<T>)Arrays.asList(TArray));
    }

    public <T> void setColumnOptions(int n, Collection<T> collection) {
        ComboBoxTableCell<T> comboBoxTableCell = new ComboBoxTableCell<T>(collection);
        this.setClipboard(n, (guiTableClipboard)new LimitedTableClipboard(collection));
        this.getColumnModel().getColumn(n).setCellRenderer(comboBoxTableCell);
        this.getColumnModel().getColumn(n).setCellEditor(comboBoxTableCell);
    }

    protected static TableObjectSelection getClipboardContents(Transferable transferable) {
        TableObjectSelection tableObjectSelection = null;
        try {
            tableObjectSelection = (TableObjectSelection)transferable.getTransferData(GUITABLE_DATA_FLAVOR);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                tableObjectSelection = guiTable.parsePastedString(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException2) {
                unsupportedFlavorException2.printStackTrace();
            }
        }
        return tableObjectSelection;
    }

    private static TableObjectSelection parsePastedString(String string) {
        TableObjectSelection tableObjectSelection = new TableObjectSelection();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ROW_SEPARATOR, true);
        String string2 = "";
        String string3 = "";
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.equals(ROW_SEPARATOR)) {
                if (string2.equals(ROW_SEPARATOR)) {
                    ++n;
                } else {
                    guiTable.parsePastedRowString(tableObjectSelection, string2, n);
                }
                ++n;
            }
            string2 = string3;
        }
        if (!string2.equals(ROW_SEPARATOR)) {
            guiTable.parsePastedRowString(tableObjectSelection, string2, n);
        }
        return tableObjectSelection;
    }

    private static void parsePastedRowString(TableObjectSelection tableObjectSelection, String string, int n) {
        int n2 = 0;
        String string2 = "";
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, COL_SEPARATOR, true);
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.equals(COL_SEPARATOR)) {
                if (string2.equals(COL_SEPARATOR)) {
                    tableObjectSelection.setObject(n, n2, (Serializable)((Object)""));
                } else {
                    tableObjectSelection.setObject(n, n2, (Serializable)((Object)string2));
                }
                ++n2;
            }
            string2 = string3;
        }
        if (!string2.equals(COL_SEPARATOR)) {
            tableObjectSelection.setObject(n, n2, (Serializable)((Object)string2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean copy() {
        void var4_6;
        int n;
        int n2;
        int n32;
        int[] nArray = this.getSelectedColumns();
        int[] nArray2 = this.getSelectedRows();
        if (nArray.length == 0 || nArray2.length == 0) {
            return false;
        }
        Arrays.sort(nArray2);
        Arrays.sort(nArray);
        TableObjectSelection tableObjectSelection = new TableObjectSelection();
        for (int n32 : nArray2) {
            int[] nArray3 = nArray;
            n2 = nArray3.length;
            for (n = 0; n < n2; ++n) {
                int n4 = nArray3[n];
                Object object = this.getValueAt(n32, n4);
                if (!(object instanceof Serializable) && object != null) continue;
                tableObjectSelection.setObject(n32, n4, (Serializable)object);
            }
        }
        String string = "";
        int n5 = nArray2[0];
        int n6 = nArray2[nArray2.length - 1];
        n32 = nArray[0];
        int n7 = nArray[nArray.length - 1];
        for (n2 = n5; n2 <= n6; ++n2) {
            void var4_7;
            for (n = n32; n <= n7; ++n) {
                void var4_9;
                Object object = this.getValueAt(n2, n);
                if (object != null) {
                    String string2 = (String)var4_7 + object;
                }
                String string3 = (String)var4_9 + COL_SEPARATOR;
            }
            String string4 = (String)var4_7 + ROW_SEPARATOR;
        }
        ObjectSelection objectSelection = new ObjectSelection(tableObjectSelection, (String)var4_6, GUITABLE_DATA_FLAVOR);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(objectSelection, objectSelection);
        return true;
    }

    public boolean cut() {
        this.copy();
        this.delete();
        return true;
    }

    public void paste() {
        Object object2;
        int n;
        int n2 = this.getSelectedRow();
        int n3 = this.getSelectedColumn();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        this.lockSort();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        TableObjectSelection tableObjectSelection = guiTable.getClipboardContents(clipboard.getContents(this));
        if (tableObjectSelection == null) {
            return;
        }
        Set<Integer> set = tableObjectSelection.getAvailableRows();
        if (set.isEmpty()) {
            return;
        }
        Vector<Integer[]> vector = new Vector<Integer[]>();
        int n4 = set.iterator().next();
        int n5 = tableObjectSelection.getObjectsForRow(n4).keySet().iterator().next();
        Object[] objectArray = set.iterator();
        while (objectArray.hasNext()) {
            n = objectArray.next();
            object2 = tableObjectSelection.getObjectsForRow(n);
            Iterator<Integer> object3 = object2.keySet().iterator();
            for (Serializable serializable : object2.values()) {
                boolean bl;
                int n6 = object3.next();
                int n7 = n - n4 + n2;
                int n8 = n6 - n5 + n3;
                if (n7 >= this.getRowCount() || n8 >= this.getColumnCount() || !this.isCellEditable(n7, n8) || (bl = this.pasteData(serializable, n7, n8))) continue;
                vector.add(new Integer[]{n7, n8});
            }
        }
        this.revalidate();
        this.repaint();
        if (!vector.isEmpty()) {
            objectArray = new String[vector.size()];
            n = 0;
            for (Integer[] integerArray : vector) {
                assert (integerArray.length == 2);
                objectArray[n++] = this.formatCellName(integerArray[0], integerArray[1]);
            }
            Arrays.sort(objectArray);
            object2 = Intl.intl("The copied values could not be pasted into the following cells:") + ROW_SEPARATOR;
            for (Object object : objectArray) {
                object2 = (String)object2 + (String)object + ROW_SEPARATOR;
            }
            Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
            JOptionPane.showMessageDialog(window, object2, Intl.intl("Paste Warning"), 2);
        }
        this.freeSort();
        this.resort();
    }

    private String formatCellName(int n, int n2) {
        Object object = this.getColumnModel().getColumn(n2).getHeaderValue();
        if (object != null) {
            return String.format(Intl.intl("Column \"%s\", Row %d"), object, n + 1);
        }
        return String.format(Intl.intl("Column %1$d, Row %2$d"), n2 + 1, n + 1);
    }

    private boolean pasteData(Object object, int n, int n2) {
        if (this.d_canResize || this.isInTable(n, n2)) {
            guiTableClipboard guiTableClipboard2 = this.getClipboard(n2);
            return guiTableClipboard2.pasteObject(this, object, n, n2);
        }
        return true;
    }

    private boolean isInTable(int n, int n2) {
        return n >= 0 && n < this.getRowCount() && n2 >= 0 && n2 < this.getColumnCount();
    }

    public DeleteCmd getDeleteCommand() {
        return this.d_deleteCmd;
    }

    public CutCmd getCutCommand() {
        return this.d_cutCmd;
    }

    public CopyCmd getCopyCommand() {
        return this.d_copyCmd;
    }

    public PasteCmd getPasteCommand() {
        return this.d_pasteCmd;
    }

    @Override
    public int convertRowIndexToView(int n) {
        return this.d_sortMod.getSortIndex(n);
    }

    @Override
    public int convertRowIndexToModel(int n) {
        return this.d_sortMod.getModelIndex(n);
    }

    public int getSortOrder() {
        return this.d_sortMod.getSortOrder();
    }

    public void setSortOrder(int n) {
        if (this.isSortOrderAllowed(n)) {
            this.resortDir(n);
            this.updateColumnHeaders();
        }
    }

    public boolean isSortOrderAllowed(int n) {
        return n == 0 && (this.d_sortOptions & 1) > 0 || n == 1 && (this.d_sortOptions & 2) > 0 || n == 2 && (this.d_sortOptions & 4) > 0;
    }

    public void setSortColumn(int n) {
        this.d_lastSortColumn = this.d_sortMod.getSortColumn();
        this.resortCol(n);
        this.updateColumnHeaders();
    }

    public int getSortColumn() {
        return this.d_sortMod.getSortColumn();
    }

    private void updateColumnHeaders() {
        TableColumn tableColumn;
        if (this.d_sortOptions == 0) {
            return;
        }
        if (this.getTableHeader() == null) {
            System.out.println("Warning: null TableHeader, can't update.");
            return;
        }
        int n = this.convertColumnIndexToView(this.d_lastSortColumn);
        int n2 = this.convertColumnIndexToView(this.d_sortMod.getSortColumn());
        if (n >= 0) {
            tableColumn = this.getColumnModel().getColumn(n);
            tableColumn.setHeaderRenderer(null);
        }
        if (n2 >= 0) {
            tableColumn = this.getColumnModel().getColumn(n2);
            if (this.d_sortMod.getSortOrder() == 1) {
                tableColumn.setHeaderRenderer(HEADER_UP);
            } else if (this.d_sortMod.getSortOrder() == 2) {
                tableColumn.setHeaderRenderer(HEADER_DOWN);
            }
        }
        this.getTableHeader().repaint();
    }

    private void resort() {
        this.resort(this.d_baseModel, this.d_sortMod.getSortColumn(), this.d_sortMod.getSortOrder());
    }

    private void resortCol(int n) {
        this.resort(this.d_baseModel, n, this.d_sortMod.getSortOrder());
    }

    private void resortDir(int n) {
        this.resort(this.d_baseModel, this.d_sortMod.getSortColumn(), n);
    }

    private void resort(TableModel tableModel, int n, int n2) {
        int n3;
        int n4 = this.getSelectedRow();
        n4 = this.convertRowIndexToModel(n4);
        this.d_sortMod.sort(tableModel, n, n2);
        if (n4 >= 0 && (n3 = this.convertRowIndexToView(n4)) >= 0 && this.getRowCount() > 0) {
            super.setRowSelectionInterval(n3, n3);
        }
    }

    private int getNextAllowedSortOption(boolean bl) {
        int n = this.getSortOrder();
        if (bl) {
            n = 0;
        }
        int n2 = this.getNextSortOption(n);
        while (n2 != n) {
            if (this.isSortOrderAllowed(n2)) {
                return n2;
            }
            n2 = this.getNextSortOption(n2);
        }
        return 0;
    }

    private int getNextSortOption(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 2;
        }
        return 0;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if ((keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 9 && this.getSelectedColumn() == this.getColumnCount() - 1) && !keyStroke.isOnKeyRelease() && this.isAddRow(this.getSelectedRow()) && (this.addRowIsModified() || this.isEditing())) {
            this.validateData(false, true);
            return true;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public void delete() {
        this.requestFocus();
        this.lockSort();
        boolean bl = false;
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        for (int n : nArray) {
            for (int n2 : nArray2) {
                Object object;
                if (!this.isCellEditable(n, n2) || (object = this.getValueAt(n, n2)) == null) continue;
                bl = true;
                this.setValueAt(null, n, n2);
            }
        }
        this.freeSort();
        if (bl) {
            this.resort();
        }
    }

    public void setColumnEditable(int n, boolean bl) {
        if (!bl) {
            this.d_uneditableCols.add(n);
        } else {
            this.d_uneditableCols.remove(n);
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return super.isCellEditable(n, n2) && !this.d_uneditableCols.contains(n2);
    }

    private boolean addRowIsModified() {
        return this.d_addRowModified;
    }

    public void removeSelectedRows() {
        if (!this.d_canResize) {
            return;
        }
        ResizableTableModel resizableTableModel = (ResizableTableModel)this.d_baseModel;
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        Arrays.sort(nArray);
        int n = nArray.length - 1;
        int n2 = this.getEditingRow();
        if (this.isAddRow(nArray[n])) {
            this.allocateTempRowValues();
            this.repaint();
            --n;
        }
        int[] nArray2 = new int[n + 1];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = this.convertRowIndexToModel(nArray[i]);
            if (nArray[i] != n2) continue;
            this.getCellEditor().cancelCellEditing();
        }
        Arrays.sort(nArray2);
        while (n >= 0) {
            resizableTableModel.removeRow(nArray2[n]);
            --n;
        }
        if (nArray[0] >= 0 && nArray[0] < this.getRowCount()) {
            this.setRowSelectionInterval(nArray[0], nArray[0]);
        }
        this.resort();
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        Object object;
        if (bl2) {
            object = this.getCellEditor();
            if (object != null && !object.stopCellEditing()) {
                int n = this.getEditingRow();
                int n2 = this.getEditingColumn();
                String string = String.format(Intl.intl("Invalid value in cell, [%s]."), this.formatCellName(n, n2));
                this.flagInvalidCell(n, n2, bl, bl2, string);
                return false;
            }
            if (this.d_canAddRow && this.d_canResize && this.d_addRowModified) {
                ResizableTableModel resizableTableModel = (ResizableTableModel)this.d_baseModel;
                resizableTableModel.insertRow(this.getRowCount() - 1, this.d_tempRowValues);
                this.allocateTempRowValues();
                this.setRowSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
                if (this.getSelectedColumn() == this.getColumnCount() - 1) {
                    this.setColumnSelectionInterval(0, 0);
                }
            }
        }
        if (!this.d_nullValuesAllowed) {
            object = this.getModel();
            for (int i = 0; i < object.getRowCount(); ++i) {
                for (int j = 0; j < object.getColumnCount(); ++j) {
                    if (object.getValueAt(i, j) != null) continue;
                    String string = String.format(Intl.intl("Error: Blank value in cell, [%s]."), this.formatCellName(i, j));
                    this.flagInvalidCell(i, j, bl, bl2, string);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (tableModelEvent.getFirstRow() == -1) {
            this.allocateTempRowValues();
        }
        if (!this.d_delaySort) {
            this.resort();
        }
        if (this.d_rowHeader != null) {
            this.d_rowHeader.revalidate();
            this.d_rowHeader.repaint();
        }
        this.d_isModified = true;
    }

    @Override
    public void setRowSelectionInterval(int n, int n2) {
        super.setRowSelectionInterval(n, n2);
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).selectAll();
        }
        component.setEnabled(this.isEnabled());
        return component;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        component.setEnabled(this.isEnabled());
        return component;
    }

    @Override
    public boolean getSurrendersFocusOnKeystroke() {
        return this.getEditorComponent() instanceof JComboBox;
    }

    public void flagInvalidCell(int n, int n2, boolean bl, boolean bl2, String string) {
        Serializable serializable;
        if (bl2) {
            serializable = guiUtil.findTab(this);
            if (serializable != null) {
                ((JTabbedPane)serializable.v1).setSelectedComponent((Component)serializable.v2);
            }
            this.requestFocus();
            if (this.getRowSelectionAllowed()) {
                if (n == -1) {
                    this.setRowSelectionInterval(0, this.getRowCount() - 1);
                } else {
                    this.setRowSelectionInterval(n, n);
                }
            }
            if (this.getColumnSelectionAllowed()) {
                if (n2 == -1) {
                    this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
                } else {
                    this.setColumnSelectionInterval(n2, n2);
                }
            }
        }
        if (bl) {
            serializable = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
            guiDialog.showInvalidEntryMessage(serializable, string);
        }
    }

    @Override
    public boolean isModified() {
        return this.d_isModified;
    }

    @Override
    public void setModified(boolean bl) {
        this.d_isModified = bl;
    }

    class SortListener
    extends MouseAdapter {
        private guiTable d_guiTable;

        public SortListener(guiTable guiTable3) {
            this.d_guiTable = guiTable3;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.d_guiTable.isEnabled()) {
                return;
            }
            if (!guiTable.this.validateData(true, true)) {
                return;
            }
            int n = this.d_guiTable.getSortColumn();
            int n2 = this.d_guiTable.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
            int n3 = this.d_guiTable.convertColumnIndexToModel(n2);
            this.d_guiTable.setSortColumn(n3);
            this.d_guiTable.setSortOrder(this.d_guiTable.getNextAllowedSortOption(n3 != n));
            this.d_guiTable.repaint();
        }
    }

    public static class UnitDoubleEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 5575889810490058966L;
        private final Unit d_unit;
        private UnitDouble d_ud;

        public UnitDoubleEditor(Unit unit) {
            super(new JTextField());
            this.d_unit = unit;
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }

        public Unit getDefaultUnit() {
            return this.d_unit;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            UnitDouble unitDouble = (UnitDouble)object;
            String string = unitDouble == null ? "" : Global.format(unitDouble);
            JComponent jComponent = (JComponent)super.getTableCellEditorComponent(jTable, string, bl, n, n2);
            jComponent.setBorder(new LineBorder(Color.black));
            jComponent.setToolTipText(null);
            return jComponent;
        }

        @Override
        public boolean stopCellEditing() {
            JComponent jComponent = (JComponent)this.getComponent();
            jComponent.setBorder(new LineBorder(Color.black));
            jComponent.setToolTipText(null);
            String string = (String)super.getCellEditorValue();
            if ("".equals(string)) {
                this.d_ud = null;
                return super.stopCellEditing();
            }
            try {
                this.d_ud = Global.parseUnitDouble(string, this.d_unit);
            }
            catch (ParseException parseException) {
                jComponent.setBorder(new LineBorder(Color.red));
                jComponent.setToolTipText(parseException.getLocalizedMessage());
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return this.d_ud;
        }
    }

    public static class UnitDoubleRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -5563971923114670659L;

        public UnitDoubleRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        protected void setValue(Object object) {
            String string = object == null ? "" : Global.format((UnitDouble)object);
            this.setText(string);
        }
    }

    public static class guiDoubleRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -5153516322727616533L;

        public guiDoubleRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public void setValue(Object object) {
            this.setText(object == null ? "" : Global.format((Double)object));
        }
    }

    public static class guiDoubleEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 5777673938968734296L;
        Object value;

        public guiDoubleEditor() {
            super(new JTextField());
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }

        @Override
        public boolean stopCellEditing() {
            String string = (String)super.getCellEditorValue();
            if ("".equals(string)) {
                this.value = null;
                return super.stopCellEditing();
            }
            try {
                this.value = new Double(Global.parseDouble(string));
            }
            catch (ParseException parseException) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JTextField jTextField = (JTextField)this.getComponent();
            this.value = object;
            jTextField.setText(object != null ? Global.format((Double)object) : "");
            jTextField.setBorder(new LineBorder(Color.black));
            return jTextField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }

    protected static class TableObjectSelection
    implements Serializable {
        static final long serialVersionUID = 1L;
        private final TreeMap<Integer, Map<Integer, Serializable>> d_rowMap = new TreeMap();

        public void setObject(int n, int n2, Serializable serializable) {
            Map<Integer, Serializable> map = this.d_rowMap.get(n);
            if (map == null) {
                map = new TreeMap<Integer, Serializable>();
                this.d_rowMap.put(n, map);
            }
            map.put(n2, serializable);
        }

        public Set<Integer> getAvailableRows() {
            return this.d_rowMap.keySet();
        }

        public Map<Integer, Serializable> getObjectsForRow(int n) {
            return this.d_rowMap.get(n);
        }
    }

    private class PasteCmd
    extends TableCommand {
        public PasteCmd() {
            super(Intl.intl(guiTable.PASTE_ACTION), "graphics/Paste16.gif", PASTE_ACCEL);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            guiTable.this.paste();
        }
    }

    private class CopyCmd
    extends TableCommand {
        public CopyCmd() {
            super(Intl.intl(guiTable.COPY_ACTION), "graphics/Copy16.gif", COPY_ACCEL);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            guiTable.this.copy();
        }
    }

    private class CutCmd
    extends TableCommand {
        public CutCmd() {
            super(Intl.intl(guiTable.CUT_ACTION), "graphics/Cut16.gif", CUT_ACCEL);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            guiTable.this.cut();
        }
    }

    private class DeleteCmd
    extends TableCommand {
        public DeleteCmd() {
            super(Intl.intl(guiTable.CUT_ACTION), "graphics/RowDelete16.gif", DELETE_ACCEL);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            guiTable.this.delete();
        }
    }

    private abstract class TableCommand
    extends CommandAction {
        public TableCommand(String string, String string2, KeyStroke keyStroke) {
            super(string, string2);
            this.putValue("AcceleratorKey", keyStroke);
        }

        @Override
        public boolean isEnabled() {
            return guiTable.this.isEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            guiTable.this.requestFocus();
        }
    }

    class EnableSortCmd
    extends AbstractCommand {
        private boolean d_sortAllowed;

        public EnableSortCmd() {
            super("Sort", null);
            this.d_sortAllowed = (guiTable.this.d_sortOptions & 6) > 0;
        }

        @Override
        public boolean isSelected() {
            return this.d_sortAllowed;
        }

        @Override
        public boolean isEnabled() {
            return guiTable.this.isEnabled();
        }

        @Override
        public void execute() {
            if (!this.isEnabled()) {
                return;
            }
            guiTable.this.requestFocus();
            if (this.d_sortAllowed) {
                this.d_sortAllowed = false;
                guiTable.this.d_sortOptions = 1;
                guiTable.this.setSortOrder(0);
            } else {
                this.d_sortAllowed = true;
                guiTable.this.d_sortOptions = guiTable.this.d_sortOptions | 7;
            }
            guiTable.this.repaint();
        }
    }

    class MoveRowDownCmd
    extends AbstractCommand {
        public MoveRowDownCmd() {
            super(Intl.intl("Move Down"), "graphics/Down16.gif");
        }

        @Override
        public boolean isEnabled() {
            return guiTable.this.isEnabled() && guiTable.this.getSortOrder() == 0;
        }

        @Override
        public void execute() {
            if (!this.isEnabled()) {
                return;
            }
            guiTable.this.requestFocus();
            guiTable.this.moveRows(1);
        }
    }

    class MoveRowUpCmd
    extends AbstractCommand {
        public MoveRowUpCmd() {
            super(Intl.intl("Move Up"), "graphics/Up16.gif");
        }

        @Override
        public boolean isEnabled() {
            return guiTable.this.isEnabled() && guiTable.this.getSortOrder() == 0;
        }

        @Override
        public void execute() {
            if (!this.isEnabled()) {
                return;
            }
            guiTable.this.requestFocus();
            guiTable.this.moveRows(-1);
        }
    }

    class RemoveRowCmd
    extends AbstractCommand {
        public RemoveRowCmd() {
            super(Intl.intl("Remove Row"), "graphics/RowDelete16.gif");
        }

        @Override
        public boolean isEnabled() {
            return guiTable.this.isEnabled();
        }

        @Override
        public void execute() {
            if (!this.isEnabled()) {
                return;
            }
            guiTable.this.requestFocus();
            guiTable.this.removeSelectedRows();
        }
    }

    class InsertRowCmd
    extends AbstractCommand {
        public InsertRowCmd() {
            super(Intl.intl("Insert Row"), "graphics/RowInsertBefore16.gif");
        }

        @Override
        public boolean isEnabled() {
            return guiTable.this.isEnabled() && guiTable.this.getSortOrder() == 0;
        }

        @Override
        public void execute() {
            if (!this.isEnabled()) {
                return;
            }
            guiTable.this.requestFocus();
            if (!guiTable.this.d_canResize) {
                return;
            }
            int n = guiTable.this.getSelectedRow();
            if (guiTable.this.isAddRow(n) && (guiTable.this.d_addRowModified || guiTable.this.isEditing())) {
                guiTable.this.validateData(false, true);
                n = guiTable.this.getRowCount() - 1;
            } else {
                TableCellEditor tableCellEditor;
                if (n < 0) {
                    n = guiTable.this.getRowCount() == 0 ? 0 : guiTable.this.getRowCount() - 1;
                }
                if ((tableCellEditor = guiTable.this.getCellEditor()) != null) {
                    guiTable.this.getCellEditor().stopCellEditing();
                }
                ((ResizableTableModel)guiTable.this.d_baseModel).insertRow(n, guiTable.this.allocateRow());
                guiTable.this.setRowSelectionInterval(n, n);
            }
        }
    }
}

