/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.table;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.table.TableModel;
import junit.framework.TestCase;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.DefaultTableClipboard;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.guiDefaultTableModel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.guiTable;

public class DefaultTableClipboardTest
extends TestCase {
    private guiTable d_table;
    private ClipboardOwner d_owner = new TestOwner();
    private DefaultTableClipboard d_cb;
    private String d_littleData;
    private String d_wideData;
    private String d_tallData;
    private String d_bigData;

    public DefaultTableClipboardTest(String string) {
        super(string);
    }

    public void setUp() {
        this.d_cb = new DefaultTableClipboard();
        this.d_table = new guiTable((TableModel)new guiDefaultTableModel(6, 2), 8);
        this.d_table.setValueAt(new Integer(2), 0, 0);
        this.d_table.setValueAt(new Integer(3), 1, 0);
        this.d_table.setValueAt(new Integer(4), 2, 0);
        this.d_table.setValueAt(new Integer(5), 3, 0);
        this.d_table.setValueAt(new Integer(1), 4, 0);
        this.d_table.setValueAt(new Integer(8), 5, 0);
        this.d_table.setValueAt(new Integer(10), 0, 1);
        this.d_table.setValueAt(new Integer(9), 1, 1);
        this.d_table.setValueAt(new Integer(8), 2, 1);
        this.d_table.setValueAt(new Integer(7), 3, 1);
        this.d_table.setValueAt(new Integer(6), 4, 1);
        this.d_table.setValueAt(new Integer(5), 5, 1);
        String string = "\t";
        String string2 = "\n";
        this.d_littleData = "Hi" + string + "There" + string2 + "Line" + string + "Two" + string2;
        this.d_wideData = "This" + string + "data" + string + "is" + string2 + "three" + string + "columns" + string + "wide." + string2;
        this.d_tallData = "There" + string + "are" + string2 + "three" + string + "lines" + string2 + "of" + string + "data." + string2;
        this.d_bigData = "Here" + string + "is" + string + "a" + string + "dataset" + string + "that" + string + "is" + string + "large" + string2 + "and" + string + "irregular." + string + "" + string + "There's" + string2 + "an" + string2 + "empty" + string2 + "cell" + string + "" + string + "<-empty" + string2 + "before" + string2 + "this" + string + "sentence." + string + "Make" + string + "sure" + string + "it's" + string2 + "empty." + string2;
    }

    public void testCut() {
    }

    public void testCopy() {
    }

    public void testPasteLittle() {
        this.putOnClipboard(this.d_littleData);
        this.d_table.setRowSelectionInterval(2, 2);
        this.d_table.paste();
        Integer n = (Integer)this.d_table.getValueAt(1, 0);
        DefaultTableClipboardTest.assertEquals((int)3, (int)n);
        n = (Integer)this.d_table.getValueAt(1, 1);
        DefaultTableClipboardTest.assertEquals((int)9, (int)n);
        DefaultTableClipboardTest.assertEquals((Object)"Hi", (Object)this.d_table.getValueAt(2, 0));
        DefaultTableClipboardTest.assertEquals((Object)"There", (Object)this.d_table.getValueAt(2, 1));
        DefaultTableClipboardTest.assertEquals((Object)"Line", (Object)this.d_table.getValueAt(3, 0));
        DefaultTableClipboardTest.assertEquals((Object)"Two", (Object)this.d_table.getValueAt(3, 1));
        n = (Integer)this.d_table.getValueAt(4, 0);
        DefaultTableClipboardTest.assertEquals((int)1, (int)n);
        n = (Integer)this.d_table.getValueAt(4, 1);
        DefaultTableClipboardTest.assertEquals((int)6, (int)n);
    }

    public void testPasteWide() {
        this.putOnClipboard(this.d_wideData);
        this.d_table.setRowSelectionInterval(2, 2);
        this.d_table.paste();
        DefaultTableClipboardTest.assertEquals((int)3, (int)this.d_table.getColumnCount());
        Integer n = (Integer)this.d_table.getValueAt(1, 0);
        DefaultTableClipboardTest.assertEquals((int)3, (int)n);
        n = (Integer)this.d_table.getValueAt(1, 1);
        DefaultTableClipboardTest.assertEquals((int)9, (int)n);
        DefaultTableClipboardTest.assertEquals((Object)"This", (Object)this.d_table.getValueAt(2, 0));
        DefaultTableClipboardTest.assertEquals((Object)"data", (Object)this.d_table.getValueAt(2, 1));
        DefaultTableClipboardTest.assertEquals((Object)"is", (Object)this.d_table.getValueAt(2, 2));
        DefaultTableClipboardTest.assertEquals((Object)"three", (Object)this.d_table.getValueAt(3, 0));
        DefaultTableClipboardTest.assertEquals((Object)"columns", (Object)this.d_table.getValueAt(3, 1));
        DefaultTableClipboardTest.assertEquals((Object)"wide.", (Object)this.d_table.getValueAt(3, 2));
        n = (Integer)this.d_table.getValueAt(4, 0);
        DefaultTableClipboardTest.assertEquals((int)1, (int)n);
        n = (Integer)this.d_table.getValueAt(4, 1);
        DefaultTableClipboardTest.assertEquals((int)6, (int)n);
        DefaultTableClipboardTest.assertEquals(null, (Object)this.d_table.getValueAt(4, 2));
    }

    public void testPasteTall() {
        this.putOnClipboard(this.d_tallData);
        this.d_table.setRowSelectionInterval(4, 4);
        this.d_table.paste();
        DefaultTableClipboardTest.assertEquals((int)7, (int)this.d_table.getRowCount());
        Integer n = (Integer)this.d_table.getValueAt(3, 0);
        DefaultTableClipboardTest.assertEquals((int)5, (int)n);
        n = (Integer)this.d_table.getValueAt(3, 1);
        DefaultTableClipboardTest.assertEquals((int)7, (int)n);
        DefaultTableClipboardTest.assertEquals((Object)"There", (Object)this.d_table.getValueAt(4, 0));
        DefaultTableClipboardTest.assertEquals((Object)"are", (Object)this.d_table.getValueAt(4, 1));
        DefaultTableClipboardTest.assertEquals((Object)"three", (Object)this.d_table.getValueAt(5, 0));
        DefaultTableClipboardTest.assertEquals((Object)"lines", (Object)this.d_table.getValueAt(5, 1));
        DefaultTableClipboardTest.assertEquals((Object)"of", (Object)this.d_table.getValueAt(6, 0));
        DefaultTableClipboardTest.assertEquals((Object)"data.", (Object)this.d_table.getValueAt(6, 1));
    }

    public void testPasteBig() {
        this.putOnClipboard(this.d_bigData);
        this.d_table.setRowSelectionInterval(0, 0);
        this.d_table.paste();
        DefaultTableClipboardTest.assertEquals((int)8, (int)this.d_table.getRowCount());
        DefaultTableClipboardTest.assertEquals((int)7, (int)this.d_table.getColumnCount());
        DefaultTableClipboardTest.assertEquals((Object)"Here", (Object)this.d_table.getValueAt(0, 0));
        DefaultTableClipboardTest.assertEquals((Object)"large", (Object)this.d_table.getValueAt(0, 6));
        DefaultTableClipboardTest.assertEquals((Object)"irregular.", (Object)this.d_table.getValueAt(1, 1));
        DefaultTableClipboardTest.assertEquals((Object)"empty", (Object)this.d_table.getValueAt(3, 0));
        DefaultTableClipboardTest.assertEquals((Object)"", (Object)this.d_table.getValueAt(4, 1));
        DefaultTableClipboardTest.assertEquals((Object)"empty.", (Object)this.d_table.getValueAt(7, 0));
    }

    private void putOnClipboard(String string) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), this.d_owner);
    }

    class TestOwner
    implements ClipboardOwner {
        TestOwner() {
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }
}

