/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import pyrosim.legacy_2012_1.thunderheadeng.gui.SelectableAction;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class guiUtil {
    private static final HashMap<ImageKey, WeakReference<Image>> s_images = new HashMap();

    public static Image loadImage(String string) {
        return guiUtil.loadImage(string, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadImage(String string, int n) {
        HashMap<ImageKey, WeakReference<Image>> hashMap = s_images;
        synchronized (hashMap) {
            Image image;
            ImageKey imageKey = new ImageKey(string, n);
            WeakReference<Image> weakReference = s_images.get(imageKey);
            Image image2 = image = weakReference != null ? (Image)weakReference.get() : null;
            if (image == null) {
                image = guiUtil.forceImageLoad(string, n);
                s_images.put(imageKey, new WeakReference<Image>(image));
            }
            return image;
        }
    }

    private static Image forceImageLoad(String string, int n) {
        try {
            BufferedImage bufferedImage;
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            URL uRL = guiUtil.class.getResource(string);
            Image image = bufferedImage = ImageIO.read(uRL);
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            if (n2 > n || n3 > n) {
                float f = (float)n2 / (float)n3;
                if (n2 > n3) {
                    n2 = n;
                    n3 = (int)((float)n2 / f);
                } else {
                    n3 = n;
                    n2 = (int)((float)n3 * f);
                }
                image = bufferedImage.getScaledInstance(n2, n3, 1);
            }
            return image;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ImageIcon loadTeciIcon(String string) {
        return guiUtil.loadTeciIcon(string, Integer.MAX_VALUE);
    }

    public static ImageIcon loadTeciIcon(String string, int n) {
        return guiUtil.loadIcon("pyrosim.legacy_2012_1.thunderheadeng/gui/graphics/" + string, n);
    }

    public static ImageIcon loadIcon(String string) {
        return guiUtil.loadIcon(string, Integer.MAX_VALUE);
    }

    public static ImageIcon loadIcon(String string, int n) {
        Image image = guiUtil.loadImage(string, n);
        return image == null ? null : new ImageIcon(image);
    }

    public static Cursor createTeciCursor(String string, String string2, int n, int n2) {
        return guiUtil.createCursor(string, "pyrosim.legacy_2012_1.thunderheadeng/gui/graphics/" + string2, n, n2);
    }

    public static Cursor createCursor(String string, String string2, int n, int n2) {
        Image image = guiUtil.loadImage(string2);
        try {
            return Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(n, n2), string);
        }
        catch (Exception exception) {
            return Cursor.getDefaultCursor();
        }
    }

    public static void addSelectableMenuItem(JMenu jMenu, SelectableAction selectableAction) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(selectableAction);
        jCheckBoxMenuItem.addItemListener(selectableAction);
        jMenu.add(jCheckBoxMenuItem);
    }

    public static JToggleButton createToolbarToggleButton(SelectableAction selectableAction) {
        JToggleButton jToggleButton = new JToggleButton(selectableAction);
        guiUtil.initToolbarBtn(selectableAction, jToggleButton);
        jToggleButton.addItemListener(selectableAction);
        return jToggleButton;
    }

    public static JButton createToolbarButton(Action action) {
        JButton jButton = new JButton(action);
        guiUtil.initToolbarBtn(action, jButton);
        return jButton;
    }

    private static void initToolbarBtn(Action action, AbstractButton abstractButton) {
        Icon icon = (Icon)action.getValue("SmallIcon");
        if (icon != null) {
            abstractButton.setText("");
            String string = (String)action.getValue("ShortDescription");
            if (string == null || string.trim().equals("")) {
                abstractButton.setToolTipText((String)action.getValue("Name"));
            }
        }
    }

    public static void addMEMenuItems(JMenu jMenu, SelectableAction ... selectableActionArray) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < selectableActionArray.length; ++i) {
            SelectableAction selectableAction = selectableActionArray[i];
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(selectableAction);
            jRadioButtonMenuItem.addItemListener(selectableAction);
            jMenu.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
        }
    }

    public static void addMEToolbarItems(JToolBar jToolBar, SelectableAction ... selectableActionArray) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < selectableActionArray.length; ++i) {
            JToggleButton jToggleButton = guiUtil.createToolbarToggleButton(selectableActionArray[i]);
            jToolBar.add(jToggleButton);
            buttonGroup.add(jToggleButton);
        }
    }

    public static Icon createDisabledIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics graphics = bufferedImage.getGraphics();
        icon.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return new ImageIcon(GrayFilter.createDisabledImage(bufferedImage));
    }

    public static Pair<JTabbedPane, Component> findTab(Component component) {
        if (component == null) {
            return null;
        }
        Container container = component.getParent();
        while (container != null && !(container instanceof JTabbedPane)) {
            component = container;
            container = component.getParent();
        }
        return container instanceof JTabbedPane ? new Pair<JTabbedPane, Component>((JTabbedPane)container, component) : null;
    }

    private static class ImageKey {
        public final String resourceName;
        public final int maxDimension;

        public ImageKey(String string, int n) {
            this.resourceName = string;
            this.maxDimension = n;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof ImageKey && ((ImageKey)object).resourceName.equals(this.resourceName) && ((ImageKey)object).maxDimension == this.maxDimension;
        }

        public int hashCode() {
            return 0xFAA344D ^ this.resourceName.hashCode() ^ this.maxDimension;
        }
    }
}

