/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDialog;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiLabel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiPanel;

public class guiProgressMonitor {
    private guiDialog d_dialog;
    private guiLabel d_noteLbl;
    private guiLabel d_messageLbl;
    private JProgressBar d_progBar;
    private boolean d_indeterminate;
    private volatile boolean d_cancelled;
    private volatile boolean d_showingProgress;
    private Component d_parent;
    private String d_title;
    private String d_note;
    private String d_message;

    public guiProgressMonitor(Component component, String string, String string2, int n, int n2) {
        assert (component instanceof JFrame || component instanceof JDialog);
        this.d_cancelled = false;
        this.d_showingProgress = false;
        this.d_parent = component;
        this.d_title = Intl.intl("Progress");
        this.d_note = string2;
        this.d_message = string;
        this.d_progBar = new JProgressBar();
        this.setMinimum(n);
        this.setMaximum(n2);
        this.d_noteLbl = new guiLabel(this.d_note);
        this.d_messageLbl = new guiLabel(this.d_message);
        this.d_dialog = new guiDialog(null);
    }

    public void setIndeterminate(boolean bl) {
        this.d_progBar.setIndeterminate(bl);
        this.checkProgress();
    }

    public boolean isIndeterminate() {
        return this.d_progBar.isIndeterminate();
    }

    public void show() {
        this.d_showingProgress = true;
        this.d_dialog = this.createDialog();
        new Thread(){

            @Override
            public void run() {
                int n = guiProgressMonitor.this.d_dialog.doModal();
                if (n != 1) {
                    guiProgressMonitor.this.d_cancelled = true;
                    guiProgressMonitor.this.d_showingProgress = false;
                }
            }
        }.start();
    }

    public void close() {
        this.close(16);
    }

    private void close(int n) {
        this.d_showingProgress = false;
        this.d_dialog.endModal(n);
    }

    public int getMaximum() {
        return this.d_progBar.getMaximum();
    }

    public void setMaximum(int n) {
        this.d_progBar.setMaximum(n);
    }

    public int getMinimum() {
        return this.d_progBar.getMinimum();
    }

    public void setMinimum(int n) {
        this.d_progBar.setMinimum(n);
    }

    public String getMessage() {
        return this.d_message;
    }

    public void setMessage(String string) {
        this.d_message = string;
        this.d_messageLbl.setText(string);
        this.d_dialog.repaint();
    }

    public String getNote() {
        return this.d_note;
    }

    public void setNote(String string) {
        this.d_note = string;
        this.d_noteLbl.setText(string);
        this.d_dialog.repaint();
    }

    public boolean isCancelled() {
        return this.d_cancelled;
    }

    public void setProgress(int n) {
        this.d_progBar.setValue(n);
        this.checkProgress();
    }

    private guiDialog createDialog() {
        guiDialog guiDialog2 = this.d_parent instanceof JFrame ? new guiDialog((Window)((JFrame)this.d_parent), this.d_title, 8) : new guiDialog((Window)((JDialog)this.d_parent), this.d_title, 8);
        Icon icon = UIManager.getIcon("OptionPane.informationIcon");
        guiLabel guiLabel2 = new guiLabel(icon);
        this.d_progBar.setPreferredSize(new Dimension(200, this.d_progBar.getPreferredSize().height));
        guiPanel guiPanel2 = new guiPanel(new BorderLayout());
        guiPanel2.add((Component)guiLabel2, "North");
        guiPanel guiPanel3 = new guiPanel(new GridBagLayout());
        GridBagUtil.add(guiPanel3, this.d_messageLbl, 0, 0, 1, 1, 0, 6, 6, 0, 0, 1.0, 1.0, 17);
        GridBagUtil.add(guiPanel3, this.d_noteLbl, 0, 1, 1, 1, 0, 6, 6, 0, 0, 1.0, 1.0, 17);
        GridBagUtil.add(guiPanel3, this.d_progBar, 0, 2, 1, 1, 0, 6, 0, 0, 2, 1.0, 1.0, 17);
        guiPanel guiPanel4 = guiDialog2.getDialogPane();
        guiPanel4.setLayout(new BorderLayout());
        guiPanel4.add((Component)guiPanel2, "West");
        guiPanel4.add((Component)guiPanel3, "Center");
        guiDialog2.setResizable(true);
        return guiDialog2;
    }

    private void checkProgress() {
        if (!this.d_showingProgress) {
            if (this.d_progBar.getValue() < this.d_progBar.getMaximum() || this.d_progBar.isIndeterminate()) {
                this.show();
            }
        } else if (this.d_progBar.getValue() >= this.d_progBar.getMaximum() && !this.d_progBar.isIndeterminate()) {
            this.close(1);
        }
    }
}

