/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Modifiable;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Validateable;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObservable;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObserver;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class guiFormattedFld<T>
extends JFormattedTextField
implements Modifiable,
Validateable {
    private static final long serialVersionUID = 5328550564285487691L;
    private static final String CUT = "cut-to-clipboard";
    private static final String COPY = "copy-to-clipboard";
    private static final String PASTE = "paste-from-clipboard";
    private static final String DELETE_SELECTION = "delete-selection";
    private static final String SELECT_ALL = "select-all";
    private boolean d_selectAll;
    private boolean d_modified;
    private boolean d_selectAllOnFocusEnabled;
    private PropertyChangeListener d_highlightOnErrorListener;
    private Map<Object, Action> d_rightClickMenuActions;
    private JPopupMenu d_rightClickMenu;

    public guiFormattedFld(Format format) {
        this(format, null);
    }

    public guiFormattedFld(Format format, T t) {
        this(new Formatter(format), t);
    }

    public guiFormattedFld(Formatter<T> formatter) {
        this(formatter, null);
    }

    public guiFormattedFld(Formatter<T> formatter, T t) {
        this((JFormattedTextField.AbstractFormatterFactory)new DefaultFormatterFactory(formatter), t);
    }

    public guiFormattedFld(JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory, T t) {
        super(new FormatterFactory(abstractFormatterFactory, false));
        this.init(t);
    }

    private void init(T t) {
        this.d_selectAll = true;
        this.d_selectAllOnFocusEnabled = true;
        this.d_highlightOnErrorListener = null;
        Dimension dimension = this.getPreferredSize();
        this.setPreferredSize(new Dimension(90, dimension.height));
        this.setHorizontalAlignment(2);
        this.setInputVerifier(new Verifier(true));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                guiFormattedFld.this.d_selectAll = false;
                this.maybeShowPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                Component component = mouseEvent.getComponent();
                if (component.isEnabled() && mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = guiFormattedFld.this.getRightClickMenu();
                    jPopupMenu.setLocation(mouseEvent.getPoint());
                    jPopupMenu.show(component, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!theUtil.equal(propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue())) {
                    guiFormattedFld.this.d_modified = true;
                }
            }
        });
        this.setHighlightOnError(true);
        this.setFocusLostBehavior(0);
        this.setValue(t);
        this.setModified(false);
    }

    public void setHighlightOnError(boolean bl) {
        if (bl && this.d_highlightOnErrorListener == null) {
            this.d_highlightOnErrorListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    guiFormattedFld.this.updateValidState();
                }
            };
            this.addPropertyChangeListener("editValid", this.d_highlightOnErrorListener);
        } else if (!bl && this.d_highlightOnErrorListener != null) {
            this.removePropertyChangeListener("editValid", this.d_highlightOnErrorListener);
            this.d_highlightOnErrorListener = null;
        }
        this.updateValidState();
    }

    public boolean getHightlightOnError() {
        return this.d_highlightOnErrorListener != null;
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.isTemporary()) {
            return;
        }
        if (focusEvent.getID() == 1005) {
            this.d_selectAll = true;
        } else if (this.d_selectAllOnFocusEnabled && this.d_selectAll) {
            this.selectAll();
        }
    }

    protected void updateValidState() {
        if (!this.getHightlightOnError() || this.isEditValid()) {
            Border border = this.getBorder();
            if (border instanceof InvalidBorder) {
                InvalidBorder invalidBorder = (InvalidBorder)border;
                Border border2 = invalidBorder.getInsideBorder();
                this.setBorder(border2);
            }
        } else {
            Border border = this.getBorder();
            if (!(border instanceof InvalidBorder)) {
                this.setBorder(new InvalidBorder(border));
            }
        }
    }

    public void setSelectAllOnFocus(boolean bl) {
        this.d_selectAllOnFocusEnabled = bl;
    }

    public boolean getSelectAllOnFocus() {
        return this.d_selectAllOnFocusEnabled;
    }

    public void setYieldFocusOnError(boolean bl) {
        ((Verifier)this.getInputVerifier()).setYieldFocusOnErrorEnabled(bl);
    }

    public boolean getYieldFocusOnError() {
        return ((Verifier)this.getInputVerifier()).isYieldFocusOnErrorEnabled();
    }

    public void setCommitOnValidEdit(boolean bl) {
        FormatterFactory formatterFactory = this.getFormatterFactory();
        if (formatterFactory != null) {
            formatterFactory.setCommitOnValidEdit(this, bl);
        }
    }

    public boolean getCommitOnValidEdit() {
        return this.getFormatterFactory().d_commitOnValidEdit;
    }

    public void addValueChangeListener(PropertyChangeListener propertyChangeListener) {
        this.addPropertyChangeListener("value", propertyChangeListener);
    }

    private JPopupMenu getRightClickMenu() {
        Object object;
        if (this.d_rightClickMenu == null) {
            this.d_rightClickMenu = new JPopupMenu();
            this.d_rightClickMenuActions = new HashMap<Object, Action>();
            object = new DefaultEditorKit.CutAction();
            object.putValue("Name", Intl.intl("Cut"));
            DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
            copyAction.putValue("Name", Intl.intl("Copy"));
            DefaultEditorKit.PasteAction pasteAction = new DefaultEditorKit.PasteAction();
            pasteAction.putValue("Name", Intl.intl("Paste"));
            AbstractAction abstractAction = new AbstractAction(Intl.intl("Delete")){
                private static final long serialVersionUID = -1145220452963451362L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    guiFormattedFld.this.replaceSelection("");
                }
            };
            AbstractAction abstractAction2 = new AbstractAction(Intl.intl("Select All")){
                private static final long serialVersionUID = 7156361685066902730L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    guiFormattedFld.this.selectAll();
                }
            };
            this.d_rightClickMenuActions.put(CUT, (Action)object);
            this.d_rightClickMenuActions.put(COPY, copyAction);
            this.d_rightClickMenuActions.put(PASTE, pasteAction);
            this.d_rightClickMenuActions.put(DELETE_SELECTION, abstractAction);
            this.d_rightClickMenuActions.put(SELECT_ALL, abstractAction2);
            this.d_rightClickMenu.add((Action)object);
            this.d_rightClickMenu.add(copyAction);
            this.d_rightClickMenu.add(pasteAction);
            this.d_rightClickMenu.add(abstractAction);
            this.d_rightClickMenu.addSeparator();
            this.d_rightClickMenu.add(abstractAction2);
        }
        object = this.getSelectedText();
        boolean bl = this.isEnabled() && this.isEditable();
        this.d_rightClickMenuActions.get(CUT).setEnabled(object != null && bl);
        this.d_rightClickMenuActions.get(COPY).setEnabled(object != null);
        this.d_rightClickMenuActions.get(PASTE).setEnabled(bl);
        this.d_rightClickMenuActions.get(DELETE_SELECTION).setEnabled(object != null && bl);
        this.d_rightClickMenuActions.get(SELECT_ALL).setEnabled(!this.getText().isEmpty() && (object == null || ((String)object).length() < this.getText().length()));
        return this.d_rightClickMenu;
    }

    public T getValue() {
        return (T)super.getValue();
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean bl) {
        this.d_modified = bl;
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!this.shouldValidate()) {
            return true;
        }
        try {
            InputVerifier inputVerifier = this.getInputVerifier();
            ((Verifier)inputVerifier).check(this);
            if (bl2) {
                this.commitEdit();
            }
        }
        catch (ParseException parseException) {
            if (bl) {
                this.showMessageBox(parseException.getLocalizedMessage(), true);
            }
            if (bl2) {
                this.requestFocusHack();
            }
            return false;
        }
        return true;
    }

    protected boolean shouldValidate() {
        return this.isEnabled();
    }

    protected void showMessageBox(String string) {
        this.showMessageBox(string, false);
    }

    protected void showMessageBox(String string, boolean bl) {
        int n = this.getFocusLostBehavior();
        FocusListener[] focusListenerArray = null;
        if (bl) {
            this.setFocusLostBehavior(3);
            for (FocusListener focusListener : focusListenerArray = this.getFocusListeners()) {
                this.removeFocusListener(focusListener);
            }
        }
        FocusListener[] focusListenerArray2 = (FocusListener[])SwingUtilities.getAncestorOfClass(Window.class, this);
        JOptionPane.showMessageDialog((Component)focusListenerArray2, string, Intl.intl("Invalid Entry"), 2);
        if (bl) {
            for (FocusListener focusListener : focusListenerArray) {
                this.addFocusListener(focusListener);
            }
            this.setFocusLostBehavior(n);
        }
    }

    protected void requestFocusHack() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                guiFormattedFld.this.requestFocus();
            }
        });
    }

    @Override
    public final void setInputVerifier(InputVerifier inputVerifier) {
        if (!(inputVerifier instanceof Verifier)) {
            return;
        }
        this.setInputVerifier((Verifier)inputVerifier);
    }

    public void setInputVerifier(Verifier<T> verifier) {
        super.setInputVerifier(verifier);
    }

    @Override
    public Verifier<T> getInputVerifier() {
        return (Verifier)super.getInputVerifier();
    }

    @Override
    public JFormattedTextField.AbstractFormatter getFormatter() {
        return super.getFormatter();
    }

    @Override
    public void setFormatterFactory(JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory) {
        if (!(abstractFormatterFactory instanceof FormatterFactory)) {
            FormatterFactory formatterFactory = this.getFormatterFactory();
            boolean bl = formatterFactory != null ? formatterFactory.d_commitOnValidEdit : false;
            abstractFormatterFactory = new FormatterFactory(abstractFormatterFactory, bl);
        }
        super.setFormatterFactory(abstractFormatterFactory);
    }

    @Override
    public FormatterFactory getFormatterFactory() {
        return (FormatterFactory)super.getFormatterFactory();
    }

    public static class Verifier<T>
    extends InputVerifier {
        private boolean d_yieldFocusOnError;

        public Verifier(boolean bl) {
            this.d_yieldFocusOnError = bl;
        }

        public boolean isYieldFocusOnErrorEnabled() {
            return this.d_yieldFocusOnError;
        }

        public void setYieldFocusOnErrorEnabled(boolean bl) {
            this.d_yieldFocusOnError = bl;
        }

        @Override
        public boolean verify(JComponent jComponent) {
            try {
                this.check(jComponent);
            }
            catch (ParseException parseException) {
                return false;
            }
            return true;
        }

        @Override
        public boolean shouldYieldFocus(JComponent jComponent) {
            return this.isYieldFocusOnErrorEnabled() || super.shouldYieldFocus(jComponent);
        }

        public void check(JComponent jComponent) throws ParseException {
            assert (jComponent instanceof guiFormattedFld);
            guiFormattedFld guiFormattedFld2 = (guiFormattedFld)jComponent;
            JFormattedTextField.AbstractFormatter abstractFormatter = guiFormattedFld2.getFormatter();
            if (abstractFormatter != null) {
                String string = guiFormattedFld2.getText();
                abstractFormatter.stringToValue(string);
            }
        }
    }

    public static class Formatter<T>
    extends InternationalFormatter
    implements IObserver {
        private static final long serialVersionUID = 6485261405788018218L;
        private IObjectFilter<T> d_filter;
        private boolean d_nullAllowed;

        public Formatter(Format format) {
            this(format, null, false);
        }

        public Formatter(Format format, IObjectFilter<T> iObjectFilter) {
            this(format, iObjectFilter, false);
        }

        public Formatter(Format format, boolean bl) {
            this(format, null, bl);
        }

        public Formatter(Format format, IObjectFilter<T> iObjectFilter, boolean bl) {
            super(format);
            if (format instanceof IObservable) {
                ((IObservable)((Object)format)).addObserver(this, true);
            }
            this.d_filter = iObjectFilter;
            this.d_nullAllowed = bl;
        }

        @Override
        public void update(IObservable iObservable, Object object) {
            JFormattedTextField jFormattedTextField = this.getFormattedTextField();
            if (jFormattedTextField != null && !jFormattedTextField.isFocusOwner()) {
                this.uninstall();
                this.install(jFormattedTextField);
            }
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            Object object = super.stringToValue(string);
            if (object == null && !this.isNullAllowed()) {
                throw new ParseException(Intl.intl("Empty values are not allowed."), 0);
            }
            if (this.d_filter != null && this.d_filter.shouldFilter(object)) {
                throw new ParseException(this.d_filter.toString(), 0);
            }
            return object;
        }

        public IObjectFilter<T> getFilter() {
            return this.d_filter;
        }

        public void setFilter(IObjectFilter<T> iObjectFilter) {
            this.d_filter = iObjectFilter;
        }

        public boolean isNullAllowed() {
            return this.d_nullAllowed;
        }

        public void setNullAllowed(boolean bl) {
            this.d_nullAllowed = bl;
        }
    }

    public static class FormatterFactory
    extends JFormattedTextField.AbstractFormatterFactory {
        private boolean d_commitOnValidEdit;
        private JFormattedTextField.AbstractFormatterFactory d_baseFactory;

        public FormatterFactory(JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory, boolean bl) {
            this.d_baseFactory = abstractFormatterFactory;
            this.d_commitOnValidEdit = bl;
        }

        @Override
        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
            JFormattedTextField.AbstractFormatter abstractFormatter = this.d_baseFactory.getFormatter(jFormattedTextField);
            this.updateFormatter(abstractFormatter);
            return abstractFormatter;
        }

        public void setCommitOnValidEdit(JFormattedTextField jFormattedTextField, boolean bl) {
            this.d_commitOnValidEdit = bl;
            this.updateFormatter(jFormattedTextField.getFormatter());
        }

        public void updateFormatter(JFormattedTextField.AbstractFormatter abstractFormatter) {
            if (abstractFormatter instanceof DefaultFormatter) {
                ((DefaultFormatter)abstractFormatter).setCommitsOnValidEdit(this.d_commitOnValidEdit);
            }
        }
    }

    protected static class InvalidBorder
    extends CompoundBorder {
        private static final long serialVersionUID = -6494216944048832137L;

        public InvalidBorder(Border border) {
            super(BorderFactory.createLineBorder(Color.RED), border);
        }
    }
}

