/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Modifiable;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Validateable;
import pyrosim.legacy_2012_1.thunderheadeng.util.IntVR;
import pyrosim.legacy_2012_1.thunderheadeng.util.ValueRange;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class guiComboBox<T>
extends JComboBox
implements Modifiable,
Validateable {
    private static final long serialVersionUID = 417191893483447922L;
    private ValueRange d_range = IntVR.unbounded();
    private boolean d_modified = false;

    public guiComboBox() {
        this.init(null);
    }

    public guiComboBox(T ... TArray) {
        super(TArray);
        this.init(null);
    }

    public guiComboBox(Vector<? extends T> vector) {
        super(vector);
        this.init(null);
    }

    public guiComboBox(Collection<? extends T> collection) {
        super(new Vector<T>(collection));
        this.init(null);
    }

    public guiComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.init(null);
    }

    private void init(ValueRange valueRange) {
        this.setControls();
    }

    public Vector<T> getAllItems() {
        Vector<T> vector = new Vector<T>(this.getModel().getSize());
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            vector.add(this.getItemAt(i));
        }
        return vector;
    }

    public void add(T t) {
        Vector<T> vector = this.getAllItems();
        if (!vector.contains(t)) {
            vector.add(t);
        }
        this.setItems(vector);
    }

    public boolean contains(T t) {
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            if (!theUtil.equal(t, this.getModel().getElementAt(i))) continue;
            return true;
        }
        return false;
    }

    public void setRange(ValueRange valueRange) {
        this.d_range = valueRange;
    }

    @Override
    protected void fireItemStateChanged(ItemEvent itemEvent) {
        this.d_modified = true;
        super.fireItemStateChanged(itemEvent);
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean bl) {
        this.d_modified = bl;
    }

    public void setItems(T ... TArray) {
        this.setModel(new DefaultComboBoxModel<T>(TArray));
    }

    public void setItems(Vector<? extends T> vector) {
        this.setModel(new DefaultComboBoxModel<T>(vector));
    }

    public void setItems(Collection<? extends T> collection) {
        if (collection instanceof Vector) {
            this.setItems((Vector)collection);
        } else {
            this.setItems(new Vector<T>(collection));
        }
    }

    public T getItemAt(int n) {
        return (T)super.getItemAt(n);
    }

    public T getSelectedItem() {
        return (T)super.getSelectedItem();
    }

    public Collection<T> getSelectedItems() {
        Object[] objectArray = super.getSelectedObjects();
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (Object object : objectArray) {
            arrayList.add(object);
        }
        return arrayList;
    }

    private void setControls() {
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width, 24);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!this.isEnabled() || !this.d_range.checksMax() && !this.d_range.checksMin()) {
            return true;
        }
        int n = 0;
        try {
            n = Integer.parseInt(this.getSelectedItem().toString());
        }
        catch (NumberFormatException numberFormatException) {
            if (bl) {
                String string = "The entry \"" + this.getSelectedItem().toString() + "\" is invalid.\n" + "Please enter " + this.d_range.describeRange() + ".";
                this.showMessageBox(string);
                this.requestFocusHack();
            }
            return false;
        }
        if (!this.d_range.checkValue(n)) {
            if (bl) {
                String string = "The entry \"" + this.getSelectedItem().toString() + "\" is invalid.\n" + "Please enter " + this.d_range.describeRange() + ".";
                this.showMessageBox(string);
                this.requestFocusHack();
            }
            return false;
        }
        return true;
    }

    public boolean validateData() {
        return this.validateData(true, true);
    }

    protected void showMessageBox(String string) {
        JOptionPane.showMessageDialog(null, string, "Invalid Entry", 2);
    }

    protected void requestFocusHack() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                guiComboBox.this.requestFocus();
            }
        });
    }
}

