/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.JColorChooser;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.ColorHistory;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.DoubleRGBChooser;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDialog;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDoubleField;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiLabel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiPanel;
import pyrosim.legacy_2012_1.thunderheadeng.util.ColorPool;
import pyrosim.legacy_2012_1.thunderheadeng.util.DoubleVR;

public class SimpleColorChooser
extends guiDialog {
    private static final long serialVersionUID = 324998146549309706L;
    private final guiDoubleField d_alphaFld;
    private final JColorChooser d_chooser;
    private static JColorChooser s_chooser;

    public SimpleColorChooser(Window window, String string) {
        this(window, string, true);
    }

    public SimpleColorChooser(Window window, String string, boolean bl) {
        super(window, string, 9);
        this.d_chooser = SimpleColorChooser.getChooser(bl);
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = this.d_chooser.getChooserPanels();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add("RGB", abstractColorChooserPanelArray[3]);
        jTabbedPane.add(Intl.intl("Palette"), abstractColorChooserPanelArray[0]);
        jTabbedPane.add(Intl.intl("Sliders"), abstractColorChooserPanelArray[2]);
        this.d_alphaFld = new guiDoubleField(1.0, DoubleVR.between(0.0, 1.0, true, true));
        guiPanel guiPanel2 = new guiPanel(new GridBagLayout());
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Alpha") + ":"), 0, 0, 1, 1, 0, 0, 0, 6, 0, 1.0, 1.0, 17);
        GridBagUtil.add(guiPanel2, this.d_alphaFld, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1.0, 1.0, 17);
        this.getDialogPane().setLayout(new GridBagLayout());
        int n = 0;
        GridBagUtil.add(this.getDialogPane(), guiPanel2, 0, ++n, 1, 1, 0, 6, 11, 0, 0, 1.0, 1.0, 17);
        GridBagUtil.add(this.getDialogPane(), jTabbedPane, 0, ++n, 2, 1, 0, 0, 11, 0);
        GridBagUtil.add(this.getDialogPane(), this.d_chooser.getPreviewPanel(), 0, ++n, 1, 1, 0, 0, 0, 0, 0, 1.0, 1.0, 10);
    }

    @Override
    public int doModal() {
        return super.doModal();
    }

    public Color getColor() {
        Color color = this.d_chooser.getColor();
        float[] fArray = new float[3];
        color.getRGBColorComponents(fArray);
        Color color2 = new Color(fArray[0], fArray[1], fArray[2], (float)((Double)this.d_alphaFld.getValue()).doubleValue());
        return ColorPool.get(color2);
    }

    public void setColor(Color color) {
        this.d_chooser.setColor(color);
        float[] fArray = new float[4];
        color.getComponents(fArray);
        this.d_alphaFld.setValue(fArray[3]);
    }

    private static JColorChooser getChooser(boolean bl) {
        if (!bl) {
            return SimpleColorChooser.createChooser();
        }
        if (s_chooser == null) {
            s_chooser = SimpleColorChooser.createChooser();
            s_chooser.getSelectionModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    SimpleColorChooser simpleColorChooser = (SimpleColorChooser)SwingUtilities.getAncestorOfClass(SimpleColorChooser.class, s_chooser);
                    Color color = simpleColorChooser != null ? simpleColorChooser.getColor() : s_chooser.getColor();
                    ColorHistory.add(color);
                }
            });
        }
        return s_chooser;
    }

    private static JColorChooser createChooser() {
        JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.addChooserPanel(new DoubleRGBChooser());
        return jColorChooser;
    }
}

