/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDoubleField;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiLabel;
import pyrosim.legacy_2012_1.thunderheadeng.util.ColorPool;
import pyrosim.legacy_2012_1.thunderheadeng.util.DoubleVR;

public class DoubleRGBChooser
extends AbstractColorChooserPanel {
    private static final long serialVersionUID = 6665713942823059278L;
    private guiDoubleField d_red;
    private guiDoubleField d_green;
    private guiDoubleField d_blue;
    private boolean d_pauseUpdate = false;

    @Override
    public void updateChooser() {
        if (!this.d_pauseUpdate) {
            Color color = this.getColorFromModel();
            float[] fArray = color.getRGBColorComponents(null);
            this.d_red.setValue(fArray[0]);
            this.d_green.setValue(fArray[1]);
            this.d_blue.setValue(fArray[2]);
        }
    }

    @Override
    protected void buildChooser() {
        this.setLayout(new GridBagLayout());
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Red") + ":");
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Green") + ":");
        guiLabel guiLabel4 = new guiLabel(Intl.intl("Blue") + ":");
        DoubleVR doubleVR = DoubleVR.between(0.0, 1.0, true, true);
        this.d_red = new guiDoubleField(doubleVR);
        this.d_green = new guiDoubleField(doubleVR);
        this.d_blue = new guiDoubleField(doubleVR);
        GridBagUtil.add(this, guiLabel2, 0, 0, 1, 1, 12, 12, 5, 11);
        GridBagUtil.add(this, guiLabel3, 0, 1, 1, 1, 0, 12, 5, 11);
        GridBagUtil.add(this, guiLabel4, 0, 2, 1, 1, 0, 12, 11, 11);
        GridBagUtil.add(this, this.d_red, 1, 0, 1, 1, 12, 0, 5, 11);
        GridBagUtil.add(this, this.d_green, 1, 1, 1, 1, 0, 0, 5, 11);
        GridBagUtil.add(this, this.d_blue, 1, 2, 1, 1, 0, 0, 11, 11);
        GridBagUtil.addGlue(this);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                guiDoubleField guiDoubleField2 = (guiDoubleField)keyEvent.getSource();
                if (guiDoubleField2.validateData(false, false)) {
                    DoubleRGBChooser.this.d_pauseUpdate = true;
                    Color color = new Color(DoubleRGBChooser.getValue(DoubleRGBChooser.this.d_red), DoubleRGBChooser.getValue(DoubleRGBChooser.this.d_green), DoubleRGBChooser.getValue(DoubleRGBChooser.this.d_blue));
                    color = ColorPool.get(color);
                    DoubleRGBChooser.this.getColorSelectionModel().setSelectedColor(color);
                    DoubleRGBChooser.this.d_pauseUpdate = false;
                }
            }
        };
        this.d_red.addKeyListener(keyAdapter);
        this.d_green.addKeyListener(keyAdapter);
        this.d_blue.addKeyListener(keyAdapter);
    }

    private static float getValue(guiDoubleField guiDoubleField2) {
        double d = (Double)guiDoubleField2.getValue();
        return (float)d;
    }

    @Override
    public String getDisplayName() {
        return "RGB";
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }
}

