/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ColorScheme
implements Cloneable {
    private String d_name;
    private Hashtable d_colors;
    public static final String SEPARATOR = ".";

    public ColorScheme(String string) {
        this.d_name = string;
        this.d_colors = new Hashtable();
    }

    public Object clone(String string) {
        try {
            ColorScheme colorScheme = (ColorScheme)super.clone();
            colorScheme.d_name = string;
            return colorScheme;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getName() {
        return this.d_name;
    }

    public String toString() {
        return "ColorScheme: " + this.getName() + " (" + this.d_colors.size() + " colors)";
    }

    public Color getColor(String string) {
        return (Color)this.d_colors.get(string);
    }

    public void setColor(String string, Color color) {
        this.d_colors.put(string, color);
    }

    public String[] getColorNames() {
        return this.d_colors.keySet().toArray(new String[this.d_colors.size()]);
    }

    public void load(Properties properties, String string) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            String string3 = string2.substring(string.length());
            try {
                Color color = Color.decode((String)properties.get(string2));
                this.d_colors.put(string3, color);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void store(Properties properties, String string) {
        Enumeration enumeration = this.d_colors.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            properties.setProperty(string + this.d_name + SEPARATOR + string2, this.encodeColor((Color)this.d_colors.get(string2)));
        }
    }

    private String encodeColor(Color color) {
        int n = (color.getRed() << 16) + (color.getGreen() << 8) + color.getBlue();
        return "0x" + Integer.toHexString(n);
    }
}

