/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.ColorChangedEvent;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.ColorChangedListener;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.ColorScheme;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;

public class ColorMgr {
    private Hashtable d_schemes = new Hashtable();
    private ColorScheme d_currScheme;
    private Set<ColorChangedListener> d_listeners = new IdentityHashSet<ColorChangedListener>();
    private String d_prefix = "Colors";
    private static final String DEFAULT_PREFIX = "Colors";
    private static final String CURR_SCHEME_KEY = "DefaultScheme";

    private void putScheme(ColorScheme colorScheme) {
        this.d_schemes.put(colorScheme.getName(), colorScheme);
    }

    public void addScheme(ColorScheme colorScheme) {
        this.putScheme(colorScheme);
    }

    public void removeScheme(String string) {
        this.d_schemes.remove(string);
        this.fireColorChangedEvent();
    }

    public void setCurrentColorScheme(String string) {
        ColorScheme colorScheme = (ColorScheme)this.d_schemes.get(string);
        if (colorScheme != null) {
            this.d_currScheme = colorScheme;
            this.fireColorChangedEvent();
        }
    }

    public void setCurrentColorScheme(ColorScheme colorScheme) {
        if (colorScheme != null) {
            this.putScheme(colorScheme);
            this.d_currScheme = colorScheme;
            this.fireColorChangedEvent();
        }
    }

    public ColorScheme getCurrentColorScheme() {
        return this.d_currScheme;
    }

    public String[] getAvailableSchemes() {
        String[] stringArray = new String[this.d_schemes.size()];
        Enumeration enumeration = this.d_schemes.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public Color getColor(String string) {
        ColorScheme colorScheme = this.getCurrentColorScheme();
        if (colorScheme == null) {
            return null;
        }
        return colorScheme.getColor(string);
    }

    public void setColor(String string, Color color) {
        ColorScheme colorScheme = this.getCurrentColorScheme();
        if (colorScheme != null) {
            colorScheme.setColor(string, color);
            this.fireColorChangedEvent();
        }
    }

    public void setPrefix(String string) {
        this.d_prefix = string;
    }

    public void addColorChangedListener(ColorChangedListener colorChangedListener) {
        this.d_listeners.add(colorChangedListener);
    }

    public void removeColorChangedListener(ColorChangedListener colorChangedListener) {
        this.d_listeners.remove(colorChangedListener);
    }

    public Collection<ColorChangedListener> getListeners() {
        return Collections.unmodifiableCollection(this.d_listeners);
    }

    protected void fireColorChangedEvent() {
        this.fireColorChangedEvent(new ColorChangedEvent());
    }

    protected void fireColorChangedEvent(ColorChangedEvent colorChangedEvent) {
        for (ColorChangedListener colorChangedListener : this.d_listeners) {
            colorChangedListener.colorChanged(colorChangedEvent);
        }
    }

    public void load(Properties properties) {
        ColorScheme colorScheme;
        String string;
        Enumeration<Object> enumeration = properties.keys();
        String string2 = this.d_prefix + ".";
        IdentityHashSet identityHashSet = new IdentityHashSet();
        while (enumeration.hasMoreElements()) {
            String string3;
            ColorScheme colorScheme2;
            int n;
            int n2;
            string = (String)enumeration.nextElement();
            if (!string.startsWith(string2) || (n2 = string.indexOf(".", (n = string2.length()) + 1)) < 0 || identityHashSet.contains(colorScheme2 = (ColorScheme)this.d_schemes.get(string3 = string.substring(n, n2)))) continue;
            ColorScheme colorScheme3 = colorScheme2 == null ? new ColorScheme(string3) : colorScheme2;
            colorScheme3.load(properties, string2 + string3 + ".");
            if (colorScheme3.getColorNames().length <= 0) continue;
            this.putScheme(colorScheme3);
            identityHashSet.add(colorScheme3);
            System.out.println("Added scheme: " + colorScheme3.toString());
        }
        string = properties.getProperty(this.d_prefix + "." + CURR_SCHEME_KEY);
        if (string != null && (colorScheme = (ColorScheme)this.d_schemes.get(string)) != null) {
            this.d_currScheme = colorScheme;
            this.fireColorChangedEvent();
        }
    }

    public void store(Properties properties) {
        Iterator iterator = this.d_schemes.values().iterator();
        while (iterator.hasNext()) {
            ((ColorScheme)iterator.next()).store(properties, this.d_prefix + ".");
        }
        if (this.d_currScheme != null) {
            properties.setProperty(this.d_prefix + "." + CURR_SCHEME_KEY, this.d_currScheme.getName());
        }
    }
}

