/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Observer;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Modifiable;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.SimpleColorChooser;
import pyrosim.legacy_2012_1.thunderheadeng.util.ColorPool;
import thunderheadeng.gui.Application;

public class ColorButton
extends JButton
implements Modifiable {
    private static final long serialVersionUID = -6531505849770221371L;
    private SimpleColorChooser d_chooser;
    private Color d_color = this.getBackground();
    private boolean d_modified = false;
    private final List d_observers = new LinkedList();

    public ColorButton() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorButton.this.editColor();
            }
        });
        this.setText("MMM");
    }

    public void editColor() {
        if (this.d_chooser == null) {
            this.d_chooser = new SimpleColorChooser((Window)Application.getApp().getActiveFrame(), Intl.intl("Color"));
        }
        this.d_chooser.setColor(this.d_color);
        if (this.d_chooser.doModal() == 1) {
            this.setColor(this.d_chooser.getColor());
            this.yell();
        }
    }

    public void setColor(Color color) {
        this.d_color = color;
        this.d_modified = true;
        this.repaint();
    }

    public Color getColor() {
        return this.d_color;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = this.getVisibleRect();
        super.paintComponent(graphics);
        int n = 6;
        int n2 = 5;
        rectangle.width -= 2 * n + 1;
        rectangle.height -= 2 * n2 + 1;
        Color color = this.d_color.getAlpha() == 255 ? this.d_color : ColorPool.get(new Color(this.d_color.getRed(), this.d_color.getGreen(), this.d_color.getBlue(), 255));
        graphics.setColor(color);
        graphics.fillRect(n, n2, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, rectangle.width, rectangle.height);
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean bl) {
        this.d_modified = bl;
    }

    public void yell() {
        for (Object e : this.d_observers) {
            ((Observer)e).update(null, null);
        }
    }

    public void addObserver(Observer observer) {
        this.d_observers.add(observer);
    }

    public void deleteObserver(Observer observer) {
        this.d_observers.remove(observer);
    }
}

