/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.MultiLineLabel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Utils;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDialog;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiFileChooser;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiPanel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.guiTable;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.guiTableEditor;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.guiTableUtil;
import pyrosim.legacy_2012_1.thunderheadeng.util.IWarning;
import pyrosim.legacy_2012_1.thunderheadeng.util.WarningReport;
import thunderheadeng.gui.Application;

public class WarningDlg<T extends IWarning>
extends guiDialog {
    private static final long serialVersionUID = 4781445495340909253L;
    private WarningReport<T> d_report;
    private T[] d_warnings;
    private guiTableEditor d_editor;
    private guiTable d_table;
    private JButton d_saveReportToFileButton;
    private JButton d_copyReportToClipBoardButton;

    public static <T extends IWarning> WarningDlg create(Component component, String string, String string2, WarningReport<T> warningReport) {
        if ((component = Utils.findParentWindow(component)) instanceof JDialog) {
            return new WarningDlg<T>((JDialog)component, string, string2, warningReport);
        }
        if (component instanceof JFrame) {
            return new WarningDlg<T>((JFrame)component, string, string2, warningReport);
        }
        return new WarningDlg<T>(Application.getApp().getActiveFrame(), string, string2, warningReport);
    }

    public WarningDlg(JDialog jDialog, String string, String string2, WarningReport<T> warningReport) {
        super((Window)jDialog, string, 1);
        this.init(string2, warningReport);
    }

    public WarningDlg(JFrame jFrame, String string, String string2, WarningReport<T> warningReport) {
        super((Window)jFrame, string, 1);
        this.init(string2, warningReport);
    }

    private void init(String string, WarningReport<T> warningReport) {
        this.d_report = warningReport;
        this.d_warnings = (IWarning[])Array.newInstance(this.d_report.getType(), this.d_report.getWarnings().size());
        this.d_report.getWarnings().toArray(this.d_warnings);
        Object[] objectArray = new Class[this.d_report.getInfoTypes().length];
        Arrays.fill(objectArray, String.class);
        this.d_table = guiTableUtil.fixedColumnTable(this.d_report.getInfoDescriptions(), (Class[])objectArray, 7);
        this.d_table.setSortOrder(0);
        this.d_editor = new guiTableEditor(this.d_table, 0);
        this.d_table.setCellSelectionEnabled(false);
        this.d_table.setRowSelectionAllowed(true);
        CellRenderer cellRenderer = new CellRenderer();
        CellEditor cellEditor = new CellEditor();
        for (int i = 0; i < this.d_report.getInfoTypes().length; ++i) {
            this.d_table.getColumnModel().getColumn(i).setCellRenderer(cellRenderer);
            this.d_table.getColumnModel().getColumn(i).setCellEditor(cellEditor);
        }
        this.d_table.addMouseListener(new MouseMessageListener());
        JScrollPane jScrollPane = new JScrollPane(this.d_editor);
        this.d_saveReportToFileButton = new JButton(Intl.intl("Save to File"));
        this.d_saveReportToFileButton.addActionListener(new SaveToFileAction());
        this.d_copyReportToClipBoardButton = new JButton(Intl.intl("Copy to Clipboard"));
        this.d_copyReportToClipBoardButton.addActionListener(new CopyToClipboardAction());
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        Icon icon = UIManager.getIcon("OptionPane.warningIcon");
        JLabel jLabel = new JLabel(icon);
        MultiLineLabel multiLineLabel = new MultiLineLabel(string);
        int n = 0;
        GridBagUtil.add(guiPanel2, jLabel, 0, n, 1, 1, 0, 0, 12, 6, 2, 0.0, 0.0, 10);
        GridBagUtil.add(guiPanel2, multiLineLabel, 1, n, 1, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 10);
        GridBagUtil.add(guiPanel2, jScrollPane, 0, ++n, 2, 1, 0, 0, 12, 0, 1, 1.0, 1.0, 10);
        guiPanel guiPanel3 = new guiPanel(new FlowLayout(1, 6, 0));
        guiPanel3.add(this.d_saveReportToFileButton);
        guiPanel3.add(this.d_copyReportToClipBoardButton);
        GridBagUtil.add(guiPanel2, guiPanel3, 0, ++n, 2, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 10);
        this.loadValues();
        this.d_table.autoSizeColumns(true);
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.setPreferredSize(new Dimension(500, 300));
    }

    private String getMessageForWarning(T t) {
        String string = "";
        int[] nArray = this.d_report.getInfoTypes();
        String[] stringArray = this.d_report.getInfoDescriptions();
        for (int i = 0; i < nArray.length; ++i) {
            Comparable comparable = t.getWarningInfo(nArray[i]);
            string = string + stringArray[i] + ":  " + comparable.toString() + "\n";
        }
        return string;
    }

    private void loadValues() {
        int[] nArray = this.d_report.getInfoTypes();
        for (int i = 0; i < this.d_warnings.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                this.d_table.setValueAt(this.getObjectAt(i, j), i, j);
            }
        }
    }

    public Comparable getObjectAt(int n, int n2) {
        T t = this.d_warnings[n];
        return t.getWarningInfo(this.d_report.getInfoTypes()[n2]);
    }

    private void prepareForReport() {
        int n;
        int n2 = this.d_table.getSortColumn();
        int n3 = this.d_report.getInfoTypes()[n2];
        int n4 = this.d_table.getSortOrder();
        switch (n4) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                assert (false);
                n = 0;
            }
        }
        this.d_report.sortWarnings(n3, n);
    }

    private class CopyToClipboardAction
    extends AbstractAction {
        private static final long serialVersionUID = -7897925698417705455L;

        private CopyToClipboardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WarningDlg.this.prepareForReport();
            String string = WarningDlg.this.d_report.prepareReport();
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(string), null);
        }
    }

    private class SaveToFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 4656191590391288940L;

        private SaveToFileAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            guiFileChooser guiFileChooser2 = new guiFileChooser("txt", "Text Files");
            guiFileChooser2.setAcceptAllFileFilterUsed(true);
            guiFileChooser2.setSelectedFile(new File("warning_log.txt"));
            int n = guiFileChooser2.showSaveDialog(WarningDlg.this);
            if (n == 0) {
                WarningDlg.this.prepareForReport();
                File file = guiFileChooser2.getSelectedFile();
                try {
                    WarningDlg.this.d_report.writeReport(file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    WarningDlg.this.showMessageBox(iOException.getMessage());
                }
            }
        }
    }

    private class CellEditor
    implements TableCellEditor {
        private CellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return false;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -661138943373637331L;

        private CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, "<html>" + object, bl, bl2, n, n2);
            if (component instanceof JComponent && object != null) {
                ((JComponent)component).setToolTipText(object.toString());
            }
            return component;
        }
    }

    private class MouseMessageListener
    extends MouseAdapter {
        private MouseMessageListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() >= 2) {
                int n = WarningDlg.this.d_table.rowAtPoint(mouseEvent.getPoint());
                int n2 = WarningDlg.this.d_table.columnAtPoint(mouseEvent.getPoint());
                if (n < 0 || n2 < 0 || n >= WarningDlg.this.d_report.getWarnings().size() || n2 >= WarningDlg.this.d_report.getInfoTypes().length) {
                    return;
                }
                IWarning iWarning = WarningDlg.this.d_warnings[n];
                String string = WarningDlg.this.getMessageForWarning(iWarning);
                JOptionPane.showMessageDialog(WarningDlg.this, string, "Warning", 2);
            }
        }
    }
}

