/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import pyrosim.legacy_2012_1.thunderheadeng.gui.RecursiveLinkStatusListener;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiPanel;

public class Utils {
    public static void noToolBarFocus(JToolBar jToolBar) {
        Component[] componentArray = jToolBar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setFocusable(false);
        }
    }

    public static void setEnabled(Component component, boolean bl) {
        if (component instanceof AbstractButton) {
            component.setEnabled(bl);
            if (bl) {
                AbstractButton abstractButton = (AbstractButton)component;
                ItemListener[] itemListenerArray = abstractButton.getItemListeners();
                for (int i = 0; i < itemListenerArray.length; ++i) {
                    if (!(itemListenerArray[i] instanceof RecursiveLinkStatusListener)) continue;
                    RecursiveLinkStatusListener recursiveLinkStatusListener = (RecursiveLinkStatusListener)itemListenerArray[i];
                    recursiveLinkStatusListener.updateStatus();
                }
            }
        } else if (component instanceof guiPanel) {
            component.setEnabled(bl);
        } else if (component instanceof Container) {
            component.setEnabled(bl);
            Utils.setEnabled(((Container)component).getComponents(), bl);
        } else {
            component.setEnabled(bl);
        }
    }

    public static void setEnabled(Component[] componentArray, boolean bl) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (int i = componentArray.length - 1; i >= 0; --i) {
            Component component = componentArray[i];
            if (component instanceof AbstractButton) {
                arrayList.add(component);
                continue;
            }
            Utils.setEnabled(component, bl);
        }
        for (Component component : arrayList) {
            Utils.setEnabled(component, bl);
        }
    }

    public static void requestFocus(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                component.requestFocus();
            }
        });
    }

    public static Component findParentWindow(Component component) {
        if (component instanceof Frame || component instanceof Window || component instanceof Dialog || component == null) {
            return component;
        }
        return Utils.findParentWindow(component.getParent());
    }

    public static FocusTraversalPolicy createFocusTraversalPolicy(Component ... componentArray) {
        final List<Component> list = Arrays.asList(componentArray);
        return new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container container, Component component) {
                int n = list.indexOf(component);
                return n < list.size() - 1 ? (Component)list.get(n + 1) : null;
            }

            @Override
            public Component getComponentBefore(Container container, Component component) {
                int n = list.indexOf(component);
                return 0 < n ? (Component)list.get(n - 1) : null;
            }

            @Override
            public Component getDefaultComponent(Container container) {
                return this.getFirstComponent(container);
            }

            @Override
            public Component getFirstComponent(Container container) {
                return (Component)list.get(0);
            }

            @Override
            public Component getLastComponent(Container container) {
                return (Component)list.get(list.size() - 1);
            }
        };
    }
}

