/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiStatusBar;

public class StatusBarTips {
    private final guiStatusBar d_statusBar;
    private final int d_statusBarPane;

    public StatusBarTips(guiStatusBar guiStatusBar2, int n) {
        this.d_statusBar = guiStatusBar2;
        this.d_statusBarPane = n;
    }

    public void addTrigger(AbstractButton abstractButton) {
        Action action = abstractButton.getAction();
        if (action != null) {
            StatusBarUpdater statusBarUpdater = new StatusBarUpdater(this);
            this.putTriggerImpl(abstractButton, statusBarUpdater);
        }
    }

    public void addTrigger(Component component, String string) {
        if (string != null) {
            ConstantUpdater constantUpdater = new ConstantUpdater(this, string);
            this.putTriggerImpl(component, constantUpdater);
        }
    }

    private void putTriggerImpl(Component component, StatusBarUpdater statusBarUpdater) {
        component.addMouseListener(statusBarUpdater);
        if (component instanceof JMenuItem) {
            ((JMenuItem)component).addActionListener(statusBarUpdater);
        }
    }

    public void removeTrigger(Component component) {
        for (MouseListener mouseListener : component.getMouseListeners()) {
            if (!this.isListener(mouseListener)) continue;
            component.removeMouseListener(mouseListener);
        }
        if (component instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)component;
            for (ActionListener actionListener : jMenuItem.getActionListeners()) {
                if (!this.isListener(actionListener)) continue;
                jMenuItem.removeActionListener(actionListener);
            }
        }
    }

    protected boolean isListener(EventListener eventListener) {
        return eventListener instanceof StatusBarUpdater && ((StatusBarUpdater)eventListener).getTips() == this;
    }

    protected void setTip(String string) {
        this.d_statusBar.setMessage(this.d_statusBarPane, string);
    }

    private static class ConstantUpdater
    extends StatusBarUpdater {
        private final String d_tip;

        public ConstantUpdater(StatusBarTips statusBarTips, String string) {
            super(statusBarTips);
            this.d_tip = string;
        }

        @Override
        protected Object getTip(Object object) {
            return this.d_tip;
        }
    }

    private static class StatusBarUpdater
    extends MouseAdapter
    implements ActionListener {
        private final StatusBarTips d_tips;

        public StatusBarUpdater(StatusBarTips statusBarTips) {
            this.d_tips = statusBarTips;
        }

        public StatusBarTips getTips() {
            return this.d_tips;
        }

        protected Object getTip(Object object) {
            if (object instanceof AbstractButton) {
                return ((AbstractButton)object).getAction();
            }
            return null;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Object object = this.getTip(mouseEvent.getSource());
            if (object instanceof Action) {
                object = ((Action)object).getValue("LongDescription");
            }
            if (object != null) {
                this.d_tips.setTip(object.toString());
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.d_tips.setTip("");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.d_tips.setTip("");
        }
    }
}

