/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.basic.BasicArrowButton;

public class SplitButton
extends JButton {
    private static final long serialVersionUID = -8868284652560095900L;
    private JPopupMenu dropDownMenu;
    private int d_orient;
    private boolean d_mouseInside = false;
    private Point d_mouseEvtLoc = null;

    public SplitButton() {
        this(" ");
    }

    public SplitButton(String string) {
        this(string, 5);
    }

    public SplitButton(String string, int n) {
        super(string);
        this.d_orient = n;
        this.setHorizontalAlignment(2);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                SplitButton.this.d_mouseInside = true;
                SplitButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                SplitButton.this.d_mouseInside = false;
                SplitButton.this.repaint();
            }
        });
    }

    public void setArrowOrient(int n) {
        this.d_orient = n;
    }

    public int getArrowOrient() {
        return this.d_orient;
    }

    public void setMenu(JPopupMenu jPopupMenu) {
        this.dropDownMenu = jPopupMenu;
    }

    public JPopupMenu getMenu() {
        return this.dropDownMenu;
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        this.d_mouseEvtLoc = mouseEvent.getPoint();
        super.processMouseEvent(mouseEvent);
        this.d_mouseEvtLoc = null;
    }

    @Override
    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (this.isOverDropdownBtn(this.d_mouseEvtLoc)) {
            if (this.dropDownMenu == null) {
                return;
            }
            if (!this.dropDownMenu.isVisible()) {
                int n = 0;
                int n2 = this.getPreferredSize().height;
                this.dropDownMenu.show(this, n, n2);
            } else {
                this.dropDownMenu.setVisible(false);
            }
            return;
        }
        super.fireActionPerformed(actionEvent);
    }

    private boolean isOverDropdownBtn(Point point) {
        if (this.d_mouseEvtLoc == null) {
            return false;
        }
        return point.x > this.getActionPreferredSize().width - 3;
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        super.addActionListener(actionListener);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics = graphics.create();
        super.paintComponent(graphics);
        graphics.translate(this.getActionPreferredSize().width - 3, 0);
        CustomSep customSep = new CustomSep();
        graphics.translate(customSep.getPreferredSize().width - 3, 0);
        CustomArrow customArrow = new CustomArrow(this.d_orient);
        customArrow.setEnabled(this.isEnabled());
        customArrow.setSize(new Dimension(customArrow.getPreferredSize().width, this.getSize().height));
        customArrow.paintComponent(graphics);
        if (this.d_mouseInside) {
            graphics.translate(-(customSep.getPreferredSize().width - 3), 0);
            customSep.setSize(new Dimension(customSep.getPreferredSize().width, this.getSize().height - this.getInsets().top - this.getInsets().bottom + 1));
            customSep.setEnabled(this.isEnabled());
            int n = this.getInsets().top - 1;
            graphics.translate(0, n);
            customSep.paintComponent(graphics);
            graphics.translate(0, -n);
        }
        graphics.dispose();
    }

    private Dimension getActionPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.getActionPreferredSize();
        Dimension dimension2 = new JSeparator(1).getPreferredSize();
        Dimension dimension3 = new BasicArrowButton(this.d_orient).getPreferredSize();
        int n = dimension.width + dimension2.width + dimension3.width - 6;
        int n2 = dimension.height;
        return new Dimension(n, n2);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.isMinimumSizeSet() ? super.getMinimumSize() : this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.isMaximumSizeSet() ? super.getMaximumSize() : this.getPreferredSize();
    }

    private static class CustomArrow
    extends BasicArrowButton {
        private static final long serialVersionUID = 4360551273472906899L;

        public CustomArrow(int n) {
            super(n);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n = this.getSize().width + 2;
            int n2 = this.getSize().height;
            int n3 = Math.min((n2 - 4) / 3, (n - 4) / 3);
            n3 = Math.max(n3, 2);
            this.paintTriangle(graphics, (n - n3) / 2, (n2 - n3) / 2, n3, this.direction, this.isEnabled());
        }
    }

    private static class CustomSep
    extends JSeparator {
        private static final long serialVersionUID = -3599408847522726590L;

        public CustomSep() {
            super(1);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
        }
    }
}

