/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiLabel;

public class GridBagHelper {
    public static int REMAINING = 0;
    public static final int DEF_COL_SPACE = 6;
    public static final int DEF_ROW_SPACE = 6;
    public static final int DEF_INDENT = 18;
    public static final Anchor DEF_ANCHOR = Anchor.LEFT;
    public static final double DEF_FILL = 0.0;
    private final Container d_panel;
    public int d_colSpace;
    public int d_rowSpace;
    public int d_indent;
    public Anchor d_anchor;
    public double d_hfill;
    public double d_vfill;
    private boolean d_firstRowAdded = true;
    private int d_currRow;
    private int d_currCol;
    private int d_indentLevel;

    public GridBagHelper(Container container, boolean bl, int n, int n2) {
        this.d_panel = container;
        if (!(container.getLayout() instanceof GridBagLayout)) {
            container.setLayout(new GridBagLayout());
        }
        this.d_colSpace = n;
        this.d_rowSpace = n2;
        this.d_indent = 18;
        this.d_anchor = DEF_ANCHOR;
        this.d_vfill = 0.0;
        this.d_hfill = 0.0;
        this.d_currCol = 0;
        this.d_currRow = 0;
        this.d_indentLevel = 0;
        if (bl) {
            this.addBorder();
        }
    }

    public GridBagHelper(Container container) {
        this(container, false, 6, 6);
    }

    public GridBagHelper(Container container, boolean bl) {
        this(container, bl, 6, 6);
    }

    public void setCurrentRow(int n) {
        this.d_currRow = n;
    }

    public int getCurrentRow() {
        return this.d_currRow;
    }

    public void indent(boolean bl) {
        if (bl) {
            this.indent();
        } else {
            this.unindent();
        }
    }

    public void indent() {
        ++this.d_indentLevel;
    }

    public void unindent() {
        --this.d_indentLevel;
    }

    public void addFilledRow(Object object) {
        this.addRow(object, 1.0, REMAINING);
    }

    public void addIdentRow(Object ... objectArray) {
        this.indent(true);
        this.addRow(objectArray);
        this.indent(false);
    }

    public void addRow(Object ... objectArray) {
        int n;
        for (n = 0; n < objectArray.length; ++n) {
            if (!(objectArray[n] instanceof String)) continue;
            objectArray[n] = new guiLabel((String)objectArray[n]);
        }
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null && !(objectArray[n] instanceof Component)) {
                ++n;
                continue;
            }
            Component component = (Component)objectArray[n];
            n = this.addCol(component, objectArray, n + 1);
        }
        this.nextRow();
    }

    public void nextRow() {
        ++this.d_currRow;
        this.d_firstRowAdded = false;
        this.d_currCol = 0;
    }

    public void addCol(Component component, Object ... objectArray) {
        this.addCol(component, objectArray, 0);
    }

    public void addCol(String string, Object ... objectArray) {
        this.addCol((Component)new guiLabel(string), objectArray);
    }

    public int addCol(Component component, Object[] objectArray, int n) {
        int n2;
        Object object;
        int n3;
        int n4 = this.d_indentLevel * this.d_indent;
        int n5 = this.d_firstRowAdded ? 0 : this.d_rowSpace;
        double d = this.d_hfill;
        double d2 = this.d_vfill;
        int n6 = 1;
        int n7 = 1;
        Anchor anchor = this.d_anchor;
        for (n3 = n; n3 < objectArray.length && !((object = objectArray[n3]) instanceof Component) && object != null; ++n3) {
            if (object instanceof Anchor) {
                anchor = (Anchor)((Object)object);
                continue;
            }
            if (object instanceof Double) {
                d = (Double)object;
                continue;
            }
            if (object instanceof double[]) {
                d = ((double[])object)[0];
                d2 = ((double[])object)[1];
                continue;
            }
            if (object instanceof Integer) {
                n6 = (Integer)object;
                continue;
            }
            if (!(object instanceof int[])) continue;
            n6 = ((int[])object)[0];
            n7 = ((int[])object)[1];
        }
        int n8 = n2 = this.d_currCol == 0 ? n4 : this.d_colSpace;
        if (component == null) {
            this.d_currCol += n6;
            return n3;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = d == 0.0 && d2 == 0.0 ? 0 : (d == 0.0 ? 3 : (d2 == 0.0 ? 2 : 1));
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        switch (anchor) {
            case TOP_LEFT: {
                gridBagConstraints.anchor = 18;
                break;
            }
            case TOP: {
                gridBagConstraints.anchor = 11;
                break;
            }
            case TOP_RIGHT: {
                gridBagConstraints.anchor = 12;
                break;
            }
            case LEFT: {
                gridBagConstraints.anchor = 17;
                break;
            }
            case CENTER: {
                gridBagConstraints.anchor = 10;
                break;
            }
            case RIGHT: {
                gridBagConstraints.anchor = 13;
                break;
            }
            case BOTTOM_LEFT: {
                gridBagConstraints.anchor = 16;
                break;
            }
            case BOTTOM: {
                gridBagConstraints.anchor = 15;
                break;
            }
            case BOTTOM_RIGHT: {
                gridBagConstraints.anchor = 14;
            }
        }
        gridBagConstraints.gridx = this.d_currCol;
        gridBagConstraints.gridy = this.d_currRow;
        gridBagConstraints.gridwidth = n6;
        gridBagConstraints.gridheight = n7;
        gridBagConstraints.insets = new Insets(n5, n2, 0, 0);
        this.d_panel.add(component, gridBagConstraints);
        this.d_currCol += n6;
        return n3;
    }

    public void finalizeRows() {
        GridBagUtil.addGlue(this.d_panel);
    }

    public void addBorder() {
        this.addBorder(12, 12, 12, 12);
    }

    public void addBorder(int n, int n2, int n3, int n4) {
        if (this.d_panel instanceof JComponent) {
            ((JComponent)this.d_panel).setBorder(BorderFactory.createEmptyBorder(n, n2, n3, n4));
        }
    }

    public static enum Anchor {
        TOP_LEFT,
        TOP,
        TOP_RIGHT,
        LEFT,
        CENTER,
        RIGHT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT;

    }
}

