/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JPanel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Series;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;

public class Graph
extends JPanel {
    private static final long serialVersionUID = -3669781768695711115L;
    private final RenderingHints AA_ON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private final RenderingHints AA_OFF = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    public static final int AUTO = -1;
    public static final int SOLID = 0;
    public static final int DASH = 1;
    public static final int DOT = 2;
    public static final int DASH_DOT = 3;
    public static final int DASH_DOT_DOT = 4;
    public static final int NO_LINE = 5;
    public static final int SQUARE = 6;
    public static final int DIAMOND = 7;
    public static final int TRIANGLE = 8;
    public static final int CIRCLE = 9;
    public static final int SQUARE_OUTLINE = 10;
    public static final int DIAMOND_OUTLINE = 11;
    public static final int TRIANGLE_OUTLINE = 12;
    public static final int CIRCLE_OUTLINE = 13;
    public static final int NO_MARK = 14;
    private static final int TOP = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int BOTTOM = 3;
    public static final int COLORS = 0;
    public static final int PATTERNS = 1;
    public static final int COLORS_AND_PATTERNS = 2;
    private int d_autoMode = 2;
    private int d_gridlines = 0;
    private float d_size = 0.0f;
    private DateFormat d_axisTimeFormat = null;
    private boolean d_autoRangeX = true;
    private boolean d_autoRangeY = true;
    private double d_xmin;
    private double d_xmax;
    private double d_ymin;
    private double d_ymax;
    private boolean d_showLegend = false;
    private String d_title = "";
    private String d_xTitle = "";
    private String d_yTitle = "";
    private Set<Series> series;
    private AffineTransform transform;
    private AffineTransform inverse;
    private int curr = 0;
    private int currStyle = 0;
    private double xmin = Double.MAX_VALUE;
    private double xmax = -1.7976931348623157E308;
    private double ymin = Double.MAX_VALUE;
    private double ymax = -1.7976931348623157E308;
    private double xinc = 0.0;
    private double yinc = 0.0;
    private Set<Annotation> d_annotations;
    private Color[] colors = new Color[]{SystemColor.windowText, Color.blue, Color.red, Color.green, Color.magenta, Color.orange, Color.cyan, Color.gray, Color.pink, Color.yellow};
    private int[] styles = new int[]{0, 1, 2, 3, 4};
    private int[] markers = new int[]{6, 7, 8, 9, 10, 11, 12, 13};
    private int[] weights = new int[]{1, 3};

    public void setAutoMode(int n) {
        this.d_autoMode = n;
    }

    public int getAutoMode() {
        return this.d_autoMode;
    }

    public void setGridlines(int n) {
        this.d_gridlines = n;
    }

    public int getGridlines() {
        return this.d_gridlines;
    }

    public Graph() {
        this.series = new LinkedHashSet<Series>();
        this.d_annotations = new HashSet<Annotation>();
        this.transform = new AffineTransform();
    }

    public void reset() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Graph.this.series.clear();
                Graph.this.d_annotations.clear();
            }
        });
    }

    public void addSeries(final Series series) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Graph.this.series.add(series);
            }
        });
    }

    public void removeSeries(final Series series) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Graph.this.series.remove(series);
            }
        });
    }

    public boolean addAnnotation(Annotation annotation) {
        return this.d_annotations.add(annotation);
    }

    public boolean removeAnnotation(Annotation annotation) {
        return this.d_annotations.remove(annotation);
    }

    public void setLegendVisible(boolean bl) {
        this.d_showLegend = bl;
    }

    private void updateTransform() {
        this.updateAxes();
        Dimension dimension = this.getSize();
        this.transform.setToIdentity();
        this.transform.scale((double)dimension.width / (this.xmax - this.xmin) / 1.4, -((double)dimension.height) / (this.ymax - this.ymin) / 1.3);
        this.transform.translate(-(this.xmin - 0.2 * (this.xmax - this.xmin)), -(this.ymax + 0.15 * (this.ymax - this.ymin)));
        try {
            this.inverse = new AffineTransform(this.transform);
            this.inverse.invert();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
            this.inverse = null;
        }
    }

    public void setAutoRangeX(boolean bl) {
        this.d_autoRangeX = bl;
    }

    public boolean getAutoRangeX() {
        return this.d_autoRangeX;
    }

    public void setAutoRangeY(boolean bl) {
        this.d_autoRangeY = bl;
    }

    public boolean getAutoRangeY() {
        return this.d_autoRangeY;
    }

    public void setRangeX(double d, double d2) {
        this.d_xmin = d;
        this.d_xmax = d2;
    }

    public void setRangeY(double d, double d2) {
        this.d_ymin = d;
        this.d_ymax = d2;
    }

    public double getMinX() {
        return this.d_xmin;
    }

    public double getMaxX() {
        return this.d_xmax;
    }

    public double getMinY() {
        return this.d_ymin;
    }

    public double getMaxY() {
        return this.d_ymax;
    }

    private void calcGlobalBounds() {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        for (Series series : this.series) {
            if (series.getMinX() < d) {
                d = series.getMinX();
            }
            if (series.getMaxX() > d2) {
                d2 = series.getMaxX();
            }
            if (series.getMinY() < d3) {
                d3 = series.getMinY();
            }
            if (!(series.getMaxY() > d4)) continue;
            d4 = series.getMaxY();
        }
        if (this.d_autoRangeX) {
            this.d_xmin = d;
            this.d_xmax = d2;
        }
        if (this.d_autoRangeY) {
            this.d_ymin = d3;
            this.d_ymax = d4;
        }
        if (this.d_xmin == this.d_xmax) {
            this.d_xmin -= 0.1;
            this.d_xmax += 0.1;
        }
        if (this.d_ymin == this.d_ymax) {
            this.d_ymin -= 0.1;
            this.d_ymax += 0.1;
        }
    }

    private void updateAxes() {
        this.calcGlobalBounds();
        double d = this.d_xmax - this.d_xmin;
        if (d == 0.0) {
            d = 0.2;
        }
        this.xinc = Math.log(d) / Math.log(10.0);
        this.xinc = Math.floor(this.xinc);
        this.xinc = Math.pow(10.0, this.xinc);
        if (d / this.xinc < 2.0) {
            this.xinc /= 5.0;
        } else if (d / this.xinc < 5.0) {
            this.xinc /= 2.0;
        }
        this.xmin = Math.floor(this.d_xmin / this.xinc) * this.xinc;
        this.xmax = Math.ceil(this.d_xmax / this.xinc) * this.xinc;
        double d2 = this.d_ymax - this.d_ymin;
        if (d2 == 0.0) {
            d2 = 0.2;
        }
        this.yinc = Math.log(d2) / Math.log(10.0);
        this.yinc = Math.floor(this.yinc);
        this.yinc = Math.pow(10.0, this.yinc);
        if (d2 / this.yinc < 2.0) {
            this.yinc /= 5.0;
        } else if (d2 / this.yinc < 5.0) {
            this.yinc /= 2.0;
        }
        this.ymin = Math.floor(this.d_ymin / this.yinc) * this.yinc;
        this.ymax = Math.ceil(this.d_ymax / this.yinc) * this.yinc;
    }

    public void setAxisTimeFormat(DateFormat dateFormat) {
        this.d_axisTimeFormat = dateFormat;
    }

    public Stroke getStroke(Series series) {
        int n;
        int n2 = series.getLineType();
        if (n2 == 5) {
            return null;
        }
        if (n2 == -1) {
            n2 = this.getAutoLineStyle(series);
        }
        if ((n = series.getWeight()) == -1) {
            n = this.getAutoWeight(series);
        }
        float[] fArray = new float[]{16.0f, 4.0f};
        float[] fArray2 = new float[]{4.0f, 4.0f};
        float[] fArray3 = new float[]{15.0f, 4.0f, 4.0f, 4.0f};
        float[] fArray4 = new float[]{16.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f};
        switch (n2) {
            case 0: {
                return new BasicStroke(n);
            }
            case 1: {
                return new BasicStroke(n, 0, 0, 10.0f, fArray, 0.0f);
            }
            case 2: {
                return new BasicStroke(n, 0, 0, 10.0f, fArray2, 0.0f);
            }
            case 3: {
                return new BasicStroke(n, 0, 0, 10.0f, fArray3, 0.0f);
            }
            case 4: {
                return new BasicStroke(n, 0, 0, 10.0f, fArray4, 0.0f);
            }
        }
        return null;
    }

    private void drawSeries(Graphics2D graphics2D, Series series) {
        GeneralPath generalPath = new GeneralPath();
        double[] dArray = series.getX();
        double[] dArray2 = series.getY();
        double[] dArray3 = new double[2 * dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[2 * i] = dArray[i];
            dArray3[2 * i + 1] = dArray2[i];
        }
        this.transform.transform(dArray3, 0, dArray3, 0, dArray.length);
        if (dArray.length == 0) {
            return;
        }
        Stroke stroke = graphics2D.getStroke();
        Color color = series.getColor();
        if (color == null) {
            color = this.getAutoColor(series);
        }
        graphics2D.setPaint(color);
        if (series.getLineType() == 5) {
            return;
        }
        Stroke stroke2 = this.getStroke(series);
        assert (stroke2 != null);
        graphics2D.setStroke(stroke2);
        Point2D.Double double_ = new Point2D.Double(this.xmin, this.ymax);
        Point2D.Double double_2 = new Point2D.Double(this.xmax, this.ymin);
        this.transform.transform(double_, double_);
        this.transform.transform(double_2, double_2);
        Shape shape = graphics2D.getClip();
        graphics2D.clipRect((int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), (int)(((Point2D)double_2).getX() - ((Point2D)double_).getX()), (int)(((Point2D)double_2).getY() - ((Point2D)double_).getY()));
        boolean bl = false;
        for (int i = 0; i < dArray.length - 1; ++i) {
            if (dArray[i] < this.xmin && dArray[i + 1] < this.xmin || dArray[i] > this.xmax && dArray[i + 1] > this.xmax || dArray2[i] < this.ymin && dArray2[i + 1] < this.ymin || dArray2[i] > this.ymax && dArray2[i + 1] > this.ymax) {
                bl = false;
                continue;
            }
            if (!bl) {
                generalPath.moveTo((float)dArray3[2 * i], (float)dArray3[2 * i + 1]);
                bl = true;
            }
            generalPath.lineTo((float)dArray3[2 * (i + 1)], (float)dArray3[2 * (i + 1) + 1]);
        }
        graphics2D.draw(generalPath);
        graphics2D.setClip(shape);
        graphics2D.setStroke(stroke);
    }

    private void drawMarkers(Graphics2D graphics2D, Series series) {
        double[] dArray = series.getX();
        double[] dArray2 = series.getY();
        double[] dArray3 = new double[2];
        block10: for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] < this.xmin || dArray[i] > this.xmax || dArray2[i] < this.ymin || dArray2[i] > this.ymax) continue;
            dArray3[0] = dArray[i];
            dArray3[1] = dArray2[i];
            this.transform.transform(dArray3, 0, dArray3, 0, 1);
            int n = series.getMarkType();
            if (n == -1) {
                n = this.getAutoMarkStyle(series);
            }
            switch (n) {
                case 6: {
                    this.drawSquare(graphics2D, (float)dArray3[0], (float)dArray3[1], 1);
                    continue block10;
                }
                case 7: {
                    this.drawDiamond(graphics2D, (float)dArray3[0], (float)dArray3[1], 1);
                    continue block10;
                }
                case 8: {
                    this.drawTriangle(graphics2D, (float)dArray3[0], (float)dArray3[1], 1);
                    continue block10;
                }
                case 9: {
                    this.drawCircle(graphics2D, (float)dArray3[0], (float)dArray3[1], 1);
                    continue block10;
                }
                case 10: {
                    this.drawSquare(graphics2D, (float)dArray3[0], (float)dArray3[1], 0);
                    continue block10;
                }
                case 11: {
                    this.drawDiamond(graphics2D, (float)dArray3[0], (float)dArray3[1], 0);
                    continue block10;
                }
                case 12: {
                    this.drawTriangle(graphics2D, (float)dArray3[0], (float)dArray3[1], 0);
                    continue block10;
                }
                case 13: {
                    this.drawCircle(graphics2D, (float)dArray3[0], (float)dArray3[1], 0);
                }
            }
        }
    }

    private void drawSquare(Graphics2D graphics2D, float f, float f2, int n) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(f - 3.0f * this.d_size, f2 - 3.0f * this.d_size, 6.0f * this.d_size, 6.0f * this.d_size);
        if (n == 0) {
            graphics2D.draw(float_);
        } else {
            graphics2D.fill(float_);
        }
    }

    private void drawDiamond(Graphics2D graphics2D, float f, float f2, int n) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2 - 4.0f * this.d_size);
        generalPath.lineTo(f + 4.0f * this.d_size, f2);
        generalPath.lineTo(f, f2 + 4.0f * this.d_size);
        generalPath.lineTo(f - 4.0f * this.d_size, f2);
        generalPath.closePath();
        if (n == 0) {
            graphics2D.draw(generalPath);
        } else {
            graphics2D.fill(generalPath);
        }
    }

    private void drawTriangle(Graphics2D graphics2D, float f, float f2, int n) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f - 4.0f * this.d_size, f2 + 2.0f * this.d_size);
        generalPath.lineTo(f + 4.0f * this.d_size, f2 + 2.0f * this.d_size);
        generalPath.lineTo(f, f2 - 4.0f * this.d_size);
        generalPath.closePath();
        if (n == 0) {
            graphics2D.draw(generalPath);
        } else {
            graphics2D.fill(generalPath);
        }
    }

    private void drawCircle(Graphics2D graphics2D, float f, float f2, int n) {
        Arc2D.Float float_ = new Arc2D.Float(f - 3.5f * this.d_size, f2 - 3.5f * this.d_size, 7.0f * this.d_size, 7.0f * this.d_size, 0.0f, 360.0f, 0);
        if (n == 0) {
            graphics2D.draw(float_);
        } else {
            graphics2D.fill(float_);
        }
    }

    private void drawGridlines(Graphics2D graphics2D) {
        int n;
        GeneralPath generalPath = new GeneralPath();
        int n2 = (int)((this.xmax - this.xmin) / this.xinc);
        for (n = 1; n < n2; ++n) {
            generalPath.moveTo((float)(this.xmin + (double)n * this.xinc), (float)this.ymin);
            generalPath.lineTo((float)(this.xmin + (double)n * this.xinc), (float)this.ymax);
        }
        generalPath.transform(this.transform);
        graphics2D.draw(generalPath);
        generalPath.reset();
        n2 = (int)((this.ymax - this.ymin) / this.yinc);
        for (n = 1; n < n2; ++n) {
            generalPath.moveTo((float)this.xmin, (float)(this.ymin + (double)n * this.yinc));
            generalPath.lineTo((float)this.xmax, (float)(this.ymin + (double)n * this.yinc));
        }
        generalPath.transform(this.transform);
        graphics2D.draw(generalPath);
    }

    private void drawAxes(Graphics2D graphics2D) {
        int n;
        Point2D.Double double_ = new Point2D.Double(this.xmin, 0.0);
        Point2D.Double double_2 = new Point2D.Double(this.xmax, 0.0);
        if (this.ymax < 0.0) {
            ((Point2D)double_).setLocation(this.xmin, this.ymax);
            ((Point2D)double_2).setLocation(this.xmax, this.ymax);
        } else if (this.ymin > 0.0) {
            ((Point2D)double_).setLocation(this.xmin, this.ymin);
            ((Point2D)double_2).setLocation(this.xmax, this.ymin);
        }
        Point2D.Double double_3 = new Point2D.Double(0.0, this.ymin);
        Point2D.Double double_4 = new Point2D.Double(0.0, this.ymax);
        if (this.xmax < 0.0) {
            ((Point2D)double_3).setLocation(this.xmax, this.ymin);
            ((Point2D)double_4).setLocation(this.xmax, this.ymax);
        } else if (this.xmin > 0.0) {
            ((Point2D)double_3).setLocation(this.xmin, this.ymin);
            ((Point2D)double_4).setLocation(this.xmin, this.ymax);
        }
        Point2D.Double double_5 = new Point2D.Double();
        Point2D.Double double_6 = new Point2D.Double();
        Point2D.Double double_7 = new Point2D.Double();
        Point2D.Double double_8 = new Point2D.Double();
        this.transform.transform(double_, double_5);
        this.transform.transform(double_2, double_6);
        this.transform.transform(double_3, double_7);
        this.transform.transform(double_4, double_8);
        Line2D.Double double_9 = new Line2D.Double(double_, double_2);
        Line2D.Double double_10 = new Line2D.Double(double_3, double_4);
        Line2D.Double double_11 = new Line2D.Double(double_5, double_6);
        Line2D.Double double_12 = new Line2D.Double(double_7, double_8);
        graphics2D.draw(double_11);
        graphics2D.draw(double_12);
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        ((DecimalFormat)numberFormat).applyPattern("0.00E00");
        Point2D.Double double_13 = new Point2D.Double();
        GeneralPath generalPath = new GeneralPath();
        int n2 = (int)((this.xmax - this.xmin) / this.xinc);
        for (n = 0; n <= n2; ++n) {
            double_13.x = this.xmin + (double)n * this.xinc;
            double_13.y = double_9.y1;
            this.transform.transform(double_13, double_13);
            generalPath.moveTo((float)double_13.x, (float)(double_13.y - (double)(4.0f * this.d_size)));
            generalPath.lineTo((float)double_13.x, (float)(double_13.y + (double)(4.0f * this.d_size)));
        }
        graphics2D.draw(generalPath);
        generalPath.reset();
        n2 = (int)((this.ymax - this.ymin) / this.yinc);
        for (n = 0; n <= n2; ++n) {
            double_13.x = double_10.x1;
            double_13.y = this.ymin + (double)n * this.yinc;
            this.transform.transform(double_13, double_13);
            generalPath.moveTo((float)(double_13.x - (double)(4.0f * this.d_size)), (float)double_13.y);
            generalPath.lineTo((float)(double_13.x + (double)(4.0f * this.d_size)), (float)double_13.y);
        }
        graphics2D.draw(generalPath);
        double_13.x = (this.xmin + this.xmax) / 2.0;
        double_13.y = double_9.y1;
        if (this.d_gridlines != 0) {
            double_13.y = this.ymin;
        }
        double_13.y = (this.ymin + this.ymax) / 2.0;
        double_13.x = this.xmin;
        this.transform.transform(double_13, double_13);
    }

    private void drawLabels(Graphics2D graphics2D) {
        int n;
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        ((DecimalFormat)numberFormat).applyPattern("0.00E00");
        Point2D.Double double_ = new Point2D.Double();
        int n2 = (int)((this.xmax - this.xmin) / this.xinc);
        double d = 0.0;
        int n3 = 0;
        float f = 8.0f * this.d_size;
        if (this.ymax <= 0.0) {
            d = this.ymax;
            n3 = 3;
            f = -f;
        } else if (this.ymin > 0.0 || this.d_gridlines != 0) {
            d = this.ymin;
        }
        if (this.d_axisTimeFormat != null) {
            graphics2D.setFont(new Font("SansSerif", 0, (int)(10.0f * this.d_size)));
            for (n = 0; n <= n2; ++n) {
                double_.x = this.xmin + (double)n * this.xinc;
                double_.y = d;
                this.transform.transform(double_, double_);
                this.drawText(graphics2D, this.d_axisTimeFormat.format(new Date((long)(this.xmin + (double)n * this.xinc))), (float)double_.x, (float)double_.y + f, n3);
            }
        } else {
            graphics2D.setFont(new Font("SansSerif", 0, (int)(14.0f * this.d_size)));
            for (n = 0; n <= n2; ++n) {
                double_.x = this.xmin + (double)n * this.xinc;
                double_.y = d;
                this.transform.transform(double_, double_);
                this.drawText(graphics2D, Global.formatGraph(this.xmin + (double)n * this.xinc), (float)double_.x, (float)double_.y + f, n3);
            }
        }
        n2 = (int)((this.ymax - this.ymin) / this.yinc);
        double d2 = 0.0;
        n3 = 2;
        f = -10.0f * this.d_size;
        if (this.xmax < 0.0) {
            d2 = this.xmax;
            n3 = 1;
            f = -f;
        } else if (this.xmin > 0.0 || this.d_gridlines != 0) {
            d2 = this.xmin;
        }
        for (int i = 0; i <= n2; ++i) {
            double_.x = d2;
            double_.y = this.ymin + (double)i * this.yinc;
            this.transform.transform(double_, double_);
            this.drawText(graphics2D, Global.formatGraph(this.ymin + (double)i * this.yinc), (float)double_.x + f, (float)double_.y, n3);
        }
        double_.x = (this.xmin + this.xmax) / 2.0;
        double_.y = this.ymin;
        this.transform.transform(double_, double_);
        graphics2D.setFont(new Font("SansSerif", 0, (int)(18.0f * this.d_size)));
        this.drawText(graphics2D, this.d_xTitle, (float)double_.x, (float)double_.y + 25.0f * this.d_size, 0);
        double_.y = (this.ymin + this.ymax) / 2.0;
        double_.x = this.xmin;
        this.transform.transform(double_, double_);
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
        affineTransform2.rotate(-1.5707963267948966, double_.x, double_.y);
        graphics2D.setTransform(affineTransform2);
        this.drawText(graphics2D, this.d_yTitle, (float)double_.x, (float)(double_.y - (double)(75.0f * this.d_size)), 3);
        graphics2D.setTransform(affineTransform);
    }

    private void drawText(Graphics2D graphics2D, String string, float f, float f2, int n) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.getAscent();
        int n3 = fontMetrics.stringWidth(string);
        switch (n) {
            case 0: {
                f = (int)((double)f - (double)n3 / 2.0);
                f2 += (float)n2;
                break;
            }
            case 1: {
                f2 += (float)((int)((double)n2 / 2.0));
                break;
            }
            case 2: {
                f -= (float)n3;
                f2 += (float)((int)((double)n2 / 2.0));
                break;
            }
            case 3: {
                f -= (float)((int)((double)n3 / 2.0));
            }
        }
        graphics2D.drawString(string, f, f2);
    }

    public void drawAnnotation(Graphics2D graphics2D, Annotation annotation) {
        if (this.inverse == null) {
            return;
        }
        double d = annotation.point.getX();
        double d2 = annotation.point.getY();
        double d3 = 6.0;
        double d4 = Math.abs(this.inverse.getScaleX() * d3);
        double d5 = Math.abs(this.inverse.getScaleY() * d3);
        Arc2D.Double double_ = new Arc2D.Double(d - d4, d2 - d5, 2.0 * d4, 2.0 * d5, 0.0, 360.0, 0);
        d3 = 4.0;
        d4 = Math.abs(this.inverse.getScaleX() * d3);
        d5 = Math.abs(this.inverse.getScaleY() * d3);
        Arc2D.Double double_2 = new Arc2D.Double(d - d4, d2 - d5, 2.0 * d4, 2.0 * d5, 0.0, 360.0, 0);
        AffineTransform affineTransform = new AffineTransform(graphics2D.getTransform());
        graphics2D.transform(this.transform);
        graphics2D.setColor(SystemColor.window);
        graphics2D.fill(double_);
        graphics2D.setColor(annotation.color);
        graphics2D.fill(double_2);
        graphics2D.setTransform(affineTransform);
        graphics2D.setFont(new Font("Monospaced", 0, (int)(18.0 * Math.min(0.8, (double)this.d_size))));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(annotation.text, graphics2D);
        graphics2D.setColor(SystemColor.windowText);
        Point2D.Double double_3 = new Point2D.Double(d, d2);
        this.transform.transform(double_3, double_3);
        graphics2D.drawString(annotation.text, (float)(((Point2D)double_3).getX() - rectangle2D.getWidth() / 2.0), (float)(((Point2D)double_3).getY() - rectangle2D.getHeight() / 2.0));
    }

    public void drawLegend(Graphics2D graphics2D) {
        if (this.series.isEmpty()) {
            return;
        }
        int n = 0;
        graphics2D.setFont(new Font("Monospaced", 0, (int)(18.0 * Math.min(0.8, (double)this.d_size))));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        for (Series series : this.series) {
            n = Math.max(n, fontMetrics.stringWidth(series.getName()));
        }
        int n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 6;
        int n3 = this.getWidth() - 12 - n;
        int n4 = (int)(10.0f * this.d_size) + 2 * n2;
        int n5 = 40;
        for (Series series : this.series) {
            graphics2D.setStroke(this.getStroke(series));
            graphics2D.setColor(series.getColor());
            Line2D.Double double_ = new Line2D.Double(n3, n4 + n2 / 2, n3 + n5, n4 + n2 / 2);
            graphics2D.draw(double_);
            graphics2D.setColor(SystemColor.windowText);
            this.drawText(graphics2D, series.getName(), n3, n4, 1);
            n4 += n2;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.d_size = (float)this.getWidth() / 800.0f;
        this.updateTransform();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.addRenderingHints(this.AA_OFF);
        graphics2D.setColor(SystemColor.window);
        graphics2D.fill(new Rectangle(this.getSize()));
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
        graphics2D.setColor(SystemColor.windowText);
        Point2D.Double double_2 = new Point2D.Double(this.xmin, this.ymin);
        this.transform.transform(double_2, double_2);
        double_2.x = this.xmax;
        double_2.y = this.ymax;
        this.transform.transform(double_2, double_2);
        if (this.d_gridlines != 0) {
            graphics2D.setPaint(Color.gray);
            this.drawGridlines(graphics2D);
            graphics2D.setPaint(Color.black);
            graphics2D.draw(this.transform.createTransformedShape(double_));
        }
        graphics2D.setStroke(new BasicStroke(2.0f));
        this.drawAxes(graphics2D);
        graphics2D.addRenderingHints(this.AA_ON);
        graphics2D.setPaint(Color.blue);
        graphics2D.setStroke(new BasicStroke(1.0f));
        for (Series object : this.series) {
            this.drawSeries(graphics2D, object);
            this.drawMarkers(graphics2D, object);
        }
        graphics2D.addRenderingHints(this.AA_OFF);
        graphics2D.setPaint(Color.black);
        this.drawLabels(graphics2D);
        graphics2D.setFont(new Font("SansSerif", 0, (int)(24.0f * this.d_size)).deriveFont(1));
        this.drawText(graphics2D, this.d_title, (float)((double)this.getSize().width / 2.0), 10.0f * this.d_size, 0);
        for (Annotation annotation : this.d_annotations) {
            this.drawAnnotation(graphics2D, annotation);
        }
        if (this.d_showLegend) {
            this.drawLegend(graphics2D);
        }
    }

    public void setTitle(String string) {
        this.d_title = string;
    }

    public void setXTitle(String string) {
        this.d_xTitle = string;
    }

    public void setYTitle(String string) {
        this.d_yTitle = string;
    }

    private int getAutoMarkStyle(Series series) {
        return this.markers[series.getId() % this.markers.length];
    }

    private Color getAutoColor(Series series) {
        if (this.d_autoMode == 1) {
            return this.colors[0];
        }
        return this.colors[series.getId() % this.colors.length];
    }

    private int getAutoLineStyle(Series series) {
        if (this.d_autoMode == 0) {
            return 0;
        }
        if (this.d_autoMode == 1) {
            return this.styles[series.getId() % this.styles.length];
        }
        return this.styles[series.getId() / this.colors.length % this.styles.length];
    }

    private int getAutoWeight(Series series) {
        if (this.d_autoMode == 0) {
            return this.weights[series.getId() / this.colors.length % this.weights.length];
        }
        if (this.d_autoMode == 1) {
            return this.weights[series.getId() / this.styles.length % this.weights.length];
        }
        return this.weights[series.getId() / this.colors.length / this.styles.length % this.weights.length];
    }

    public boolean pickPoint(int n, int n2, int n3, PickPointVal pickPointVal) {
        assert (pickPointVal != null);
        Point2D.Double double_ = new Point2D.Double(n, n2);
        Point2D.Double double_2 = new Point2D.Double();
        Point2D.Double double_3 = null;
        try {
            this.inverse.transform(double_, double_2);
            double_3 = new Point2D.Double(this.inverse.getScaleX() * (double)n3, this.inverse.getScaleY() * (double)n3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        double d = double_3.distance(0.0, 0.0);
        Series series = null;
        int n4 = -1;
        for (Series series2 : this.series) {
            double[] dArray = series2.getX();
            double[] dArray2 = series2.getY();
            for (int i = 0; i < dArray.length; ++i) {
                double d2 = double_2.distance(dArray[i], dArray2[i]);
                if (!(d2 <= d)) continue;
                d = d2;
                series = series2;
                n4 = i;
            }
        }
        if (series != null) {
            pickPointVal.series = series;
            pickPointVal.i = n4;
            return true;
        }
        return false;
    }

    public static class Annotation {
        public final String text;
        public final Point2D point;
        public final Color color;

        public Annotation(String string, Point2D point2D, Color color) {
            this.text = string;
            this.point = point2D;
            this.color = color;
        }
    }

    public static class PickPointVal {
        public Series series = null;
        public int i = -1;
    }
}

