/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiCheckBox;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiPanel;

public class CkBoxListPanel
extends guiPanel {
    private static final long serialVersionUID = 4512186325580864763L;
    private final JTree d_tree = new JTree();
    private int d_overRow;
    private int d_mouseDown;
    private int d_mouseUp;
    private boolean[] d_selected;

    public CkBoxListPanel() {
        this.d_tree.getInputMap().put(KeyStroke.getKeyStroke(65, 2), new Object());
        this.d_tree.getInputMap().put(KeyStroke.getKeyStroke(67, 2), new Object());
        this.d_overRow = -1;
        this.d_mouseDown = -1;
        this.d_mouseUp = -1;
        this.d_selected = new boolean[0];
        this.d_tree.setRootVisible(false);
        this.d_tree.setCellRenderer(new LayerCkRenderer(this.d_tree.getBackground()));
        MouseHandler mouseHandler = new MouseHandler(this.d_tree);
        this.d_tree.addMouseListener(mouseHandler);
        this.d_tree.addMouseMotionListener(mouseHandler);
        JScrollPane jScrollPane = new JScrollPane(this.d_tree);
        jScrollPane.setPreferredSize(new Dimension(115, 0));
        this.setLayout(new GridBagLayout());
        GridBagUtil.add(this, jScrollPane, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0);
    }

    public void setItems(Object[] objectArray) {
        this.d_selected = new boolean[objectArray.length];
        Arrays.fill(this.d_selected, false);
        Node node = new Node("root");
        for (Object object : objectArray) {
            node.add(new Node(object.toString()));
        }
        this.d_tree.setModel(new DefaultTreeModel(node));
    }

    public JTree getTree() {
        return this.d_tree;
    }

    public void setSelectedAll(boolean bl) {
        for (int i = 0; i < this.d_selected.length; ++i) {
            this.setSelected(i, bl);
        }
    }

    public void setSelected(int n, boolean bl) {
        if (this.d_selected[n] != bl) {
            this.toggleSelected(n);
        }
    }

    private void toggleSelected(int n) {
        if (0 <= n && n < this.d_selected.length) {
            this.d_selected[n] = !this.d_selected[n];
            int n2 = this.d_selected[n] ? 0 : 1;
            this.d_comm.touch(new EvtMessage(n2, n));
        }
    }

    public boolean isSelected(int n) {
        if (n < 0 || this.d_selected.length <= n) {
            return false;
        }
        return this.d_selected[n];
    }

    public static class EvtMessage {
        public static final int TYPE_SELECTED = 0;
        public static final int TYPE_DESELECTED = 1;
        public final int type;
        public final int row;

        public EvtMessage(int n, int n2) {
            this.type = n;
            this.row = n2;
        }
    }

    private class LayerCkRenderer
    extends guiCheckBox
    implements TreeCellRenderer {
        private static final long serialVersionUID = 2256570908673749505L;

        public LayerCkRenderer(Color color) {
            super("");
            Insets insets = this.getMargin();
            insets.left = 3;
            this.setMargin(insets);
            this.setBackground(color);
            this.setBorderPaintedFlat(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.setText(object.toString());
            this.getModel().setRollover(CkBoxListPanel.this.d_mouseDown != n && CkBoxListPanel.this.d_overRow == n);
            this.getModel().setArmed(CkBoxListPanel.this.d_mouseDown == n && CkBoxListPanel.this.d_overRow == n);
            this.getModel().setPressed(CkBoxListPanel.this.d_mouseDown == n && CkBoxListPanel.this.d_overRow == n);
            this.getModel().setSelected(CkBoxListPanel.this.isSelected(n));
            return this;
        }
    }

    private class MouseHandler
    implements MouseMotionListener,
    MouseListener {
        private final JTree d_tree;

        public MouseHandler(JTree jTree) {
            this.d_tree = jTree;
        }

        private void over(int n, int n2) {
            CkBoxListPanel.this.d_overRow = this.d_tree.getRowForLocation(n, n2);
            this.d_tree.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.over(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.over(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                CkBoxListPanel.this.d_mouseDown = this.d_tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                CkBoxListPanel.this.d_mouseUp = -1;
                this.d_tree.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                CkBoxListPanel.this.d_mouseUp = this.d_tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (CkBoxListPanel.this.d_mouseUp >= 0 && CkBoxListPanel.this.d_mouseUp == CkBoxListPanel.this.d_mouseDown) {
                    CkBoxListPanel.this.toggleSelected(CkBoxListPanel.this.d_mouseUp);
                }
                CkBoxListPanel.this.d_mouseDown = -1;
                this.d_tree.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.over(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private static class Node
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 5152471108485842346L;

        public Node() {
        }

        public Node(Object object) {
            super(object);
        }

        public Node(Object object, boolean bl) {
            super(object, bl);
        }
    }
}

