/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.IDnDTreeModel;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public abstract class AbstractDnDTree
extends JTree
implements DragGestureListener,
DropTargetListener,
DragSourceListener {
    private static final long serialVersionUID = -6453938749789904326L;
    private static final Container CONTAINER = new Container();
    private static final Rectangle ICON_BOUNDS = new Rectangle();
    private static final int ON_ICON = 0;
    private static final int ABOVE = 1;
    private static final int INSIDE = 2;
    private static final int BELOW = 3;
    private static final DataFlavor FLAVOR_OBJ_ARR = new DataFlavor(Object[].class, "Objects in PyroSim's Tree");
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{FLAVOR_OBJ_ARR};
    private final Composite ALPHA_COMPOSITE = AlphaComposite.getInstance(3, 0.8f);
    private final List d_renderNodes;
    private final Point d_mouseDown = new Point();
    private final Point d_mouseCurrent = new Point();
    private final Timer d_hover;
    private boolean d_hoverFeedback;
    private boolean d_canHover = true;
    private IDnDTreeModel.IDragPacket d_dragPacket;
    private Object d_dropTarget = null;
    private int d_dropIndex = -1;
    private boolean d_dropped = false;
    private final DragSource d_dragSource;
    private TreePath d_lastPath = null;
    private final Comparator d_sorter;
    private boolean d_selectParentOnCollapse = true;

    public AbstractDnDTree(IDnDTreeModel iDnDTreeModel) {
        super(iDnDTreeModel);
        this.d_renderNodes = new ArrayList();
        this.d_sorter = new PathSorter();
        this.d_dragSource = DragSource.getDefaultDragSource();
        this.d_dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        new DropTarget(this, this);
        this.d_hover = new HoverTimer();
        new MultiSelectHack(this);
    }

    public void setSelectNodeOnCollapse(boolean bl) {
        this.d_selectParentOnCollapse = bl;
    }

    public boolean selectNodeOnCollapse() {
        return this.d_selectParentOnCollapse;
    }

    @Override
    public void collapsePath(TreePath treePath) {
        if (this.d_selectParentOnCollapse) {
            super.collapsePath(treePath);
        } else {
            TreeSelectionModel treeSelectionModel = this.getSelectionModel();
            this.setSelectionModel(null);
            super.collapsePath(treePath);
            this.setSelectionModel(treeSelectionModel);
        }
    }

    @Override
    public void collapseRow(int n) {
        if (this.d_selectParentOnCollapse) {
            super.collapseRow(n);
        } else {
            TreeSelectionModel treeSelectionModel = this.getSelectionModel();
            this.setSelectionModel(null);
            super.collapseRow(n);
            this.setSelectionModel(treeSelectionModel);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.getDnDModel().isDragging()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(this.ALPHA_COMPOSITE);
        int n = this.d_mouseCurrent.x - this.d_mouseDown.x;
        int n2 = this.d_mouseCurrent.y - this.d_mouseDown.y;
        for (int i = 0; i < this.d_renderNodes.size(); ++i) {
            Image image = ((RenderNode)this.d_renderNodes.get((int)i)).nodeImg;
            Rectangle rectangle = ((RenderNode)this.d_renderNodes.get((int)i)).bounds;
            graphics2D.drawImage(image, rectangle.x + n, rectangle.y + n2, this);
        }
        if (this.d_dropIndex >= 0) {
            Object object;
            int n3;
            TreePath treePath = this.getSelectionModel().getSelectionPath();
            int n4 = this.getModel().getChildCount(this.d_dropTarget);
            if (n4 == 0) {
                n3 = this.getRowForPath(treePath) + 1;
            } else if (n4 <= this.d_dropIndex) {
                object = this.getModel().getChild(this.d_dropTarget, this.d_dropIndex - 1);
                TreePath treePath2 = treePath.pathByAddingChild(object);
                n3 = this.getRowForPath(treePath2) + 1;
            } else {
                object = this.getModel().getChild(this.d_dropTarget, this.d_dropIndex);
                TreePath treePath3 = treePath.pathByAddingChild(object);
                n3 = this.getRowForPath(treePath3);
            }
            int n5 = n3 * this.getRowHeight();
            graphics.setColor(Color.BLACK);
            graphics.drawLine(0, n5, this.getWidth(), n5);
        }
        if (this.d_hoverFeedback) {
            graphics.setColor(Color.RED);
            graphics2D.draw(this.getExpandedIconBounds(this.d_lastPath));
        }
        graphics2D.setComposite(composite);
    }

    public IDnDTreeModel getDnDModel() {
        return (IDnDTreeModel)this.getModel();
    }

    protected IDnDTreeModel.IDragPacket prepareDragPacket() {
        TreeSelectionModel treeSelectionModel = this.getSelectionModel();
        TreePath[] treePathArray = treeSelectionModel.getSelectionPaths();
        Arrays.sort(treePathArray, this.d_sorter);
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        Rectangle rectangle = this.getVisibleRect();
        int n = Math.max(0, rectangle.y - rectangle.height);
        int n2 = rectangle.y + rectangle.height * 2;
        List<TreePath> list = Arrays.asList(treePathArray);
        for (int i = 0; i < treePathArray.length; ++i) {
            Rectangle rectangle2 = this.getPathBounds(treePathArray[i]);
            if (rectangle2 == null) continue;
            int n3 = rectangle2.y;
            int n4 = rectangle2.y + rectangle2.height;
            if (n3 >= n2 || n4 <= n) continue;
            Component component = treeCellRenderer.getTreeCellRendererComponent(this, treePathArray[i].getLastPathComponent(), false, false, false, 0, false);
            this.d_renderNodes.add(new RenderNode(component, rectangle2));
        }
        return this.getDnDModel().preparePacket(list);
    }

    public Rectangle getExpandedIconBounds(TreePath treePath) {
        BasicTreeUI basicTreeUI = (BasicTreeUI)this.getUI();
        Rectangle rectangle = this.getPathBounds(treePath);
        if (rectangle == null) {
            ICON_BOUNDS.setBounds(0, 0, 0, 0);
            return ICON_BOUNDS;
        }
        int n = basicTreeUI.getExpandedIcon().getIconWidth() + 1;
        int n2 = basicTreeUI.getExpandedIcon().getIconHeight() + 1;
        int n3 = rectangle.x - basicTreeUI.getRightChildIndent() - n / 2 + 1;
        int n4 = rectangle.y + n2 / 2 - 2;
        ICON_BOUNDS.setBounds(n3, n4, n, n2);
        return ICON_BOUNDS;
    }

    private int getCursorPos(TreePath treePath, Point point) {
        Rectangle rectangle = this.getPathBounds(treePath);
        if (this.getExpandedIconBounds(treePath).contains(point)) {
            return 0;
        }
        if (rectangle.y + rectangle.height / 3 > point.y) {
            return 1;
        }
        if (rectangle.y + 2 * (rectangle.height / 3) < point.y) {
            return 3;
        }
        return 2;
    }

    public TreePath getExtendedPathForLocation(int n, int n2) {
        TreePath treePath = this.getClosestPathForLocation(n, n2);
        Rectangle rectangle = this.getPathBounds(treePath);
        if (rectangle.contains(n, n2)) {
            return treePath;
        }
        if (this.getModel().isLeaf(treePath.getLastPathComponent())) {
            return null;
        }
        Rectangle rectangle2 = this.getExpandedIconBounds(treePath);
        if (rectangle2.contains(n, n2)) {
            return treePath;
        }
        return null;
    }

    public Pair<TreePath, Boolean> getExtendedPathForLocationEx(int n, int n2) {
        TreePath treePath = this.getClosestPathForLocation(n, n2);
        Rectangle rectangle = this.getPathBounds(treePath);
        if (rectangle.contains(n, n2)) {
            return new Pair<TreePath, Boolean>(treePath, Boolean.FALSE);
        }
        if (this.getModel().isLeaf(treePath.getLastPathComponent())) {
            return null;
        }
        Rectangle rectangle2 = this.getExpandedIconBounds(treePath);
        if (rectangle2.contains(n, n2)) {
            return new Pair<TreePath, Boolean>(treePath, Boolean.TRUE);
        }
        return null;
    }

    public boolean isOverExpansionIcon(TreePath treePath, int n, int n2) {
        Rectangle rectangle = this.getExpandedIconBounds(treePath);
        return rectangle.contains(n, n2);
    }

    protected boolean isOwnParent(List list, TreePath treePath) {
        for (int i = 0; i < list.size(); ++i) {
            if (!((TreePath)list.get(i)).isDescendant(treePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        TreeSelectionModel treeSelectionModel = this.getSelectionModel();
        TreePath[] treePathArray = treeSelectionModel.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return;
        }
        this.d_mouseDown.setLocation(dragGestureEvent.getDragOrigin());
        this.d_mouseCurrent.setLocation(dragGestureEvent.getDragOrigin());
        TreePath treePath = this.getPathForLocation(this.d_mouseDown.x, this.d_mouseDown.y);
        if (treePath == null || !this.getSelectionModel().isPathSelected(treePath)) {
            return;
        }
        Object[] objectArray = new Object[treePathArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = treePathArray[i].getLastPathComponent();
        }
        Cursor cursor = this.selectCursor(dragGestureEvent.getDragAction());
        TransferAdapter transferAdapter = new TransferAdapter(objectArray);
        this.d_dragSource.startDrag(dragGestureEvent, cursor, transferAdapter, this);
        this.d_dragPacket = this.prepareDragPacket();
        this.getDnDModel().setDragging(true);
        this.getSelectionModel().clearSelection();
    }

    private Cursor selectCursor(int n) {
        switch (n) {
            case 2: {
                return DragSource.DefaultMoveDrop;
            }
        }
        return Cursor.getDefaultCursor();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.d_mouseCurrent.setLocation(dropTargetDragEvent.getLocation());
        TreePath treePath = this.getClosestPathForLocation(this.d_mouseCurrent.x, this.d_mouseCurrent.y);
        if (this.d_lastPath == null || treePath.getLastPathComponent() != this.d_lastPath.getLastPathComponent()) {
            this.d_lastPath = treePath;
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (!this.getDnDModel().canDrop(this.d_dragPacket, this.d_dropTarget)) {
            return;
        }
        this.d_hover.stop();
        if (this.d_dropIndex >= 0) {
            this.getDnDModel().drop(this.d_dragPacket, this.d_dropTarget, this.d_dropIndex);
        } else {
            this.getDnDModel().drop(this.d_dragPacket, this.d_dropTarget);
        }
        this.d_dropped = true;
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        Object object = this.d_lastPath.getLastPathComponent();
        Object object2 = this.d_lastPath.getPath()[this.d_lastPath.getPathCount() - 2];
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        if (this.getModel().isLeaf(object) && !this.getDnDModel().isLeafDroppable(object)) {
            this.dragOverLeaf(dragSourceContext, object2, object, this.d_mouseCurrent.x, this.d_mouseCurrent.y);
        } else {
            this.dragOverNonLeaf(dragSourceContext, object2, object, this.d_mouseCurrent.x, this.d_mouseCurrent.y);
        }
        this.autoscroll(this.d_mouseCurrent);
        this.repaint();
    }

    private void dragOverLeaf(DragSourceContext dragSourceContext, Object object, Object object2, int n, int n2) {
        boolean bl;
        boolean bl2 = this.getDnDModel().canDrop(this.d_dragPacket, object);
        Rectangle rectangle = this.getPathBounds(this.d_lastPath);
        boolean bl3 = bl = this.d_mouseCurrent.y > rectangle.y + rectangle.height / 2;
        if (bl2) {
            this.d_dropTarget = object;
            this.d_dropIndex = this.getModel().getIndexOfChild(object, object2);
            if (bl) {
                ++this.d_dropIndex;
            }
            this.getSelectionModel().setSelectionPath(this.d_lastPath.getParentPath());
            dragSourceContext.setCursor(DragSource.DefaultMoveDrop);
        } else {
            this.d_dropTarget = null;
            this.d_dropIndex = -1;
            this.getSelectionModel().clearSelection();
            dragSourceContext.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    private void dragOverNonLeaf(DragSourceContext dragSourceContext, Object object, Object object2, int n, int n2) {
        TreePath treePath;
        block17: {
            int n3;
            block16: {
                n3 = this.getCursorPos(this.d_lastPath, this.d_mouseCurrent);
                if (!this.isExpanded(this.d_lastPath)) break block16;
                switch (n3) {
                    case 0: {
                        this.d_dropTarget = object2;
                        this.d_dropIndex = -1;
                        treePath = this.d_lastPath;
                        if (this.d_hover.isRunning()) break block17;
                        this.d_hover.restart();
                        break block17;
                    }
                    case 1: {
                        this.d_dropTarget = object;
                        this.d_dropIndex = this.getModel().getIndexOfChild(object, object2);
                        treePath = this.d_lastPath.getParentPath();
                        this.d_hover.stop();
                        break block17;
                    }
                    case 2: {
                        this.d_dropTarget = object2;
                        this.d_dropIndex = -1;
                        treePath = this.d_lastPath;
                        this.d_hover.stop();
                        break block17;
                    }
                    case 3: {
                        this.d_dropTarget = object2;
                        this.d_dropIndex = 0;
                        treePath = this.d_lastPath;
                        this.d_hover.stop();
                        break block17;
                    }
                    default: {
                        treePath = null;
                        assert (false);
                        break block17;
                    }
                }
            }
            switch (n3) {
                case 0: {
                    this.d_dropTarget = object2;
                    this.d_dropIndex = -1;
                    treePath = this.d_lastPath;
                    if (this.d_hover.isRunning()) break;
                    this.d_hover.restart();
                    break;
                }
                case 1: {
                    this.d_dropTarget = object;
                    this.d_dropIndex = this.getModel().getIndexOfChild(object, object2);
                    treePath = this.d_lastPath.getParentPath();
                    this.d_hover.stop();
                    break;
                }
                case 2: {
                    this.d_dropTarget = object2;
                    this.d_dropIndex = -1;
                    treePath = this.d_lastPath;
                    this.d_hover.stop();
                    break;
                }
                case 3: {
                    this.d_dropTarget = object;
                    this.d_dropIndex = this.getModel().getIndexOfChild(object, object2) + 1;
                    treePath = this.d_lastPath.getParentPath();
                    this.d_hover.stop();
                    break;
                }
                default: {
                    treePath = null;
                    assert (false);
                    break;
                }
            }
        }
        if (this.getDnDModel().canDrop(this.d_dragPacket, this.d_dropTarget)) {
            this.getSelectionModel().setSelectionPath(treePath);
            dragSourceContext.setCursor(DragSource.DefaultMoveDrop);
        } else {
            this.getSelectionModel().clearSelection();
            this.d_dropTarget = null;
            this.d_dropIndex = -1;
            dragSourceContext.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        DragSourceContext dragSourceContext = dragSourceEvent.getDragSourceContext();
        dragSourceContext.setCursor(DragSource.DefaultMoveNoDrop);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        ArrayList<TreePath> arrayList;
        IDnDTreeModel.IDragPacket iDragPacket = this.d_dragPacket;
        Object object = this.d_dropTarget;
        TreePath treePath = this.d_lastPath;
        boolean bl = this.d_dropped;
        this.d_dropTarget = null;
        this.d_dropIndex = -1;
        this.d_renderNodes.clear();
        this.d_dragPacket = null;
        this.d_dropIndex = -1;
        this.d_dropTarget = null;
        this.d_dropped = false;
        this.getSelectionModel().clearSelection();
        this.getDnDModel().setDragging(false);
        if (!bl) {
            arrayList = iDragPacket.getSelectedPaths();
        } else if (treePath != null) {
            Iterator<? extends TreePath> iterator;
            ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
            for (int i = 0; i < treePath.getPathCount() && (iterator = treePath.getPathComponent(i)) != object; ++i) {
                arrayDeque.addLast(iterator);
            }
            arrayDeque.addLast(object);
            ArrayList<TreePath> arrayList2 = new ArrayList<TreePath>(iDragPacket.getSelectedPaths().size());
            for (TreePath treePath2 : iDragPacket.getSelectedPaths()) {
                Object object2 = treePath2.getLastPathComponent();
                arrayDeque.addLast(object2);
                arrayList2.add(new TreePath(arrayDeque.toArray(new Object[arrayDeque.size()])));
                arrayDeque.removeLast();
            }
            arrayList = arrayList2;
        } else {
            arrayList = Collections.EMPTY_LIST;
        }
        this.getSelectionModel().setSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
        this.repaint();
    }

    private void autoscroll(Point point) {
        boolean bl;
        int n = this.getClosestRowForLocation(point.x, point.y);
        if (n < 0 || n == 0 || n >= this.getRowCount()) {
            return;
        }
        boolean bl2 = bl = point.y + this.getBounds().y <= 12;
        if (bl) {
            this.scrollRowToVisible(n - 1);
        } else {
            this.scrollRowToVisible(n + 1);
        }
    }

    private class PathSorter
    implements Comparator<TreePath> {
        private PathSorter() {
        }

        @Override
        public int compare(TreePath treePath, TreePath treePath2) {
            int n = AbstractDnDTree.this.getRowForPath(treePath);
            int n2 = AbstractDnDTree.this.getRowForPath(treePath2);
            return n - n2;
        }
    }

    private class MultiSelectHack
    extends MouseAdapter {
        public MultiSelectHack(JTree jTree) {
            int n;
            MouseListener[] mouseListenerArray = jTree.getMouseListeners();
            for (n = 0; n < mouseListenerArray.length; ++n) {
                jTree.removeMouseListener(mouseListenerArray[n]);
            }
            jTree.addMouseListener(this);
            for (n = 0; n < mouseListenerArray.length; ++n) {
                jTree.addMouseListener(mouseListenerArray[n]);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                if (mouseEvent.isControlDown()) {
                    return;
                }
                TreePath[] treePathArray = ((JTree)mouseEvent.getSource()).getSelectionPaths();
                if (treePathArray == null || treePathArray.length == 0) {
                    return;
                }
                TreePath treePath = AbstractDnDTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                boolean bl = false;
                for (int i = 0; i < treePathArray.length && !bl; ++i) {
                    bl = treePathArray[i].equals(treePath);
                }
                if (bl) {
                    mouseEvent.consume();
                }
            }
        }
    }

    private class HoverTimerListener
    implements ActionListener {
        private HoverTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AbstractDnDTree.this.isExpanded(AbstractDnDTree.this.d_lastPath)) {
                AbstractDnDTree.this.collapsePath(AbstractDnDTree.this.d_lastPath);
            } else {
                AbstractDnDTree.this.expandPath(AbstractDnDTree.this.d_lastPath);
            }
        }
    }

    private class HoverTimer
    extends Timer {
        private static final long serialVersionUID = 8772719953158351347L;

        public HoverTimer() {
            super(1000, new HoverTimerListener());
            this.setRepeats(false);
        }

        @Override
        public void restart() {
            if (AbstractDnDTree.this.d_canHover) {
                super.restart();
                AbstractDnDTree.this.d_hoverFeedback = true;
                AbstractDnDTree.this.d_canHover = false;
            }
        }

        @Override
        public void stop() {
            super.stop();
            AbstractDnDTree.this.d_hoverFeedback = false;
            AbstractDnDTree.this.d_canHover = true;
        }
    }

    private class TransferAdapter
    implements Transferable {
        private final Object d_obj;

        public TransferAdapter(Object object) {
            this.d_obj = object;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.equals(FLAVOR_OBJ_ARR);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return this.d_obj;
        }
    }

    private class RenderNode {
        public final Image nodeImg;
        public final Rectangle bounds;

        public RenderNode(Component component, Rectangle rectangle) {
            int n = component.getPreferredSize().width;
            int n2 = component.getPreferredSize().height;
            this.nodeImg = new BufferedImage(n, n2, 2);
            Graphics graphics = this.nodeImg.getGraphics();
            SwingUtilities.paintComponent(graphics, component, CONTAINER, 0, 0, n, n2);
            component.paint(graphics);
            graphics.dispose();
            this.bounds = rectangle;
        }
    }
}

