/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.test;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.vecmath.Matrix4d;
import junit.framework.TestCase;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyLine;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ShapeGeom;

public class GeomTest
extends TestCase {
    protected void setUp() throws Exception {
    }

    public void testMirrorAABoxGeom() {
    }

    public void testScale() {
    }

    public void testAreaShapeGeom() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 200.0, 100.0);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(50.0, 25.0, 100.0, 50.0);
        Area area = new Area(double_);
        area.subtract(new Area(double_2));
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        ShapeGeom shapeGeom = new ShapeGeom((Shape)area, matrix4d);
        GeomTest.assertSame((Object)1, (Object)shapeGeom.getNumPrims(1));
        List<IPrimitive> list = GeomUtil.explodeToTypes(shapeGeom, 1);
        GeomTest.assertSame((Object)1, (Object)list.size());
        GeomTest.assertTrue((boolean)(list.get(0) instanceof IFace));
        IFace iFace = (IFace)list.get(0);
        GeomTest.assertTrue((boolean)(iFace instanceof IPolygon));
        IPolygon iPolygon = (IPolygon)iFace;
        GeomTest.assertSame((Object)2, (Object)iPolygon.getNumLoops());
    }

    public void testGeneralShapeGeom() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 200.0, 100.0);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(50.0, 25.0, 100.0, 50.0);
        Path2D.Double double_3 = new Path2D.Double(double_);
        double_3.append(double_2, false);
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        ShapeGeom shapeGeom = new ShapeGeom((Shape)double_3, matrix4d);
        GeomTest.assertSame((Object)2, (Object)shapeGeom.getNumPrims(2));
        List<IPrimitive> list = GeomUtil.explodeToTypes(shapeGeom, 2);
        GeomTest.assertSame((Object)2, (Object)list.size());
        GeomTest.assertTrue((list.get(0) instanceof PolyLine && list.get(1) instanceof ICurve ? 1 : 0) != 0);
        PolyLine polyLine = (PolyLine)list.get(0);
        GeomTest.assertSame((Object)5, (Object)polyLine.verts.length);
    }
}

