/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.AExtrudeHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ILinearCurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Quad;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.TransformedGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.LineConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import thunderheadeng.geometry.objs.ClosedLinearCurve;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.WallGeom;

public class WallGeom
implements IGeom,
IManipulatable {
    private static final long serialVersionUID = 1L;
    private static final double NONLINEAR_CURVE_TOL = 0.001;
    public final ICurve refCurve;
    public final Alignment alignment;
    public final double thickness;
    public final double height;
    private transient Point3d[] d_refCurveVerts;

    public WallGeom(ICurve iCurve, Alignment alignment, double d, double d2) {
        this.refCurve = iCurve;
        this.alignment = alignment;
        this.thickness = d;
        this.height = d2;
        this.d_refCurveVerts = null;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        WallGeom.Alignment alignment;
        switch (this.alignment) {
            case CENTER: {
                alignment = WallGeom.Alignment.CENTER;
                break;
            }
            case LEFT: {
                alignment = WallGeom.Alignment.LEFT;
                break;
            }
            default: {
                alignment = WallGeom.Alignment.RIGHT;
            }
        }
        thunderheadeng.geometry.objs.ICurve iCurve = (thunderheadeng.geometry.objs.ICurve)legacyDictionary_2012_1.get(this.refCurve);
        Point3d[] point3dArray = this.getReferenceVerts();
        if (this.isWrapped(point3dArray)) {
            iCurve = new ClosedLinearCurve(new PolyLine(point3dArray));
        }
        thunderheadeng.geometry.objs.WallGeom wallGeom = new thunderheadeng.geometry.objs.WallGeom(iCurve, alignment, this.thickness, this.height);
        assert (wallGeom.getNumPrims(7) == this.getNumPrims(7));
        return wallGeom;
    }

    @Override
    public WallGeom optimize(IPointOptimizer iPointOptimizer) {
        ICurve iCurve = this.refCurve.optimize(iPointOptimizer);
        if (iCurve == this.refCurve) {
            return this;
        }
        return new WallGeom(iCurve, this.alignment, this.thickness, this.height);
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(this.generateVerts());
        return aABox;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IGeom transform(Matrix4d matrix4d, IGeom.XformOp xformOp) {
        switch (xformOp) {
            case RETAINED: {
                return new TransformedGeom(matrix4d, this);
            }
        }
        return this.toMesh(matrix4d);
    }

    public boolean isWrapped() {
        return this.isWrapped(this.getReferenceVerts());
    }

    private boolean isWrapped(Point3d[] point3dArray) {
        return point3dArray.length >= 3 && point3dArray[0].epsilonEquals(point3dArray[point3dArray.length - 1], 1.0E-9);
    }

    public Mesh toMesh(Matrix4d matrix4d) {
        int n;
        int n2;
        int n3;
        int n4;
        Point3d[] point3dArray = this.getReferenceVerts();
        if (point3dArray.length == 0) {
            return new Mesh(new Point3d[0], new int[0], 3, 4);
        }
        Point3d[] point3dArray2 = this.generateVerts(point3dArray);
        if (matrix4d != null) {
            for (Point3d object2 : point3dArray2) {
                matrix4d.transform(object2);
            }
        }
        int n5 = this.getNumPrims(1);
        int[] nArray = new int[n5 * 4];
        int object3 = 0;
        int[] nArray2 = this.getFaceRange(Face.BOTTOM, n5);
        int[] nArray3 = this.getFaceRange(Face.TOP, n5);
        int[] nArray4 = this.getFaceRange(Face.SIDE1, n5);
        int[] nArray5 = this.getFaceRange(Face.SIDE2, n5);
        int[] nArray6 = this.getFaceRange(Face.ENDCAP_START, n5);
        int[] nArray7 = this.getFaceRange(Face.ENDCAP_END, n5);
        int n6 = point3dArray.length * 2;
        int[] n7 = this.alignment == Alignment.RIGHT ? nArray4 : nArray5;
        object3 = n7[0] * 4;
        for (n4 = 0; n4 < n7[1]; ++n4) {
            n3 = n4 << 1;
            n2 = n3 + n6;
            nArray[object3++] = n3 + 1;
            nArray[object3++] = n3 + 3;
            nArray[object3++] = n2 + 3;
            nArray[object3++] = n2 + 1;
        }
        n7 = this.alignment == Alignment.RIGHT ? nArray5 : nArray4;
        object3 = n7[0] * 4;
        for (n4 = 0; n4 < n7[1]; ++n4) {
            n3 = n4 << 1;
            n2 = n3 + n6;
            nArray[object3++] = n3 + 2;
            nArray[object3++] = n3;
            nArray[object3++] = n2;
            nArray[object3++] = n2 + 2;
        }
        object3 = nArray2[0] * 4;
        for (n = 0; n < nArray2[1]; ++n) {
            n4 = n << 1;
            nArray[object3++] = n4 + 1;
            nArray[object3++] = n4;
            nArray[object3++] = n4 + 2;
            nArray[object3++] = n4 + 3;
        }
        object3 = nArray3[0] * 4;
        for (n = 0; n < nArray3[1]; ++n) {
            n4 = (n << 1) + n6;
            nArray[object3++] = n4;
            nArray[object3++] = n4 + 1;
            nArray[object3++] = n4 + 3;
            nArray[object3++] = n4 + 2;
        }
        if (nArray6[1] > 0) {
            object3 = nArray6[0] * 4;
            nArray[object3++] = 0;
            nArray[object3++] = 1;
            nArray[object3++] = 1 + n6;
            nArray[object3++] = n6;
        }
        if (nArray7[1] > 0) {
            object3 = nArray7[0] * 4;
            nArray[object3++] = n6 - 1;
            nArray[object3++] = n6 - 2;
            nArray[object3++] = n6 * 2 - 2;
            nArray[object3++] = n6 * 2 - 1;
        }
        return new Mesh(point3dArray2, nArray, 3, 4);
    }

    public int[] getFaceRange(Face face) {
        int n = this.getNumPrims(1);
        return this.getFaceRange(face, n);
    }

    protected int[] getFaceRange(Face face, int n) {
        if (n == 0) {
            return new int[]{0, 0};
        }
        if (n == 2) {
            switch (face) {
                case ENDCAP_START: {
                    return new int[]{0, 1};
                }
                case ENDCAP_END: {
                    return new int[]{1, 1};
                }
            }
            return new int[]{0, 0};
        }
        int n2 = this.getNumEndcaps();
        int n3 = (n - n2) / 4;
        switch (face) {
            case SIDE1: {
                return new int[]{0, n3};
            }
            case SIDE2: {
                return new int[]{n3, n3};
            }
            case ENDCAP_START: {
                return new int[]{n3 * 2, n2 / 2};
            }
            case ENDCAP_END: {
                return new int[]{n3 * 2 + 1, n2 / 2};
            }
            case BOTTOM: {
                return new int[]{n3 * 2 + n2, n3};
            }
            case TOP: {
                return new int[]{n3 * 3 + n2, n3};
            }
        }
        return null;
    }

    public int getNumEndcaps() {
        return this.isWrapped() ? 0 : 2;
    }

    @Override
    public int getNumPrims(int n) {
        if (GeomUtil.test(n, 1)) {
            int n2 = this.getReferenceVerts().length;
            if (n2 == 0) {
                return 0;
            }
            return (n2 - 1) * 4 + this.getNumEndcaps();
        }
        return 0;
    }

    @Override
    public boolean isAxisAlignedBlock(Matrix4d matrix4d) {
        Point3d point3d = null;
        Point3d point3d2 = null;
        if (!(this.refCurve instanceof ILinearCurve) || ((ILinearCurve)this.refCurve).getNumVerts() != 2) {
            return false;
        }
        point3d = ((ILinearCurve)this.refCurve).getVert(0);
        point3d2 = ((ILinearCurve)this.refCurve).getVert(1);
        return theUtil.eq(point3d.z, point3d2.z, 1.0E-6) && (theUtil.eq(point3d.x, point3d2.x, 1.0E-6) || theUtil.eq(point3d.y, point3d2.y, 1.0E-6));
    }

    @Override
    public boolean isShell() {
        return Boolean.FALSE;
    }

    public Point3d[] generateVerts() {
        Point3d[] point3dArray = this.getReferenceVerts();
        return this.generateVerts(point3dArray);
    }

    protected Point3d[] generateVerts(Point3d ... point3dArray) {
        Object object;
        Tuple3d tuple3d;
        Point3d point3d;
        int n;
        if (point3dArray.length == 0) {
            return new Point3d[0];
        }
        if (point3dArray.length == 1) {
            Point3d point3d2 = point3dArray[0];
            return new Point3d[]{new Point3d(point3d2.x, point3d2.y + this.thickness, point3d2.z), new Point3d(point3d2), new Point3d(point3d2.x, point3d2.y, point3d2.z + this.height), new Point3d(point3d2.x, point3d2.y + this.thickness, point3d2.z + this.height)};
        }
        Point3d[] point3dArray2 = new Point3d[point3dArray.length * 2 * 2];
        int n2 = 0;
        int n3 = point3dArray.length - 1;
        Vector3d[] vector3dArray = new Vector3d[n3];
        for (n = 0; n < n3; ++n) {
            Point3d point3d3 = point3dArray[n];
            point3d = point3dArray[n + 1];
            vector3dArray[n] = WallGeom.vectorN2d(point3d3, point3d);
        }
        n = this.isWrapped() ? 1 : 0;
        for (int i = 0; i < n3; ++i) {
            Vector3d vector3d;
            point3d = point3dArray[i];
            Point3d point3d4 = point3dArray[i + 1];
            tuple3d = vector3dArray[i];
            object = this.getOffsetPoints(point3d, point3d4);
            if (i == 0) {
                point3dArray2[n2++] = new Point3d(object[0]);
                point3dArray2[n2++] = new Point3d(object[1]);
            }
            Vector3d vector3d2 = null;
            if (!(n == 0 && i >= n3 - 1 || theUtil.eq(Math.abs(((Vector3d)tuple3d).dot(vector3d = vector3dArray[(i + 1) % n3])), 1.0, 1.0E-6))) {
                Vector3d vector3d3 = Util3D.add((Vector3d)tuple3d, (Tuple3d)vector3d);
                vector3d3.normalize();
                vector3d2 = vector3d3;
            }
            if (vector3d2 == null) {
                vector3d2 = new Vector3d((Vector3d)tuple3d);
            }
            double d = vector3d2.x;
            vector3d2.x = -vector3d2.y;
            vector3d2.y = d;
            double[] dArray = Inter3D.lineLineProximityT(point3d4, vector3d2, object[0], (Vector3d)tuple3d, 1.0E-6);
            double[] dArray2 = Inter3D.lineLineProximityT(point3d4, vector3d2, object[1], (Vector3d)tuple3d, 1.0E-6);
            Point3d point3d5 = dArray != null ? Util3D.linePoint(point3d4, vector3d2, dArray[0]) : new Point3d(point3d4);
            Point3d point3d6 = dArray2 != null ? Util3D.linePoint(point3d4, vector3d2, dArray2[0]) : new Point3d(point3d4);
            point3dArray2[n2++] = point3d5;
            point3dArray2[n2++] = point3d6;
            if (n == 0 || i != n3 - 1) continue;
            point3dArray2[0] = new Point3d(point3d5);
            point3dArray2[1] = new Point3d(point3d6);
        }
        Vector3d vector3d = new Vector3d(0.0, 0.0, this.height);
        int n4 = point3dArray2.length / 2;
        assert (n2 == n4);
        for (int i = 0; i < n4; ++i) {
            tuple3d = point3dArray2[i];
            point3dArray2[i + n4] = object = Util3D.add((Point3d)tuple3d, (Tuple3d)vector3d);
        }
        return point3dArray2;
    }

    private static boolean equal2d(Point3d point3d, Point3d point3d2) {
        return point3d.x == point3d2.x && point3d.y == point3d2.y;
    }

    private static Vector3d vectorN2d(Point3d point3d, Point3d point3d2) {
        Vector3d vector3d = new Vector3d(point3d2.x - point3d.x, point3d2.y - point3d.y, 0.0);
        vector3d.normalize();
        return vector3d;
    }

    private Point3d[] getOffsetPoints(Point3d point3d, Point3d point3d2) {
        Vector3d vector3d;
        double d = point3d2.x - point3d.x;
        double d2 = point3d2.y - point3d.y;
        if (Math.abs(d) < 1.0E-15 && Math.abs(d2) < 1.0E-15) {
            vector3d = new Vector3d(1.0, 0.0, 0.0);
        } else {
            vector3d = new Vector3d(-d2, d, 0.0);
            vector3d.normalize();
        }
        switch (this.alignment) {
            case LEFT: {
                vector3d.scale(this.thickness);
                return new Point3d[]{Util3D.add(point3d, (Tuple3d)vector3d), point3d};
            }
            case RIGHT: {
                vector3d.scale(this.thickness);
                return new Point3d[]{point3d, Util3D.sub(point3d, (Tuple3d)vector3d)};
            }
        }
        vector3d.scale(this.thickness * 0.5);
        return new Point3d[]{Util3D.add(point3d, (Tuple3d)vector3d), Util3D.sub(point3d, (Tuple3d)vector3d)};
    }

    private Point3d[] getReferenceVerts() {
        ArrayList<Point3d> arrayList;
        if (this.d_refCurveVerts != null) {
            return this.d_refCurveVerts;
        }
        if (this.refCurve instanceof ILinearCurve) {
            ILinearCurve iLinearCurve = (ILinearCurve)this.refCurve;
            arrayList = new ArrayList<Point3d>(iLinearCurve.getNumVerts());
            Point3d point3d = null;
            for (int i = 0; i < iLinearCurve.getNumVerts(); ++i) {
                Point3d point3d2 = iLinearCurve.getVert(i);
                if (point3d == null || !WallGeom.equal2d(point3d, point3d2)) {
                    arrayList.add(point3d2);
                }
                point3d = point3d2;
            }
        } else {
            Mesh mesh = this.refCurve.getSegments(0.001);
            if (mesh.indices.length == 0) {
                return new Point3d[0];
            }
            arrayList = new ArrayList(mesh.indices.length / 2 - 1);
            Point3d point3d = null;
            for (int i = 0; i < mesh.indices.length; i += 2) {
                Point3d point3d3 = mesh.vertices[mesh.indices[i]];
                if (point3d == null || !WallGeom.equal2d(point3d, point3d3)) {
                    arrayList.add(point3d3);
                }
                point3d = point3d3;
            }
            Point3d point3d4 = mesh.vertices[mesh.indices[mesh.indices.length - 1]];
            if (point3d == null || !WallGeom.equal2d(point3d, point3d4)) {
                arrayList.add(point3d4);
            }
        }
        this.d_refCurveVerts = arrayList.toArray(new Point3d[arrayList.size()]);
        return this.d_refCurveVerts;
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> collection) {
        collection.add(this.toMesh(null));
        return collection;
    }

    @Override
    public boolean intersectsBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        Mesh mesh;
        return (iIsectFilter.acceptGeomType(object, GeomType.FACE) || iIsectFilter.acceptGeomType(object, GeomType.FACE_EDGE) || iIsectFilter.acceptGeomType(object, GeomType.FACE_VERTEX)) && (mesh = this.toMesh(null)).intersectsBox(object, iIsectFilter, convexHull);
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        if (iIsectFilter.acceptGeomType(object, GeomType.FACE) || iIsectFilter.acceptGeomType(object, GeomType.FACE_EDGE) || iIsectFilter.acceptGeomType(object, GeomType.FACE_VERTEX)) {
            Mesh mesh = this.toMesh(null);
            mesh.pickPoints(iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, iTest);
        }
    }

    @Override
    public void find(ITest<AABox> iTest, IResult<? super IPrimitive> iResult) {
        this.toMesh(null).find(iTest, iResult);
    }

    @Override
    public void getAll(IResult<? super IPrimitive> iResult) {
        this.toMesh(null).getAll(iResult);
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        Face[] faceArray;
        Object object;
        ICurve[] iCurveArray;
        ArrayList<IHandle> arrayList = new ArrayList<IHandle>();
        for (ICurve i : iCurveArray = new ICurve[]{this.refCurve, this.refCurve.transform(Util.translateMat(0.0, 0.0, this.height))}) {
            if (!(i instanceof IManipulatable)) continue;
            object = (IManipulatable)((Object)i);
            for (IHandle iHandle : object.generateManipHandles()) {
                arrayList.add(new VertHandle(this, iHandle, i == this.refCurve));
            }
        }
        if (this.alignment == Alignment.CENTER) {
            Face[] faceArray2 = new Face[2];
            faceArray2[0] = Face.SIDE1;
            faceArray = faceArray2;
            faceArray2[1] = Face.SIDE2;
        } else {
            Face[] faceArray3 = new Face[1];
            faceArray = faceArray3;
            faceArray3[0] = Face.SIDE1;
        }
        Face[] faceArray4 = faceArray;
        Object object2 = faceArray4;
        int n = ((Face[])object2).length;
        for (int i = 0; i < n; ++i) {
            object = object2[i];
            Object object3 = this.getFaceRange((Face)((Object)object));
            for (reference var9_13 = object3[0]; var9_13 < object3[0] + object3[1]; ++var9_13) {
                arrayList.add(new ThicknessHandle(this, (int)var9_13));
            }
        }
        arrayList.add(new HeightHandle(this, Face.BOTTOM));
        arrayList.add(new HeightHandle(this, Face.TOP));
        if (this.refCurve instanceof IManipulatable && !this.isWrapped() && !(object2 = new ArrayList<IHandle>(((IManipulatable)((Object)this.refCurve)).generateManipHandles())).isEmpty()) {
            arrayList.add(new EndcapHandle(this, Face.ENDCAP_START, (IHandle)object2.get(0)));
            arrayList.add(new EndcapHandle(this, Face.ENDCAP_END, (IHandle)object2.get(object2.size() - 1)));
        }
        return arrayList;
    }

    private static class VertHandle
    implements IHandle {
        private WallGeom geom;
        private final IHandle handle;
        private final boolean bottom;

        public VertHandle(WallGeom wallGeom, IHandle iHandle, boolean bl) {
            this.geom = wallGeom;
            this.handle = iHandle;
            this.bottom = bl;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof VertHandle && ((VertHandle)object).handle.equals(this.handle) && ((VertHandle)object).bottom == this.bottom;
        }

        @Override
        public IGeom getGeom() {
            return this.handle.getGeom();
        }

        @Override
        public IIsectFilter getPickFilter() {
            return this.handle.getPickFilter();
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            return this.handle.getConstraint(point3d);
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
            this.handle.begin(point3d, iSnapConstraint);
        }

        @Override
        public Object modify(Point3d point3d) throws Exception {
            Object object = this.handle.modify(point3d);
            this.geom = this.modify(object);
            return this.geom;
        }

        @Override
        public Object end() {
            this.geom = this.modify(this.handle.end());
            return this.geom;
        }

        protected WallGeom modify(Object object) {
            if (object instanceof ICurve) {
                ICurve iCurve = (ICurve)object;
                if (!this.bottom) {
                    iCurve = iCurve.transform(Util.translateMat(0.0, 0.0, -this.geom.height));
                }
                return new WallGeom(iCurve, this.geom.alignment, this.geom.thickness, this.geom.height);
            }
            return this.geom;
        }
    }

    private static class HeightHandle
    extends AExtrudeHandle<WallGeom> {
        private final Face d_face;

        public HeightHandle(WallGeom wallGeom, Face face) {
            super(wallGeom);
            this.d_face = face;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && object instanceof HeightHandle && ((HeightHandle)object).d_face == this.d_face;
        }

        @Override
        public IGeom getGeom() {
            int[] nArray = ((WallGeom)this.getManipGeom()).getFaceRange(this.d_face);
            Mesh mesh = ((WallGeom)this.getManipGeom()).toMesh(null);
            ArrayList<IPrimitive> arrayList = new ArrayList<IPrimitive>(nArray[1]);
            for (int i = nArray[0]; i < nArray[0] + nArray[1]; ++i) {
                arrayList.add(mesh.getPrimitive(i));
            }
            return GeomUtil.group(arrayList);
        }

        @Override
        protected WallGeom extrude(WallGeom wallGeom, Vector3d vector3d, double d) throws Exception {
            if (this.d_face == Face.TOP) {
                double d2 = wallGeom.height + d;
                if (d2 < 0.0) {
                    d2 = 0.0;
                }
                return new WallGeom(wallGeom.refCurve, wallGeom.alignment, wallGeom.thickness, d2);
            }
            if (d > wallGeom.height) {
                d = wallGeom.height;
            }
            double d3 = wallGeom.height - d;
            Matrix4d matrix4d = Util.translateMat(0.0, 0.0, d);
            ICurve iCurve = wallGeom.refCurve.transform(matrix4d);
            return new WallGeom(iCurve, wallGeom.alignment, wallGeom.thickness, d3);
        }

        @Override
        protected Vector3d getExtrudeDir(WallGeom wallGeom) {
            return GeomConstants.VEC3D_ZPOS;
        }
    }

    private static class EndcapHandle
    implements IHandle {
        private WallGeom d_geom;
        private final Face d_face;
        private final IHandle d_refHandle;
        private Point3d t_pickLoc;

        public EndcapHandle(WallGeom wallGeom, Face face, IHandle iHandle) {
            this.d_geom = wallGeom;
            this.d_face = face;
            this.d_refHandle = iHandle;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof EndcapHandle && ((EndcapHandle)object).d_face == this.d_face;
        }

        @Override
        public IGeom getGeom() {
            int[] nArray = this.d_geom.getFaceRange(this.d_face);
            assert (nArray[1] == 1);
            return this.d_geom.toMesh(null).getPrimitive(nArray[0]);
        }

        @Override
        public IIsectFilter getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            ISnapConstraint iSnapConstraint = this.d_refHandle.getConstraint(point3d);
            if (iSnapConstraint != null) {
                return iSnapConstraint;
            }
            IPolygon iPolygon = (IPolygon)this.getGeom();
            return new LineConstraint(point3d, iPolygon.getNormal());
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
            this.t_pickLoc = point3d;
            IGeom iGeom = this.d_refHandle.getGeom();
            if (iGeom instanceof Point) {
                point3d = ((Point)iGeom).loc;
            }
            this.d_refHandle.begin(point3d, iSnapConstraint);
        }

        @Override
        public Object modify(Point3d point3d) throws Exception {
            Object object;
            IGeom iGeom = this.d_refHandle.getGeom();
            if (iGeom instanceof Point) {
                object = Util3D.vector(this.t_pickLoc, point3d);
                point3d = Util3D.add(((Point)iGeom).loc, (Tuple3d)object);
                this.t_pickLoc = Util3D.add(this.t_pickLoc, (Tuple3d)object);
            }
            object = this.d_refHandle.modify(point3d);
            this.d_geom = this.finalize(object);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.d_geom = this.finalize(this.d_refHandle.end());
            this.t_pickLoc = null;
            return this.d_geom;
        }

        private WallGeom finalize(Object object) {
            if (object instanceof ICurve) {
                return new WallGeom((ICurve)object, this.d_geom.alignment, this.d_geom.thickness, this.d_geom.height);
            }
            return this.d_geom;
        }
    }

    private static class ThicknessHandle
    extends AExtrudeHandle<WallGeom> {
        private final int d_faceIx;

        public ThicknessHandle(WallGeom wallGeom, int n) {
            super(wallGeom);
            this.d_faceIx = n;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && object instanceof ThicknessHandle && ((ThicknessHandle)object).d_faceIx == this.d_faceIx;
        }

        @Override
        public IGeom getGeom() {
            Mesh mesh = ((WallGeom)this.getManipGeom()).toMesh(null);
            return mesh.getPrimitive(this.d_faceIx);
        }

        @Override
        protected Vector3d getExtrudeDir(WallGeom wallGeom) {
            Mesh mesh = ((WallGeom)this.getManipGeom()).toMesh(null);
            Quad quad = (Quad)mesh.getPrimitive(this.d_faceIx);
            return quad.getNormal();
        }

        @Override
        protected WallGeom extrude(WallGeom wallGeom, Vector3d vector3d, double d) {
            if (wallGeom.alignment == Alignment.CENTER) {
                d *= 2.0;
            }
            double d2 = wallGeom.thickness + d;
            Alignment alignment = wallGeom.alignment;
            if (d2 < 0.0) {
                alignment = wallGeom.alignment.opposite();
                d2 = -d2;
            }
            return new WallGeom(wallGeom.refCurve, alignment, d2, wallGeom.height);
        }
    }

    public static enum Face {
        SIDE1,
        SIDE2,
        BOTTOM,
        TOP,
        ENDCAP_START,
        ENDCAP_END;

    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER;


        Alignment opposite() {
            switch (this) {
                case LEFT: {
                    return RIGHT;
                }
                case RIGHT: {
                    return LEFT;
                }
            }
            return CENTER;
        }
    }
}

