/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;

public class Triangle
extends AFace
implements IPolygon,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final Point3d p1;
    public final Point3d p2;
    public final Point3d p3;

    public Triangle(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        this.p1 = point3d;
        this.p2 = point3d2;
        this.p3 = point3d3;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        return new thunderheadeng.geometry.objs.Triangle(this.p1, this.p2, this.p3);
    }

    @Override
    public Triangle optimize(IPointOptimizer iPointOptimizer) {
        Point3d point3d = iPointOptimizer.getExisting(this.p1);
        Point3d point3d2 = iPointOptimizer.getExisting(this.p2);
        Point3d point3d3 = iPointOptimizer.getExisting(this.p3);
        return point3d != this.p1 || point3d2 != this.p2 || point3d3 != this.p3 ? new Triangle(point3d, point3d2, point3d3) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(this.p1);
        aABox.add(this.p2);
        aABox.add(this.p3);
        return aABox;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public Triangle transform(Matrix4d matrix4d) {
        return new Triangle(Util3D.xform(matrix4d, this.p1), Util3D.xform(matrix4d, this.p2), Util3D.xform(matrix4d, this.p3));
    }

    @Override
    public int getNumLoops() {
        return 1;
    }

    @Override
    public int getNumPoints(int n) {
        return 3;
    }

    @Override
    public Point3d getPoint(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.p1;
            }
            case 1: {
                return this.p2;
            }
            case 2: {
                return this.p3;
            }
        }
        return null;
    }

    @Override
    public void getBoundary(List<ICurve> list) {
        PolyUtil.getBoundary(list, this);
    }

    @Override
    public Vector3d getNormal() {
        Vector3d vector3d = Util3D.simplePolygonNormal(Arrays.asList(this.p1, this.p2, this.p3), 1.0E-6);
        return vector3d == null ? GeomConstants.VEC3D_ZERO : vector3d;
    }

    @Override
    public Mesh triangulate(double d) {
        Point3d[] point3dArray = new Point3d[]{this.p1, this.p2, this.p3};
        int[] nArray = new int[]{0, 1, 2};
        return new Mesh(point3dArray, nArray, 2);
    }

    @Override
    public boolean intersectsBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        return PolyUtil.intersectsBox(object, this, iIsectFilter, convexHull);
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        PolyUtil.pickPoints(this, iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, iTest);
    }

    @Override
    public Point3d project(Point3d point3d) {
        return PolyUtil.getPlane(this).projectOntoPlane(point3d);
    }

    @Override
    public IFace.PointClassify classify(Point3d point3d, double d) {
        return PolyUtil.classify(this, point3d, d);
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return PolyUtil.generateManipHandles(this);
    }
}

