/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ISearchVol;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IProxyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.util.TaskProgress;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;

public class TransformedGeom
implements IProxyGeom,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final Matrix4d xform;
    public final IGeom geom;

    public TransformedGeom(Matrix4d matrix4d, IGeom iGeom) {
        this.xform = matrix4d;
        this.geom = iGeom;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        Object object = legacyDictionary_2012_1.get(this.geom);
        MatrixXform matrixXform = new MatrixXform(this.xform);
        if (object instanceof thunderheadeng.geometry.objs.IGeom) {
            return GeomNodeUtil.newNode((ITransform)matrixXform, (thunderheadeng.geometry.objs.IGeom)object);
        }
        if (object instanceof IGeomNode) {
            IGeomNode iGeomNode = (IGeomNode)object;
            TransformInfo transformInfo = matrixXform.getInfo();
            return iGeomNode.transform(transformInfo);
        }
        return null;
    }

    @Override
    public IGeom getBase() {
        return this.geom;
    }

    @Override
    public TransformedGeom collapse() {
        Matrix4d matrix4d = this.xform;
        IGeom iGeom = this.geom;
        while (iGeom instanceof TransformedGeom) {
            TransformedGeom transformedGeom = (TransformedGeom)iGeom;
            iGeom = transformedGeom.geom;
            if (matrix4d == this.xform) {
                matrix4d = new Matrix4d(this.xform);
            }
            matrix4d.mul(transformedGeom.xform);
        }
        return iGeom == this.geom ? this : new TransformedGeom(matrix4d, iGeom);
    }

    @Override
    public IGeom optimize(IPointOptimizer iPointOptimizer) {
        IGeom iGeom = this.geom.optimize(iPointOptimizer);
        if (GeomConstants.IDENTITY4d.equals(this.xform)) {
            return iGeom;
        }
        if (iGeom != this.geom) {
            return new TransformedGeom(this.xform, iGeom);
        }
        return this;
    }

    @Override
    public AABox getBoundingBox(final AABox aABox) {
        final TransformedGeom transformedGeom = this.collapse();
        AABox aABox2 = new AABox(){
            private static final long serialVersionUID = 8170265483089249418L;

            @Override
            public void add(AABox aABox2) {
                aABox.add(aABox2.transform(transformedGeom.xform));
            }

            @Override
            public void add(ISearchVol iSearchVol) {
                assert (false);
                aABox.add(iSearchVol);
            }

            @Override
            public void addPoint(double d, double d2, double d3) {
                Point3d point3d = new Point3d(d, d2, d3);
                transformedGeom.xform.transform(point3d);
                aABox.addPoint(point3d.x, point3d.y, point3d.z);
            }
        };
        transformedGeom.geom.getBoundingBox(aABox2);
        return aABox;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IGeom transform(Matrix4d matrix4d, IGeom.XformOp xformOp) {
        Matrix4d matrix4d2 = new Matrix4d(matrix4d);
        matrix4d2.mul(this.xform);
        return this.geom.transform(matrix4d2, xformOp);
    }

    @Override
    public boolean isAxisAlignedBlock(Matrix4d matrix4d) {
        matrix4d = TransformedGeom.transform(matrix4d, this.xform);
        return this.geom.isAxisAlignedBlock(matrix4d);
    }

    @Override
    public boolean isShell() {
        return this.geom.isShell();
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public int getNumPrims(int n) {
        return this.geom.getNumPrims(n);
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> collection) {
        TransformedGeom transformedGeom = this.collapse();
        IGeom iGeom = transformedGeom.geom.transform(transformedGeom.xform, IGeom.XformOp.EXPLODED);
        collection.add(iGeom);
        return collection;
    }

    private static Matrix4d transform(Matrix4d matrix4d, Matrix4d matrix4d2) {
        if (matrix4d == null) {
            return matrix4d2;
        }
        matrix4d = new Matrix4d(matrix4d);
        matrix4d.mul(matrix4d2);
        return matrix4d;
    }

    public static TransformedGeom collapse(TransformedGeom transformedGeom) {
        return transformedGeom.collapse();
    }

    @Override
    public boolean intersectsBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        Matrix4d matrix4d = this.getInverseXform();
        convexHull = convexHull.transform(matrix4d);
        return this.geom.intersectsBox(object, iIsectFilter, convexHull);
    }

    @Override
    public void pickPoints(final IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> xformTester) {
        Matrix4d matrix4d = this.getInverseXform();
        point3d = Util3D.xform(matrix4d, point3d);
        point3d2 = Util3D.xform(matrix4d, point3d2);
        vector3d = Util3D.xform(matrix4d, vector3d);
        vector3d.normalize();
        IIsectCollector iIsectCollector2 = new IIsectCollector(){

            @Override
            public void add(Object object, Point3d point3d, GeomType geomType, IPrimitive iPrimitive) {
                point3d = Util3D.xform(TransformedGeom.this.xform, point3d);
                iPrimitive = iPrimitive.transform(TransformedGeom.this.xform);
                iIsectCollector.add(object, point3d, geomType, iPrimitive);
            }

            @Override
            public void addInfinite(Object object, Point3d point3d, GeomType geomType, IPrimitive iPrimitive) {
                point3d = Util3D.xform(TransformedGeom.this.xform, point3d);
                iPrimitive = iPrimitive.transform(TransformedGeom.this.xform);
                iIsectCollector.addInfinite(object, point3d, geomType, iPrimitive);
            }

            @Override
            public TaskProgress getProgress() {
                return iIsectCollector.getProgress();
            }
        };
        xformTester = new XformTester(xformTester, this.xform);
        this.geom.pickPoints(iIsectCollector2, iIsectFilter, object, point3d, point3d2, vector3d, xformTester);
    }

    public Matrix4d getInverseXform() {
        Matrix4d matrix4d = new Matrix4d(this.xform);
        matrix4d.invert();
        return matrix4d;
    }

    @Override
    public void find(ITest<AABox> xformTester, IResult<? super IPrimitive> xformResult) {
        TransformedGeom transformedGeom = this.collapse();
        xformTester = new XformTester(xformTester, transformedGeom.xform);
        xformResult = new XformResult(xformResult, transformedGeom.xform);
        transformedGeom.geom.find(xformTester, xformResult);
    }

    @Override
    public void getAll(IResult<? super IPrimitive> iResult) {
        Collection<IGeom> collection = this.explode(new ArrayList<IGeom>());
        for (IGeom iGeom : collection) {
            iGeom.getAll(iResult);
        }
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        if (!(this.geom instanceof IManipulatable)) {
            return Collections.EMPTY_LIST;
        }
        Collection<? extends IHandle> collection = ((IManipulatable)((Object)this.geom)).generateManipHandles();
        ArrayList<Handle> arrayList = new ArrayList<Handle>(collection.size());
        for (IHandle iHandle : collection) {
            arrayList.add(new Handle(this, iHandle));
        }
        return arrayList;
    }

    private static class Handle
    implements IHandle {
        private TransformedGeom d_geom;
        private final IHandle d_handle;
        private Matrix4d t_xform;
        private Matrix4d t_invXform;

        public Handle(TransformedGeom transformedGeom, IHandle iHandle) {
            this.d_geom = transformedGeom;
            this.d_handle = iHandle;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Handle && ((Handle)object).d_handle.equals(this.d_handle);
        }

        @Override
        public IGeom getGeom() {
            return new TransformedGeom(this.d_geom.xform, this.d_handle.getGeom());
        }

        @Override
        public IIsectFilter getPickFilter() {
            return this.d_handle.getPickFilter();
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            this.t_invXform = this.d_geom.getInverseXform();
            this.t_xform = this.d_geom.xform;
            ISnapConstraint iSnapConstraint = this.d_handle.getConstraint(point3d = Util3D.xform(this.t_invXform, point3d));
            return iSnapConstraint == null ? iSnapConstraint : iSnapConstraint.transform(this.t_xform);
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
            assert (this.t_invXform != null && this.t_xform != null);
            point3d = Util3D.xform(this.t_invXform, point3d);
            iSnapConstraint = iSnapConstraint == null ? iSnapConstraint : iSnapConstraint.transform(this.t_invXform);
            this.d_handle.begin(point3d, iSnapConstraint);
        }

        @Override
        public Object modify(Point3d point3d) throws Exception {
            point3d = Util3D.xform(this.t_invXform, point3d);
            Object object = this.d_handle.modify(point3d);
            this.d_geom = this.modify(object);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.d_geom = this.modify(this.d_handle.end());
            this.t_invXform = null;
            this.t_xform = null;
            return this.d_geom;
        }

        private TransformedGeom modify(Object object) {
            if (object instanceof IGeom) {
                return new TransformedGeom(this.d_geom.xform, (IGeom)object);
            }
            return this.d_geom;
        }
    }

    private static class XformResult
    implements IResult<IPrimitive> {
        private final Matrix4d d_xform;
        private final IResult<? super IPrimitive> d_base;

        public XformResult(IResult<? super IPrimitive> iResult, Matrix4d matrix4d) {
            this.d_xform = matrix4d;
            this.d_base = iResult;
        }

        @Override
        public void mark(IPrimitive iPrimitive, Containment containment) {
            iPrimitive = iPrimitive.transform(this.d_xform);
            this.d_base.mark(iPrimitive, containment);
        }
    }

    private static class XformTester
    implements ITest<AABox> {
        private final ITest<AABox> base;
        private final Matrix4d xform;

        public XformTester(ITest<AABox> iTest, Matrix4d matrix4d) {
            this.base = iTest;
            this.xform = matrix4d;
        }

        @Override
        public Containment test(AABox aABox) {
            AABox aABox2 = new AABox(aABox);
            aABox2.transformEq(this.xform);
            return this.base.test(aABox2);
        }
    }
}

